-- isvcalcprectotal.sql

set quoted_identifier on
GO

set ansi_nulls on
GO

if objectproperty(object_id('dbo.IsvCalcPrecTotal'), 'IsProcedure') = 1
	drop procedure dbo.IsvCalcPrecTotal
GO

/*
	:
		   
	 :
		@cTableName varchar(100) -  
		@cAddWhere varchar(8000) -    
		@cIdentityField varchar(100) - - 
		@cHierarchyField varchar(100) -      ()
		@cHierarchyLength varchar(1000) -        @cHierarchyField
		@nTotalPrecision integer -    
		@cTotalFields varchar(8000) -     () (   = 10)
	 :
		@nErrorCode integer -  :
			= 0 -  
			> 0 -  ,    
			< 0 - 
	 :
		execute dbo.IsvCalcPrecTotal
				@cTableName = '#rro'
				,@cAddWhere = 'substring(csbo, 8, 2) in ('''', ''00'')'
				,@cIdentityField = 'row_id'
				,@cHierarchyField = 'hierarchy'
				,@cHierarchyLength = '3,5'
				,@nTotalPrecision = 1
				,@cTotalFields = 's_fakt0,s_plan0,s_plan1,s_plan2,s_plan3,s_plan4'
				,@nErrorCode = @nCode output
	:
		2010-02-03       
		2011-03-04    : @nSum bigint, @nSumCnt bigint
		2016-01-19  
	:
		  (Keysystems),  ..
*/
create procedure dbo.IsvCalcPrecTotal
	@cTableName varchar(100) = null
	,@cAddWhere varchar(8000) = null
	,@cIdentityField varchar(100) = null
	,@cHierarchyField varchar(100) = null
	,@cHierarchyLength varchar(1000) = null
	,@nTotalPrecision integer = null
	,@cTotalFields varchar(8000) = null
	,@nErrorCode integer output
	,@nSingleMode integer = 0
	,@cTableNotRound varchar(100) = null
as
begin
	set @cTableName = replace(@cTableName, ' ', '')
	set @cIdentityField = replace(@cIdentityField, ' ', '')
	set @cHierarchyField = replace(@cHierarchyField, ' ', '')
	set @cHierarchyLength = replace(@cHierarchyLength, ' ', '')
	set @cTotalFields = replace(@cTotalFields, ' ', '')
	set @nTotalPrecision = case when coalesce(@nTotalPrecision, 0) <= 0 then 0 else @nTotalPrecision end
	set @nTotalPrecision = case when @nTotalPrecision > 10 then 10 else @nTotalPrecision end
	set @nErrorCode = 0

	--  
	declare @title nvarchar(1000), @message nvarchar(1000), @cField varchar(100), @cLength varchar(100), @nOrder integer, @cWhere varchar(8000)
	set @title = dbo.ErrorMessage(@@PROCID, '! %s')

	if object_id('tempdb..' + @cTableName) is null
		begin
			set @nErrorCode = -1
			set @message = '    ' + coalesce(@cTableName, '@cTableName') + '.'
			raiserror(@title, 18, 1, @message)
			return
		end

	if not exists(select * from tempdb..syscolumns where id = object_id('tempdb..' + @cTableName) and name = @cIdentityField and type_name(xtype) = 'uniqueidentifier')
		begin
			set @nErrorCode = -2
			set @message = '  -  ' + coalesce(@cIdentityField, '@cIdentityField') + '.'
			raiserror(@title, 18, 1, @message)
			return
		end

	if not exists(select * from tempdb..syscolumns where id = object_id('tempdb..' + @cTableName) and name = @cHierarchyField and type_name(xtype) in ('char','varchar'))
		begin
			set @nErrorCode = -3
			set @message = '       () ' + coalesce(@cHierarchyField, '@cHierarchyField') + '.'
			raiserror(@title, 18, 1, @message)
			return
		end

	if not exists(select * from tempdb..syscolumns sc, dbo.split2(@cTotalFields, ',') t where sc.id = object_id('tempdb..' + @cTableName) and sc.name = t.value and type_name(sc.xtype) in ('money','smallmoney','numeric','decimal'))
		begin
			set @nErrorCode = -4
			set @message = '     () ' + coalesce(@cTotalFields, '@cTotalFields') + '.'
			raiserror(@title, 18, 1, @message)
			return
		end

	if not exists(select * from dbo.split2(@cHierarchyLength, ',') where isnumeric(value) = 1)
		begin
			set @nErrorCode = -5
			set @message = '       ' + coalesce(@cHierarchyLength, '@cHierarchyLength') + '.'
			raiserror(@title, 18, 1, @message)
			return
		end

	--  
	if @nSingleMode = 0
		begin
			declare c_HierarchyLength cursor local forward_only static read_only for
				select distinct left(value, 100), orders from dbo.split2(@cHierarchyLength, ',') where isnumeric(value) = 1
			open c_HierarchyLength
			fetch next from c_HierarchyLength into @cLength, @nOrder
			while @@fetch_status = 0
				begin
					set @cWhere = coalesce(nullif(ltrim(rtrim(@cAddWhere)), '') + ' and ', '') + 'len(' + @cHierarchyField + ')'
						+ case when exists(select * from dbo.split2(@cHierarchyLength, ',') where isnumeric(value) = 1 and orders = @nOrder + 1)
							then ' between ' + @cLength + ' and '
								+ (select top 1 left(value, 100) from dbo.split2(@cHierarchyLength, ',') where isnumeric(value) = 1 and orders = @nOrder + 1)
							else ' >= ' + @cLength end

					declare c_TotalFields cursor local forward_only static read_only for
						select distinct left(t.value, 100) from tempdb..syscolumns sc, dbo.split2(@cTotalFields, ',') t
						where sc.id = object_id('tempdb..' + @cTableName) and sc.name = t.value and type_name(sc.xtype) in ('money','smallmoney','numeric','decimal')
					open c_TotalFields
					fetch next from c_TotalFields into @cField
					while @@fetch_status = 0
						begin
							execute dbo.IsvCalcPrecTotal @cTableName = @cTableName, @cAddWhere = @cWhere, @cIdentityField = @cIdentityField
								,@cHierarchyField = @cHierarchyField, @cHierarchyLength = @cLength, @nTotalPrecision = @nTotalPrecision
								,@cTotalFields = @cField, @nErrorCode = @nErrorCode output, @nSingleMode = 1, @cTableNotRound = @cTableNotRound

							fetch next from c_TotalFields into @cField
						end
					close c_TotalFields
					deallocate c_TotalFields

					fetch next from c_HierarchyLength into @cLength, @nOrder
				end
			close c_HierarchyLength
			deallocate c_HierarchyLength

			return
		end

	--  ,    @cHierarchyLength  @cTotalFields   
	declare @cSql varchar(max), @nHierarchyLength integer, @hierarchy varchar(8000), @nSumCnt bigint, @cHierarchyFieldLen varchar(100)
	set @nHierarchyLength = convert(integer, @cHierarchyLength)
	set @cHierarchyFieldLen = case when col_length('tempdb..' + @cTableName, @cHierarchyField) > 900 then '8000' end

	if object_id('tempdb..#OriginalTotal') is not null
		drop table #OriginalTotal
	create table #OriginalTotal (
		id integer identity(1, 1) not null constraint pk_tmp_OriginalTotal_id primary key clustered with fillfactor = 100 on [primary],
		row_id uniqueidentifier,
		hierarchy varchar(900),
		hierarchyl varchar(900),
		hLength integer,
		hLeaf integer,
		summa numeric(28, 10)
	)
	create index ix_tmp_OriginalTotal_r on #OriginalTotal (row_id)
	create index ix_tmp_OriginalTotal_l on #OriginalTotal (hLength)
	if len(@cHierarchyFieldLen) > 0 begin
		execute ('
		begin
			alter table #OriginalTotal alter column hierarchy varchar(' + @cHierarchyFieldLen + ')
			alter table #OriginalTotal alter column hierarchyl varchar(' + @cHierarchyFieldLen + ')
		end
		')
	end else begin
		create index ix_tmp_OriginalTotal_h on #OriginalTotal (hierarchy)
		create index ix_tmp_OriginalTotal_hl on #OriginalTotal (hierarchyl)
	end

	set @cSql = '
		insert into #OriginalTotal (row_id, hierarchy, hierarchyl, hLength, hLeaf, summa)
			select ' + @cIdentityField + ', ' + @cHierarchyField + ', left(' + @cHierarchyField + ', ' + str(@nHierarchyLength) + '), 0, 1, ' + @cTotalFields + '
			from ' + @cTableName + '
			' + case when coalesce(@cAddWhere, '') <> '' then 'where ' + @cAddWhere else '' end + '
			order by ' + @cHierarchyField + '
	'
	execute (@cSql)

	update #OriginalTotal set hLength = @nHierarchyLength where len(hierarchy) = @nHierarchyLength
	update t set hLeaf = 0
		from #OriginalTotal t
		where t.hLength = @nHierarchyLength
			and exists(select * from #OriginalTotal _t where _t.hierarchyl = t.hierarchy and _t.row_id <> t.row_id	and _t.hLength = 0)

	if object_id('tempdb..#RoundTotal') is not null
		drop table #RoundTotal
	create table #RoundTotal (
		id integer identity(1, 1) not null constraint pk_tmp_RoundTotal_id primary key clustered with fillfactor = 100 on [primary],
		row_id uniqueidentifier,
		hierarchy varchar(900),
		hierarchyl varchar(900),
		hLength integer,
		hLeaf integer,
		summa numeric(28, 10),
		ves numeric(28, 10)
	)
	create index ix_tmp_RoundTotal_r on #RoundTotal (row_id)
	create index ix_tmp_RoundTotal_l on #RoundTotal (hLength)
	if len(@cHierarchyFieldLen) > 0 begin
		execute ('
		begin
			alter table #RoundTotal alter column hierarchy varchar(' + @cHierarchyFieldLen + ')
			alter table #RoundTotal alter column hierarchyl varchar(' + @cHierarchyFieldLen + ')
		end
		')
	end else begin
		create index ix_tmp_RoundTotal_h on #RoundTotal (hierarchy)
		create index ix_tmp_RoundTotal_hl on #RoundTotal (hierarchyl)
	end

	insert into #RoundTotal (row_id, hierarchy, hierarchyl, hLength, hLeaf, summa, ves)
		select row_id, hierarchy, hierarchyl, hLength, hLeaf, round(summa, @nTotalPrecision),abs(summa-round(summa, @nTotalPrecision))
		 from #OriginalTotal order by hierarchy

	if object_id('tempdb..#DifferenceTotal') is not null
		drop table #DifferenceTotal
	create table #DifferenceTotal (
		id integer identity(1, 1) not null constraint pk_tmp_DifferenceTotal_id primary key clustered with fillfactor = 100 on [primary],
		row_id uniqueidentifier,
		hierarchy varchar(900),
		hierarchyl varchar(900),
		hLength integer,
		hLeaf integer,
		summa numeric(28, 10),
		nSum bigint,
		nSumCnt bigint,
		nRecCnt integer
	)
	create index ix_tmp_DifferenceTotal_r on #DifferenceTotal (row_id)
	create index ix_tmp_DifferenceTotal_l on #DifferenceTotal (hLength)
	if len(@cHierarchyFieldLen) > 0 begin
		execute ('
		begin
			alter table #DifferenceTotal alter column hierarchy varchar(' + @cHierarchyFieldLen + ')
			alter table #DifferenceTotal alter column hierarchyl varchar(' + @cHierarchyFieldLen + ')
		end
		')
	end else begin
		create index ix_tmp_DifferenceTotal_h on #DifferenceTotal (hierarchy)
		create index ix_tmp_DifferenceTotal_hl on #DifferenceTotal (hierarchyl)
	end

	insert into #DifferenceTotal (row_id, hierarchy, hierarchyl, hLength, hLeaf, summa)
		select row_id, hierarchy, hierarchyl, hLength, hLeaf, summa from #RoundTotal
		where hLength = @nHierarchyLength
		order by hierarchy

	update dt
		set summa = coalesce((select coalesce(sum(rt.summa), 0) from #RoundTotal rt where rt.hLeaf = 1 and rt.hierarchyl = dt.hierarchy), 0) - dt.summa
			,nRecCnt = coalesce((select count(*) from #RoundTotal rt where rt.hLeaf = 1 and rt.hierarchyl = dt.hierarchy and rt.summa <> 0), 0)
		from #DifferenceTotal dt

	delete from #DifferenceTotal where summa = 0 or nRecCnt = 0

	if exists(select * from #DifferenceTotal)
		begin
			update #DifferenceTotal set nSumCnt = abs(convert(bigint, summa * Power(10, @nTotalPrecision)))
			update #DifferenceTotal set nSum = convert(bigint, nSumCnt / nRecCnt)
			update #DifferenceTotal set nSumCnt = nSumCnt % nRecCnt + 1

			if object_id('tempdb..#RoundTotalLeaf') is not null
				drop table #RoundTotalLeaf
			create table #RoundTotalLeaf (
				id integer identity(1, 1) not null constraint pk_tmp_RoundTotalLeaf_id primary key clustered with fillfactor = 100 on [primary],
				row_id uniqueidentifier,
				hierarchy varchar(900),
				hierarchyl varchar(900),
				hLength integer,
				hLeaf integer,
				summa numeric(28, 10),
				dt_hierarchy varchar(900),
				dt_summa numeric(28, 10),
				dt_nSum bigint,
				dt_nSumCnt bigint
			)
			create index ix_tmp_RoundTotalLeaf_r on #RoundTotalLeaf (row_id)
			create index ix_tmp_RoundTotalLeaf_l on #RoundTotalLeaf (hLength)
			if len(@cHierarchyFieldLen) > 0 begin
				execute ('
				begin
					alter table #RoundTotalLeaf alter column hierarchy varchar(' + @cHierarchyFieldLen + ')
					alter table #RoundTotalLeaf alter column hierarchyl varchar(' + @cHierarchyFieldLen + ')
					alter table #RoundTotalLeaf alter column dt_hierarchy varchar(' + @cHierarchyFieldLen + ')
				end
				')
			end else begin
				create index ix_tmp_RoundTotalLeaf_h on #RoundTotalLeaf (hierarchy)
				create index ix_tmp_RoundTotalLeaf_hl on #RoundTotalLeaf (hierarchyl)
				create index ix_tmp_RoundTotalLeaf_dt on #RoundTotalLeaf (dt_hierarchy)
			end

			set @cSql = '
			insert into #RoundTotalLeaf (row_id, hierarchy, hierarchyl, hLength, hLeaf, summa, dt_hierarchy, dt_summa, dt_nSum, dt_nSumCnt)
				select rt.row_id, rt.hierarchy, rt.hierarchyl, rt.hLength, rt.hLeaf, rt.summa, dt.hierarchy, dt.summa, dt.nSum, dt.nSumCnt
				from #RoundTotal rt, #DifferenceTotal dt
				where rt.hLeaf = 1 and rt.hierarchyl = dt.hierarchy and rt.summa <> 0
				' + case when col_length('tempdb..' + @cTableNotRound, 'row_id') is not null and col_length('tempdb..' + @cTableNotRound, 'fields') is not null then '
					and not exists(select * from ' + @cTableNotRound + ' f where f.fields like ''%,' + @cTotalFields + ',%'' and f.row_id = rt.row_id)' else '' end + '
				order by dt.hierarchy, rt.ves desc, rt.hierarchy
			'
			execute (@cSql)

			update #RoundTotalLeaf
				set summa = summa
					+ case when (case when @hierarchy = dt_hierarchy then @nSumCnt else dt_nSumCnt end) > 0 then (case when sign(dt_summa) >= 0 then -1.0 else 1.0 end) / power(10, @nTotalPrecision) else 0.0 end
					+ dt_nSum * (case when sign(dt_summa) >= 0 then -1.0 else 1.0 end) / power(10, @nTotalPrecision)
					, @nSumCnt = (case when @hierarchy = dt_hierarchy then @nSumCnt else dt_nSumCnt end) - 1, @hierarchy = dt_hierarchy

			update rt set summa = rtl.summa
				from #RoundTotal rt, #RoundTotalLeaf rtl
				where rt.row_id = rtl.row_id

			if object_id('tempdb..#RoundTotalLeaf') is not null
				drop table #RoundTotalLeaf
		end

	--  
	set @cSql = '
		update t set ' + @cTotalFields + ' = rt.summa
			from ' + @cTableName + ' t, #RoundTotal rt
			where t.' + @cIdentityField + ' = rt.row_id
	'
	execute (@cSql)

	if object_id('tempdb..#OriginalTotal') is not null
		drop table #OriginalTotal
	if object_id('tempdb..#RoundTotal') is not null
		drop table #RoundTotal
	if object_id('tempdb..#DifferenceTotal') is not null
		drop table #DifferenceTotal
end
GO

if object_id('dbo.IsvCalcPrecTotal') is not null begin
	grant execute on dbo.IsvCalcPrecTotal to public
end
GO


-- roundrro.sql

set quoted_identifier on
GO

set ansi_nulls on
GO

if objectproperty(object_id('dbo.ROUNDRRO'), 'IsProcedure') = 1
	drop procedure dbo.ROUNDRRO
GO
/*
:
	  
 :
	@dRoundRRO1   
	@dRoundRRO2   
	@div1000    :  : 3 - ., 5 - ., 7 - ..
	@digts    
	@flagtable=1       SUMMA  . ( )
	@this_year  
 :
	execute dbo.ROUNDRRO @dRoundRRO1='20210101',@dRoundRRO2='20211231',@div1000=3,@digts=1,@flagtable=0,@this_year=2021
:
	  (Keysystems),  ..
*/
create procedure dbo.ROUNDRRO

	@dRoundRRO1 datetime --    
	,@dRoundRRO2 datetime --    
	,@div1000 int  --3 .. 5 .. 7 ..
	,@digts int --   
	,@flagtable int = 0 -- 1       (  )
	,@this_year int -- 
	,@FlagRoundAll bit = 0  --1    
	,@test bit = 0 --1   ()

as
begin

	declare
		@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@GRADE_SUM_REESTR_RO int
		,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
		,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
		,@DICTIONARY_RRO_CONSOLIDATED_MO int,@DICTIONARY_FIELD_RRO int
		,@REFERENCE_TARGET_ITEM int,@DICTIONARY_TARGET_ITEM int
		,@nCode int
		,@ndiv1000 numeric(28, 10)
		,@name varchar(max),@link_self int,@object int,@names varchar(8000),@sql varchar(max)
		,@tree int,@tsql nvarchar(4000),@nobjectsumm int,@cobjectsumm varchar(100),@nyear int,@nobj int
	select @PLAN_SUM_REESTR_RO=dbo.obj_id('PLAN_SUM_REESTR_RO')
		,@ACTUAL_SUM_REESTR_RO=dbo.obj_id('ACTUAL_SUM_REESTR_RO')
		,@GRADE_SUM_REESTR_RO=dbo.obj_id('GRADE_SUM_REESTR_RO')
		,@DOCUMENTS_REESTR_RO=dbo.obj_id('DOCUMENTS_REESTR_RO')
		,@DOCUMENTS_REESTR_IZM=dbo.obj_id('DOCUMENTS_REESTR_IZM')
		,@DOCUMENTS_REESTR_SDR=dbo.obj_id('DOCUMENTS_REESTR_SDR')
		,@DOCUMENTS_TREESTR_RO=dbo.obj_id('DOCUMENTS_TREESTR_RO')
		,@DOCUMENTS_TREESTR_IZM=dbo.obj_id('DOCUMENTS_TREESTR_IZM')
		,@DOCUMENTS_TREESTR_SDR=dbo.obj_id('DOCUMENTS_TREESTR_SDR')
		,@DOCUMENTS_REESTR_SDR_IZM=coalesce(dbo.obj_id('DOCUMENTS_REESTR_SDR_IZM'),0)
		,@DOCUMENTS_TREESTR_SDR_IZM=coalesce(dbo.obj_id('DOCUMENTS_TREESTR_SDR_IZM'),0)
		,@DICTIONARY_SODERG_RO=dbo.obj_id('DICTIONARY_SODERG_RO')
		,@DICTIONARY_SODERG_RO_MO=dbo.obj_id('DICTIONARY_SODERG_RO_MO')
		,@DICTIONARY_RRO_CONSOLIDATED_MO=dbo.obj_id('DICTIONARY_RRO_CONSOLIDATED_MO')
		,@DICTIONARY_FIELD_RRO=dbo.obj_id('DICTIONARY_FIELD_RRO')
		,@REFERENCE_TARGET_ITEM=dbo.obj_id('REFERENCE_TARGET_ITEM')
		,@DICTIONARY_TARGET_ITEM=dbo.obj_id('DICTIONARY_TARGET_ITEM')
		,@tree=0

	select top 1 @tree=record from dbo.get_val_refer('NASTR_RRO_TREE_DICT_TAB_ROUND', 'SINGLE_REFER_VALUE', 0)

	if not (@div1000 in (3,5,7) or @digts in (0,1)) begin
		if @flagtable=1
			select value,link_up,object_dict,object,date_first,date_last,credit,credit2,kbk,corr,account,req,orders,subsh,summa,row_id,summa2
			from dbo.object_credit oc
			where oc.object_dict in (@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@GRADE_SUM_REESTR_RO)
			and exists(select * from dbo.credit_doc where link=oc.link_up
			and object in (@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM)
			and date between @dRoundRRO1 and @dRoundRRO2) and summa is not null
		return
	end

	set @ndiv1000=1
	if @div1000=3 set @ndiv1000=1000.0000000000
	if @div1000=5 set @ndiv1000=1000000.0000000000
	if @div1000=7 set @ndiv1000=1000000000.0000000000

	if object_id('tempdb..#RoundRRO') is not null
		drop table #RoundRRO

	create table #RoundRRO (
		hierarchy varchar(900)
		,caux varchar(254)
		,po int
		,object_poln int
		,link_up int
		,object_dict int
		,object int
		,date_first datetime
		,credit int
		,credit2 int
		,kbk int
		,req int
		,sround numeric(28, 10)
		,summa numeric(28, 10)
		,summa2 numeric(28, 10)
		,sitog money
		,row_id uniqueidentifier
		,value varchar(254)
		,date_last datetime
		,corr int
		,account int
		,orders int
		,subsh int
		,npo varchar(100)
		,tpo bigint
		,cgr varchar(254)
		,gr int
		,po1 int
		,po2 int
		,po3 int
		,po4 int
		,po5 int
		,cpo varchar(100)
		,cpo1 varchar(100)
		,cpo2 varchar(100)
		,cpo3 varchar(100)
		,cpo4 varchar(100)
		,cpo5 varchar(100)
		,vnut varchar(1)
		,ctgt varchar(20)
	)

	set @tsql='insert #RoundRRO (hierarchy,caux,po,object_poln,link_up,object_dict,object,date_first,credit,credit2,kbk,req,sround,summa,summa2)
	select cast(year(date_first) as varchar(900)) as hierarchy
	,coalesce((select top 1 code from dbo.s_note where link=oc.req),'''') as caux
	,(select top 1 po.credit from dbo.object_credit po where po.link_up=oc.link_up and po.object=oc.object and po.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO) and po.credit is not null) as po
	,(select top 1 po.object_dict from dbo.object_credit po where po.link_up=oc.link_up and po.object=oc.object and po.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO) and po.credit is not null) as object_poln
	,link_up,object_dict,object,date_first,credit,credit2,kbk,req
	,cast(sum(summa)/@ndiv1000*1.0000000000 as numeric(28, 10)) as sround
	,cast(sum(summa) as numeric(28, 10)) as summa
	,cast(sum(summa2) as numeric(28, 10)) as summa2
	from dbo.object_credit oc
	where oc.object_dict in (@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@GRADE_SUM_REESTR_RO)
	and object in (@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM)
	and exists(select * from dbo.credit_doc where link=oc.link_up and date between @dRoundRRO1 and @dRoundRRO2 and object=oc.object)'+case when @FlagRoundAll=0 then '
	and year(date_first) between @this_year-2 and @this_year+4' else '' end+'
	group by link_up,object_dict,object,date_first,credit,credit2,kbk,req'

	execute sp_executesql @tsql,N'@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
	,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@GRADE_SUM_REESTR_RO int
	,@nobj int,@nyear int,@this_year int
	,@ndiv1000 numeric(28, 10),@dRoundRRO1 datetime,@dRoundRRO2 datetime'
	,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@GRADE_SUM_REESTR_RO
	,@nobj,@nyear,@this_year
	,@ndiv1000,@dRoundRRO1,@dRoundRRO2

	if @FlagRoundAll=0 begin
--    
		create table #RoundRRO_sum_nastr(cnastr varchar(128)
		,nnastr int
		,nyear int
		,nobj int) 

		set @nobjectsumm=1
		while @nobjectsumm<=2 begin
		
-- ,  
			if @nobjectsumm=1
				set @cobjectsumm='COLUMN_REESTR_RO_SUMMA'
			else
				set @cobjectsumm='COLUMN_REESTR_SDR_SUMMA'

			insert #RoundRRO_sum_nastr(cnastr,nnastr,nyear,nobj) 
			select @cobjectsumm+'_F_4',coalesce(dbo.get_val_int(@cobjectsumm+'_F_4','NASTR_SHOW_DISABLE',0),1),@this_year-5,@ACTUAL_SUM_REESTR_RO
			union select @cobjectsumm+'_F_3',coalesce(dbo.get_val_int(@cobjectsumm+'_F_3','NASTR_SHOW_DISABLE',0),1),@this_year-4,@ACTUAL_SUM_REESTR_RO
			union select @cobjectsumm+'_F_2',coalesce(dbo.get_val_int(@cobjectsumm+'_F_2','NASTR_SHOW_DISABLE',0),1),@this_year-3,@ACTUAL_SUM_REESTR_RO
	--		union select @cobjectsumm+'_F_1',coalesce(dbo.get_val_int(@cobjectsumm+'_F_1','NASTR_SHOW_DISABLE',0),1),@this_year-2,@ACTUAL_SUM_REESTR_RO
	--		union select @cobjectsumm+'_F',coalesce(dbo.get_val_int(@cobjectsumm+'_F','NASTR_SHOW_DISABLE',0),1),@this_year-1,@ACTUAL_SUM_REESTR_RO
	--		union select @cobjectsumm+'_P',coalesce(dbo.get_val_int(@cobjectsumm+'_P','NASTR_SHOW_DISABLE',0),1),@this_year-1,@PLAN_SUM_REESTR_RO
	--		union select @cobjectsumm+'_P0',coalesce(dbo.get_val_int(@cobjectsumm+'_P0','NASTR_SHOW_DISABLE',0),1),@this_year,@PLAN_SUM_REESTR_RO
	--		union select @cobjectsumm+'_P1',coalesce(dbo.get_val_int(@cobjectsumm+'_P1','NASTR_SHOW_DISABLE',0),1),@this_year+1,@PLAN_SUM_REESTR_RO
	--		union select @cobjectsumm+'_P2',coalesce(dbo.get_val_int(@cobjectsumm+'_P2','NASTR_SHOW_DISABLE',0),1),@this_year+2,@PLAN_SUM_REESTR_RO
	--		union select @cobjectsumm+'_P3',coalesce(dbo.get_val_int(@cobjectsumm+'_P3','NASTR_SHOW_DISABLE',0),1),@this_year+3,@PLAN_SUM_REESTR_RO
	--		union select @cobjectsumm+'_P4',coalesce(dbo.get_val_int(@cobjectsumm+'_P4','NASTR_SHOW_DISABLE',0),1),@this_year+4,@PLAN_SUM_REESTR_RO
			union select @cobjectsumm+'_P5',coalesce(dbo.get_val_int(@cobjectsumm+'_P5','NASTR_SHOW_DISABLE',0),1),@this_year+5,@PLAN_SUM_REESTR_RO
	--		union select @cobjectsumm+'_P_1',coalesce(dbo.get_val_int(@cobjectsumm+'_P_1','NASTR_SHOW_DISABLE',0),1),@this_year-2,@PLAN_SUM_REESTR_RO
	--		union select @cobjectsumm+'_G',coalesce(dbo.get_val_int(@cobjectsumm+'_G','NASTR_SHOW_DISABLE',0),1),@this_year-1,@GRADE_SUM_REESTR_RO
	--		union select @cobjectsumm+'_G1',coalesce(dbo.get_val_int(@cobjectsumm+'_G1','NASTR_SHOW_DISABLE',0),1),@this_year,@GRADE_SUM_REESTR_RO
	--		union select @cobjectsumm+'_G2',coalesce(dbo.get_val_int(@cobjectsumm+'_G2','NASTR_SHOW_DISABLE',0),1),@this_year+1,@GRADE_SUM_REESTR_RO
	--		union select @cobjectsumm+'_G3',coalesce(dbo.get_val_int(@cobjectsumm+'_G3','NASTR_SHOW_DISABLE',0),1),@this_year+2,@GRADE_SUM_REESTR_RO
	--		union select @cobjectsumm+'_G4',coalesce(dbo.get_val_int(@cobjectsumm+'_G4','NASTR_SHOW_DISABLE',0),1),@this_year+3,@GRADE_SUM_REESTR_RO
	--		union select @cobjectsumm+'_G5',coalesce(dbo.get_val_int(@cobjectsumm+'_G5','NASTR_SHOW_DISABLE',0),1),@this_year+4,@GRADE_SUM_REESTR_RO
			union select @cobjectsumm+'_G6',coalesce(dbo.get_val_int(@cobjectsumm+'_G6','NASTR_SHOW_DISABLE',0),1),@this_year+5,@GRADE_SUM_REESTR_RO
	--		union select @cobjectsumm+'_G_1',coalesce(dbo.get_val_int(@cobjectsumm+'_G_1','NASTR_SHOW_DISABLE',0),1),@this_year-2,@GRADE_SUM_REESTR_RO
			union select @cobjectsumm+'_G_2',coalesce(dbo.get_val_int(@cobjectsumm+'_G_2','NASTR_SHOW_DISABLE',0),1),@this_year-3,@GRADE_SUM_REESTR_RO
			union select @cobjectsumm+'_G_3',coalesce(dbo.get_val_int(@cobjectsumm+'_G_3','NASTR_SHOW_DISABLE',0),1),@this_year-4,@GRADE_SUM_REESTR_RO
			union select @cobjectsumm+'_G_4',coalesce(dbo.get_val_int(@cobjectsumm+'_G_4','NASTR_SHOW_DISABLE',0),1),@this_year-5,@GRADE_SUM_REESTR_RO

			declare c_objectsumm cursor local forward_only static read_only for
			select distinct nyear,nobj from #RoundRRO_sum_nastr where nnastr=2 and nyear not between @this_year-2 and @this_year+4
			open c_objectsumm
			fetch next from c_objectsumm into @nyear,@nobj
			while @@fetch_status = 0
			begin

				set @tsql='
				insert #RoundRRO (hierarchy,caux,po,object_poln,link_up,object_dict,object,date_first,credit,credit2,kbk,req,sround,summa,summa2)
				select cast(year(date_first) as varchar(900)) as hierarchy
				,coalesce((select top 1 code from dbo.s_note where link=oc.req),'''') as caux
				,(select top 1 po.credit from dbo.object_credit po where po.link_up=oc.link_up and po.object=oc.object and po.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO) and po.credit is not null) as po
				,(select top 1 po.object_dict from dbo.object_credit po where po.link_up=oc.link_up and po.object=oc.object and po.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO) and po.credit is not null) as object_poln
				,link_up,object_dict,object,date_first,credit,credit2,kbk,req
				,cast(sum(summa)/@ndiv1000*1.0000000000 as numeric(28, 10)) as sround
				,cast(sum(summa) as numeric(28, 10)) as summa
				,cast(sum(summa2) as numeric(28, 10)) as summa2
				from dbo.object_credit oc
				where oc.object_dict=@nobj
				and object in ('+case when @nobjectsumm=1 then '@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM'
				else '@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM' end+')
				and exists(select * from dbo.credit_doc where link=oc.link_up and date between @dRoundRRO1 and @dRoundRRO2 and object=oc.object)
				and year(date_first)=@nyear
				group by link_up,object_dict,object,date_first,credit,credit2,kbk,req
				'
				execute sp_executesql @tsql,N'@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
				,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
				,@nobj int,@nyear int
				,@ndiv1000 numeric(28, 10),@dRoundRRO1 datetime,@dRoundRRO2 datetime'
				,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
				,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
				,@nobj,@nyear
				,@ndiv1000,@dRoundRRO1,@dRoundRRO2

				fetch next from c_objectsumm into @nyear,@nobj
			end
			close c_objectsumm
			deallocate c_objectsumm

			set @nobjectsumm=@nobjectsumm+1
		end
	end
-- 
	update t set corr=(select top 1 corr from dbo.object_credit where link_up=t.link_up and object=t.object and object_dict=t.object and corr is not null) from #RoundRRO t

	update t set ctgt=substring(sk.code,4,2) from #RoundRRO t
	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_TARGET_ITEM
	join dbo.s_kbk sk on sk.link=tk.ref2 and sk.object=@DICTIONARY_TARGET_ITEM
	and substring(sk.code,4,1) in ('A','D','E','F','G','I','J','L','N','P','R','S','T','V','U','Y')

	update t set po5=t.po,po4=t.po,po3=t.po,po2=t.po,po1=t.po,cpo=cd.number from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.po

	update t set po5=coalesce(cd.link_class,t.po)
	from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.po-- and cd.link_class is not null

	update t set po4=t.po5,cpo4=cd.number,cpo3=cd.number,cpo2=cd.number,cpo1=cd.number
	,po5=coalesce(cd.link_class,t.po5)
	from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.po5-- and cd.link_class is not null

	update t set po3=t.po4,cpo3=t.cpo4,cpo2=t.cpo4,cpo1=t.cpo4
	,po4=t.po5,cpo4=cd.number
	,po5=coalesce(cd.link_class,t.po5)
	from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.po5-- and cd.link_class is not null

	update t set po2=t.po3,cpo2=t.cpo3,cpo1=t.cpo3
	,po3=t.po4,cpo3=t.cpo4
	,po4=t.po5,cpo4=cd.number
	,po5=coalesce(cd.link_class,t.po5)
	from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.po5-- and cd.link_class is not null

	update t set po1=t.po2,cpo1=t.cpo2
	,po2=t.po3,cpo2=t.cpo3
	,po3=t.po4,cpo3=t.cpo4
	,po4=t.po5,cpo4=cd.number
	,po5=coalesce(cd.link_class,t.po5)
	from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.po5-- and cd.link_class is not null

	update t set cpo5=cd.number
	from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.po5

	declare @step int
	set @step=1
	while exists(select * from #RoundRRO where po5=po4 and po5=po3 and po4=po2) and @step<5 begin
		update #RoundRRO set po2=po1,cpo2=cpo1,po1=po,cpo1=cpo where po5=po4 and po5=po3 and po4=po2
		set @step=@step+1
	end
	set @step=1
	while exists(select * from #RoundRRO where po5=po4 and po5=po3) and @step<5 begin
		update #RoundRRO set po3=po2,cpo3=cpo2,po2=po1,cpo2=cpo1,po1=po,cpo1=cpo where po5=po4 and po5=po3
		set @step=@step+1
	end
	set @step=1
	while exists(select * from #RoundRRO where po5=po4) and @step<5 begin
		update #RoundRRO set po4=po3,cpo4=cpo3,po3=po2,cpo3=cpo2,po2=po1,cpo2=cpo1,po1=po,cpo1=cpo where po5=po4
		set @step=@step+1
	end

	update #RoundRRO set vnut='0'
	update #RoundRRO set vnut='1' where cpo in ('1204','2100','2604','3500','3804','4700','5204','6100','6804','7700','8304','9200','9504','10400','10704','11600') and object_poln=@DICTIONARY_SODERG_RO_MO
	update #RoundRRO set vnut='1' where cpo1 in ('1204','2100','2604','3500','3804','4700','5204','6100','6804','7700','8304','9200','9504','10400','10704','11600') and object_poln=@DICTIONARY_SODERG_RO_MO
	update #RoundRRO set vnut='1' where cpo2 in ('1204','2100','2604','3500','3804','4700','5204','6100','6804','7700','8304','9200','9504','10400','10704','11600') and object_poln=@DICTIONARY_SODERG_RO_MO
	update #RoundRRO set vnut='1' where cpo3 in ('1204','2100','2604','3500','3804','4700','5204','6100','6804','7700','8304','9200','9504','10400','10704','11600') and object_poln=@DICTIONARY_SODERG_RO_MO
	update #RoundRRO set vnut='1' where cpo4 in ('1204','2100','2604','3500','3804','4700','5204','6100','6804','7700','8304','9200','9504','10400','10704','11600') and object_poln=@DICTIONARY_SODERG_RO_MO

	update t set hierarchy=hierarchy+replace(str(t.object_poln,10),' ','0')+replace(str(t.object_dict,10),' ','0')
	+case when oc.object=@DICTIONARY_SODERG_RO_MO and len(coalesce(oc.value,''))>0 then left(oc.value,1) else '0' end
	--25 ,  ,  ,  
	+case when len(caux)>=2 and substring(caux,2,1) in ('1','6') then '1'
		when len(caux)>=2 and substring(caux,2,1) in ('2','9','A','B','C') then '2'
		when len(caux)>=2 and t.object_poln=@DICTIONARY_SODERG_RO_MO and substring(caux,2,1) in ('5','F','G','H','D') then '5'
		else '3' end--26  ( )
	+case when len(caux)>0 and left(caux,1)='1' then '1' else '0' end--27 
	+vnut--28  
	,npo=case when oc.object=@DICTIONARY_SODERG_RO_MO then coalesce(oc.value,'') else '' end
	,gr=oc.credit
	,row_id=newid()
	from #RoundRRO t
	join dbo.object_credit oc on oc.link_up=t.po and oc.object=t.object_poln and oc.object_dict=t.object_poln and oc.value is not null

	update t set cgr=cd.number from #RoundRRO t
	join dbo.credit_doc cd on cd.link=t.gr
	update #RoundRRO set cgr=coalesce(cgr,'')

	update #RoundRRO set hierarchy=hierarchy
	+case when ctgt is not null and substring(caux,2,1) in ('6','7','8','9','A','B','C','D','E','F','G','H') then '1' else '0' end--29   .
	+case when ctgt is not null then left(ctgt,1) else '0' end--30  . 1 
	+case when ctgt is not null then right(ctgt,1) else '0' end--31  . 2 
	+'00'-- 33 
	+replace(str(coalesce(po5,0),10),' ','0')--43   
	+replace(str(coalesce(po4,0),10),' ','0')--53   
	+replace(str(coalesce(po3,0),10),' ','0')--63   
	+replace(str(coalesce(po2,0),10),' ','0')--73   
	+replace(str(coalesce(po1,0),10),' ','0')--83   
	+replace(str(coalesce(po,0),10),' ','0')--93 
	+replace(str(coalesce(corr,0),10),' ','0')--103 
	+replace(str(coalesce(req,0),10),' ','0')--113  
	+replace(str(coalesce(kbk,0),10),' ','0')--123 
	+replace(str(coalesce(credit,0),10),' ','0')--133  
	+replace(str(coalesce(credit2,0),10),' ','0')--143  
	+replace(str(coalesce(link_up,0),10),' ','0')--153 

--25 ,  ,  ,  
	if object_id('tempdb..#RoundRRO25') is not null
		drop table #RoundRRO25

	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	into #RoundRRO25
	from (select cast(left(hierarchy,25) as varchar(900)) as hierarchy,round(sum(sround),@digts) as sround,sum(summa) as summa
	from #RoundRRO group by left(hierarchy,25))f

--26  ( )
	union select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,26) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO group by left(hierarchy,26))f

	if object_id('tempdb..#RoundRRO26') is not null
		drop table #RoundRRO26

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO26 from #RoundRRO25 t where len(hierarchy) in (25,26)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO26'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (25,26)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '25', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO26 order by hierarchy

--27 
	insert #RoundRRO26 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,27) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,27))f

	if object_id('tempdb..#RoundRRO27') is not null
		drop table #RoundRRO27

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO27 from #RoundRRO26 t where len(hierarchy) in (26,27)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO27'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (26,27)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '26', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO27 order by hierarchy

--28  
	insert #RoundRRO27 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,28) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,28))f

	if object_id('tempdb..#RoundRRO28') is not null
		drop table #RoundRRO28

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO28 from #RoundRRO27 t where len(hierarchy) in (27,28)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO28'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (27,28)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '27', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO28 order by hierarchy

--29   .
	insert #RoundRRO28 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,29) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,29))f

	if object_id('tempdb..#RoundRRO29') is not null
		drop table #RoundRRO29

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO29 from #RoundRRO28 t where len(hierarchy) in (28,29)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO29'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (28,29)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '28', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO29 order by hierarchy

--30  . 1 
	insert #RoundRRO29 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,30) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,30))f

	if object_id('tempdb..#RoundRRO30') is not null
		drop table #RoundRRO30

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO30 from #RoundRRO29 t where len(hierarchy) in (29,30)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO30'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (29,30)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '29', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO30 order by hierarchy

--33    .
	insert #RoundRRO30 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,33) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,33))f

	if object_id('tempdb..#RoundRRO33') is not null
		drop table #RoundRRO33

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO33 from #RoundRRO30 t where len(hierarchy) in (30,33)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO33'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (30,33)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '30', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO33 order by hierarchy

--43  
	insert #RoundRRO33 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,43) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,43))f

	if object_id('tempdb..#RoundRRO43') is not null
		drop table #RoundRRO43

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO43 from #RoundRRO33 t where len(hierarchy) in (33,43)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO43'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (33,43)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '33', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO43 order by hierarchy

--53  
	insert #RoundRRO43 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,53) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,53))f

	if object_id('tempdb..#RoundRRO53') is not null
		drop table #RoundRRO53

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO53 from #RoundRRO43 t where len(hierarchy) in (43,53)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO53'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (43,53)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '43', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO53 order by hierarchy

--63  
	insert #RoundRRO53 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,63) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,63))f

	if object_id('tempdb..#RoundRRO63') is not null
		drop table #RoundRRO63

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO63 from #RoundRRO53 t where len(hierarchy) in (53,63)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO63'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (53,63)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '53', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO63 order by hierarchy

--73  
	insert #RoundRRO63 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,73) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,73))f

	if object_id('tempdb..#RoundRRO73') is not null
		drop table #RoundRRO73

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO73 from #RoundRRO63 t where len(hierarchy) in (63,73)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO73'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (63,73)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '63', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO73 order by hierarchy

--83  
	insert #RoundRRO73 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,83) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,83))f

	if object_id('tempdb..#RoundRRO83') is not null
		drop table #RoundRRO83

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO83 from #RoundRRO73 t where len(hierarchy) in (73,83)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO83'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (73,83)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '73', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO83 order by hierarchy

--93 
	insert #RoundRRO83 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,93) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,93))f

	if object_id('tempdb..#RoundRRO93') is not null
		drop table #RoundRRO93

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO93 from #RoundRRO83 t where len(hierarchy) in (83,93)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO93'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (83,93)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '83', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO93 order by hierarchy

--103 
	insert #RoundRRO93 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,cast(newid() as uniqueidentifier) as row_id,summa
	from (select cast(left(hierarchy,103) as varchar(900)) as hierarchy,sum(sround) as sround,sum(summa) as summa
	from #RoundRRO
	group by left(hierarchy,103))f

	if object_id('tempdb..#RoundRRO103') is not null
		drop table #RoundRRO103

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO103 from #RoundRRO93 t where len(hierarchy) in (93,103)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO103'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (93,103)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '93', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select *,len(hierarchy) from #RoundRRO103 order by hierarchy

--153-
	insert #RoundRRO103 (hierarchy,sround,row_id,summa)
	select hierarchy,sround,row_id,summa
	from #RoundRRO
	where len(hierarchy)=153

	if object_id('tempdb..#RoundRRO153') is not null
		drop table #RoundRRO153

	select distinct hierarchy,sround,row_id,summa
	into #RoundRRO153 from #RoundRRO103 t where len(hierarchy) in (103,153)
	order by hierarchy

	execute dbo.IsvCalcPrecTotal @cTableName = '#RoundRRO153'--, @cAddWhere = 'row_id is not null and len(hierarchy) in (103,153)'
	,@cIdentityField = 'row_id', @cHierarchyField = 'hierarchy', @cHierarchyLength = '103', @nTotalPrecision = @digts
	,@cTotalFields = 'sround', @nErrorCode = @nCode output
--select len(t.hierarchy),* from #RoundRRO153 t order by t.hierarchy

-----------------------

	update t set sitog=t2.sround
	from #RoundRRO t join #RoundRRO153 t2 on t2.row_id=t.row_id

	if @test=0 begin
		if @flagtable=1 begin
			if @div1000=3
				select value,link_up,object_dict,object,date_first,date_last,credit,credit2,kbk,corr,account,req,orders,subsh,sitog*1000 as summa,row_id,sitog as summa2
				from #RoundRRO where len(hierarchy)=153
			if @div1000=5
				select value,link_up,object_dict,object,date_first,date_last,credit,credit2,kbk,corr,account,req,orders,subsh,sitog*1000000 as summa,row_id,sitog as summa2
				from #RoundRRO where len(hierarchy)=153
			if @div1000=7
				select value,link_up,object_dict,object,date_first,date_last,credit,credit2,kbk,corr,account,req,orders,subsh,sitog*1000000000 as summa,row_id,sitog as summa2
				from #RoundRRO where len(hierarchy)=153
		end else
			select value,link_up,object_dict,object,date_first,date_last,credit,credit2,kbk,corr,account,req,orders,subsh,sitog as summa,row_id,sitog as summa2
			from #RoundRRO where len(hierarchy)=153
	end else
		select * from #RoundRRO where len(hierarchy)=153
end
GO

if object_id('dbo.ROUNDRRO') is not null grant execute on dbo.ROUNDRRO to public
GO


-- SQUERY_REESTR_RO_76N-SYS_2458925_5Q00YYQ54.sql

--squery
--KS-1063\katyakov 26.02.2025

--%OBJECT%SYS_2458925_5Q00YYQ54%%
-- :    (   34)

if object_id('tempdb..#T_OBJ') is not null drop table #T_OBJ
if object_id('tempdb..#T_PROP') is not null drop table #T_PROP
if object_id('tempdb..#T_OBJECT') is not null drop table #T_OBJECT
if object_id('tempdb..#T_GROUPS') is not null drop table #T_GROUPS

GO


	CREATE TABLE #T_OBJ (LINK int, NAME varchar(254), OBJECT int, CODE varchar(100), USERS int, ORDERS int, LINK_SELF int, LINK_STATE int, CODE_OBJ varchar(100), CODE_SELF varchar(100), CODE_STATE varchar(100))


	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', '26885210911198922764692133', null, 35, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SMKC6')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ3L', null, 1, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SRE44')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ3M', null, 2, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SRE44')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ3N', null, 3, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ3O', null, 999, 'SQUERY_CALC_FIELD', 'SYS_2458925_5Q00YYQ54', 'SYS_2451999_0CO0WTIQ2')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ3P', null, 0, 'SQUERY_LINK_BASE', 'SYS_2458925_5Q00YYQ3O', 'SYS_2451999_0CO0WTIQ2')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ3Q', null, 0, 'SQUERY_LINK_SOURCE', 'SYS_2458925_5Q00YYQ3O', 'SYS_2451999_0CO0WTIQ2')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ3R', null, 0, 'SQUERY_LINK_SQUERY', 'SYS_2458925_5Q00YYQ3O', 'SYS_2458925_5Q00YYQ54')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('   - ', 'SYS_2458925_5Q00YYQ3S', null, 4, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('   ()', 'SYS_2458925_5Q00YYQ3T', null, 5, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  -  ', 'SYS_2458925_5Q00YYQ3U', null, 6, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  -   - ', 'SYS_2458925_5Q00YYQ3V', null, 7, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  -   ()', 'SYS_2458925_5Q00YYQ3W', null, 8, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ3X', null, 11, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SPJX8')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ3Y', null, 12, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2456597_3WZ0Q27SA')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ40', null, 1, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2453663_1N30VHE9Y')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('    ', 'SYS_2458925_5Q00YYQ41', null, 2, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2453685_1NP15IJFU')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ42', null, 3, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452075_0ES11WDAS')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ43', null, 4, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452075_0ES11W9R4')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ44', null, 5, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452075_0ES11WGRP')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ45', null, 6, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452075_0ES11XAR1')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ46', null, 7, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452075_0ES11XDUV')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('. ', 'SYS_2458925_5Q00YYQ47', null, 8, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452075_0ES120FUG')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ48', null, 9, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2454777_2I70HZDH1')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ49', null, 10, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452018_0D713HY5T')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ,   ', 'SYS_2458925_5Q00YYQ4A', null, 11, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2454257_23P0K9XH5')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ4B', null, 12, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2454210_22E0SBYSY')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ4C', null, 13, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2454210_22E0SBV81')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4D', null, 14, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452591_0T60IH9JK')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ4E', null, 15, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2454712_2GE0WKDHB')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4F', null, 13, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SMKC6')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('   (),  ()', 'SYS_2458925_5Q00YYQ4G', null, 14, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('      ', 'SYS_2458925_5Q00YYQ4H', null, 15, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('     ', 'SYS_2458925_5Q00YYQ4I', null, 16, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ4J', null, 17, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('   ', 'SYS_2458925_5Q00YYQ4K', null, 18, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4L', null, 19, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452053_0E60N8VDM')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4M', null, 21, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4N', null, 22, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ4O', null, 23, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ4P', null, 24, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('   ', 'SYS_2458925_5Q00YYQ4Q', null, 21, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2454616_2DQ0S0UTJ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ4R', null, 25, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('    ', 'SYS_2458925_5Q00YYQ4S', null, 26, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4T', null, 27, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4U', null, 28, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2458925_5Q00YYQ4V', null, 29, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('   () - ', 'SYS_2458925_5Q00YYQ4X', null, 9, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  -   () - ', 'SYS_2458925_5Q00YYQ4Y', null, 10, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458925_5Q00YYQ4Z', null, 30, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452053_0E60N8VDM')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ50', null, 22, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2457890_4X30J5UPE')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2458925_5Q00YYQ51', null, 31, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452053_0E60N8VDM')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('   (   34)', 'SYS_2458925_5Q00YYQ54', null, 0, 'SQUERY_REESTR_RO_76N', null, null)
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES (' ', 'SYS_2458927_5Q20UZ0SA', null, 20, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('     ', 'SYS_2458969_5R814Y1RA', null, 33, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('  ', 'SYS_2459307_60N0ZHNXN', null, 23, 'SQUERY_OTBOR', 'SYS_2458925_5Q00YYQ54', 'SYS_2457841_4VQ0VX3X6')
	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('', 'SYS_2459369_62D10YYZR', null, 34, 'SQUERY_LINK_NASTR', 'SYS_2458925_5Q00YYQ54', 'SYS_2452040_0DT0SOMGQ')

GO
		

	CREATE TABLE #T_PROP (LINK_UP int, PROPERTY int, USERS int, ORDERS int, VALUE nvarchar(max), CODE_UP varchar(100), CODE_PROP varchar(100))


	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', '26885210911198922764692133', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', '26885210911198922764692133', 'SQUERY_DICT_WHERE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', '26885210911198922764692133', 'SQUERY_FIELD_TYPE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@cText_35', '26885210911198922764692133', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', '26885210911198922764692133', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', '26885210911198922764692133', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '  ', '26885210911198922764692133', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '0', '26885210911198922764692133', 'SQUERY_NOT_VISIBLE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ3L', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@dDate_1', 'SYS_2458925_5Q00YYQ3L', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ3L', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '0', 'SYS_2458925_5Q00YYQ3L', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, ' . ', 'SYS_2458925_5Q00YYQ3L', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ3M', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@dDate_2', 'SYS_2458925_5Q00YYQ3M', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '0', 'SYS_2458925_5Q00YYQ3M', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, ' . ', 'SYS_2458925_5Q00YYQ3M', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_3', 'SYS_2458925_5Q00YYQ3N', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3N', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ3N', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'S_89440090', 'SYS_2458925_5Q00YYQ3O', 'SQUERY_FIELD_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ3O', 'SQUERY_FIELD_SQLTYPE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '2', 'SYS_2458925_5Q00YYQ3O', 'SQUERY_FIELD_TYPE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_4', 'SYS_2458925_5Q00YYQ3S', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3S', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ3S', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_5', 'SYS_2458925_5Q00YYQ3T', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3T', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ3T', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_6', 'SYS_2458925_5Q00YYQ3U', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3U', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ3U', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_7', 'SYS_2458925_5Q00YYQ3V', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3V', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ3V', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_8', 'SYS_2458925_5Q00YYQ3W', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3W', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ3W', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nOption_9', 'SYS_2458925_5Q00YYQ3X', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3X', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, ',,', 'SYS_2458925_5Q00YYQ3X', 'SQUERY_NASTR_SOURCE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ3X', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ3Y', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nInt_10', 'SYS_2458925_5Q00YYQ3Y', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ3Y', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ3Y', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '2025', 'SYS_2458925_5Q00YYQ3Y', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ41', 'SQUERY_DICT_WHERE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ48', 'SQUERY_DICT_WHERE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ48', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'exists(select * from object_credit where corr=c.link and object=object_dict)', 'SYS_2458925_5Q00YYQ49', 'SQUERY_DICT_WHERE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ49', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4E', 'SQUERY_DICT_WHERE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4E', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4F', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@cText_12', 'SYS_2458925_5Q00YYQ4F', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4F', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4G', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_13', 'SYS_2458925_5Q00YYQ4G', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4G', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4G', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4G', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4H', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_14', 'SYS_2458925_5Q00YYQ4H', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4H', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4H', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4H', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_15', 'SYS_2458925_5Q00YYQ4I', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4I', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4I', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_16', 'SYS_2458925_5Q00YYQ4J', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4J', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4J', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_17', 'SYS_2458925_5Q00YYQ4K', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4K', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4K', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4L', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCombo_18', 'SYS_2458925_5Q00YYQ4L', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4L', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4L', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, ',,   ,  ,,    ,. ,.  ( ),  ,, ( )', 'SYS_2458925_5Q00YYQ4L', 'SQUERY_NASTR_SOURCE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4L', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_19', 'SYS_2458925_5Q00YYQ4M', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4M', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4M', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_20', 'SYS_2458925_5Q00YYQ4N', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4N', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4N', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_21', 'SYS_2458925_5Q00YYQ4O', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4O', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4O', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_22', 'SYS_2458925_5Q00YYQ4P', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4P', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4P', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_23', 'SYS_2458925_5Q00YYQ4R', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4R', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4R', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4S', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_24', 'SYS_2458925_5Q00YYQ4S', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4S', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4S', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_25', 'SYS_2458925_5Q00YYQ4T', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4T', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4T', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_26', 'SYS_2458925_5Q00YYQ4U', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4U', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4U', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4V', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_27', 'SYS_2458925_5Q00YYQ4V', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4V', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4V', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_29', 'SYS_2458925_5Q00YYQ4X', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4X', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4X', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_30', 'SYS_2458925_5Q00YYQ4Y', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4Y', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458925_5Q00YYQ4Y', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4Z', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCombo_31', 'SYS_2458925_5Q00YYQ4Z', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4Z', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ4Z', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, ',,,,,  ', 'SYS_2458925_5Q00YYQ4Z', 'SQUERY_NASTR_SOURCE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ4Z', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ51', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCombo_32', 'SYS_2458925_5Q00YYQ51', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ51', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '   ,   ', 'SYS_2458925_5Q00YYQ51', 'SQUERY_NASTR_SOURCE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '   ', 'SYS_2458925_5Q00YYQ51', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, 'CREATE PROCEDURE #P_SQUERY --   (   34)
		@cText_12 varchar(4000) /* */,
		@cText_35 varchar(4000) /*  */,
		@dDate_1 datetime /* */,
		@dDate_2 datetime /* */,
		@nCheck_11 int /*  */,
		@nCheck_13 int /*   (),  ()*/,
		@nCheck_14 int /*      */,
		@nCheck_15 int /*     */,
		@nCheck_16 int /*  */,
		@nCheck_17 int /*   */,
		@nCheck_19 int /**/,
		@nCheck_20 int /**/,
		@nCheck_21 int /**/,
		@nCheck_22 int /*  */,
		@nCheck_23 int /*  */,
		@nCheck_24 int /*    */,
		@nCheck_25 int /*.*/,
		@nCheck_26 int /*.*/,
		@nCheck_27 int /**/,
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '		@nCheck_29 int /*   () - */,
		@nCheck_3 int /*  */,
		@nCheck_30 int /*  -   () - */,
		@nCheck_33 int /*     */,
		@nCheck_34 int /**/,
		@nCheck_4 int /*   - */,
		@nCheck_5 int /*   ()*/,
		@nCheck_6 int /*  -  */,
		@nCheck_7 int /*  -   - */,
		@nCheck_8 int /*  -   ()*/,
		@nCombo_18 int /* */,
		@nCombo_31 int /* */,
		@nCombo_32 int /*  */,
		@nInt_10 int /* */,
		@nOption_9 int /**/,
		@nOtborLink1 int = 0 /*  */,
		@nOtborLink2 int = 0 /*    */,
		@nOtborLink3 int = 0 /**/,
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '		@nOtborLink4 int = 0 /**/,
		@nOtborLink5 int = 0 /* */,
		@nOtborLink6 int = 0 /* */,
		@nOtborLink7 int = 0 /**/,
		@nOtborLink8 int = 0 /*. */,
		@nOtborLink9 int = 0 /* */,
		@nOtborLink10 int = 0 /**/,
		@nOtborLink11 int = 0 /* ,   */,
		@nOtborLink12 int = 0 /*  */,
		@nOtborLink13 int = 0 /*  */,
		@nOtborLink14 int = 0 /* */,
		@nOtborLink15 int = 0 /**/,
		@nOtborLink21 int = 0 /*   */,
		@nOtborLink22 int = 0 /*  */,
		@nOtborLink23 int = 0 /*  */,
--		@nOtborLink24 int = 0 /* */,
		@cTableInto varchar(20) = '''',
		@nDictFilter int = NULL,
		@user int = 0
AS
BEGIN

	set @user = coalesce(nullif(@user, 0), dbo.user_id(null))

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '	-- #161282  ,      m_exec_squery,       report_exec
	if object_id(''tempdb..#t_inv_otbors'') is null
	begin
		create table #t_inv_otbors (link int, code varchar(100))
	end

	if object_id(''tempdb..#t_inv_otbors0'') is null
	begin
		insert into #t_inv_otbors (link)
		select v.link_up 
		from dbo.object_var_values v, dbo.obj_ids(''SQUERY_OTBOR_INV'') o
		where v.link_up in (@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,
			@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21,@nOtborLink22,@nOtborLink23/*,@nOtborLink24*/)
			and v.property = o.link and v.value = ''1''
			and not exists(select * from #t_inv_otbors t where t.link = v.link_up)
		group by v.link_up
	end

	if not (@nInt_10>=2012 and @nInt_10<=2025) begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '		raiserror(''%s " " " "  .   .'', 16, 1, '''')
		return
	end

	declare @SRID uniqueidentifier, @nVarLink integer, @cSqCode varchar(100),@div1000 int,@digts int
	-- #161282  ,      m_exec_squery,       report_exec
	if object_id(''tempdb..#t_report_nastrs'') is null
	begin
		set @cSqCode = ''SYS_2458925_5Q00YYQ54''
		set @SRID = cast(cast(@@spid as binary(16)) as uniqueidentifier)
		select @nVarLink = orders from dbo.sysvalues(@SRID) sv     where sv.code = @cSqCode

		select @div1000=dbo.m_get_sq_nastr(@nVarLink, null, ''SQUERY_DIV1000'', 0) --     
		select @digts=dbo.m_get_sq_nastr(@nVarLink, null, ''SQUERY_DIV1000_DIGITS'', 0) --    
	end
	else
	begin
		set @div1000 = coalesce((select top 1 cast(value as int) from #t_report_nastrs where code=''SQUERY_DIV1000'' and isnumeric(value)=1), 1)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '		set @digts = coalesce((select top 1 cast(value as int) from #t_report_nastrs where code=''SQUERY_DIV1000_DIGITS'' and isnumeric(value)=1), 2)
	end

create table #t_res(id int identity primary key,
 r int
,kbk int
,god int
,obj int
,corr int
,s money--numeric(28,8)
,k money--numeric(28,8)
,dep int
,div int
,tgt int
,exp int
,itm int
,dop int
,lcl int
,po int
,cpo varchar(100)
,objpo int
,objcd int
,name varchar(8000)
,row_id uniqueidentifier
,hierarchy varchar(254)
,metod int
,oc int
,lev int
,su int
,ate int
,status int
,cd int
,list int
,ecp varchar(8000))

declare @sql varchar(max),@sql2 varchar(max),@cCheck_16 varchar(1)
,@tsql nvarchar(4000),@tsql2 nvarchar(4000),@tsql3 nvarchar(4000),@tsql4 nvarchar(4000),@tsql_npa nvarchar(4000)
,@not2 int
,@lev int
,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 7, ',@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int
,@DOCUMENTS_REESTR_SDR_IZM int, @DOCUMENTS_TREESTR_SDR_IZM int
,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int,@DICTIONARY_REASON_CREDIT int
,@DICTIONARY_CORR int,@DICTIONARY_CORR_TYPE int,@REFERENCE_CORR_TYPE int,@COLUMN_DICT_BUDJET_E_NAME_B int,@REFERENCE_BUDJET_EXP int,@DICTIONARY_DIVISION int
,@REFERENCE_BCORR int
,@DICTIONARY_DEPARTMENT int
,@DICTIONARY_TARGET_ITEM int
,@DICTIONARY_EXPEND int
,@DICTIONARY_ITEM int
,@DICTIONARY_ADD_BK int
,@DICTIONARY_KBK_LOCAL int
,@rid UniqueIdentifier
,@link int
,@SQUERY_USER_TREE int
,@checked int,@cfrom2 varchar(8000),@cwhere2 varchar(max),@link_self int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 8, ',@DICTIONARY_FIELD_RRO int
,@DICTIONARY_AUTHORITY_GROUP int
,@po int,@bud int,@st int,@ate int
,@DICTIONARY_RRO_CONSOLIDATED_MO int
,@DICTIONARY_NPA_GROUP int
,@DICTIONARY_LEVEL_NORM_DOC int
,@NASTR_RRO_RASH_YEAR int
,@NASTR_RRO_RASH_YEAR_MO int
,@list int,@cpo varchar(100),@cpog varchar(254),@ctgt varchar(254)
select @PLAN_SUM_REESTR_RO=dbo.obj_id(''PLAN_SUM_REESTR_RO'')
,@ACTUAL_SUM_REESTR_RO=dbo.obj_id(''ACTUAL_SUM_REESTR_RO'')
,@DICTIONARY_PREC_DOC=dbo.obj_id(''DICTIONARY_PREC_DOC'')
,@DICTIONARY_NORM_DOC=dbo.obj_id(''DICTIONARY_NORM_DOC'')
,@GRADE_SUM_REESTR_RO=dbo.obj_id(''GRADE_SUM_REESTR_RO'')*@nCheck_22 /*     */
,@DOCUMENTS_REESTR_RO=dbo.obj_id(''DOCUMENTS_REESTR_RO'')*@nCheck_3 /*  */
,@DOCUMENTS_REESTR_IZM=dbo.obj_id(''DOCUMENTS_REESTR_IZM'')*@nCheck_4 /*   - */
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 9, ',@DOCUMENTS_REESTR_SDR=dbo.obj_id(''DOCUMENTS_REESTR_SDR'')*@nCheck_5 /*   ()*/
,@DOCUMENTS_TREESTR_RO=dbo.obj_id(''DOCUMENTS_TREESTR_RO'')*@nCheck_6 /*  -  */
,@DOCUMENTS_TREESTR_IZM=dbo.obj_id(''DOCUMENTS_TREESTR_IZM'')*@nCheck_7 /*  -   - */
,@DOCUMENTS_TREESTR_SDR=dbo.obj_id(''DOCUMENTS_TREESTR_SDR'')*@nCheck_8 /*  -   ()*/
,@DOCUMENTS_REESTR_SDR_IZM=coalesce(dbo.obj_id(''DOCUMENTS_REESTR_SDR_IZM'')*@nCheck_29,0) /*  () - */
,@DOCUMENTS_TREESTR_SDR_IZM=coalesce(dbo.obj_id(''DOCUMENTS_TREESTR_SDR_IZM'')*@nCheck_30,0) /* -   () - */
,@REFERENCE_DEPARTMENT=dbo.obj_id(''REFERENCE_DEPARTMENT'')
,@REFERENCE_DIVISION=dbo.obj_id(''REFERENCE_DIVISION'')
,@REFERENCE_TARGET_ITEM=dbo.obj_id(''REFERENCE_TARGET_ITEM'')
,@REFERENCE_EXPEND=dbo.obj_id(''REFERENCE_EXPEND'')
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 10, ',@REFERENCE_ITEM=dbo.obj_id(''REFERENCE_ITEM'')
,@REFERENCE_ADD_BK=dbo.obj_id(''REFERENCE_ADD_BK'')
,@REFERENCE_KBK_LOCAL=dbo.obj_id(''REFERENCE_KBK_LOCAL'')
,@DICTIONARY_SODERG_RO=dbo.obj_id(''DICTIONARY_SODERG_RO'')
,@DICTIONARY_SODERG_RO_MO=dbo.obj_id(''DICTIONARY_SODERG_RO_MO'')
,@DICTIONARY_ANALITIC=dbo.obj_id(''DICTIONARY_ANALITIC'')
,@DICTIONARY_ATE=dbo.obj_id(''DICTIONARY_ATE'')
,@DICTIONARY_REASON_CREDIT=dbo.obj_id(''DICTIONARY_REASON_CREDIT'')
,@DICTIONARY_CORR=dbo.obj_id(''DICTIONARY_CORR'')
,@DICTIONARY_CORR_TYPE=dbo.obj_id(''DICTIONARY_CORR_TYPE'')
,@REFERENCE_CORR_TYPE=dbo.obj_id(''REFERENCE_CORR_TYPE'')
,@COLUMN_DICT_BUDJET_E_NAME_B=dbo.obj_id(''COLUMN_DICT_BUDJET_E_NAME_B'')
,@REFERENCE_BUDJET_EXP=dbo.obj_id(''REFERENCE_BUDJET_EXP'')
,@DICTIONARY_DIVISION=dbo.obj_id(''DICTIONARY_DIVISION'')
,@REFERENCE_BCORR=dbo.obj_id(''REFERENCE_BCORR'')
,@DICTIONARY_DEPARTMENT=dbo.obj_id(''DICTIONARY_DEPARTMENT'')
,@DICTIONARY_TARGET_ITEM=dbo.obj_id(''DICTIONARY_TARGET_ITEM'')
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 11, ',@DICTIONARY_EXPEND=dbo.obj_id(''DICTIONARY_EXPEND'')
,@DICTIONARY_ITEM=dbo.obj_id(''DICTIONARY_ITEM'')
,@DICTIONARY_ADD_BK=dbo.obj_id(''DICTIONARY_ADD_BK'')
,@DICTIONARY_KBK_LOCAL=dbo.obj_id(''DICTIONARY_KBK_LOCAL'')
,@SQUERY_USER_TREE=dbo.obj_id(''SQUERY_USER_TREE'')
,@DICTIONARY_FIELD_RRO=dbo.obj_id(''DICTIONARY_FIELD_RRO'')
,@DICTIONARY_AUTHORITY_GROUP=dbo.obj_id(''DICTIONARY_AUTHORITY_GROUP'')
,@DICTIONARY_RRO_CONSOLIDATED_MO=dbo.obj_id(''DICTIONARY_RRO_CONSOLIDATED_MO'')
,@DICTIONARY_NPA_GROUP=dbo.obj_id(''DICTIONARY_NPA_GROUP'')
,@DICTIONARY_LEVEL_NORM_DOC=dbo.obj_id(''DICTIONARY_LEVEL_NORM_DOC'')
,@NASTR_RRO_RASH_YEAR=coalesce(dbo.get_val_int(''DOCUMENTS_REESTR_RO'',''NASTR_RRO_RASH_YEAR'',@user),1)
,@NASTR_RRO_RASH_YEAR_MO=coalesce(dbo.get_val_int(''DOCUMENTS_REESTR_SDR'',''NASTR_RRO_RASH_YEAR'',@user),1)

if @nCombo_18=9 begin
	declare @COLUMN_REESTR_RO_SUMMA_F int
	,@COLUMN_REESTR_RO_SUMMA_F_1 int
	,@COLUMN_REESTR_RO_SUMMA_F_2 int
	,@COLUMN_REESTR_RO_SUMMA_F_3 int
	,@COLUMN_REESTR_RO_SUMMA_F_4 int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 12, '	,@COLUMN_REESTR_RO_SUMMA_P int
	,@COLUMN_REESTR_RO_SUMMA_P0 int
	,@COLUMN_REESTR_RO_SUMMA_P1 int
	,@COLUMN_REESTR_RO_SUMMA_P2 int
	,@COLUMN_REESTR_RO_SUMMA_P3 int
	,@COLUMN_REESTR_RO_SUMMA_P4 int
	,@COLUMN_REESTR_RO_SUMMA_P5 int
	,@COLUMN_REESTR_RO_SUMMA_P_1 int
	,@COLUMN_REESTR_RO_SUMMA_G int
	,@COLUMN_REESTR_RO_SUMMA_G1 int
	,@COLUMN_REESTR_RO_SUMMA_G2 int
	,@COLUMN_REESTR_RO_SUMMA_G3 int
	,@COLUMN_REESTR_RO_SUMMA_G4 int
	,@COLUMN_REESTR_RO_SUMMA_G5 int
	,@COLUMN_REESTR_RO_SUMMA_G6 int
	,@COLUMN_REESTR_RO_SUMMA_G_1 int
	,@COLUMN_REESTR_RO_SUMMA_G_2 int
	,@COLUMN_REESTR_RO_SUMMA_G_3 int
	,@COLUMN_REESTR_RO_SUMMA_G_4 int
	select @COLUMN_REESTR_RO_SUMMA_F=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_F'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_F_1=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_F_1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_F_2=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_F_2'',''NASTR_SHOW_DISABLE'',@user),1)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 13, '	,@COLUMN_REESTR_RO_SUMMA_F_3=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_F_3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_F_4=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_F_4'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_P=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_P0=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P0'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_P1=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_P2=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P2'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_P3=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_P4=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P4'',''NASTR_SHOW_DISABLE'',@user),1)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 14, '	,@COLUMN_REESTR_RO_SUMMA_P5=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P5'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_P_1=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_P_1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G1=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G2=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G2'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G3=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G4=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G4'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G5=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G5'',''NASTR_SHOW_DISABLE'',@user),1)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 15, '	,@COLUMN_REESTR_RO_SUMMA_G6=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G6'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G_1=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G_1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G_2=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G_2'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G_3=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G_3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_RO_SUMMA_G_4=coalesce(dbo.get_val_int(''COLUMN_REESTR_RO_SUMMA_G_4'',''NASTR_SHOW_DISABLE'',@user),1)
	declare @COLUMN_REESTR_SDR_SUMMA_F int
	,@COLUMN_REESTR_SDR_SUMMA_F_1 int
	,@COLUMN_REESTR_SDR_SUMMA_F_2 int
	,@COLUMN_REESTR_SDR_SUMMA_F_3 int
	,@COLUMN_REESTR_SDR_SUMMA_F_4 int
	,@COLUMN_REESTR_SDR_SUMMA_P int
	,@COLUMN_REESTR_SDR_SUMMA_P0 int
	,@COLUMN_REESTR_SDR_SUMMA_P1 int
	,@COLUMN_REESTR_SDR_SUMMA_P2 int
	,@COLUMN_REESTR_SDR_SUMMA_P3 int
	,@COLUMN_REESTR_SDR_SUMMA_P4 int
	,@COLUMN_REESTR_SDR_SUMMA_P5 int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 16, '	,@COLUMN_REESTR_SDR_SUMMA_P_1 int
	,@COLUMN_REESTR_SDR_SUMMA_G int
	,@COLUMN_REESTR_SDR_SUMMA_G1 int
	,@COLUMN_REESTR_SDR_SUMMA_G2 int
	,@COLUMN_REESTR_SDR_SUMMA_G3 int
	,@COLUMN_REESTR_SDR_SUMMA_G4 int
	,@COLUMN_REESTR_SDR_SUMMA_G5 int
	,@COLUMN_REESTR_SDR_SUMMA_G6 int
	,@COLUMN_REESTR_SDR_SUMMA_G_1 int
	,@COLUMN_REESTR_SDR_SUMMA_G_2 int
	,@COLUMN_REESTR_SDR_SUMMA_G_3 int
	,@COLUMN_REESTR_SDR_SUMMA_G_4 int
	select @COLUMN_REESTR_SDR_SUMMA_F=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_F'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_F_1=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_F_1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_F_2=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_F_2'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_F_3=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_F_3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_F_4=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_F_4'',''NASTR_SHOW_DISABLE'',@user),1)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 17, '	,@COLUMN_REESTR_SDR_SUMMA_P=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_P0=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P0'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_P1=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_P2=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P2'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_P3=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_P4=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P4'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_P5=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P5'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_P_1=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_P_1'',''NASTR_SHOW_DISABLE'',@user),1)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 18, '	,@COLUMN_REESTR_SDR_SUMMA_G=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G1=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G1'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G2=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G2'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G3=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G4=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G4'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G5=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G5'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G6=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G6'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G_1=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G_1'',''NASTR_SHOW_DISABLE'',@user),1)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 19, '	,@COLUMN_REESTR_SDR_SUMMA_G_2=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G_2'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G_3=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G_3'',''NASTR_SHOW_DISABLE'',@user),1)
	,@COLUMN_REESTR_SDR_SUMMA_G_4=coalesce(dbo.get_val_int(''COLUMN_REESTR_SDR_SUMMA_G_4'',''NASTR_SHOW_DISABLE'',@user),1)

	create table #COLUMN_REESTR (god int, obj int, list int,obj_n varchar(254))
	select @tsql = case when @COLUMN_REESTR_RO_SUMMA_F=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-1,2,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_F_1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-2,2,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_F_2=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-3,2,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_F_3=1 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 20, 'insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-4,2,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_F_4=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-5,2,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_P=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-1,1,1,''''  '''''' end+case when @COLUMN_REESTR_RO_SUMMA_P0=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10,1,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_P1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+1,1,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_P2=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+2,1,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_P3=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+3,1,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_P4=1 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 21, 'insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+4,1,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_P5=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+5,1,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_P_1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-2,1,1,''''  '''''' end+case when @COLUMN_REESTR_RO_SUMMA_G=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-1,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G2=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+1,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G3=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+2,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G4=1 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 22, 'insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+3,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G5=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+4,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G6=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+5,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G_1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-2,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G_2=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-3,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G_3=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-4,3,1,'''''''''' end+case when @COLUMN_REESTR_RO_SUMMA_G_4=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-5,3,1,'''''''''' end+
	case when @COLUMN_REESTR_SDR_SUMMA_F=1 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 23, 'insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-1,2,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_F_1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-2,2,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_F_2=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-3,2,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_F_3=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-4,2,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_F_4=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-5,2,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-1,1,2,''''  '''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P0=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10,1,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P1=1 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 24, 'insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+1,1,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P2=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+2,1,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P3=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+3,1,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P4=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+4,1,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P5=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+5,1,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_P_1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-2,1,2,''''  '''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-1,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G1=1 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 25, 'insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G2=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+1,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G3=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+2,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G4=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+3,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G5=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+4,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G6=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10+5,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G_1=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-2,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G_2=1 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 26, 'insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-3,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G_3=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-4,3,2,'''''''''' end+case when @COLUMN_REESTR_SDR_SUMMA_G_4=1 then '''' else ''
insert #COLUMN_REESTR (god,obj,list,obj_n) select @nInt_10-5,3,2,'''''''''' end
--print @tsql
	execute sp_executesql @tsql,N''@nInt_10 int,@ACTUAL_SUM_REESTR_RO int,@PLAN_SUM_REESTR_RO int,@GRADE_SUM_REESTR_RO int''
	,@nInt_10,@ACTUAL_SUM_REESTR_RO,@PLAN_SUM_REESTR_RO,@GRADE_SUM_REESTR_RO
	set @tsql=null
end

set @rid=null--NewID()
create table #link (link int,object int)
exec dbo.list @cObjCode=''DICTIONARY_REESTR_RO_ALL'',@rid=@rid out, @mode=''search'', @nUser = @user
insert #link (link,object)
select link,object from dbo.syslink(@rid)
exec dbo.sys_link_delete @rid=@rid

create table #kbk (lev int,dep int,div int,tgt int,exp int,itm int,dop int,lcl int,dro int)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 27, 'create table #not_kbk (lev int,dep int,div int,tgt int,exp int,itm int,dop int,lcl int,dro int)
create table #kbk2 (link int,cinsert varchar(8000),cselect varchar(8000),cfrom varchar(8000),cwhere varchar(8000)
,cfrom2 varchar(8000),cwhere2 varchar(8000),lev int,checked int)

select distinct cast(gr.number as int) as orders,gr.name,oc.credit as record,cd.name as code
into #t_npa1
from dbo.object_credit oc
join dbo.credit_doc cd on cd.link=oc.credit and cd.object=@DICTIONARY_REASON_CREDIT
join dbo.credit_doc gr on gr.link=cd.link_class and gr.object=@DICTIONARY_NPA_GROUP
where oc.object=oc.object_dict and oc.object=@DICTIONARY_NORM_DOC
and oc.req=(select top 1 link from dbo.s_note where object=@DICTIONARY_LEVEL_NORM_DOC and code=''1'')
and gr.number in (''1'',''2'',''3'',''4'',''5'',''6'')

select distinct cast(gr.number as int)-6 as orders,replace(gr.name,''  '',@cText_35) as name,oc.credit as record
into #t_npa2
from dbo.object_credit oc
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 28, 'join dbo.credit_doc cd on cd.link=oc.credit and cd.object=@DICTIONARY_REASON_CREDIT
join dbo.credit_doc gr on gr.link=cd.link_class and gr.object=@DICTIONARY_NPA_GROUP
where oc.object=oc.object_dict and oc.object=@DICTIONARY_NORM_DOC
and oc.req=(select top 1 link from dbo.s_note where object=@DICTIONARY_LEVEL_NORM_DOC and code=''2'')
and gr.number in (''7'',''8'')

create table #t_npa3 (orders int,name varchar(254),record int)

select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code
into #t_dop
from (
select 1 as list,2 as orders,cast(''    '' as varchar(254)) as name union
select 2 as list,2 as orders,cast('' ..      '' as varchar(254)) as name
)f
join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
and substring(sn.code,2,1)=''1''

union
select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 29, 'select 1 as list,3 as orders,cast(''    ''+@cText_35 as varchar(254)) as name union
select 2 as list,3 as orders,cast('' ..      '' as varchar(254)) as name
)f
join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
and substring(sn.code,2,1)=''2''

union
select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
select 1 as list,4 as orders,cast(''    '' as varchar(254)) as name union
select 2 as list,4 as orders,cast('' ..     ,   '' as varchar(254)) as name
)f
join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
and substring(sn.code,2,1) in (''3'',''4'')

union
select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
select 2 as list,5 as orders,cast('' ..     '' as varchar(254)) as name
)f
join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
and substring(sn.code,2,1)=''5''

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 30, 'if @nCombo_18 in (7,8,12)

	insert #t_dop (list,orders,name,record,code)
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,6 as orders,cast(''      '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''6''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,7 as orders,cast(''      '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''7''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,8 as orders,cast(''    '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''8''
	
	union
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 31, '	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,9 as orders,cast(''        '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''9''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,10 as orders,cast(''        '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''A''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,11 as orders,cast(''      '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''B''
	
	union
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 32, '	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,12 as orders,cast(''    ( ''+@cText_35+'')'' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''C''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,13 as orders,cast(''    ( )'' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''D''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,14 as orders,cast('' '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''E''

	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 33, '	select 0 as list,15 as orders,cast(''        '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''F''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,16 as orders,cast(''        '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''G''
	
	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 0 as list,17 as orders,cast(''      '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1)=''H''
	
else

	insert #t_dop (list,orders,name,record,code)
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 34, '	from (
	select 1 as list,2 as orders,cast(''    '' as varchar(254)) as name union
	select 2 as list,2 as orders,cast('' ..      '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1) in (''6'')

	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 1 as list,3 as orders,cast(''    ''+@cText_35 as varchar(254)) as name union
	select 2 as list,3 as orders,cast('' ..      '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1) in (''9'',''A'',''B'',''C'')

	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 1 as list,4 as orders,cast(''    '' as varchar(254)) as name union
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 35, '	select 2 as list,4 as orders,cast('' ..     ,   '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1) in (''7'',''8'',''E'')

	union
	select f.list,f.orders,f.name,cast(sn.link as int) as record,sn.code from (
	select 2 as list,5 as orders,cast('' ..     '' as varchar(254)) as name
	)f
	join dbo.s_note sn on sn.object=@DICTIONARY_FIELD_RRO
	and substring(sn.code,2,1) in (''F'',''G'',''H'',''D'')

--select * from #t_npa1
--select * from #t_npa2
--select * from #t_npa3
--select * from #t_dop order by orders
--return

select @lev=0
--if exists(select * from #kbk3) --@nCombo_18=20
--	select top 1 @lev=coalesce(lev,0) from #kbk3 where ord=1

if @nOtborLink2<>0
	select distinct record,link_up into #object_var_records_npa from dbo.object_var_records where link_up=@nOtborLink2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 36, '	union select distinct cd.link as record,ovr.link_up from dbo.object_var_records ovr join dbo.credit_doc cd on cd.link_class=ovr.record and ovr.link_up=@nOtborLink2

--set @digts=2----------------!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
if @nCheck_11=1 and (@div1000 in (3,5,7) or @digts in (0,1)) begin
	select top 0 * into #object_credit from dbo.object_credit
	insert #object_credit (value,link_up,object_dict,object,date_first,date_last,credit,credit2,kbk,corr,account,req,orders,subsh,summa,row_id,summa2)
	execute dbo.ROUNDRRO @dRoundRRO1=@dDate_1,@dRoundRRO2=@dDate_2,@div1000=@div1000,@digts=@digts,@this_year=@nInt_10
end

set @tsql3=@tsql
set @tsql=''
insert #t_res (lev,r,kbk,god,obj/*,corr*/,s''+case when 1 in (@nCheck_14,@nCheck_15) then '',name'' else '''' end+'',metod,su/*,status*/,objcd)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 37, 'select ''+cast(@lev as varchar)+'',r.link,s.kbk,year(s.date_first),s.object_dict/*,o.corr*/,sum(s.''+case when @nCheck_11=1 and (@div1000 in (3,5,7) or @digts in (0,1)) then ''summa2'' else ''summa'' end+'')''+case when 1 in (@nCheck_14,@nCheck_15) then '',left(r.name,8000)'' else '''' end+'',s.credit''+case when @nCombo_32=1 then ''2'' else '''' end+'',s.req/*,o.orders*/,r.object
from dbo.credit_doc r
join ''+case when @nCheck_11=1 and (@div1000 in (3,5,7) or @digts in (0,1)) then ''#object_credit'' else ''dbo.object_credit'' end+'' s on s.link_up=r.link and s.object_dict in (@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@GRADE_SUM_REESTR_RO)
--join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object
where r.date between @dDate_1 and @dDate_2 ''+case when @nCombo_18=9 then ''
and exists(select * from #COLUMN_REESTR where god=year(s.date_first))'' else ''
and year(s.date_first) between @nInt_10-1 and @nInt_10+''+case when @nCombo_18 in (7,8,12) then ''4'' else ''3'' end end+''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 38, 'and r.object in (@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM)''
+case when exists(select * from #link) then ''
and exists(select * from #link where link=r.link)'' else '''' end
+case @nOption_9 when 1 then ''
and exists(select * from dbo.object_credit where link_up=r.link and object=r.object and object_dict=r.object and coalesce(orders,0)=1)'' when 2 then ''
and not exists(select * from dbo.object_credit where link_up=r.link and object=r.object and object_dict=r.object and coalesce(orders,0)=1)'' else '''' end
+case when @nOtborLink1 <> 0 /*  */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink1) then ''not '' else '''' end+''exists(select * from dbo.object_var_records where link_up=@nOtborLink1 and record=r.link)'' else '''' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 39, '+case when @nOtborLink2 <> 0 /*    */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink2) then ''not '' else '''' end+''exists(select * from dbo.#object_var_records_npa ovr join dbo.object_credit oc on oc.credit=ovr.record and ovr.link_up=@nOtborLink2 and oc.link_up=r.link and oc.object_dict in (@DICTIONARY_NORM_DOC,@DICTIONARY_PREC_DOC))'' else '''' end
+case when @nOtborLink3 <> 0 /**/ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink3) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink3 and tk.ref1=s.kbk and tk.object=@REFERENCE_DEPARTMENT)'' else '''' end
+case when @nOtborLink4 <> 0 /**/ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 40, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink4) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink4 and tk.ref1=s.kbk and tk.object=@REFERENCE_DIVISION)'' else '''' end
+case when @nOtborLink5 <> 0 /* */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink5) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink5 and tk.ref1=s.kbk and tk.object=@REFERENCE_TARGET_ITEM)'' else '''' end
+case when @nOtborLink6 <> 0 /* */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink6) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink6 and tk.ref1=s.kbk and tk.object=@REFERENCE_EXPEND)'' else '''' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 41, '+case when @nOtborLink7 <> 0 /**/ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink7) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink7 and tk.ref1=s.kbk and tk.object=@REFERENCE_ITEM)'' else '''' end
+case when @nOtborLink8 <> 0 /*. */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink8) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink8 and tk.ref1=s.kbk and tk.object=@REFERENCE_ADD_BK)'' else '''' end
+case when @nOtborLink9 <> 0 /* */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 42, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink9) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink9 and tk.ref1=s.kbk and tk.object=@REFERENCE_KBK_LOCAL)'' else '''' end
+case when @nOtborLink10 <> 0 /**/ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink10) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovt join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovt.link_up=@nOtborLink10 and ovt.record=o.corr)'' else '''' end
+case when @nOtborLink11 <> 0 /* ,   */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 43, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink11) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit oc on oc.credit=ovr.record and ovr.link_up=@nOtborLink11 and oc.link_up=r.link and oc.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO))'' else '''' end
+case when @nOtborLink12 <> 0 /*  */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink12) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovt join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovt.link_up=@nOtborLink12 and ovt.record=o.req)'' else '''' end
+case when @nOtborLink13 <> 0 /*  */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 44, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink13) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovt join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovt.link_up=@nOtborLink13 and ovt.record=o.credit)'' else '''' end
+case when @nOtborLink14 <> 0 /* */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink14) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit oc on oc.req=ovr.record and ovr.link_up=@nOtborLink14 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_ANALITIC)'' else '''' end
+case when @nOtborLink15 <> 0 /* */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 45, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink15) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit oc on oc.corr=ovr.record and ovr.link_up=@nOtborLink15 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_ATE)'' else '''' end
+case when @nOtborLink21 <> 0 /*   */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink21) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr where s.req=ovr.record and ovr.link_up=@nOtborLink21)'' else '''' end
+case when @nOtborLink22<>0 then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink22) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join (dbo.object_credit gpo join dbo.object_credit dict on gpo.link_up=dict.credit and dict.link_up=r.link) on ovr.record=gpo.credit and ovr.link_up=''+cast(@nOtborLink22 as varchar)+'')'' else '''' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 46, '+case when @nOtborLink23<>0 /*  */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink23) then '''' else ''not '' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit ovroc on ovr.link_up=''+cast(@nOtborLink23 as varchar)+'' and ovr.record=ovroc.req and ovroc.link_up=r.link)'' else '''' end
+coalesce(@tsql,'''')

select @link=1,@tsql2=@tsql

select @tsql=@tsql+''
group by r.link,s.kbk,year(s.date_first),s.object_dict/*,o.corr*/,s.req''+case when 1 in (@nCheck_14,@nCheck_15) then '',left(r.name,8000)'' else '''' end+'',s.credit''+case when @nCombo_32=1 then ''2'' else '''' end+''/*,o.orders*/,r.object''
,@tsql2=@tsql2+''
group by r.link,s.kbk,year(s.date_first),s.object_dict*/,o.corr*/,s.req''+case when 1 in (@nCheck_14,@nCheck_15) then '',left(r.name,8000)'' else '''' end+'',s.credit''+case when @nCombo_32=1 then ''2'' else '''' end+'',/*o.orders*/,r.object''
--print @tsql
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 47, 'execute sp_executesql @tsql, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 48, ''',@nInt_10,@dDate_1,@dDate_2
,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21

if 1<0 and @nOtborLink2 <> 0 /*    */ begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 49, '	set @tsql_npa=replace(@tsql,''exists(select * from #object_var_records_npa ovr join dbo.object_credit oc on oc.credit=ovr.record and ovr.link_up=@nOtborLink2 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_NORM_DOC)''
	,''exists(select * from #object_var_records_npa ovr join (dbo.object_credit oc join dbo.credit_doc npa on npa.link=oc.credit) on npa.link_class=ovr.record and ovr.link_up=@nOtborLink2 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_PREC_DOC)
	and not exists(select * from #t_res where r=r.link)'')
--print @tsql
	execute sp_executesql @tsql_npa, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
	,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
	,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 50, '	,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
	,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
	,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
	,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
	'',@nInt_10,@dDate_1,@dDate_2
	,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
	,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 51, '	,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
	,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
	,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21
end
--return

if @nCombo_18 in (1,2,4,6,5,6,7,8,9,10,11,12) begin

	select 1 as ord,1 as lev,1 as checked,'''' as cfrom2
	,'' and kbk.dep is null and kbk.div is null and kbk.tgt is null and kbk.exp is null and kbk.itm is null and kbk.dop is null and kbk.lcl is null and kbk.dro=s.req and exists(select * from dbo.object_credit where link_up=r.link and object_dict in (@DICTIONARY_SODERG_RO))'' as cwhere2
	into #kbk3
	union
	select 2 as ord,2 as lev,1 as checked,'''' as cfrom2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 52, '	,'' and kbk.dep is null and kbk.div is null and kbk.tgt is null and kbk.exp is null and kbk.itm is null and kbk.dop is null and kbk.lcl is null and kbk.dro=s.req and exists(select * from dbo.object_credit where link_up=r.link and object_dict in (@DICTIONARY_SODERG_RO_MO))'' as cwhere2

	insert #kbk(lev,dro)
	select list,record from #t_dop where left(code,1)=''1''

	while exists(select * from #kbk3 where checked<>0) begin

		select top 1 @link=ord,@checked=checked,@cfrom2=cfrom2,@cwhere2=cwhere2,@lev=lev from #kbk3 where checked<>0

		set @tsql=''
		insert #t_res (lev,r,kbk,god,obj/*,corr*/,k''+case when 1 in (@nCheck_14,@nCheck_15) then '',name'' else '''' end+'',metod,su,objcd)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 53, '		select ''+cast(@lev as varchar)+'',r.link,s.kbk,year(s.date_first),s.object_dict/*,o.corr*/,sum(s.''+case when @nCheck_11=1 and (@div1000 in (3,5,7) or @digts in (0,1)) then ''summa2'' else ''summa'' end+'')''+case when 1 in (@nCheck_14,@nCheck_15) then '',left(r.name,8000)'' else '''' end+'',s.credit''+case when @nCombo_32=1 then ''2'' else '''' end+'',s.req,r.object
		from dbo.credit_doc r
		join ''+case when @nCheck_11=1 and (@div1000 in (3,5,7) or @digts in (0,1)) then ''#object_credit'' else ''dbo.object_credit'' end+'' s on s.link_up=r.link and s.object_dict in (@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@GRADE_SUM_REESTR_RO)
--		join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object
		where r.date between @dDate_1 and @dDate_2''+case when @nCombo_18=9 then ''
		and exists(select * from #COLUMN_REESTR where god=year(s.date_first))'' else ''
		and year(s.date_first) between @nInt_10-1 and @nInt_10+''+case when @nCombo_18 in (7,8,12) then ''4'' else ''3'' end end+''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 54, '		and r.object in (@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM)''
		+case when exists(select * from #link) then ''
		and exists(select * from #link where link=r.link)'' else '''' end
		+case @nOption_9 when 1 then ''
		and exists(select * from dbo.object_credit where link_up=r.link and object=r.object and object_dict=r.object and coalesce(orders,0)=1)'' when 2 then ''
		and not exists(select * from dbo.object_credit where link_up=r.link and object=r.object and object_dict=r.object and coalesce(orders,0)=1)'' else '''' end
		+case when @nOtborLink1 <> 0 /*  */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink1) then ''not '' else '''' end+''exists(select * from dbo.object_var_records where link_up=@nOtborLink1 and record=r.link)'' else '''' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 55, '		+case when @nOtborLink2 <> 0 /*    */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink2) then ''not '' else '''' end+''exists(select * from #object_var_records_npa ovr join dbo.object_credit oc on oc.credit=ovr.record and ovr.link_up=@nOtborLink2 and oc.link_up=r.link and oc.object_dict in (@DICTIONARY_NORM_DOC,@DICTIONARY_PREC_DOC))'' else '''' end
		+case when @nOtborLink3 <> 0 /**/ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink3) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink3 and tk.ref1=s.kbk and tk.object=@REFERENCE_DEPARTMENT)'' else '''' end
		+case when @nOtborLink4 <> 0 /**/ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 56, '		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink4) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink4 and tk.ref1=s.kbk and tk.object=@REFERENCE_DIVISION)'' else '''' end
		+case when @nOtborLink5 <> 0 /* */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink5) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink5 and tk.ref1=s.kbk and tk.object=@REFERENCE_TARGET_ITEM)'' else '''' end
		+case when @nOtborLink6 <> 0 /* */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink6) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink6 and tk.ref1=s.kbk and tk.object=@REFERENCE_EXPEND)'' else '''' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 57, '		+case when @nOtborLink7 <> 0 /**/ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink7) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink7 and tk.ref1=s.kbk and tk.object=@REFERENCE_ITEM)'' else '''' end
		+case when @nOtborLink8 <> 0 /*. */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink8) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink8 and tk.ref1=s.kbk and tk.object=@REFERENCE_ADD_BK)'' else '''' end
		+case when @nOtborLink9 <> 0 /* */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 58, '		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink9) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.t_kbk tk on tk.ref2=ovr.record and ovr.link_up=@nOtborLink9 and tk.ref1=s.kbk and tk.object=@REFERENCE_KBK_LOCAL)'' else '''' end
		+case when @nOtborLink10 <> 0 /**/ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink10) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovt join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovt.link_up=@nOtborLink10 and ovt.record=o.corr)'' else '''' end
		+case when @nOtborLink11 <> 0 /* ,   */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 59, '		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink11) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit oc on oc.credit=ovr.record and ovr.link_up=@nOtborLink11 and oc.link_up=r.link and oc.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO))'' else '''' end
		+case when @nOtborLink12 <> 0 /*  */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink12) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovt join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovt.link_up=@nOtborLink12 and ovt.record=o.req)'' else '''' end
		+case when @nOtborLink13 <> 0 /*  */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 60, '		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink13) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovt join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovt.link_up=@nOtborLink13 and ovt.record=o.credit)'' else '''' end
		+case when @nOtborLink14 <> 0 /* */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink14) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit oc on oc.req=ovr.record and ovr.link_up=@nOtborLink14 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_ANALITIC)'' else '''' end
		+case when @nOtborLink15 <> 0 /* */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 61, '		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink15) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit oc on oc.corr=ovr.record and ovr.link_up=@nOtborLink15 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_ATE)'' else '''' end
		+case when @nOtborLink21 <> 0 /*   */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink21) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr where s.req=ovr.record and ovr.link_up=@nOtborLink21)'' else '''' end
		+case when @nOtborLink22<>0 then /*  */ ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 62, '		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink22) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join (dbo.object_credit gpo join dbo.object_credit dict on gpo.link_up=dict.credit and dict.link_up=r.link) on ovr.record=gpo.credit and ovr.link_up=''+cast(@nOtborLink22 as varchar)+'')'' else '''' end
		+case when @nOtborLink23<>0 /*  */ then ''
		and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink23) then '''' else ''not '' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit ovroc on ovr.link_up=''+cast(@nOtborLink23 as varchar)+'' and ovr.record=ovroc.req and ovroc.link_up=r.link)'' else '''' end
		+coalesce(@tsql3,'''')

		select @tsql4=@tsql

		set @tsql=@tsql+''
		and ''+case when @checked<0 then ''not '' else '''' end+''exists(select * from #''+case when @checked<0 then ''not_'' else '''' end+''kbk kbk''+@cfrom2+'' where ''+substring(@cwhere2,6,8000)+'' and lev=''+cast(@lev as varchar)+'')''

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 63, '		set @tsql4=@tsql4+''
		and ''+case when @checked<0 then ''not '' else '''' end+''exists(select * from #''+case when @checked<0 then ''not_'' else '''' end+''kbk kbk''+@cfrom2+'' where ''+substring(@cwhere2,6,8000)+'' and lev=''+cast(@lev as varchar)+'')''

		select @tsql=@tsql+''
		group by r.link,s.kbk,year(s.date_first),s.object_dict/*,o.corr*/,s.req,r.object''+case when 1 in (@nCheck_14,@nCheck_15) then '',left(r.name,8000)'' else '''' end+'',s.credit''+case when @nCombo_32=1 then ''2'' else '''' end
		,@tsql4=@tsql4+''
		group by r.link,s.kbk,year(s.date_first),s.object_dict/*,o.corr*/,s.req,r.object''+case when 1 in (@nCheck_14,@nCheck_15) then '',left(r.name,8000)'' else '''' end+'',s.credit''+case when @nCombo_32=1 then ''2'' else '''' end
--print @tsql
		execute sp_executesql @tsql, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
		,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 64, '		,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
		,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
		,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
		,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
		,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
		'',@nInt_10,@dDate_1,@dDate_2
		,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 65, '		,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
		,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
		,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
		,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
		,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21

		if 1<0 and @nOtborLink2 <> 0 /*    */ begin
			set @tsql_npa=replace(@tsql,''exists(select * from #object_var_records_npa ovr join dbo.object_credit oc on oc.credit=ovr.record and ovr.link_up=@nOtborLink2 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_NORM_DOC)''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 66, '			,''exists(select * from #object_var_records_npa ovr join (dbo.object_credit oc join dbo.credit_doc npa on npa.link=oc.credit) on npa.link_class=ovr.record and ovr.link_up=@nOtborLink2 and oc.link_up=r.link and oc.object_dict=@DICTIONARY_PREC_DOC)
			and not exists(select * from #t_res where r=r.link)'')
--print @tsql
			execute sp_executesql @tsql_npa, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
			,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
			,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
			,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
			,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 67, '			,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
			,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
			'',@nInt_10,@dDate_1,@dDate_2
			,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
			,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
			,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
			,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
			,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 68, '			,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21
		end
	
		update #kbk3 set checked=0 where ord=@link
	end
end
--select * from #t_res
--return

if @nCombo_18 not in (2,4,6,7,8,12) or @nCheck_34=1
	update t set div=ref2 from #t_res t
	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_DIVISION

if @nCheck_19=1 or @nCombo_18 in (7,8,12) or @nCombo_31=5
	update t set tgt=ref2 from #t_res t
	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_TARGET_ITEM

if @nCheck_20=1
	update t set exp=ref2 from #t_res t
	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_EXPEND

if @nCheck_21=1
	update t set itm=ref2 from #t_res t
	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_ITEM

if @nCheck_25=1
	update t set dop=ref2 from #t_res t
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 69, '	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_ADD_BK

if @nCheck_26=1
	update t set lcl=ref2 from #t_res t
	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_KBK_LOCAL

if @nCheck_27=1 or @nCombo_31=3
	update t set dep=ref2 from #t_res t
	join dbo.t_kbk tk on tk.ref1=t.kbk and tk.object=@REFERENCE_DEPARTMENT

if @nCombo_18=6
	select distinct dep,r into #dep_r from #t_res where dep is not null

update t set po=oc.credit,cpo=cd.number,objpo=oc.object_dict from #t_res t
join (dbo.object_credit oc join dbo.credit_doc cd on cd.link=oc.credit) on oc.link_up=t.r and oc.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO)

if @nCheck_16=1
	set @cCheck_16=''3''
else
	set @cCheck_16=''0''

create table #oc(link_up int,date_first datetime,date_last datetime,credit int,object int,object_dict int,dep int,status int)

if @nCombo_18 in (1,2,3,4,6,10,11) begin

set @tsql=''
insert #oc (link_up,date_first,date_last,credit,object,object_dict,status)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 70, 'select distinct oc.link_up,oc.date_first,oc.date_last,oc.credit,oc.object,oc.object_dict
,(select top 1 orders from dbo.object_credit where link_up=oc.link_up and object=oc.object and object_dict=oc.object)
from dbo.object_credit oc
where oc.object_dict=@DICTIONARY_NORM_DOC''
if @nCombo_18=3
set @tsql=@tsql+''
and exists(select * from dbo.object_credit where link_up=oc.credit and object=object_dict and coalesce(value,'''''''')<>'''''''')''
--if @nCheck_17=1
select @tsql2=@tsql,@tsql=@tsql+''
and exists(select * from dbo.credit_doc r where r.link=oc.link_up and r.date between @dDate_1 and @dDate_2 and r.object in (@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM))''
+case when exists(select * from #link) then ''
and exists(select * from #link where link=oc.link_up)'' else '''' end
+case @nOption_9 when 1 then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 71, 'and exists(select * from dbo.object_credit where link_up=oc.link_up and object=oc.object and object_dict=oc.object and coalesce(orders,0)=1)'' when 2 then ''
and not exists(select * from dbo.object_credit where link_up=oc.link_up and object=oc.object and object_dict=oc.object and coalesce(orders,0)=1)'' else '''' end
+case when @nOtborLink1 <> 0 /*  */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink1) then ''not '' else '''' end+''exists(select * from dbo.object_var_records where link_up=@nOtborLink1 and record=oc.link_up)'' else '''' end
+case when @nOtborLink2 <> 0 /*    */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 72, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink2) then ''not '' else '''' end+''exists(select * from #object_var_records_npa ovr join dbo.object_credit o on o.credit=ovr.record and ovr.link_up=@nOtborLink2 and o.link_up=oc.link_up and o.object_dict in (@DICTIONARY_NORM_DOC,@DICTIONARY_PREC_DOC))'' else '''' end
+case when @nOtborLink3+@nOtborLink4+@nOtborLink5+@nOtborLink6+@nOtborLink7+@nOtborLink8+@nOtborLink9+@nOtborLink21>0 /*    */ then ''
and exists(select * from #t_res where r=oc.link_up)'' else '''' end
+case when @nOtborLink10 <> 0 /**/ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink10) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit o on o.link_up=oc.link_up and o.object=oc.object where ovr.link_up=@nOtborLink10 and ovr.record=o.corr)'' else '''' end
+case when @nOtborLink11 <> 0 /* ,   */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 73, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink11) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit o on o.credit=ovr.record and ovr.link_up=@nOtborLink11 and o.link_up=oc.link_up and o.object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO))'' else '''' end
+case when @nOtborLink12 <> 0 /*  */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink12) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovr.link_up=@nOtborLink12 and ovr.record=o.req)'' else '''' end
+case when @nOtborLink13 <> 0 /*  */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 74, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink13) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit o on o.link_up=r.link and o.object=r.object and o.object_dict=r.object and ovr.link_up=@nOtborLink13 and ovr.record=o.credit)'' else '''' end
+case when @nOtborLink14 <> 0 /* */ then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink14) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit o on o.req=ovr.record and ovr.link_up=@nOtborLink14 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_ANALITIC)'' else '''' end
+case when @nOtborLink15 <> 0 /* */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 75, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink15) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit o on o.corr=ovr.record and ovr.link_up=@nOtborLink15 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_ATE)'' else '''' end
+case when @nOtborLink22<>0 then ''
and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink22) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr join (dbo.object_credit gpo join dbo.object_credit dict on gpo.link_up=dict.credit and dict.link_up=oc.link_up) on ovr.record=gpo.credit and ovr.link_up=''+cast(@nOtborLink22 as varchar)+'')'' else '''' end
+case when @nOtborLink23<>0 /*  */ then ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 76, 'and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink23) then '''' else ''not '' end+''exists(select * from dbo.object_var_records ovr join dbo.object_credit ovroc on ovr.link_up=''+cast(@nOtborLink23 as varchar)+'' and ovr.record=ovroc.req and ovroc.link_up=oc.link_up)'' else '''' end
--else
--set @tsql=@tsql+''
--and exists(select * from #t_res where r=oc.link_up)''
--print @tsql
execute sp_executesql @tsql, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 77, ',@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
'',@nInt_10,@dDate_1,@dDate_2
,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 78, ',@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21

if 1<0 and @nOtborLink2 <> 0 /*    */ begin
	set @tsql_npa=replace(@tsql,''exists(select * from #object_var_records_npa ovr join dbo.object_credit o on o.credit=ovr.record and ovr.link_up=@nOtborLink2 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_NORM_DOC)''
	,''exists(select * from #object_var_records_npa ovr join (dbo.object_credit o join dbo.credit_doc npa on npa.link=o.credit) on npa.link_class=ovr.record and ovr.link_up=@nOtborLink2 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_PREC_DOC)
	and not exists(select * from #oc where link_up=oc.link_up)'')
--print @tsql
	execute sp_executesql @tsql_npa, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 79, '	,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
	,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
	,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
	,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
	,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
	,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
	'',@nInt_10,@dDate_1,@dDate_2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 80, '	,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
	,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
	,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
	,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
	,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21
end

if @nCheck_17=0 begin
	set @tsql2=@tsql2+''
	and not exists(select * from #oc where link_up=oc.link_up and credit=oc.credit)
	and exists(select * from #t_res where r=oc.link_up)''
	--print @tsql
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 81, '	execute sp_executesql @tsql2, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
	,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
	,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
	,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
	,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
	,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
	,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 82, '	'',@nInt_10,@dDate_1,@dDate_2
	,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
	,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
	,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
	,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
	,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21

	if 1<0 and @nOtborLink2 <> 0 /*    */ begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 83, '		set @tsql_npa=replace(@tsql2,''exists(select * from #object_var_records_npa ovr join dbo.object_credit o on o.credit=ovr.record and ovr.link_up=@nOtborLink2 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_NORM_DOC)''
		,''exists(select * from #object_var_records_npa ovr join (dbo.object_credit o join dbo.credit_doc npa on npa.link=o.credit) on npa.link_class=ovr.record and ovr.link_up=@nOtborLink2 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_PREC_DOC)
		and not exists(select * from #oc where link_up=oc.link_up)'')
--print @tsql
		execute sp_executesql @tsql_npa, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
		,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
		,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 84, '		,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
		,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
		,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
		,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
		'',@nInt_10,@dDate_1,@dDate_2
		,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
		,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 85, '		,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
		,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
		,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
		,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21
	end
end

set @tsql=replace(@tsql,''where oc.object_dict=@DICTIONARY_NORM_DOC'',''where oc.object_dict=@DICTIONARY_PREC_DOC'')
if @nCombo_18=3
	set @tsql=replace(@tsql
	,''and exists(select * from dbo.object_credit where link_up=oc.credit and object=object_dict and coalesce(value,'''''''')<>'''''''')''
	,''and exists(select * from dbo.object_credit norm, credit_doc perc where norm.link_up=perc.link_class and perc.link=oc.credit and norm.object=norm.object_dict and coalesce(norm.value,'''''''')<>'''''''')'')
--print @tsql
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 86, 'execute sp_executesql @tsql, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 87, ''',@nInt_10,@dDate_1,@dDate_2
,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21

if 1<0 and @nOtborLink2 <> 0 /*    */ begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 88, '	set @tsql_npa=replace(@tsql,''exists(select * from #object_var_records_npa ovr join dbo.object_credit o on o.credit=ovr.record and ovr.link_up=@nOtborLink2 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_NORM_DOC)''
	,''exists(select * from #object_var_records_npa ovr join (dbo.object_credit o join dbo.credit_doc npa on npa.link=o.credit) on npa.link_class=ovr.record and ovr.link_up=@nOtborLink2 and o.link_up=oc.link_up and o.object_dict=@DICTIONARY_PREC_DOC)
	and not exists(select * from #oc where link_up=oc.link_up)'')
--print @tsql
	execute sp_executesql @tsql_npa, N''		@nInt_10 int,@dDate_1 datetime, @dDate_2 datetime
	,@PLAN_SUM_REESTR_RO int,@ACTUAL_SUM_REESTR_RO int,@DICTIONARY_PREC_DOC int,@DICTIONARY_NORM_DOC int,@GRADE_SUM_REESTR_RO int
	,@DOCUMENTS_REESTR_RO int,@DOCUMENTS_TREESTR_RO int,@DOCUMENTS_REESTR_SDR int,@DOCUMENTS_TREESTR_SDR int,@DOCUMENTS_REESTR_IZM int,@DOCUMENTS_TREESTR_IZM int,@DOCUMENTS_REESTR_SDR_IZM int,@DOCUMENTS_TREESTR_SDR_IZM int
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 89, '	,@REFERENCE_DEPARTMENT int,@REFERENCE_DIVISION int,@REFERENCE_TARGET_ITEM int,@REFERENCE_EXPEND int,@REFERENCE_ITEM int,@REFERENCE_ADD_BK int,@REFERENCE_KBK_LOCAL int
	,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int
	,@DICTIONARY_ANALITIC int,@DICTIONARY_ATE int
	,@nOtborLink1 int,@nOtborLink2 int,@nOtborLink3 int,@nOtborLink4 int,@nOtborLink5 int,@nOtborLink6 int,@nOtborLink7 int,@nOtborLink8 int,@nOtborLink9 int,@nOtborLink10 int,@nOtborLink11 int,@nOtborLink12 int,@nOtborLink13 int,@nOtborLink14 int,@nOtborLink15 int,@nOtborLink21 int
	'',@nInt_10,@dDate_1,@dDate_2
	,@PLAN_SUM_REESTR_RO,@ACTUAL_SUM_REESTR_RO,@DICTIONARY_PREC_DOC,@DICTIONARY_NORM_DOC,@GRADE_SUM_REESTR_RO
	,@DOCUMENTS_REESTR_RO,@DOCUMENTS_TREESTR_RO,@DOCUMENTS_REESTR_SDR,@DOCUMENTS_TREESTR_SDR,@DOCUMENTS_REESTR_IZM,@DOCUMENTS_TREESTR_IZM,@DOCUMENTS_REESTR_SDR_IZM,@DOCUMENTS_TREESTR_SDR_IZM
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 90, '	,@REFERENCE_DEPARTMENT,@REFERENCE_DIVISION,@REFERENCE_TARGET_ITEM,@REFERENCE_EXPEND,@REFERENCE_ITEM,@REFERENCE_ADD_BK,@REFERENCE_KBK_LOCAL
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
	,@DICTIONARY_ANALITIC,@DICTIONARY_ATE
	,@nOtborLink1,@nOtborLink2,@nOtborLink3,@nOtborLink4,@nOtborLink5,@nOtborLink6,@nOtborLink7,@nOtborLink8,@nOtborLink9,@nOtborLink10,@nOtborLink11,@nOtborLink12,@nOtborLink13,@nOtborLink14,@nOtborLink15,@nOtborLink21
end

--select * from #t_res
--return

if @nCombo_18=3
	delete t from #t_res t where not exists(select * from #oc where link_up=t.r)

end --@nCombo_18 not in (5,7,8,9,12)

if @nCombo_18=6 begin
	update oc set dep=t.dep from #oc oc
	join #dep_r t on t.r=oc.link_up

	insert #oc (link_up,date_first,date_last,credit,object,object_dict,dep)
	select distinct oc.link_up,oc.date_first,oc.date_last,oc.credit,oc.object,oc.object_dict,t.dep from #oc oc
	join #dep_r t on t.r=oc.link_up
	where not exists(select * from #oc where link_up=t.r and dep=t.dep)
end

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 91, 'create table #npa (link_up int,credit int,object int,object_dict int,date_first datetime,date_last datetime,dep int,status int,objpo int,ate int,corr int)

if @nCombo_18 in (1,2,3,4,6,10,11) begin
	set @tsql=''insert #npa (link_up,credit,object,object_dict,date_first,date_last,dep,status,objpo)
	select distinct oc.link_up,oc.credit,oc.object,oc.object_dict,oc.date_first,oc.date_last,oc.dep,oc.status
	,(select top 1 object_dict from dbo.object_credit where link_up=oc.link_up and object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO)) as objpo
	from #oc oc where exists(select * from #t_res t where t.r=oc.link_up)''--bug 209795
	--print @tsql
	execute sp_executesql @tsql, N''		@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int,@DICTIONARY_ATE int''
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO,@DICTIONARY_ATE
end

update t set corr=o.corr,status=o.orders from #t_res t
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 92, 'join dbo.object_credit o on o.link_up=t.r and o.object=t.objcd and o.object_dict=t.objcd and o.corr is not null
update t set corr=o.corr,status=o.orders from #npa t
join dbo.object_credit o on o.link_up=t.link_up and o.object=t.object and o.object_dict=t.object and o.corr is not null

update t set status=coalesce((select top 1 status from #oc where credit=t.credit and status<>0),status) from #oc t where status=0

if @nCombo_31=2 begin

	update t set ate=oc.corr from #t_res t
	join dbo.object_credit oc on oc.link_up=t.r and oc.object_dict=@DICTIONARY_ATE and oc.corr is not null

	update t set ate=scc.ate from #t_res t
	join dbo.s_corr_cpp scc on scc.corr=t.corr
	join dbo.s_corr sc on sc.cppu=scc.cppu and sc.link=t.corr
	where t.ate is null

	select distinct corr,ate,ate5.link into #ate5 from #t_res t
	join dbo.s_corr ate on ate.link=t.ate
	join dbo.s_corr ate5 on left(ate5.inn,5)=left(ate.inn,5) and substring(ate5.inn,6,3)=''000'' and ate5.object=@DICTIONARY_ATE

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 93, '	update t set ate=a5.link from #t_res t
	join #ate5 a5 on a5.corr=t.corr
	update t set ate=a5.link from #npa t
	join #ate5 a5 on a5.corr=t.corr

end

--
create table #t_npa (po int,number varchar(100),date datetime,name varchar(8000),date_first datetime,date_last datetime,credit int,bud int,vyp int,res varchar(8000),number2 varchar(100),name2 varchar(8000),objpo int,record int,cod varchar(100),link_class int,dep int,ate int,status int,cd int)
set @tsql=''
insert #t_npa (po,number,date,name,date_first,date_last,credit,bud,vyp,number2,name2,objpo,record,cod,link_class,dep,ate,status''+case when @nCombo_18=3 or @nCombo_31 in (4,6) then '',cd'' else '''' end+'')
select distinct (select top 1 credit from dbo.object_credit where link_up=oc.link_up and object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO) and credit is not null) as po,cd2.number,cd2.date,cd2.name
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 94, ',''+case when dbo.get_val_int(''COLUMN_DICT_PREC_DOC_AUTH'',''NASTR_SHOW_DISABLE'',@user)=2 then ''coalesce((select top 1 date_first from dbo.object_credit where link_up=oc.credit and object=oc.object_dict and object_dict=oc.object_dict),oc2.date_first) as '' else ''oc2.'' end+''date_first
,''+case when dbo.get_val_int(''COLUMN_DICT_PREC_DOC_AUTH_2'',''NASTR_SHOW_DISABLE'',@user)=2 then ''coalesce((select top 1 date_last from dbo.object_credit where link_up=oc.credit and object=oc.object_dict and object_dict=oc.object_dict),oc2.date_last) as '' else ''oc2.'' end+''date_last
,oc2.credit,(select top 1 code from dbo.s_note where link=oc2.req) as bud
,oc.credit as vyp
,cd3.number as number2,cd3.name as name2,objpo
,cd3.link as record
,(select top 1 value from dbo.object_credit where link_up=cd2.link and object=object_dict and coalesce(value,'''''''')<>'''''''') as cod
,cd.link_class
,oc.dep
,oc.ate
,oc.status
''+case when @nCombo_18=3 or @nCombo_31 in (4,6) then '',oc.link_up'' else '''' end+''
from #npa oc
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 95, 'join (dbo.credit_doc cd join (dbo.credit_doc cd2 join dbo.object_credit oc2 on oc2.link_up=cd2.link and oc2.object=oc2.object_dict
join dbo.credit_doc cd3 on cd3.link=oc2.credit) on cd2.link=cd.link_class) on cd.link=oc.credit
where oc.object_dict=@DICTIONARY_PREC_DOC
and cd.link_class is not null
and exists(select * from dbo.object_credit oc4 join dbo.s_note sn on sn.link=oc4.req and oc4.link_up=cd.link_class and sn.code in (''''1'''',''''2'''',@cCheck_16))
--and exists(select * from #t_res where r=oc.link_up)''
execute sp_executesql @tsql, N''		@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int,@DICTIONARY_PREC_DOC int,@cCheck_16 varchar(1)''
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO,@DICTIONARY_PREC_DOC,@cCheck_16

create table #t_vyp (id int identity primary key,
link_up int,ord int,code varchar(254),value varchar(254),abr varchar(10),res varchar(8000),status int)
--@nCheck_13    (),  ()
--, , , , 
set @tsql=''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 96, 'insert #t_vyp (link_up,ord,code,value,abr,status)
select oc.link_up,case
when sn.code=''''3'''' then 1
when sn.code=''''8'''' then 2
when sn.code=''''4'''' then 5
when sn.code=''''7'''' then 6''+case when @nCheck_13=0 then ''
when sn.code=''''6'''' then 4
when isnumeric(sn.code)=1 then cast(''''1''''+sn.code as int)'' else '''' end+''
else 99 end as ord
,sn.code,oc.value
,case 
when sn.code=''''3'''' then ''''.''''
when sn.code=''''8'''' then ''''.''''
when sn.code=''''4'''' then ''''.''''
when sn.code=''''7'''' then ''''.''''''+case when @nCheck_13=0 then ''
when sn.code=''''1'''' then ''''.''''
when sn.code=''''2'''' then ''''.''''
when sn.code=''''6'''' then ''''.''''
when sn.code=''''5'''' then ''''.''''
else sn.value end'' else ''
else '''''''' end'' end+''
,(select top 1 orders from dbo.object_credit where link_up=oc.link_up and object=oc.object and object_dict=oc.object)
from dbo.object_credit oc
join dbo.s_note sn on sn.link=oc.req
where exists(select * from #t_npa where vyp=oc.link_up)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 97, 'and oc.value is not null''+case when @nCheck_13=1 then '' and sn.code in (''''3'''',''''8'''',''''4'''',''''7'''')'' else '''' end+''
group by oc.link_up,sn.code,oc.value,sn.value,oc.object
order by oc.link_up,ord,sn.code,oc.value,sn.value''
execute sp_executesql @tsql

declare @link_up int,@res varchar(8000)
update #t_vyp set @res=res=case when coalesce(@link_up,0)=link_up then coalesce(@res+'' '','''') else '''' end+coalesce(abr+value,'''')
,@link_up=link_up

update t set res=coalesce((select top 1 res from #t_vyp where link_up=t.vyp order by len(res) desc),'' '') from #t_npa t

set @tsql=''
insert #t_npa (po,number,date,name,date_first,date_last,credit,bud,res,number2,name2,objpo,record,cod,link_class,dep,ate,status''+case when @nCombo_18=3 or @nCombo_31 in (4,6) then '',cd'' else '''' end+'')
select distinct (select top 1 credit from dbo.object_credit where link_up=oc.link_up and object_dict in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO) and credit is not null) as po,cd.number,cd.date,cd.name
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 98, ',oc2.date_first,oc2.date_last,oc2.credit,(select top 1 code from dbo.s_note where link=oc2.req) as bud
,'''' '''' as res
,cd3.number as number2,cd3.name as name2,objpo
,cd3.link as record
,(select top 1 value from dbo.object_credit where link_up=cd.link and object=object_dict and coalesce(value,'''''''')<>'''''''') as cod
,cd.link as link_class
,oc.dep
,oc.ate
,oc.status
''+case when @nCombo_18=3 or @nCombo_31 in (4,6) then '',oc.link_up'' else '''' end+''
from #npa oc
join (dbo.credit_doc cd join dbo.object_credit oc2 on oc2.link_up=cd.link and oc2.object=oc2.object_dict
join dbo.credit_doc cd3 on cd3.link=oc2.credit) on cd.link=oc.credit
where oc.object_dict=@DICTIONARY_NORM_DOC
and cd.link_class is null
and exists(select * from dbo.object_credit oc4 join dbo.s_note sn on sn.link=oc4.req and oc4.link_up=cd.link and sn.code in (''''1'''',''''2'''',@cCheck_16))
--and exists(select * from #t_res where r=oc.link_up)
''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 99, 'execute sp_executesql @tsql, N''		@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int,@DICTIONARY_NORM_DOC int,@cCheck_16 varchar(1)''
	,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO,@DICTIONARY_NORM_DOC,@cCheck_16

--select * from #t_npa
--select * from #t_npa1
--select * from #t_npa2
--return

create table #t_bud (id int identity primary key,
po int,bud int,number2 varchar(254),nam varchar(8000),res varchar(8000),dat varchar(254),st int,objpo int,lev1 int,lev2 int,lev3 int,cod varchar(254),dep int,ate int,status int,cd int,corr int,ecp varchar(8000))

create table #t_npa_lev (objpo int,po int,number varchar(254),date datetime,name varchar(8000),date_first datetime,date_last datetime, credit int,bud int,vyp int,res varchar(8000),number2 varchar(254),name2 varchar(8000),lev1 int,lev2 int,lev3 int,cod varchar(254),dep int,ate int,status int,cd int,link_class int)

if @nCombo_18<>3 begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 100, '	insert #t_npa_lev (objpo,po,number,date,name,date_first,date_last,credit,bud,vyp,res,number2,name2,lev1,cod,link_class,dep,ate,status,cd)
	select distinct n.objpo,n.po,n.number,n.date,n.name,n.date_first,n.date_last,n.credit,n.bud,n.vyp,n.res,n.number2,n.name2,l.orders as lev1,n.cod,n.link_class,n.dep,n.ate,n.status,n.cd
	 from #t_npa n,#t_npa1 l where n.bud=1 and n.record=l.record and l.orders<>2
	--      
	update #t_npa_lev set lev1=3 where lev1=4
	insert #t_npa_lev (objpo,po,number,date,name,date_first,date_last,credit,bud,vyp,res,number2,name2,lev2,cod,link_class,dep,ate,status,cd)
	select distinct n.objpo,n.po,n.number,n.date,n.name,n.date_first,n.date_last,n.credit,n.bud,n.vyp,n.res,n.number2,n.name2,l.orders as lev2,n.cod,n.link_class,n.dep,n.ate,n.status,n.cd
	 from #t_npa n,#t_npa2 l where n.bud=2 and n.record=l.record
end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 101, '--           
if @nCheck_33=0 or @nCombo_18=3
	insert #t_npa_lev (objpo,po,number,date,name,date_first,date_last,credit,bud,vyp,res,number2,name2,lev1,cod,link_class,dep,ate,status,cd)
	select distinct n.objpo,n.po,n.number,n.date,n.name,n.date_first,n.date_last,n.credit,n.bud,n.vyp,n.res,n.number2,n.name2,l.orders as lev1,n.cod,n.link_class,n.dep,n.ate,n.status,n.cd
	 from #t_npa n,#t_npa1 l where n.bud=1 and n.record=l.record and l.orders in (2,4) and n.cod is not null
else begin
	insert #t_npa_lev (objpo,po,number,date,name,date_first,date_last,credit,bud,vyp,res,number2,name2,lev1,cod,link_class,dep,ate,status,cd)
	select distinct n.objpo,n.po,n.number,n.date,n.name,n.date_first,n.date_last,n.credit,n.bud,n.vyp,n.res,n.number2,n.name2,l.orders as lev1,n.cod,n.link_class,n.dep,n.ate,n.status,n.cd
	 from #t_npa n,#t_npa1 l where n.bud=1 and n.record=l.record and l.orders=2 and n.cod is not null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 102, '	update t set lev1=l.orders from #t_npa_lev t join #t_npa n on t.link_class=n.link_class and t.po=n.po and coalesce(t.vyp,0)=coalesce(n.vyp,0)
	join #t_npa1 l on n.bud=1 and n.record=l.record and l.orders=4 and n.cod is not null
end

--   
insert #t_npa_lev (objpo,po,number,date,name,date_first,date_last,credit,bud,vyp,res,number2,name2,lev1,cod,link_class,dep,ate,status,cd)
select distinct n.objpo,n.po,n.number,n.date,n.name,n.date_first,n.date_last,n.credit,n.bud,n.vyp,n.res,n.number2,n.name2,0 as lev1,n.cod,n.link_class,n.dep,n.ate,n.status,n.cd
from #t_npa n where n.bud=1 and not exists(select * from #t_npa1 l where n.record=l.record)
and not exists(select * from #t_npa_lev where coalesce(credit,0)=coalesce(n.credit,0) and coalesce(vyp,0)=coalesce(n.vyp,0))

insert #t_npa_lev (objpo,po,number,date,name,date_first,date_last,credit,bud,vyp,res,number2,name2,lev2,cod,link_class,dep,ate,status,cd)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 103, 'select distinct n.objpo,n.po,n.number,n.date,n.name,n.date_first,n.date_last,n.credit,n.bud,n.vyp,n.res,n.number2,n.name2,0 as lev2,n.cod,n.link_class,n.dep,n.ate,n.status,n.cd
from #t_npa n where n.bud=2 and not exists(select * from #t_npa2 l where n.record=l.record)
and not exists(select * from #t_npa_lev where coalesce(credit,0)=coalesce(n.credit,0) and coalesce(vyp,0)=coalesce(n.vyp,0))

--select * from #t_npa_lev order by po,date
--return

if @nCheck_23=1 begin

	select po,link_class,res
	into #t_npa_link_class
	from #t_npa_lev t
	where exists(select * from (
		select po,link_class from #t_npa_lev
--		where res<>'' ''
		group by po,link_class having count(*)>1)f where coalesce(po,0)=coalesce(t.po,0) and coalesce(link_class,0)=coalesce(t.link_class,0))
	--and res<>'' ''
	group by po,link_class,res
	order by po,link_class,res

	select @res=null,@po=null,@link=null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 104, '	update #t_npa_link_class set @res=res=case when coalesce(@po,0)=po and coalesce(@link,0)=link_class then coalesce(@res+'', '','''') else '''' end+res,@po=po,@link=link_class
		where res not in ('''','' '')
	update t set res=(select top 1 res from #t_npa_link_class where po=t.po and link_class=t.link_class and res not in ('''','' '') order by len(res) desc) from #t_npa_lev t
		where exists(select * from #t_npa_link_class where po=t.po and link_class=t.link_class and res not in ('''','' ''))
	
--select * from #t_npa_link_class
--return

end

set @sql=''
insert #t_bud (ate,po,bud,number2,nam,res,dat,objpo,lev1,cod,dep,status,cd)
select ate,po,bud,number2
,left(coalesce(coalesce(name2+''''  ''''+convert(varchar,date,104)+''''  ''''+number,'''''''')+coalesce('''' ''''+case when left(name,1) in (''''"'''') then '''''''' else ''''"'''' end+name+case when left(reverse(name),1) in (''''"'''') then '''''''' else ''''"'''' end,''''''''),name),8000)
,res
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 105, ',coalesce(convert(varchar,date_first,104)+coalesce(''''  ''''+convert(varchar,date_last,104),'''',  ''''),'''' '''')
,objpo
,lev1
,cod
,dep
,status
,cd
from #t_npa_lev t
where bud in (1,2)
and lev1 is not null
group by ate,po,bud,lev1,number2,date,number,name,name2,date_first,date_last,res,objpo,cod,dep,status,cd
order by ate,po,bud,lev1,number2,date,number''
--print @sql
exec(@sql)

--select * from #t_bud
--return

--     ,  lev1 4  3
select @lev=null,@po=null,@bud=null,@st=null,@ate=null
update #t_bud set @st=st=case when coalesce(@po,0)=po and coalesce(@bud,0)=bud and coalesce(@lev,0)=lev1 and coalesce(@ate,0)=coalesce(ate,0) then coalesce(@st,0)+1 else 1 end
,@po=po,@bud=bud,@lev=lev1,@ate=ate where bud=1 and coalesce(lev1,0)=4
update t set st=l.st from #t_bud t
join #t_bud l on l.nam=t.nam and l.lev1=4 and t.lev1=3 and l.po=t.po and l.bud=t.bud and coalesce(l.ate,0)=coalesce(t.ate,0)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 106, 'select @lev=null,@po=null,@bud=null,@st=null,@ate=null
update #t_bud set @st=st=case when coalesce(@po,0)=po and coalesce(@bud,0)=bud and coalesce(@lev,0)=lev1 and coalesce(@ate,0)=coalesce(ate,0) then coalesce(@st,0)+1 else 1 end
,@po=po,@bud=bud,@lev=lev1,@ate=ate where bud=1 and coalesce(lev1,0) not in (0,4) and coalesce(st,0)=0
update #t_bud set st=-1 where bud=1 and coalesce(lev1,0)=0
update t set st=st+coalesce((select top 1 st from #t_bud where po=t.po and bud=t.bud and coalesce(lev1,0)=4 and coalesce(ate,0)=coalesce(t.ate,0) order by st desc),0)
from #t_bud t where bud=1 and coalesce(lev1,0)=3 and cod is null

insert #t_bud (ate,po,bud,number2,nam,res,dat,objpo,lev2,cod,dep,status,cd)
select ate,po,bud,number2
,left(coalesce(name2+''  ''+convert(varchar,date,104)+''  ''+number,'''')+coalesce('' ''+case when left(name,1) in (''"'') then '''' else ''"'' end+name+case when left(reverse(name),1) in (''"'') then '''' else ''"'' end,''''),8000)
,res
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 107, ',coalesce(convert(varchar,date_first,104)+coalesce(''  ''+convert(varchar,date_last,104),'',  ''),'' '')
,objpo
,lev2,cod,dep,status,cd
from #t_npa_lev t
where bud=2
and lev2 is not null
group by ate,po,bud,lev2,number2,date,number,name,name2,date_first,date_last,res,objpo,cod,dep,status,cd
order by ate,po,bud,lev2,number2,date,number

select @po=null,@bud=null,@st=null,@lev=null,@ate=null
update #t_bud set @st=st=case when coalesce(@po,0)=po and coalesce(@bud,0)=bud and coalesce(@lev,0)=lev2 and coalesce(@ate,0)=coalesce(ate,0) then coalesce(@st,0)+1 else 1 end
,@po=po,@bud=bud,@lev=lev2,@ate=ate where bud=2 and coalesce(lev2,0)<>0
update #t_bud set st=-1 where bud=2 and coalesce(lev2,0)=0

if @nCheck_16=1 begin

	if not exists(select * from #t_npa3)
		insert #t_npa3 (orders,name,record)
		select distinct 1,'''',record from #t_npa n where bud=3

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 108, '	insert #t_npa_lev (objpo,po,number,date,name,date_first,date_last,credit,bud,vyp,res,number2,name2,lev3,cod,link_class,dep,ate,status)
	select distinct n.objpo,n.po,n.number,n.date,n.name,n.date_first,n.date_last,n.credit,n.bud,n.vyp,n.res,n.number2,n.name2,l.orders as lev3,cod,n.link_class,n.dep,n.ate,n.status from #t_npa n,#t_npa3 l where n.bud=3 and n.record=l.record

	if @nCheck_23=1 begin

		truncate table #t_npa_link_class
		insert #t_npa_link_class (po,link_class,res)
		select po,link_class,res
		from #t_npa_lev t
		where exists(select * from (
			select po,link_class from #t_npa_lev where lev3 is not null
	--		and res<>'' ''
			group by po,link_class having count(*)>1)f where coalesce(po,0)=coalesce(t.po,0) and coalesce(link_class,0)=coalesce(t.link_class,0))
			and lev3 is not null
		--and res<>'' ''
		group by po,link_class,res
		order by po,link_class,res

		select @res=null,@po=null,@link=null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 109, '		update #t_npa_link_class set @res=res=case when coalesce(@po,0)=po and coalesce(@link,0)=link_class then coalesce(@res+'', '','''') else '''' end+res,@po=po,@link=link_class
			where res not in ('''','' '')
		update t set res=(select top 1 res from #t_npa_link_class where po=t.po and link_class=t.link_class order by len(res) desc) from #t_npa_lev t
			where exists(select * from #t_npa_link_class where po=t.po and link_class=t.link_class)
			and lev3 is not null

	end

	insert #t_bud (ate,po,bud,number2,nam,res,dat,objpo,lev3,cod,dep,status,cd)
	select ate,po,bud,number2
	,left(coalesce(name2+''  ''+convert(varchar,date,104)+''  ''+number,'''')+coalesce('' ''+case when left(name,1) in (''"'') then '''' else ''"'' end+name+case when left(reverse(name),1) in (''"'') then '''' else ''"'' end,''''),8000)
	,res
	,coalesce(convert(varchar,date_first,104)+coalesce(''  ''+convert(varchar,date_last,104),'',  ''),'' '')
	,objpo
	,lev3,cod,dep,status,cd
	from #t_npa_lev t
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 110, '	where bud=3 and objpo=@DICTIONARY_SODERG_RO_MO
	and lev3 is not null
	group by ate,po,bud,lev3,number2,date,number,name2,name,date_first,date_last,res,objpo,cod,dep,status,cd
	order by ate,po,bud,lev3,number2,date,number

	select @po=null,@bud=null,@st=null,@lev=null,@ate=null
	update #t_bud set @st=st=case when coalesce(@po,0)=po and coalesce(@bud,0)=bud and coalesce(@lev,0)=lev3 and coalesce(@ate,0)=coalesce(ate,0) then coalesce(@st,0)+1 else 1 end
	,@po=po,@bud=bud,@lev=lev3,@ate=ate where bud=3 and coalesce(lev3,0)<>0
	update #t_bud set st=-1 where bud=3 and coalesce(lev3,0)=0
end

--select * from #t_bud
--return

create table #div (po int,div int,craz varchar(8000),cdiv varchar(8000),cdiv1 varchar(8000),cdiv2 varchar(8000))
create table #div_n (po int,name varchar(8000))
create table #div_t (po int,div int,cdiv varchar(8000))

declare @name varchar(8000),@sname varchar(8000),@pname varchar(8000)

--select distinct div from #t_res
--return

if @nCheck_14=0 begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 111, '	set @tsql=''insert #div (po,cdiv,div)
	select distinct po
	,(select top 1 code from dbo.s_kbk where link=t.div) as cdiv,div
		from #t_res t
	where objpo=@DICTIONARY_SODERG_RO''+case when @nCombo_18=3 then ''
	and exists(select * from #t_bud where cd=t.r)'' else '''' end+''
	group by po,div
	order by po,cdiv,div
	''
	execute sp_executesql @tsql, N''		@DICTIONARY_SODERG_RO int''
	,@DICTIONARY_SODERG_RO

end else begin

	insert #div_n (po,name)
	select po,name
		from #t_res t
	where objpo=@DICTIONARY_SODERG_RO
	group by po,name
	order by po,name

	while exists(select * from #div_n where po is not null) begin
		select top 1 @po=po,@name=name+'','',@pname=name from #div_n where po is not null
		while len(@name)>4 begin
			while len(@name)>4 and left(@name,1) not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''0'') select @name=substring(@name,2,8000)
			set @sname=''''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 112, '			while len(@name)>0 and left(@name,1) in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''0'') select @sname=@sname+left(@name,1),@name=substring(@name,2,8000)
			if len(@sname)=4
				insert #div_t (po,div,cdiv)
				select @po,s.link,s.code from dbo.s_kbk s, dbo.kbk_name(@dDate_2) n where s.link=n.link_up and s.code=@sname and s.object=@DICTIONARY_DIVISION
		end
		update #div_n set po=null where po=@po and name=@pname
	end

	insert #div (po,cdiv,div)
	select po,cdiv,div
		from #div_t
	group by po,cdiv,div
	order by po,cdiv,div
end

if @nCheck_15=0 begin

	set @tsql=''insert #div (po,cdiv,div)
	select distinct po
	,(select top 1 code from dbo.s_kbk where link=t.div) as cdiv,div
		from #t_res t
	where objpo=@DICTIONARY_SODERG_RO_MO''+case when @nCombo_18=3 then ''
	and exists(select * from #t_bud where cd=t.r)'' else '''' end+''
	group by po,div
	order by po,cdiv,div
	''
	execute sp_executesql @tsql, N''		@DICTIONARY_SODERG_RO_MO int''
	,@DICTIONARY_SODERG_RO_MO

end else begin

	if @nCheck_14=1	begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 113, '		truncate table #div_n
		truncate table #div_t
	end
	
	insert #div_n (po,name)
	select po,name
		from #t_res t
	where objpo=@DICTIONARY_SODERG_RO_MO
	group by po,name
	order by po,name

	while exists(select * from #div_n where po is not null) begin
		select top 1 @po=po,@name=name+'','',@pname=name from #div_n where po is not null
		while len(@name)>4 begin
			while len(@name)>4 and left(@name,1) not in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''0'') select @name=substring(@name,2,8000)
			set @sname=''''
			while len(@name)>0 and left(@name,1) in (''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''0'') select @sname=@sname+left(@name,1),@name=substring(@name,2,8000)
			if len(@sname)=4
				insert #div_t (po,div,cdiv)
				select @po,s.link,s.code from dbo.s_kbk s, dbo.kbk_name(@dDate_2) n where s.link=n.link_up and s.code=@sname and s.object=@DICTIONARY_DIVISION
		end
		update #div_n set po=null where po=@po and name=@pname
	end

	insert #div (po,cdiv,div)
	select po,cdiv,div
		from #div_t
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 114, '	group by po,cdiv,div
	order by po,cdiv,div
end

--select (select top 1 number from dbo.credit_doc where link=t.po),* from #div t order by po
--return

update #div set cdiv1=left(cdiv,2),cdiv2=substring(cdiv,3,2)
--if @nCombo_18 in (1,3,5,10,11)
if @nCombo_18=3
	update #div set craz=left(cdiv,2),cdiv=substring(cdiv,3,2)

--select distinct cdiv from #div
--return
select distinct * into #div_order from #div order by po,cdiv
truncate table #div
insert #div select distinct *  from #div_order order by po,div
drop table #div_order

--select (select top 1 number from dbo.credit_doc where link=t.po),* from #div t --order by po

declare @craz varchar(8000),@cdiv varchar(8000)
if @nCombo_18 in (1,3,5,9,10,11) begin
	select @po=null,@cdiv=null
	update #div set @craz=craz=case when po=coalesce(@po,0) then coalesce(@craz+''
'','''') else '''' end+craz
	,@cdiv=cdiv=case when po=coalesce(@po,0) then coalesce(@cdiv+''
'','''') else '''' end+cdiv
	,@po=po
end

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 115, '--select (select top 1 number from dbo.credit_doc where link=t.po),* from #div t --order by po
--return

create table #metod (po int,metod varchar(8000))

if @nCheck_22=1 and @nCombo_18 not in (5,7,8,9,12) begin
	select @po=null,@craz=null
	insert #metod (po,metod)
	select t.po,cast(cd.name as varchar(8000)) as metod
	from #t_res t
	join dbo.credit_doc cd on cd.link=t.metod
	group by t.po,cd.name
	order by t.po,cd.name

	while exists(select * from #metod where metod like ''%,%'') begin
		insert #metod (po,metod)
		select po,ltrim(rtrim((substring(metod,charindex('','',metod)+1,8000)))) from #metod where metod like ''%,%''
		update #metod set metod=left(metod,charindex('','',metod)-1) where metod like ''%,%''
	end

	select distinct * into #metod_order from #metod order by po,metod
	truncate table #metod
	insert #metod select distinct * from #metod_order order by po,metod
	drop table #metod_order

	update #metod set @craz=metod=case when po=coalesce(@po,0) then coalesce(@craz+''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 116, ''','''') else '''' end+metod
	,@po=po
end

update t set lev=1,su=coalesce((select top 1 d.orders from #t_dop d where d.record=t.su and d.list in (0,1)),0),list=1 from #t_res t where objpo=@DICTIONARY_SODERG_RO
update t set lev=1,su=coalesce((select top 1 d.orders from #t_dop d where d.record=t.su and d.list in (0,2)),0),list=2 from #t_res t where objpo in (@DICTIONARY_SODERG_RO_MO,@DICTIONARY_RRO_CONSOLIDATED_MO)
update #t_res set su=4 where su=0

update t set status=(select top 1 status from #t_res where r=t.r and status is not null) from #t_res t where status is null

if @nCombo_18=3
	update #t_res set cd=r

if @nCombo_31=6 begin
	create table #eds_info_out (link int primary key, ecp varchar(8000), date_ecp datetime)
	set @RID=null
	insert into #eds_info_out (link) 
	select distinct r as link from #t_res
	exec dbo.GET_EDS_INFO @cTable=''#eds_info_out'', @cTableDoc=''credit_doc'', @cLinkField=''link'', @cEdsField=''ecp'', @nSize=8000, @cSeparator1=''|'', @cSeparator2=''#''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 117, '	update t set ecp=p.ecp from #t_res t join #eds_info_out p on p.link=t.r and p.ecp is not null
end

if @nCombo_18 in (1,3,5,7,8,9,10,11,12) and @nCheck_34=0
	update #t_res set div=null

if @nCombo_18 in (7,8,12) begin
	if not exists(select * from #t_res where objpo=@DICTIONARY_SODERG_RO)
		set @NASTR_RRO_RASH_YEAR=@NASTR_RRO_RASH_YEAR_MO
end

select cast(case when objpo=@DICTIONARY_SODERG_RO then 1 else 2 end as int) as list
,cast(rtrim(po.number) as varchar(100)) as cpo
,cast(rtrim(po.name) as varchar(8000)) as po_n
,cast(rtrim((select top 1 value from dbo.object_credit where link_up=t.po and coalesce(value,'''')<>'''')) as varchar(254)) as poc
,po
,cast(null as int) as po1
,cast(null as int) as po2
,cast(null as int) as po3
,cast(null as int) as po4
,cast(null as int) as po5
,cast(null as varchar(254)) as po1c
,cast(null as varchar(254)) as po2c
,cast(null as varchar(254)) as po3c
,cast(null as varchar(254)) as po4c
,cast(null as varchar(254)) as po5c
,cast(null as varchar(100)) as cpo1
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 118, ',cast(null as varchar(100)) as cpo2
,cast(null as varchar(100)) as cpo3
,cast(null as varchar(100)) as cpo4
,cast(null as varchar(100)) as cpo5

,cast(null as varchar(100)) as cpog
,cast(null as int) as npog
,cast(null as varchar(100)) as cpo1g
,cast(null as varchar(100)) as cpo2g
,cast(null as varchar(100)) as cpo3g
,cast(null as varchar(100)) as cpo4g
,cast(null as varchar(100)) as cpo5g

,cast(null as varchar(8000)) as po1_n
,cast(null as varchar(8000)) as po2_n
,cast(null as varchar(8000)) as po3_n
,cast(null as varchar(8000)) as po4_n
,cast(null as varchar(8000)) as po5_n
,cast(null as varchar(8000)) as pog_n

,cast(sum(case when god=@nInt_10-1 and obj=@PLAN_SUM_REESTR_RO then s end) as money) as s_1
,cast(sum(case when god=@nInt_10-1 and obj=@ACTUAL_SUM_REESTR_RO then s end) as money) as s_2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 119, ',cast(sum(case when god=@nInt_10 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then s end) as money) as s_3
,cast(sum(case when god=@nInt_10+1 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10+1<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then s end) as money) as s_4
,cast(sum(case when god=@nInt_10+2 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10+2<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then s end) as money) as s_5
,cast(sum(case when god=@nInt_10+3 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10+3<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then s end) as money) as s_6
,cast(sum(case when god=@nInt_10-1 and obj=@GRADE_SUM_REESTR_RO then s end) as money) as s_7
,cast(sum(case when god=@nInt_10 and obj=@GRADE_SUM_REESTR_RO then s end) as money) as s_8
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 120, ',cast(sum(case when god=@nInt_10+1 and obj=@GRADE_SUM_REESTR_RO then s end) as money) as s_9

,cast(sum(case when @nCombo_18 in (7,8,12) and god=@nInt_10+4 and obj=@PLAN_SUM_REESTR_RO then s end) as money) as s_10
,cast(sum(case when @nCombo_18 in (7,8,12) and god=@nInt_10+2 and obj=@GRADE_SUM_REESTR_RO then s end) as money) as s_12
,cast(sum(case when @nCombo_18 in (7,8,12) and god=@nInt_10+3 and obj=@GRADE_SUM_REESTR_RO then s end) as money) as s_13
,cast(sum(case when @nCombo_18 in (7,8,12) and god=@nInt_10+4 and obj=@GRADE_SUM_REESTR_RO then s end) as money) as s_14

,cast(sum(case when god=@nInt_10-1 and obj=@PLAN_SUM_REESTR_RO then k end) as money) as k_1
,cast(sum(case when god=@nInt_10-1 and obj=@ACTUAL_SUM_REESTR_RO then k end) as money) as k_2
,cast(sum(case when god=@nInt_10 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then k end) as money) as k_3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 121, ',cast(sum(case when god=@nInt_10+1 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10+1<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then k end) as money) as k_4
,cast(sum(case when god=@nInt_10+2 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10+2<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then k end) as money) as k_5
,cast(sum(case when god=@nInt_10+3 and obj=case when @nCombo_18 in (7,8,12) and @nInt_10+3<@NASTR_RRO_RASH_YEAR then @ACTUAL_SUM_REESTR_RO else @PLAN_SUM_REESTR_RO end then k end) as money) as k_6
,cast(sum(case when god=@nInt_10-1 and obj=@GRADE_SUM_REESTR_RO then k end) as money) as k_7
,cast(sum(case when god=@nInt_10 and obj=@GRADE_SUM_REESTR_RO then k end) as money) as k_8
,cast(sum(case when god=@nInt_10+1 and obj=@GRADE_SUM_REESTR_RO then k end) as money) as k_9

,cast(null as int) as st
,cast(null as varchar(8000)) as nam_1
,cast(null as varchar(8000)) as res_1
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 122, ',cast(null as varchar(254)) as dat_1
,cast(null as varchar(254)) as cod_1
,cast(null as int) as lev1
,cast(null as varchar(8000)) as nam_2
,cast(null as varchar(8000)) as res_2
,cast(null as varchar(254)) as dat_2
,cast(null as varchar(254)) as cod_2
,cast(null as int) as lev2
,cast(null as varchar(8000)) as nam_3
,cast(null as varchar(8000)) as res_3
,cast(null as varchar(254)) as dat_3
,cast(null as varchar(254)) as cod_3
,cast(null as int) as lev3
,cast(null as varchar(8000)) as cdep
,cast(null as varchar(8000)) as cdepc
,cast((select top 1 craz from #div where po=t.po order by len(craz) desc) as varchar(8000)) as craz
,cast((select top 1 cdiv from #div where po=t.po order by len(cdiv) desc) as varchar(8000)) as cdiv
,cast(null as varchar(8000)) as cdiv1
,cast(null as varchar(8000)) as cdiv2
,cast(null as varchar(8000)) as ctgt
,cast(null as varchar(8000)) as cexp
,cast(null as varchar(8000)) as citm
,cast(null as varchar(8000)) as cdop
,cast(null as varchar(8000)) as clcl
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 123, ',cast(null as varchar(8000)) as dep_n
,cast(null as varchar(8000)) as div_n
,cast(null as varchar(8000)) as tgt_n
,cast(null as varchar(8000)) as exp_n
,cast(null as varchar(8000)) as itm_n
,cast(null as varchar(8000)) as dop_n
,cast(null as varchar(8000)) as lcl_n
,cast(coalesce((select top 1 metod from #metod where po=t.po order by len(metod) desc),'' '') as varchar(8000)) as metod
,lev,dep,div,tgt,exp,itm,dop,lcl,su
,cast(null as varchar(254)) as hierarchy,cast(null as uniqueidentifier) as row_id
,cast(null as varchar(254)) as pon
,cast((select top 1 inn from dbo.s_corr where link=t.ate) as varchar(254)) as cate
,cast((select top 1 name from dbo.s_corr where link=t.ate) as varchar(8000)) as ate_n
,status
,cd
,cast(null as varchar(100)) as cnpro1
,cast(null as varchar(100)) as cnpro
,cast(null as varchar(8000)) as npro1_n
,cast(null as varchar(8000)) as npro_n
,cast(null as int) as vnut
,objpo
,corr
,ecp
 into #t_res2
 from #t_res t
 join dbo.credit_doc po on po.link=t.po
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 124, ' group by po.number,po.name,t.po,t.objpo,lev,dep,div,tgt,exp,itm,dop,lcl,su,t.ate,status,cd,objpo,corr,ecp
 order by list,po.number

--select * from #t_res2
--return

select top 0 cpo,po,cdep,cdiv,ctgt,cexp,citm,cdop,clcl,st into #stkbk from #t_res2
if @nCombo_18 in (2,4,6,7,8,12) begin

	if @nCombo_18 not in (7,8)
		update t set cdiv=d.cdiv,cdiv1=d.cdiv1,cdiv2=d.cdiv2 from #t_res2 t
		join #div d on d.div=t.div

	if @nCheck_19=1 or @nCombo_31=5
		update t set ctgt=d.code from #t_res2 t
		join dbo.s_kbk d on d.link=t.tgt
	if @nCheck_20=1
		update t set cexp=d.code from #t_res2 t
		join dbo.s_kbk d on d.link=t.exp
	if @nCheck_21=1
		update t set citm=d.code from #t_res2 t
		join dbo.s_kbk d on d.link=t.itm
	if @nCheck_25=1
		update t set cdop=d.code from #t_res2 t
		join dbo.s_kbk d on d.link=t.dop
	if @nCheck_26=1
		update t set clcl=d.code from #t_res2 t
		join dbo.s_kbk d on d.link=t.lcl
	if @nCheck_27=1 or @nCombo_31=3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 125, '		update t set cdep=d.code,cdepc=d.code+''_''+cast(t.dep as varchar) from #t_res2 t
		join dbo.s_kbk d on d.link=t.dep

	if @nCombo_18 in (4,6) begin
		update t set div_n=d.name from #t_res2 t
		join dbo.kbk_name(@dDate_2) d on d.link_up=t.div
		if @nCheck_19=1 or @nCombo_31=5
			update t set tgt_n=d.name from #t_res2 t
			join dbo.kbk_name(@dDate_2) d on d.link_up=t.tgt
		if @nCheck_20=1
			update t set exp_n=d.name from #t_res2 t
			join dbo.kbk_name(@dDate_2) d on d.link_up=t.exp
		if @nCheck_21=1
			update t set itm_n=d.name from #t_res2 t
			join dbo.kbk_name(@dDate_2) d on d.link_up=t.itm
		if @nCheck_25=1
			update t set dop_n=d.name from #t_res2 t
			join dbo.kbk_name(@dDate_2) d on d.link_up=t.dop
		if @nCheck_26=1
			update t set lcl_n=d.name from #t_res2 t
			join dbo.kbk_name(@dDate_2) d on d.link_up=t.lcl
		if @nCheck_27=1 or @nCombo_31=3
			update t set dep_n=d.name from #t_res2 t
			join dbo.kbk_name(@dDate_2) d on d.link_up=t.dep
	end else if @nCombo_31=3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 126, '		update t set dep_n=d.name from #t_res2 t
		join dbo.kbk_name(@dDate_2) d on d.link_up=t.dep
		else if @nCombo_31=5
			update t set tgt_n=d.name from #t_res2 t
			join dbo.kbk_name(@dDate_2) d on d.link_up=t.tgt

	if @nCombo_18 in (7,8,12) begin

		create table #t_nacpro (code varchar(100),name varchar(2000),date_begin datetime,date_end datetime)
		insert #t_nacpro (code,name,date_begin,date_end)
--   _1(2021): I4, I8, P2, P4
--   _2(2022): S5 
--   _4(2024): P3, P5
select ''A'',''  "", '',null,null
union select ''A1'',''  "      " (" ")'',null,null
union select ''A2'',''  "      " (" ")'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 127, 'union select ''A3'',''  "        " (" ")'',null,null
--union select '''','' ,       ( )'',null,null
union select ''D'',''  "   "'',null,null
union select ''D1'',''  "   "'',null,null
union select ''D2'',''  " "'',null,null
union select ''D3'',''  "   "'',null,null
union select ''D4'',''  " "'',null,null
union select ''D5'',''  " "'',null,null
union select ''D6'',''  "  "'',null,null
union select ''D7'',''  " " (  2021 )'',''20210101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 128, 'union select ''D8'',''  "   -" (  2022 )'',''20220101'',null
union select ''D9'',''  "        " (  2022 )'',''20220101'',null
union select ''D'',''  "    " (  2022 )'',''20220101'',null
--union select '''','' ,       ( )'',null,null
union select ''E'',''  ""'',null,null
union select ''E1'',''  " "'',null,null
union select ''E2'',''  "  "'',null,null
union select ''E3'',''  " ,  "'',null,''20201231''
union select ''E4'',''  "  "'',null,null
union select ''E5'',''  " "'',null,''20211231''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 129, 'union select ''E6'',''  "  (   )"'',null,null
union select ''E7'',''  "   "'',null,''20201231''
union select ''E8'',''  " "'',null,null
union select ''E9'',''  " "'',null,''20211231''
union select ''E'',''  "   "'',null,null
union select ''E'',''  "    "'',''20210101'',null
union select ''E'',''  "    (" ")"'',''20220101'',null
--union select '''','' ,       ( )'',null,null
union select ''F'',''  "   "'',null,null
union select ''F1'',''  ""'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 130, 'union select ''F2'',''  "   "'',null,null
union select ''F3'',''  "       "'',null,null
union select ''F4'',''  ""'',null,null
union select ''F5'',''  " " (2021-2024)'',''20210101'',null
--union select '''','' ,       ( )'',null,null
union select ''G'',''  ""'',null,null
union select ''G1'',''  " "'',null,null
union select ''G2'',''  "      "'',null,null
union select ''G3'',''  "     I - II  "'',null,null
union select ''G4'',''  " "'',null,null
union select ''G5'',''  " " (2019-2020)'',null,''20201231''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 131, 'union select ''G6'',''  " "'',null,null
union select ''G7'',''  "  "'',null,null
union select ''G8'',''  "   "'',null,null
union select ''G9'',''  "      "'',null,null
union select ''G'',''  " "'',null,null
union select ''G'',''  "   "'',null,''20211231''
union select ''G'',''  "     '',null,null
--union select '''','' ,       ( )'',null,null
union select ''I'',''  "        "'',null,null
union select ''I1'',''  "    "'',null,''20201231''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 132, 'union select ''I2'',''  "       " (  2021 )'',''20210101'',null
union select ''I4'',''  "      ,     "'',null,''20201231''
union select ''I4_1'',''  "        " (  2021 )'',''20210101'',null
union select ''I5'',''  "     "'',null,null
union select ''I7'',''  "       "'',null,''20211231''
union select ''I8'',''  " "'',null,''20201231''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 133, 'union select ''I8_1'',''  "                    " (  2021 )'',''20210101'',null
--union select '''','' ,       ( )'',null,null
union select ''J'',''  "   "'',null,null
union select ''J1'',''  "  "'',null,null
union select ''J2'',''  "   " '',null,null
union select ''J3'',''  "    "  '',null,null
union select '''','' ,       ( )'',null,null
union select ''L'',''  "    "'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 134, 'union select ''L1'',''  "     "'',null,null
union select ''L2'',''  "      "'',null,null
union select ''L3'',''  "           "'',null,''20201231''
--union select '''','' ,       ( )'',null,null
union select ''N'',''  ""'',null,null
union select ''N1'',''  "    - "'',null,null
union select ''N2'',''  "  - "'',null,null
union select ''N3'',''  "   "'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 135, 'union select ''N4'',''  "  ,        "'',null,null
union select ''N5'',''  "      "'',null,null
union select ''N6'',''  "          "'',null,null
union select ''N7'',''  "             ()"'',null,null
union select ''N8'',''  "   "'',null,null
union select ''N9'',''  "     " (  2022 )'',''20220101'',null
--union select '''','' ,       ( )'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 136, 'union select ''P'',''  ""'',null,null
union select ''P1'',''  "     "'',null,null
union select ''P2'',''  "   -           "'',null,''20201231''
union select ''P2_1'',''  " " (  2021 )'',''20210101'',null
union select ''P3'',''   "            "'',null,null
union select ''P4'',''  "  "'',null,''20201231''
union select ''P4_1'',''  "       ,        " (  2021 )'',''20210101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 137, 'union select ''P5'',''  "             ,  ,         ,     "'',null,null
--union select '''','' ,       ( )'',null,null
union select ''R'',''  "    "'',null,null
union select ''R1'',''  "    "'',null,null
union select ''R2'',''  "    "'',null,null
union select ''R3'',''  "  "'',null,null
union select ''R4'',''  "   "'',null,null
union select ''R5'',''  "  "'',''20210101'',''20211231''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 138, 'union select ''R6'',''  "   "'',''20210101'',null
union select ''R7'',''  "  "'',''20210101'',null
--union select '''','' ,       ( )'',null,null
union select ''S'',''  "  "'',null,null
union select ''S1'',''  "   - "'',null,''20201231''
union select ''S2'',''  "          "'',null,''20201231''
union select ''S3'',''  "       "'',null,''20201231''
union select ''S4'',''  "     ,    "'',''20210101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 139, 'union select ''S5'',''  "   - "'',''20210101'',''20211231''
union select ''S5_2'',''  "    -     " (  2022 )'',''20220101'',null
union select ''S6'',''  "       " (  2021 )'',''20210101'',null
union select ''S7'',''  "     ,      "'',''20210101'',null
union select ''S8'',''  "   " (  2023 )'',''20230101'',null
--union select '''','' ,       ( )'',null,null
union select ''T'',''  "   "'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 140, 'union select ''T1'',''  " "'',null,null
union select ''T2'',''  "  "'',null,null
union select ''T3'',''  "  "'',null,''20201231''
union select ''T4'',''  " "'',null,''20211231''
union select ''T6'',''  "      "'',null,null
--union select '''','' ,       ( )'',null,null
union select ''U'',''  " ,                2024 " (  2021 )'',null,null
union select ''U1'',''  "         "'',''20210101'',''20211231''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 141, 'union select ''U1_2'',''  "  ,         " (  2022 )'',''20220101'',null
union select ''U2'',''  "  -            "'',''20210101'',''20211231''
union select ''U3'',''  "        "'',''20210101'',''20211231''
union select ''U4'',''  "        "'',''20210101'',''20211231''
union select ''U5'',''  "      ,       ".'',''20210101'',''20211231''
--union select '''','' ,       ( )'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 142, 'union select ''V'',''      '',null,null
union select ''V1'',''  "       -  "'',null,null
union select ''V2'',''  "  "'',null,null
union select ''V3'',''  "   "'',null,null
union select ''V4'',''  "   "'',null,''20211231''
union select ''V5'',''  "- "'',null,''20211231''
union select ''V6'',''  "    "'',null,''20211231''
union select ''V7'',''  "  "'',null,null
union select ''V8'',''   "   "'',null,null
union select ''V9'',''  "  "'',null,''20201231''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 143, 'union select ''V'',''  "   "'',null,''20211231''
union select ''V'',''  "   , ,    "'',null,''20211231''
union select ''V'',''  "      " (  2021 )'',''20210101'',null
union select ''V'',''  "      - " (  2021 )'',''20210101'',null
union select ''V'',''  "      - " (  2021 )'',''20210101'',null
union select ''V'',''  "     " (  2021 )'',''20210101'',null
--union select '''','' ,       ( )'',null,null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 144, 'union select ''Y'',''  "  "'',null,null
union select ''Y1'',''  " ,          " (  2024 )'',''20240101'',null
union select ''Y2'',''  "    " (  2024 )'',''20240101'',null
union select ''Y3'',''  "     " (  2024 )'',''20240101'',null
union select ''Y4'',''  "      " (  2024 )'',''20240101'',null
union select ''Y5'',''  ",         " (  2024 )'',''20240101'',null
--2025
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 145, 'union select '''',''  "   "'',''20250101'',null
union select ''1'',''  "   "'',''20250101'',null
union select ''2'',''  "     "'',''20250101'',null
union select ''3'',''  "     "'',''20250101'',null
union select ''4'',''  "        "'',''20250101'',null
union select '''',''  "   "'',''20250101'',null
union select ''1'',''  "   "'',''20250101'',null
union select ''2'',''  "    "'',''20250101'',null
union select ''3'',''  "  "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 146, 'union select ''4'',''  " "'',''20250101'',null
union select '''',''  "   "'',''20250101'',null
union select ''1'',''  "     "'',''20250101'',null
union select ''2'',''  "  - "'',''20250101'',null
union select ''3'',''  "   "'',''20250101'',null
union select ''4'',''  "   "'',''20250101'',null
union select ''5'',''  "         "'',''20250101'',null
union select ''6'',''  "   "'',''20250101'',null
union select ''7'',''  "     "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 147, 'union select ''8'',''  "   ""'',''20250101'',null
union select ''9'',''  "   ,      "'',''20250101'',null
union select '''',''  "  "'',''20250101'',null
union select '''',''  " "'',''20250101'',null
union select '''',''  "   "'',''20250101'',null
union select ''1'',''  " "'',''20250101'',null
union select ''2'',''  "    ,    ,   "'',''20250101'',null
union select ''3'',''  "         "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 148, 'union select ''4'',''  "   "'',''20250101'',null
union select ''5'',''  "     ,    "'',''20250101'',null
union select '''',''  "  "'',''20250101'',null
union select ''1'',''  "    "'',''20250101'',null
union select ''2'',''  ""'',''20250101'',null
union select ''3'',''  "  "'',''20250101'',null
union select ''4'',''  "   "'',''20250101'',null
union select ''5'',''  "  "'',''20250101'',null
union select ''6'',''  "  "'',''20250101'',null
union select ''7'',''  "  "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 149, 'union select ''8'',''  "    "'',''20250101'',null
union select ''9'',''  "    "'',''20250101'',null
union select '''',''  "  "'',''20250101'',null
union select '''',''  ""'',''20250101'',null
union select '''',''  "     "'',''20250101'',null
union select '''',''  "        2030      2036 "'',''20250101'',null
union select '''',''  ""'',''20250101'',null
union select ''1'',''  "  "'',''20250101'',null
union select ''2'',''  "   "'',''20250101'',null
union select ''3'',''  "   "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 150, 'union select ''4'',''  " "'',''20250101'',null
union select '''',''  "   "'',''20250101'',null
union select ''1'',''  " "'',''20250101'',null
union select ''2'',''  "  "'',''20250101'',null
union select ''3'',''  "      "'',''20250101'',null
union select ''4'',''  "   "'',''20250101'',null
union select '''',''  "   "'',''20250101'',null
union select ''1'',''  "   "'',''20250101'',null
union select ''2'',''  "   "'',''20250101'',null
union select ''3'',''  "   "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 151, 'union select ''4'',''  "     "'',''20250101'',null
union select ''5'',''  "         "'',''20250101'',null
union select '''',''  "  "'',''20250101'',null
union select ''1'',''  "  ,     "'',''20250101'',null
union select ''2'',''  "    "'',''20250101'',null
union select ''3'',''  "  "'',''20250101'',null
union select ''4'',''  "  "'',''20250101'',null
union select ''5'',''  "     "'',''20250101'',null
union select '''',''  "    "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 152, 'union select ''1'',''  "  "'',''20250101'',null
union select ''2'',''  "-       "'',''20250101'',null
union select ''3'',''  "  "'',''20250101'',null
union select ''4'',''  "     "'',''20250101'',null
union select ''5'',''  "       "'',''20250101'',null
union select ''6'',''  "    -     "'',''20250101'',null
union select ''7'',''  "     "'',''20250101'',null
union select ''8'',''  "       "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 153, 'union select ''9'',''  "       "'',''20250101'',null
union select '''',''  "      "'',''20250101'',null
union select '''',''  "   "'',''20250101'',null
union select ''1'',''  "  "'',''20250101'',null
union select ''2'',''  "   ,      "'',''20250101'',null
union select ''3'',''  "    "'',''20250101'',null
union select ''4'',''  " ,   ,     "'',''20250101'',null
union select ''5'',''  "        "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 154, 'union select '''',''  "  "'',''20250101'',null
union select ''1'',''  "   "'',''20250101'',null
union select ''2'',''  "    "'',''20250101'',null
union select ''3'',''  "    "'',''20250101'',null
union select ''4'',''  "    "'',''20250101'',null
union select ''5'',''  "     "'',''20250101'',null
union select ''6'',''  "   "'',''20250101'',null
union select ''7'',''  "       "'',''20250101'',null
union select ''8'',''  "   "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 155, 'union select ''9'',''  "    "'',''20250101'',null
union select '''',''  "     "'',''20250101'',null
union select ''1'',''  "   -  ""'',''20250101'',null
union select ''2'',''  "     "'',''20250101'',null
union select ''3'',''  " "'',''20250101'',null
union select ''4'',''  "  "'',''20250101'',null
union select ''5'',''  " "'',''20250101'',null
union select ''6'',''  "    "'',''20250101'',null
union select ''7'',''  " "'',''20250101'',null
union select ''8'',''  "   "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 156, 'union select '''',''  " "'',''20250101'',null
union select ''1'',''  " "'',''20250101'',null
union select ''2'',''  "  "'',''20250101'',null
union select ''3'',''  "      "'',''20250101'',null
union select ''4'',''  " "'',''20250101'',null
union select ''5'',''  " "'',''20250101'',null
union select ''6'',''  " "'',''20250101'',null
union select '''',''  "   "'',''20250101'',null
union select ''1'',''  "        "'',''20250101'',null
union select ''2'',''  " "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 157, 'union select ''3'',''  "  "'',''20250101'',null
union select ''4'',''  " "'',''20250101'',null
union select ''5'',''  "  "'',''20250101'',null
union select ''6'',''  ""'',''20250101'',null
union select '''',''  "  "'',''20250101'',null
union select ''1'',''  " -  "'',''20250101'',null
union select ''2'',''  "  (   )"'',''20250101'',null
union select ''3'',''  "  "'',''20250101'',null
union select ''4'',''  "  "'',''20250101'',null
union select ''5'',''  " "'',''20250101'',null
union select ''6'',''  "  "'',''20250101'',null
union select ''7'',''  "   "'',''20250101'',null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 158, 'union select ''8'',''  "   "'',''20250101'',null
union select ''9'',''  ""'',''20250101'',null
union select '''',''  ""'',''20250101'',null
union select ''1'',''  " "'',''20250101'',null
union select ''2'',''  " "'',''20250101'',null
union select ''3'',''  "   "'',''20250101'',null
union select ''4'',''  " "'',''20250101'',null
union select ''5'',''  "    "'',''20250101'',null

--  
--select code from #t_nacpro group by code having count(*)>1
--return

		update t set cnpro=substring(d.code,4,2),cnpro1=substring(d.code,4,1) from #t_res2 t
		join dbo.s_kbk d on d.link=t.tgt and exists(select * from #t_nacpro where left(code,2)=substring(d.code,4,2))

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 159, '		declare c_cnprog cursor local forward_only static read_only for
		select distinct right(code,2) from #t_nacpro where len(code)=4 and isnumeric(right(code,1))=1
		open c_cnprog
		fetch next from c_cnprog into @cpo
		while @@fetch_status = 0 begin
			set @po=2020+cast(right(@cpo,1) as int)

			if @nInt_10<=@po begin
				set @sql=case when @nInt_10>=@po-4 then ''
select * into #t_res2_nacpro from #t_res2 t where exists(
select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+''''''
and left(code,2)=t.cnpro)
'' else '''' end+case
				when @nInt_10=@po-4 then ''
update #t_res2_nacpro set cnpro=cnpro+''''''+@cpo+'''''',s_1=0,s_2=0,s_7=0 ,s_3=0,s_8=0, s_4=0,s_9=0, s_5=0,s_12=0, s_6=0,s_13=0
update t set s_10=0,s_14=0 from #t_res2 t where exists(
select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 160, 'delete t from #t_res2 t where exists(select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro) and coalesce(s_2,0)=0 and coalesce(s_7,0)=0 and coalesce(s_3,0)=0 and coalesce(s_8,0)=0 and coalesce(s_4,0)=0 and coalesce(s_9,0)=0 and coalesce(s_5,0)=0 and coalesce(s_12,0)=0 and coalesce(s_6,0)=0 and coalesce(s_13,0)=0
insert #t_res2 select * from #t_res2_nacpro where not(coalesce(s_10,0)=0 and coalesce(s_14,0)=0)''
				when @nInt_10=@po-3 then ''
update #t_res2_nacpro set cnpro=cnpro+''''''+@cpo+'''''',s_1=0,s_2=0,s_7=0 ,s_3=0,s_8=0, s_4=0,s_9=0, s_5=0,s_12=0
update t set s_6=0,s_13=0 ,s_10=0,s_14=0 from #t_res2 t where exists(
select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 161, 'delete t from #t_res2 t where exists(select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro) and coalesce(s_2,0)=0 and coalesce(s_7,0)=0 and coalesce(s_3,0)=0 and coalesce(s_8,0)=0 and coalesce(s_4,0)=0 and coalesce(s_9,0)=0 and coalesce(s_5,0)=0 and coalesce(s_12,0)=0
insert #t_res2 select * from #t_res2_nacpro where not(coalesce(s_6,0)=0 and coalesce(s_13,0)=0 and coalesce(s_10,0)=0 and coalesce(s_14,0)=0)''
				when @nInt_10=@po-2 then ''
update #t_res2_nacpro set cnpro=cnpro+''''''+@cpo+'''''',s_1=0,s_2=0,s_7=0 ,s_3=0,s_8=0, s_4=0,s_9=0
update t set s_5=0,s_12=0, s_6=0,s_13=0 ,s_10=0,s_14=0 from #t_res2 t where exists(
select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 162, 'delete t from #t_res2 t where exists(select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro) and coalesce(s_2,0)=0 and coalesce(s_7,0)=0 and coalesce(s_3,0)=0 and coalesce(s_8,0)=0 and coalesce(s_4,0)=0 and coalesce(s_9,0)=0
insert #t_res2 select * from #t_res2_nacpro where not(coalesce(s_5,0)=0 and coalesce(s_12,0)=0 and coalesce(s_6,0)=0 and coalesce(s_13,0)=0 and coalesce(s_10,0)=0 and coalesce(s_14,0)=0)''
				when @nInt_10=@po-1 then ''
update #t_res2_nacpro set cnpro=cnpro+''''''+@cpo+'''''',s_1=0,s_2=0,s_7=0 ,s_3=0,s_8=0
update t set s_4=0,s_9=0, s_5=0,s_12=0, s_6=0,s_13=0 ,s_10=0,s_14=0 from #t_res2 t where exists(
select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro)
delete t from #t_res2 t where exists(select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro) and coalesce(s_2,0)=0 and coalesce(s_7,0)=0 and coalesce(s_3,0)=0 and coalesce(s_8,0)=0
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 163, 'insert #t_res2 select * from #t_res2_nacpro where not(coalesce(s_4,0)=0 and coalesce(s_9,0)=0 and coalesce(s_5,0)=0 and coalesce(s_12,0)=0 and coalesce(s_6,0)=0 and coalesce(s_13,0)=0 and coalesce(s_10,0)=0 and coalesce(s_14,0)=0)''
				when @nInt_10=@po then ''
update #t_res2_nacpro set cnpro=cnpro+''''''+@cpo+'''''',s_1=0,s_2=0,s_7=0
update t set s_3=0,s_8=0, s_4=0,s_9=0, s_5=0,s_12=0, s_6=0,s_13=0, s_10=0,s_14=0 from #t_res2 t where exists(
select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro)
delete t from #t_res2 t where exists(select * from #t_nacpro where len(code)=4 and right(code,2)=''''''+@cpo+'''''' and left(code,2)=t.cnpro) and coalesce(s_2,0)=0 and coalesce(s_7,0)=0
insert #t_res2 select * from #t_res2_nacpro where not(coalesce(s_3,0)=0 and coalesce(s_8,0)=0 and coalesce(s_4,0)=0 and coalesce(s_9,0)=0 and coalesce(s_5,0)=0 and coalesce(s_12,0)=0 and coalesce(s_6,0)=0 and coalesce(s_13,0)=0 and coalesce(s_10,0)=0 and coalesce(s_14,0)=0)''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 164, '				else '''' end
--print @sql
				exec(@sql)
			end else
				update t set cnpro=cnpro+@cpo from #t_res2 t where exists(
				select * from #t_nacpro where len(code)=4 and right(code,2)=@cpo
				and left(code,2)=t.cnpro)
			fetch next from c_cnprog into @cpo
		end
		close c_cnprog
		deallocate c_cnprog

--      
set @sql=''
--   
select name,code
,case when ''+cast(@nInt_10-1 as varchar)+'' between isnull(year(date_begin),''+cast(@nInt_10-1 as varchar)+'') and isnull(year(date_end),''+cast(@nInt_10-1 as varchar)+'') then '''''''' else ''''X'''' end as _''+cast(@nInt_10-1 as varchar)+''
,case when ''+cast(@nInt_10 as varchar)+'' between isnull(year(date_begin),''+cast(@nInt_10 as varchar)+'') and isnull(year(date_end),''+cast(@nInt_10 as varchar)+'') then '''''''' else ''''X'''' end as _''+cast(@nInt_10 as varchar)+''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 165, ',case when ''+cast(@nInt_10+1 as varchar)+'' between isnull(year(date_begin),''+cast(@nInt_10+1 as varchar)+'') and isnull(year(date_end),''+cast(@nInt_10+1 as varchar)+'') then '''''''' else ''''X'''' end as _''+cast(@nInt_10+1 as varchar)+''
,case when ''+cast(@nInt_10+2 as varchar)+'' between isnull(year(date_begin),''+cast(@nInt_10+2 as varchar)+'') and isnull(year(date_end),''+cast(@nInt_10+2 as varchar)+'') then '''''''' else ''''X'''' end as _''+cast(@nInt_10+2 as varchar)+''
,case when ''+cast(@nInt_10+3 as varchar)+'' between isnull(year(date_begin),''+cast(@nInt_10+3 as varchar)+'') and isnull(year(date_end),''+cast(@nInt_10+3 as varchar)+'') then '''''''' else ''''X'''' end as _''+cast(@nInt_10+3 as varchar)+''
,case when ''+cast(@nInt_10+4 as varchar)+'' between isnull(year(date_begin),''+cast(@nInt_10+4 as varchar)+'') and isnull(year(date_end),''+cast(@nInt_10+4 as varchar)+'') then '''''''' else ''''X'''' end as _''+cast(@nInt_10+4 as varchar)+''
into #t_nacpro_testing
from #t_nacpro
order by code
--   
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 166, 'select cnpro
,isnull(sum(s_1),0)+isnull(sum(s_2),0)+isnull(sum(s_7),0) as _''+cast(@nInt_10-1 as varchar)+''
,isnull(sum(s_3),0)+isnull(sum(s_8),0) as _''+cast(@nInt_10 as varchar)+''
,isnull(sum(s_4),0)+isnull(sum(s_9),0) as _''+cast(@nInt_10+1 as varchar)+''
,isnull(sum(s_5),0)+isnull(sum(s_12),0) as _''+cast(@nInt_10+2 as varchar)+''
,isnull(sum(s_6),0)+isnull(sum(s_13),0) as _''+cast(@nInt_10+3 as varchar)+''
,isnull(sum(s_10),0)+isnull(sum(s_14),0) as _''+cast(@nInt_10+4 as varchar)+''
into #t_res2_testing
from #t_res2 where cnpro is not null
group by cnpro
order by cnpro

--select *--  
update t set cnpro=null,cnpro1=null
from #t_res2 t where exists(select * from #t_nacpro_testing where _''+cast(@nInt_10-1 as varchar)+''=''''X'''' and _''+cast(@nInt_10 as varchar)+''=''''X'''' and _''+cast(@nInt_10+1 as varchar)+''=''''X'''' and _''+cast(@nInt_10+2 as varchar)+''=''''X'''' and _''+cast(@nInt_10+3 as varchar)+''=''''X'''' and _''+cast(@nInt_10+4 as varchar)+''=''''X'''' and code=t.cnpro)

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 167, '--select *--  
delete t
from #t_nacpro t where exists(select * from #t_nacpro_testing where _''+cast(@nInt_10-1 as varchar)+''=''''X'''' and _''+cast(@nInt_10 as varchar)+''=''''X'''' and _''+cast(@nInt_10+1 as varchar)+''=''''X'''' and _''+cast(@nInt_10+2 as varchar)+''=''''X'''' and _''+cast(@nInt_10+3 as varchar)+''=''''X'''' and _''+cast(@nInt_10+4 as varchar)+''=''''X'''' and code=t.code)

--select * from #t_nacpro_testing order by code

--     
select top 0 * into #t_nacpro_sum from #t_res2
if exists(select cnpro,_''+cast(@nInt_10-1 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10-1 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10-1 as varchar)+''=''''X'''')) begin
	select * into #t_nacpro_sum_1 from #t_res2 r where exists(
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 168, '	select cnpro,_''+cast(@nInt_10-1 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10-1 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10-1 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_1,0)<>0 or isnull(s_2,0)<>0 or isnull(s_7,0)<>0
	update r set s_1=0,s_2=0,s_7=0 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10-1 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10-1 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10-1 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_1,0)<>0 or isnull(s_2,0)<>0 or isnull(s_7,0)<>0
	update #t_nacpro_sum_1 set cnpro=null,cnpro1=null, s_3=0,s_8=0, s_4=0,s_9=0, s_5=0,s_12=0, s_6=0,s_13=0, s_10=0,s_14=0
	insert #t_nacpro_sum select * from #t_nacpro_sum_1
end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 169, 'if exists(select cnpro,_''+cast(@nInt_10 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10 as varchar)+''=''''X'''')) begin
	select * into #t_nacpro_sum0 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_3,0)<>0 or isnull(s_8,0)<>0
	update r set s_3=0,s_8=0 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_3,0)<>0 or isnull(s_8,0)<>0
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 170, '	update #t_nacpro_sum0 set cnpro=null,cnpro1=null, s_1=0,s_2=0,s_7=0, s_4=0,s_9=0, s_5=0,s_12=0, s_6=0,s_13=0, s_10=0,s_14=0
	insert #t_nacpro_sum select * from #t_nacpro_sum0
end
if exists(select cnpro,_''+cast(@nInt_10+1 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+1 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+1 as varchar)+''=''''X'''')) begin
	select * into #t_nacpro_sum1 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10+1 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+1 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+1 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_4,0)<>0 or isnull(s_9,0)<>0
	update r set s_4=0,s_9=0 from #t_res2 r where exists(
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 171, '	select cnpro,_''+cast(@nInt_10+1 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+1 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+1 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_4,0)<>0 or isnull(s_9,0)<>0
	update #t_nacpro_sum1 set cnpro=null,cnpro1=null, s_1=0,s_2=0,s_7=0, s_3=0,s_8=0, s_5=0,s_12=0, s_6=0,s_13=0, s_10=0,s_14=0
	insert #t_nacpro_sum select * from #t_nacpro_sum1
end
if exists(select cnpro,_''+cast(@nInt_10+2 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+2 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+2 as varchar)+''=''''X'''')) begin
	select * into #t_nacpro_sum2 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10+2 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+2 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+2 as varchar)+''=''''X'''')
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 172, '	and cnpro=r.cnpro) and isnull(s_5,0)<>0 or isnull(s_12,0)<>0
	update r set s_5=0,s_12=0 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10+2 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+2 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+2 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_5,0)<>0 or isnull(s_12,0)<>0
	update #t_nacpro_sum2 set cnpro=null,cnpro1=null, s_1=0,s_2=0,s_7=0, s_3=0,s_8=0, s_4=0,s_9=0, s_6=0,s_13=0, s_10=0,s_14=0
	insert #t_nacpro_sum select * from #t_nacpro_sum2
end
if exists(select cnpro,_''+cast(@nInt_10+3 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+3 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+3 as varchar)+''=''''X'''')) begin
	select * into #t_nacpro_sum3 from #t_res2 r where exists(
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 173, '	select cnpro,_''+cast(@nInt_10+3 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+3 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+3 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_6,0)<>0 or isnull(s_13,0)<>0
	update r set s_6=0,s_13=0 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10+3 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+3 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+3 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_6,0)<>0 or isnull(s_13,0)<>0
	update #t_nacpro_sum3 set cnpro=null,cnpro1=null, s_1=0,s_2=0,s_7=0, s_3=0,s_8=0, s_4=0,s_9=0, s_5=0,s_12=0, s_10=0,s_14=0
	insert #t_nacpro_sum select * from #t_nacpro_sum3
end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 174, 'if exists(select cnpro,_''+cast(@nInt_10+4 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+4 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+4 as varchar)+''=''''X'''')) begin
	select * into #t_nacpro_sum4 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10+4 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+4 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+4 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_10,0)<>0 or isnull(s_14,0)<>0
	update r set s_10=0,s_14=0 from #t_res2 r where exists(
	select cnpro,_''+cast(@nInt_10+4 as varchar)+'' from #t_res2_testing t where _''+cast(@nInt_10+4 as varchar)+''<>0 and exists(select * from #t_nacpro_testing where code=t.cnpro and _''+cast(@nInt_10+4 as varchar)+''=''''X'''')
	and cnpro=r.cnpro) and isnull(s_10,0)<>0 or isnull(s_14,0)<>0
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 175, '	update #t_nacpro_sum4 set cnpro=null,cnpro1=null, s_1=0,s_2=0,s_7=0, s_3=0,s_8=0, s_4=0,s_9=0, s_5=0,s_12=0, s_6=0,s_13=0
	insert #t_nacpro_sum select * from #t_nacpro_sum4
end

insert #t_res2 select * from #t_nacpro_sum
''
--print @sql
		exec(@sql)

		update t set npro_n=d.name from #t_res2 t
		join #t_nacpro d on d.code=t.cnpro
--		join dbo.s_kbk sk on sk.code=''000''+cnpro+''00000'' and sk.object=@DICTIONARY_TARGET_ITEM
--		join dbo.kbk_name(@dDate_2) d on d.link_up=sk.link

		update t set npro1_n=d.name from #t_res2 t
		join #t_nacpro d on d.code=t.cnpro1
--		join dbo.s_kbk sk on sk.code=''000''+cnpro1+''000000'' and sk.object=@DICTIONARY_TARGET_ITEM
--		join dbo.kbk_name(@dDate_2) d on d.link_up=sk.link

		if @nCheck_19=1
			update t set ctgt=d.code,tgt_n=n.name from #t_res2 t
			join dbo.s_kbk d on d.link=t.tgt
			join dbo.kbk_name(@dDate_2) n on n.link_up=d.link
		else
			update t set ctgt=d.code,tgt_n=n.name from #t_res2 t
			join dbo.s_kbk d on d.link=t.tgt and coalesce(cnpro,'''')=''''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 176, '			join dbo.kbk_name(@dDate_2) n on n.link_up=d.link

		if @nCheck_34=1
			update t set cdiv=d.code,div_n=n.name from #t_res2 t
			join dbo.s_kbk d on d.link=t.div
			join dbo.kbk_name(@dDate_2) n on n.link_up=d.link

	end

	if @nCombo_18 in (4,6)
		insert #stkbk(cpo,po,cdep,cdiv,ctgt,cexp,citm,cdop,clcl,st)
		select cpo,po,cdepc,cdiv,ctgt,cexp,citm,cdop,clcl,st from #t_res2
		group by cpo,po,cdepc,cdiv,ctgt,cexp,citm,cdop,clcl,st
		order by cpo,po,cdepc,cdiv,ctgt,cexp,citm,cdop,clcl,st
	else
		insert #stkbk(cpo,po,cdep,cdiv,ctgt,cexp,citm,cdop,clcl,st)
		select cpo,po,cdep,cdiv,ctgt,cexp,citm,cdop,clcl,st from #t_res2
		group by cpo,po,cdep,cdiv,ctgt,cexp,citm,cdop,clcl,st
		order by cpo,po,cdep,cdiv,ctgt,cexp,citm,cdop,clcl,st

	select @po=null,@st=null
	if @nCombo_18=6 begin
		update t set @st=st=case when coalesce(@po,0)=po then coalesce(@st,0)+1 else coalesce((select top 1 st from #t_bud where po=t.po order by st desc),0)+1 end
		,@po=po from #stkbk t
	
--select * from #t_bud
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 177, '--select * from #stkbk --order by st
--return
	
	end else
		update #stkbk set @st=st=case when coalesce(@po,0)=po then coalesce(@st,0)+1 else 1 end
		,@po=po

	if @nCombo_18 in (4,6)
		update t set st=s.st from #t_res2 t
		join #stkbk s on s.po=t.po and coalesce(s.cdep,'''')=coalesce(t.cdepc,'''') and coalesce(s.cdiv,'''')=coalesce(t.cdiv,'''') and coalesce(s.ctgt,'''')=coalesce(t.ctgt,'''') and coalesce(s.cexp,'''')=coalesce(t.cexp,'''') and coalesce(s.citm,'''')=coalesce(t.citm,'''') and coalesce(s.cdop,'''')=coalesce(t.cdop,'''') and coalesce(s.clcl,'''')=coalesce(t.clcl,'''')
		and t.st is null
	else
		update t set st=s.st from #t_res2 t
		join #stkbk s on s.po=t.po and coalesce(s.cdep,'''')=coalesce(t.cdep,'''') and coalesce(s.cdiv,'''')=coalesce(t.cdiv,'''') and coalesce(s.ctgt,'''')=coalesce(t.ctgt,'''') and coalesce(s.cexp,'''')=coalesce(t.cexp,'''') and coalesce(s.citm,'''')=coalesce(t.citm,'''') and coalesce(s.cdop,'''')=coalesce(t.cdop,'''') and coalesce(s.clcl,'''')=coalesce(t.clcl,'''')
		and t.st is null

/*--30.04.2021
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 178, '	select cast(case when objpo=@DICTIONARY_SODERG_RO then 1 else 2 end as int) as list
	,rtrim(po.number) as cpo
	,rtrim(po.name) as po_n
	,rtrim((select top 1 value from dbo.object_credit where link_up=t.po and coalesce(value,'''')<>'''')) as poc
	,t.po
	,t.st
	,t.dep
	,t.ate
	,max(case when bud=1 then nam end) as nam_1
	,max(case when bud=1 then res end) as res_1
	,max(case when bud=1 then dat end) as dat_1
	,max(case when bud=1 then lev1 end) as lev1
	,max(case when bud=1 then cod end) as cod_1
	,max(case when bud=2 then nam end) as nam_2
	,max(case when bud=2 then res end) as res_2
	,max(case when bud=2 then dat end) as dat_2
	,max(case when bud=2 then lev2 end) as lev2
	,max(case when bud=2 then cod end) as cod_2
	,max(case when bud=3 then nam end) as nam_3
	,max(case when bud=3 then res end) as res_3
	,max(case when bud=3 then dat end) as dat_3
	,max(case when bud=3 then lev3 end) as lev3
	,max(case when bud=3 then cod end) as cod_3
	 into #t_res2_npa
	 from #t_bud t
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 179, '	 join dbo.credit_doc po on po.link=t.po
	 where (coalesce(t.st,1)>1 or not exists(select * from #t_res where po=t.po))
	 and exists(select * from #stkbk where po=t.po and st=t.st)
	 group by po.number,po.name,t.po,t.st,t.objpo,t.po,t.dep,t.ate
	 order by list,po.number,t.st

select * from #t_bud
select * from #t_res2_npa
return

	update t set nam_1=n.nam_1,res_1=n.res_1,dat_1=n.dat_1,lev1=n.lev1
	,nam_2=n.nam_2,res_2=n.res_2,dat_2=n.dat_2,lev2=n.lev2
	,nam_3=n.nam_3,res_3=n.res_3,dat_3=n.dat_3,lev3=n.lev3
	 from #t_res2 t
	join #t_res2_npa n on n.po=t.po and n.st=t.st

	update t set nam_1=null,res_1=null,dat_1=null
	,nam_2=null,res_2=null,dat_2=null
	,nam_3=null,res_3=null,dat_3=null
	 from #t_res2 t
	where not exists(select * from #t_res2_npa n where n.po=t.po and n.st=t.st)
	and st<>1

select * from #t_res2
return
--*/
end else if @nCombo_31=3 begin
	update t set cdep=d.code,cdepc=d.code+''_''+cast(t.dep as varchar) from #t_res2 t
	join dbo.s_kbk d on d.link=t.dep
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 180, '	update t set dep_n=d.name from #t_res2 t
	join dbo.kbk_name(@dDate_2) d on d.link_up=t.dep
end else if @nCombo_31=5 begin
	update t set ctgt=d.code from #t_res2 t
	join dbo.s_kbk d on d.link=t.tgt
	update t set tgt_n=d.name from #t_res2 t
	join dbo.kbk_name(@dDate_2) d on d.link_up=t.tgt
end

--select * from #t_res2
--return

update #t_res2 set st=1 where st is null
--select * from #div
--select * from #t_res2
--select * from #t_res
--select * from #t_bud
--return

if @nCombo_18 in (5,7,8,9,12)
	delete t from #t_bud t where not exists(select * from #t_res where po=t.po)

if @nCombo_31 in (4,6) begin
	update b set corr=oc.corr from #t_bud b join dbo.object_credit oc on oc.link_up=b.cd and oc.corr is not null and oc.object=oc.object_dict
	if @nCombo_31=6
		update b set ecp=p.ecp from #t_bud b join #eds_info_out p on p.link=b.cd and p.ecp is not null
end
--select * from #t_bud
--return

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 181, 'insert #t_res2 (list,cpo,po_n,poc,po,st,dep,cate,ate_n,nam_1,res_1,dat_1,lev1,cod_1,nam_2,res_2,dat_2,lev2,cod_2,nam_3,res_3,dat_3,lev3,cod_3,status,cd,corr,ecp)
select cast(case when objpo=@DICTIONARY_SODERG_RO then 1 else 2 end as int) as list
,rtrim(po.number) as cpo
,left(rtrim(po.name),8000) as po_n
,rtrim((select top 1 value from dbo.object_credit where link_up=t.po and coalesce(value,'''')<>'''' and object=object_dict)) as poc
,t.po
,t.st
,t.dep
,cast((select top 1 inn from dbo.s_corr where link=t.ate) as varchar(254)) as cate
,cast((select top 1 name from dbo.s_corr where link=t.ate) as varchar(8000)) as ate_n
,max(case when bud=1 then nam end) as nam_1
,max(case when bud=1 then res end) as res_1
,max(case when bud=1 then dat end) as dat_1
,lev1
,max(case when bud=1 then cod end) as cod_1
,max(case when bud=2 then nam end) as nam_2
,max(case when bud=2 then res end) as res_2
,max(case when bud=2 then dat end) as dat_2
,lev2
,max(case when bud=2 then cod end) as cod_2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 182, ',max(case when bud=3 then nam end) as nam_3
,max(case when bud=3 then res end) as res_3
,max(case when bud=3 then dat end) as dat_3
,lev3
,max(case when bud=3 then cod end) as cod_3
,t.status,t.cd,t.corr,t.ecp
 from #t_bud t
 join dbo.credit_doc po on po.link=t.po
 group by po.number,po.name,t.po,t.st,t.objpo,t.po,lev1,lev2,lev3,t.dep,t.ate,t.status,t.cd,t.corr,t.ecp
 order by list,po.number,t.st,lev1,lev2,lev3

if @nCombo_18=6 begin
	select distinct dep,cdep,dep_n into #dep_name from #t_res2 where cdep is not null
	update t set cdep=n.cdep,dep_n=n.dep_n,cdepc=n.cdep+''_''+cast(t.dep as varchar) from #t_res2 t
	join #dep_name n on n.dep=t.dep
	where t.cdep is null and t.dep is not null
end

if @nCheck_17=1 and @nOtborLink11>0 and @nCombo_18 not in (5,7,8,9,12) begin

	set @tsql=''
	insert #t_res2 (list,cpo,po_n,poc,po,st,status)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 183, '	select case when cd.object=@DICTIONARY_SODERG_RO_MO then 2 else 1 end,cd.number,left(cd.name,8000),coalesce((select top 1 value from dbo.object_credit where link_up=cd.link and coalesce(value,'''''''')<>''''''''),''''''''),cd.link,1
	,(select top 1 orders from dbo.object_credit where link_up=cd.link and object=cd.object and object_dict=cd.object)
	from dbo.credit_doc cd
	where cd.object in (@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO)
	and not exists(select * from #t_res2 where po=cd.link)
	and ''+case when exists(select * from #t_inv_otbors where link = @nOtborLink11) then ''not '' else '''' end+''exists(select * from dbo.object_var_records ovr where cd.link=ovr.record and ovr.link_up=@nOtborLink11)
	''
--print @tsql
	execute sp_executesql @tsql, N''		@nOtborLink11 int,@DICTIONARY_SODERG_RO int,@DICTIONARY_SODERG_RO_MO int''
	,@nOtborLink11,@DICTIONARY_SODERG_RO,@DICTIONARY_SODERG_RO_MO
--return

end

update #t_res2 set pon=poc
where poc is not null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 184, 'update #t_res2 set pon=case when substring(cpo,2,1)=''.'' then cpo else left(cpo,1)+''.''+substring(cpo,2,100) end+case when right(cpo,1)=''.'' then '''' else ''.'' end
where poc is null

update #t_res2 set po_n=left(poc+'' ''+po_n,8000) where coalesce(poc,'''')<>'''' and @nCombo_18 not in (10,11)
update #t_res2 set poc=cpo,cpo='''' where coalesce(poc,'''')=''''
update #t_res2 set poc=cpo where coalesce(cpo,'''')<>''''

update #t_res2 set k_1=coalesce(s_1,0)-coalesce(k_1,0)
,k_2=coalesce(s_2,0)-coalesce(k_2,0)
,k_3=coalesce(s_3,0)-coalesce(k_3,0)
,k_4=coalesce(s_4,0)-coalesce(k_4,0)
,k_5=coalesce(s_5,0)-coalesce(k_5,0)
,k_6=coalesce(s_6,0)-coalesce(k_6,0)
,k_7=coalesce(s_7,0)-coalesce(k_7,0)
,k_8=coalesce(s_8,0)-coalesce(k_8,0)
,k_9=coalesce(s_9,0)-coalesce(k_9,0)

if not (@nCheck_11=1 and (@div1000 in (3,5,7) or @digts in (0,1)))
	exec dbo.div1000 @cSrcTable=''#t_res2'', @nVariantMode=1

update #t_res2 set po5=po,po4=po,po3=po,po2=po,po1=po
	
update t set po5=cd.link_class,cpo=cd.number
from #t_res2 t
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 185, 'join dbo.credit_doc cd on cd.link=t.po and cd.link_class is not null

update t set po4=t.po5,cpo4=cd.number
,po5=cd.link_class
from #t_res2 t
join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

update t set po3=t.po4,cpo3=t.cpo4
,po4=t.po5,cpo4=cd.number
,po5=cd.link_class
from #t_res2 t
join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

update t set po2=t.po3,cpo2=t.cpo3
,po3=t.po4,cpo3=t.cpo4
,po4=t.po5,cpo4=cd.number
,po5=cd.link_class
from #t_res2 t
join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

update t set po1=t.po2,cpo1=t.cpo2
,po2=t.po3,cpo2=t.cpo3
,po3=t.po4,cpo3=t.cpo4
,po4=t.po5,cpo4=cd.number
,po5=cd.link_class
from #t_res2 t
join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

update #t_res2 set vnut=1
--if @nOtborLink24=0 begin
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 186, '	update #t_res2 set vnut=0 where cpo in (''1204'',''2100'',''2604'',''3500'',''3804'',''4700'',''5204'',''6100'',''6804'',''7700'',''8304'',''9200'',''9504'',''10400'',''10704'',''11600'') and list=2
	update #t_res2 set vnut=0 where cpo1 in (''1204'',''2100'',''2604'',''3500'',''3804'',''4700'',''5204'',''6100'',''6804'',''7700'',''8304'',''9200'',''9504'',''10400'',''10704'',''11600'') and list=2
	update #t_res2 set vnut=0 where cpo2 in (''1204'',''2100'',''2604'',''3500'',''3804'',''4700'',''5204'',''6100'',''6804'',''7700'',''8304'',''9200'',''9504'',''10400'',''10704'',''11600'') and list=2
	update #t_res2 set vnut=0 where cpo3 in (''1204'',''2100'',''2604'',''3500'',''3804'',''4700'',''5204'',''6100'',''6804'',''7700'',''8304'',''9200'',''9504'',''10400'',''10704'',''11600'') and list=2
	update #t_res2 set vnut=0 where cpo4 in (''1204'',''2100'',''2604'',''3500'',''3804'',''4700'',''5204'',''6100'',''6804'',''7700'',''8304'',''9200'',''9504'',''10400'',''10704'',''11600'') and list=2
--end else begin
--	update t set vnut=0 from #t_res2 t join dbo.object_var_records ovr on ovr.record=t.po and ovr.link_up=@nOtborLink24
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 187, '--	update t set vnut=0 from #t_res2 t join dbo.object_var_records ovr on ovr.record=t.po1 and ovr.link_up=@nOtborLink24
--	update t set vnut=0 from #t_res2 t join dbo.object_var_records ovr on ovr.record=t.po2 and ovr.link_up=@nOtborLink24
--	update t set vnut=0 from #t_res2 t join dbo.object_var_records ovr on ovr.record=t.po3 and ovr.link_up=@nOtborLink24
--	update t set vnut=0 from #t_res2 t join dbo.object_var_records ovr on ovr.record=t.po4 and ovr.link_up=@nOtborLink24
--end

if @nCombo_18 in (5,7,8) begin

	update t set po=oc.link_up
	,cpo=cd.number
	,poc=cd.number
	,objpo=oc.object,pon=(select top 1 value from object_credit where link_up=oc.link_up and object=oc.object and object_dict=oc.object)
	,po_n=left(cd.name,8000)
	from #t_res2 t
	join (dbo.object_credit oc join dbo.credit_doc cd on cd.link=oc.link_up) on oc.credit=t.po and oc.object=@DICTIONARY_RRO_CONSOLIDATED_MO and oc.object_dict=@DICTIONARY_SODERG_RO_MO

	delete t from #t_res2 t where objpo=@DICTIONARY_SODERG_RO_MO
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 188, '
	if @nCombo_18=5 begin
		delete t from #t_res2 t where objpo=@DICTIONARY_SODERG_RO
		update #t_res2 set po_n=left(pon+'' ''+po_n,8000) where coalesce(poc,'''')<>''''
	end

end

if @nCombo_18 in (1,2,4,6,5,6,7,8,9,10,11,12) begin

	update #t_res2 set po5=po,po4=po,po3=po,po2=po,po1=po,lev=coalesce(lev,0)
	update t set po5=cd.link_class
	from #t_res2 t
	join dbo.credit_doc cd on cd.link=t.po and cd.link_class is not null

	update t set po4=po5
	,po5=cd.link_class
	from #t_res2 t
	join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

	update t set po3=po4
	,po4=po5
	,po5=cd.link_class
	from #t_res2 t
	join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

	update t set po2=po3
	,po3=po4
	,po4=po5
	,po5=cd.link_class
	from #t_res2 t
	join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

	update t set po1=po2
	,po2=po3
	,po3=po4
	,po4=po5
	,po5=cd.link_class
	from #t_res2 t
	join dbo.credit_doc cd on cd.link=t.po5 and cd.link_class is not null

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 189, '	update t set po1_n=left(rtrim(po.name),8000),cpo1=rtrim(po.number)
	,po1c=rtrim((select top 1 value from dbo.object_credit where link_up=t.po1 and coalesce(value,'''')<>''''))
	 from #t_res2 t
	 join dbo.credit_doc po on po.link=t.po1
	update #t_res2 set po1_n=left(po1c+'' ''+po1_n,8000) where coalesce(po1c,'''')<>'''' and @nCombo_18 not in (10,11)
	update t set cpo1='''',po1c=(select min(poc) from #t_res2 where po1=t.po1) from #t_res2 t where coalesce(po1c,'''')=''''
	update #t_res2 set po1c=cpo1 where coalesce(cpo1,'''')<>''''

	update t set po2_n=left(rtrim(po.name),8000),cpo2=rtrim(po.number)
	,po2c=rtrim((select top 1 value from dbo.object_credit where link_up=t.po2 and coalesce(value,'''')<>''''))
	 from #t_res2 t
	 join dbo.credit_doc po on po.link=t.po2
	update #t_res2 set po2_n=left(po2c+'' ''+po2_n,8000) where coalesce(po2c,'''')<>'''' and @nCombo_18 not in (10,11)
	update t set cpo2='''',po2c=(select min(po1c) from #t_res2 where po2=t.po2) from #t_res2 t where coalesce(po2c,'''')=''''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 190, '	update #t_res2 set po2c=cpo2 where coalesce(cpo2,'''')<>''''

	update t set po3_n=left(rtrim(po.name),8000),cpo3=rtrim(po.number)
	,po3c=rtrim((select top 1 value from dbo.object_credit where link_up=t.po3 and coalesce(value,'''')<>''''))
	 from #t_res2 t
	 join dbo.credit_doc po on po.link=t.po3
	update #t_res2 set po3_n=left(po3c+'' ''+po3_n,8000) where coalesce(po3c,'''')<>'''' and @nCombo_18 not in (10,11)
	update t set cpo3='''',po3c=(select min(po2c) from #t_res2 where po3=t.po3) from #t_res2 t where coalesce(po3c,'''')=''''
	update #t_res2 set po3c=cpo3 where coalesce(cpo3,'''')<>''''

	update t set po4_n=left(rtrim(po.name),8000),cpo4=rtrim(po.number)
	,po4c=rtrim((select top 1 value from dbo.object_credit where link_up=t.po4 and coalesce(value,'''')<>''''))
	 from #t_res2 t
	 join dbo.credit_doc po on po.link=t.po4
	update #t_res2 set po4_n=left(po4c+'' ''+po4_n,8000) where coalesce(po4c,'''')<>'''' and @nCombo_18 not in (10,11)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 191, '	update t set cpo4='''',po4c=(select min(po3c) from #t_res2 where po4=t.po4) from #t_res2 t where coalesce(po4c,'''')=''''
	update #t_res2 set po4c=cpo4 where coalesce(cpo4,'''')<>''''

	update t set po5_n=left(rtrim(po.name),8000),cpo5=rtrim(po.number)
	,po5c=rtrim((select top 1 value from dbo.object_credit where link_up=t.po5 and coalesce(value,'''')<>''''))
	 from #t_res2 t
	 join dbo.credit_doc po on po.link=t.po5
	update #t_res2 set po5_n=left(po5c+'' ''+po5_n,8000) where coalesce(po5c,'''')<>'''' and @nCombo_18 not in (10,11)
	update t set cpo5='''',po5c=(select min(po4c) from #t_res2 where po5=t.po5) from #t_res2 t where coalesce(po5c,'''')=''''
	update #t_res2 set po5c=cpo5 where coalesce(cpo5,'''')<>''''

	if @nCombo_18 not in (10,11) begin
		update #t_res2 set po1c=po1c+''1'' where coalesce(cpo1,'''')=''''
		update #t_res2 set po2c=po2c+''1'' where coalesce(cpo2,'''')=''''
		update #t_res2 set po3c=po5c+''1'' where coalesce(cpo3,'''')=''''
		update #t_res2 set po4c=po4c+''1'' where coalesce(cpo4,'''')=''''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 192, '		update #t_res2 set po5c=po5c+''1'' where coalesce(cpo5,'''')=''''
	end

end

update t set pog_n=rtrim(cd.name),cpog=rtrim(cd.number)
 from #t_res2 t
 join (dbo.object_credit oc join dbo.credit_doc cd on cd.link=oc.credit and cd.object=@DICTIONARY_AUTHORITY_GROUP) on oc.link_up=t.po

if @nCheck_24=1 begin

	select @list=null,@cpo=null,@cpog=null
	update #t_res2 set npog=case when isnumeric(cpog)=1 then cast(cpog as int) else 99999 end
	select list,cpo5,npog,cpog,cpo5g into #po5g from #t_res2 where cpog is not null group by list,cpo5,npog,cpog,cpo5g order by list,cpo5,npog,cpog,cpo5g
	update #po5g set @cpog=cpo5g=case when coalesce(@list,0)=list and coalesce(@cpo,0)=cpo5 then coalesce(@cpog,'''')+'', '' else '''' end+cpog,@list=list,@cpo=cpo5
	update t set cpo5g=coalesce((select top 1 cpo5g from #po5g where list=t.list and cpo5=t.cpo5 order by len(cpo5g) desc),'''') from #t_res2 t

	select @list=null,@cpo=null,@cpog=null
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 193, '	update #t_res2 set npog=case when isnumeric(cpog)=1 then cast(cpog as int) else 99999 end
	select list,cpo4,npog,cpog,cpo4g into #po4g from #t_res2 where cpog is not null group by list,cpo4,npog,cpog,cpo4g order by list,cpo4,npog,cpog,cpo4g
	update #po4g set @cpog=cpo4g=case when coalesce(@list,0)=list and coalesce(@cpo,0)=cpo4 then coalesce(@cpog,'''')+'', '' else '''' end+cpog,@list=list,@cpo=cpo4
	update t set cpo4g=coalesce((select top 1 cpo4g from #po4g where list=t.list and cpo4=t.cpo4 order by len(cpo4g) desc),'''') from #t_res2 t

	select @list=null,@cpo=null,@cpog=null
	update #t_res2 set npog=case when isnumeric(cpog)=1 then cast(cpog as int) else 99999 end
	select list,cpo3,npog,cpog,cpo3g into #po3g from #t_res2 where cpog is not null group by list,cpo3,npog,cpog,cpo3g order by list,cpo3,npog,cpog,cpo3g
	update #po3g set @cpog=cpo3g=case when coalesce(@list,0)=list and coalesce(@cpo,0)=cpo3 then coalesce(@cpog,'''')+'', '' else '''' end+cpog,@list=list,@cpo=cpo3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 194, '	update t set cpo3g=coalesce((select top 1 cpo3g from #po3g where list=t.list and cpo3=t.cpo3 order by len(cpo3g) desc),'''') from #t_res2 t

	select @list=null,@cpo=null,@cpog=null
	update #t_res2 set npog=case when isnumeric(cpog)=1 then cast(cpog as int) else 99999 end
	select list,cpo2,npog,cpog,cpo2g into #po2g from #t_res2 where cpog is not null group by list,cpo2,npog,cpog,cpo2g order by list,cpo2,npog,cpog,cpo2g
	update #po2g set @cpog=cpo2g=case when coalesce(@list,0)=list and coalesce(@cpo,0)=cpo2 then coalesce(@cpog,'''')+'', '' else '''' end+cpog,@list=list,@cpo=cpo2
	update t set cpo2g=coalesce((select top 1 cpo2g from #po2g where list=t.list and cpo2=t.cpo2 order by len(cpo2g) desc),'''') from #t_res2 t

	select @list=null,@cpo=null,@cpog=null
	update #t_res2 set npog=case when isnumeric(cpog)=1 then cast(cpog as int) else 99999 end
	select list,cpo1,npog,cpog,cpo1g into #po1g from #t_res2 where cpog is not null group by list,cpo1,npog,cpog,cpo1g order by list,cpo1,npog,cpog,cpo1g
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 195, '	update #po1g set @cpog=cpo1g=case when coalesce(@list,0)=list and coalesce(@cpo,0)=cpo1 then coalesce(@cpog,'''')+'', '' else '''' end+cpog,@list=list,@cpo=cpo1
	update t set cpo1g=coalesce((select top 1 cpo1g from #po1g where list=t.list and cpo1=t.cpo1 order by len(cpo1g) desc),'''') from #t_res2 t

end

if @nCombo_18 in (7,8,12) begin

	declare @cnpro varchar(100)
	,@cpog2 varchar(8000)
	,@pon varchar(8000)
	,@poc varchar(8000)
	
--	set @cpog=null
	select list,cnpro,cpog
	,cast(pon as varchar(8000)) as pon
	,cast(cpo as varchar(8000)) as cpo
	,cast(null as varchar(254)) as ctgt
	into #cnprog from #t_res2 where /*isnumeric(cpog)=1 and */cnpro is not null and vnut=1 and su in (6,7,8,9,10,11,12,13,14,15,16,17)
	group by list,cnpro,cpog,pon,cpo

	insert #cnprog (list,cpog,pon,cpo,ctgt)
	select list,cpog,pon,cpo,ctgt from #t_res2 where cnpro is null and vnut=1 and su in (6,7,8,9,10,11,12,13,14,15,16,17)
	group by list,cpog,pon,cpo,ctgt
--select * from #cnprog order by list,cnpro,cpog,pon,cpo
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 196, '--return

	declare c_cnprog cursor local forward_only static read_only for
	select distinct list,cnpro,cpog,ctgt from #cnprog order by cnpro,cpog
	open c_cnprog
	fetch next from c_cnprog into @list,@cnpro,@cpog,@ctgt
	while @@fetch_status = 0 begin

		select @sql=null,@sql2=null

		declare c_pon cursor local forward_only static read_only for
		select distinct pon,cpo from #cnprog where coalesce(@list,0)=coalesce(list,0) and coalesce(@cnpro,'''')=coalesce(cnpro,'''') and coalesce(@cpog,'''')=coalesce(cpog,'''') and coalesce(@ctgt,'''')=coalesce(ctgt,'''') order by cpo
		open c_pon
		fetch next from c_pon into @pon,@poc
		while @@fetch_status = 0 begin
			select @sql=coalesce(@sql+'', '','''')+@pon
			,@sql2=coalesce(@sql2+'', '','''')+@poc
			fetch next from c_pon into @pon,@poc
		end
		close c_pon
		deallocate c_pon

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 197, '		update #cnprog set pon=@sql,cpo=@sql2 where coalesce(@list,0)=coalesce(list,0) and coalesce(@cnpro,'''')=coalesce(cnpro,'''') and coalesce(@cpog,'''')=coalesce(cpog,'''') and coalesce(@ctgt,'''')=coalesce(ctgt,'''')

		fetch next from c_cnprog into @list,@cnpro,@cpog,@ctgt
	end
	close c_cnprog
	deallocate c_cnprog

--select * from #cnprog order by list,cnpro,cpog
--return
	
	select cnpro
	,cast(cpog as varchar(8000)) as cpog
	into #cnpro from #t_res2 t where /*isnumeric(cpog)=1 and */cnpro is not null and vnut=1 and su in (6,7,8,9,10,11,12,13,14,15,16,17)
	group by cnpro,cpog
--	order by cnpro,cast(cpog as int)

	--insert #cnpro (cnpro,cpog)
	--select cnpro,cpog
	--from #t_res2 t where isnumeric(cpog)=0 and cnpro is not null and vnut=1
	--group by cnpro,cpog
	--order by cnpro,cpog

	--select @cnpro=null
	--update #cnpro set @cpog2=cpog=case when cnpro=coalesce(@cnpro,'''') and charindex(''|''+cpog+''|'',''|''+@cpog2+''|'')=0 then coalesce(@cpog2,'''')+''|'' else '''' end+ coalesce(cpog,'''')
	--,@cnpro=cnpro

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 198, '	update #cnpro set cpog=''0''+cpog where isnumeric(cpog)=1 and len(cpog)=1 and cpog<>''-''

--select * from #cnpro --where isnumeric(cpog)=1 and len(cpog)=1 order by cnpro,cpog
--return

	declare c_cnpro cursor local forward_only static read_only for
	select distinct cnpro from #cnpro order by cnpro
	open c_cnpro
	fetch next from c_cnpro into @cnpro
	while @@fetch_status = 0 begin

		select @sql=null,@sql2=null

		declare c_cpog cursor local forward_only static read_only for
		select distinct cpog from #cnpro where coalesce(@cnpro,'''')=coalesce(cnpro,'''') order by cpog
		open c_cpog
		fetch next from c_cpog into @cpog
		while @@fetch_status = 0 begin
			if isnumeric(@cpog)=1 and left(@cpog,1)=''0'' and len(@cpog)=2
				set @cpog=right(@cpog,1)
			set @sql=case when charindex(''|''+coalesce(@cpog,'''')+''|'',''|''+coalesce(@sql,'''')+''|'')=0 then coalesce(@sql+''|'','''')+coalesce(@cpog,'''') else @sql end
			fetch next from c_cpog into @cpog
		end
		close c_cpog
		deallocate c_cpog

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 199, '		update #cnpro set cpog=@sql where coalesce(@cnpro,'''')=coalesce(cnpro,'''')

		fetch next from c_cnpro into @cnpro
	end
	close c_cnpro
	deallocate c_cnpro

--select * from #cnpro order by cnpro,cpog
--return

	select cnpro
	,cast((select top 1 pon from #cnprog where list=t.list and cnpro=t.cnpro and coalesce(cpog,'''')=coalesce(t.cpog,'''') order by len(pon) desc) as varchar(8000)) as pon
	,cast((select top 1 cpo from #cnprog where list=t.list and cnpro=t.cnpro and coalesce(cpog,'''')=coalesce(t.cpog,'''') order by len(cpo) desc) as varchar(8000)) as cpo
	,list
	into #cnpro1 from #t_res2 t where /*isnumeric(cpog)=1 and */cnpro is not null and vnut=1 and su in (6,7,8,9,10,11,12,13,14,15,16,17) and list=1
	group by cnpro,cpog,list
--	order by cnpro,cast(cpog as int)

	declare c_cnpro1 cursor local forward_only static read_only for
	select distinct cnpro from #cnpro1 order by cnpro
	open c_cnpro1
	fetch next from c_cnpro1 into @cnpro
	while @@fetch_status = 0 begin

		select @sql=null,@sql2=null

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 200, '		declare c_pon cursor local forward_only static read_only for
		select distinct pon,cpo from #cnpro1 where coalesce(@cnpro,'''')=coalesce(cnpro,'''') order by cpo
		open c_pon
		fetch next from c_pon into @pon,@poc
		while @@fetch_status = 0 begin
			select @sql=coalesce(@sql+''|'','''')+@pon
			,@sql2=coalesce(@sql2+''|'','''')+@poc
			fetch next from c_pon into @pon,@poc
		end
		close c_pon
		deallocate c_pon

		update #cnpro1 set pon=@sql,cpo=@sql2 where coalesce(@cnpro,'''')=coalesce(cnpro,'''')

		fetch next from c_cnpro1 into @cnpro
	end
	close c_cnpro1
	deallocate c_cnpro1

--select * from #cnpro1
--return

	select cnpro
	,cast((select top 1 pon from #cnprog where list=t.list and cnpro=t.cnpro and coalesce(cpog,'''')=coalesce(t.cpog,'''') order by len(pon) desc) as varchar(8000)) as pon
	,cast((select top 1 cpo from #cnprog where list=t.list and cnpro=t.cnpro and coalesce(cpog,'''')=coalesce(t.cpog,'''') order by len(cpo) desc) as varchar(8000)) as cpo
	,list
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 201, '	into #cnpro2 from #t_res2 t where /*isnumeric(cpog)=1 and */cnpro is not null and vnut=1 and su in (6,7,8,9,10,11,12,13,14,15,16,17) and list=2
	group by cnpro,cpog,list
	order by cnpro,cast(cpog as int)

	declare c_cnpro2 cursor local forward_only static read_only for
	select distinct cnpro from #cnpro2 order by cnpro
	open c_cnpro2
	fetch next from c_cnpro2 into @cnpro
	while @@fetch_status = 0 begin

		select @sql=null,@sql2=null

		declare c_pon cursor local forward_only static read_only for
		select distinct pon,cpo from #cnpro2 where coalesce(@cnpro,'''')=coalesce(cnpro,'''') order by cpo
		open c_pon
		fetch next from c_pon into @pon,@poc
		while @@fetch_status = 0 begin
			select @sql=coalesce(@sql+''|'','''')+@pon
			,@sql2=coalesce(@sql2+''|'','''')+@poc
			fetch next from c_pon into @pon,@poc
		end
		close c_pon
		deallocate c_pon

		update #cnpro2 set pon=@sql,cpo=@sql2 where coalesce(@cnpro,'''')=coalesce(cnpro,'''')

		fetch next from c_cnpro2 into @cnpro
	end
	close c_cnpro2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 202, '	deallocate c_cnpro2

--select * from #cnpro2
--return
	
	insert #cnpro1 (cnpro,pon,cpo,list)
	select cnpro,pon,cpo,list from #cnpro2

end -- @nCombo_18 in (7,8,12)

-- 
update #t_res2 set poc=poc+''.000'' where charindex(''.'',poc)=0 and len(poc)<9 and list=2
update #t_res2 set po1c=po1c+''.000'' where charindex(''.'',po1c)=0 and len(po1c)<9 and list=2
update #t_res2 set po2c=po2c+''.000'' where charindex(''.'',po2c)=0 and len(po2c)<9 and list=2
update #t_res2 set po3c=po3c+''.000'' where charindex(''.'',po3c)=0 and len(po3c)<9 and list=2
update #t_res2 set po4c=po4c+''.000'' where charindex(''.'',po4c)=0 and len(po4c)<9 and list=2
update #t_res2 set po5c=po5c+''.000'' where charindex(''.'',po5c)=0 and len(po5c)<9 and list=2

update #t_res2 set poc=poc+''00'' where charindex(''.'',reverse(poc))=2 and len(poc)<9 and list=2
update #t_res2 set po1c=po1c+''00'' where charindex(''.'',reverse(po1c))=2 and len(po1c)<9 and list=2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 203, 'update #t_res2 set po2c=po2c+''00'' where charindex(''.'',reverse(po2c))=2 and len(po2c)<9 and list=2
update #t_res2 set po3c=po3c+''00'' where charindex(''.'',reverse(po3c))=2 and len(po3c)<9 and list=2
update #t_res2 set po4c=po4c+''00'' where charindex(''.'',reverse(po4c))=2 and len(po4c)<9 and list=2
update #t_res2 set po5c=po5c+''00'' where charindex(''.'',reverse(po5c))=2 and len(po5c)<9 and list=2

update #t_res2 set poc=poc+''0'' where charindex(''.'',reverse(poc))=3 and len(poc)<9 and list=2
update #t_res2 set po1c=po1c+''0'' where charindex(''.'',reverse(po1c))=3 and len(po1c)<9 and list=2
update #t_res2 set po2c=po2c+''0'' where charindex(''.'',reverse(po2c))=3 and len(po2c)<9 and list=2
update #t_res2 set po3c=po3c+''0'' where charindex(''.'',reverse(po3c))=3 and len(po3c)<9 and list=2
update #t_res2 set po4c=po4c+''0'' where charindex(''.'',reverse(po4c))=3 and len(po4c)<9 and list=2
update #t_res2 set po5c=po5c+''0'' where charindex(''.'',reverse(po5c))=3 and len(po5c)<9 and list=2

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 204, 'update #t_res2 set poc=replicate(''0'',9-len(poc))+poc where len(poc)<9 and list=2
update #t_res2 set po1c=replicate(''0'',9-len(po1c))+po1c where len(po1c)<9 and list=2
update #t_res2 set po2c=replicate(''0'',9-len(po2c))+po2c where len(po2c)<9 and list=2
update #t_res2 set po3c=replicate(''0'',9-len(po3c))+po3c where len(po3c)<9 and list=2
update #t_res2 set po4c=replicate(''0'',9-len(po4c))+po4c where len(po4c)<9 and list=2
update #t_res2 set po5c=replicate(''0'',9-len(po5c))+po5c where len(po5c)<9 and list=2

update #t_res2 set poc=''0''+poc where charindex(''.'',poc)=5 and list=2
update #t_res2 set po1c=''0''+po1c where charindex(''.'',po1c)=5 and list=2
update #t_res2 set po2c=''0''+po2c where charindex(''.'',po2c)=5 and list=2
update #t_res2 set po3c=''0''+po3c where charindex(''.'',po3c)=5 and list=2
update #t_res2 set po4c=''0''+po4c where charindex(''.'',po4c)=5 and list=2
update #t_res2 set po5c=''0''+po5c where charindex(''.'',po5c)=5 and list=2
--select distinct poc from #t_res2 order by poc
--return

', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 205, 'declare @sql_begin varchar(1000),@sql_end varchar(1000),@sql_body varchar(1000)
if @nCombo_18 in (8,11) begin
/*     XML */
set @sql_begin = ''#sql_begin:
set dateformat dmy
declare @SRID uniqueidentifier
set @SRID=newid()
execute dbo.sys_values_delete @RID=@SRID
insert into dbo.sys_values (rid,code,[group],orders,[varchar])
select @SRID,''''form_name'''',0,0,''''''+case when @nCombo_18=8 then ''___'' when @nCombo_18=11 then ''___'' else '''' end+''''''
union all select @SRID,''''form_code'''',0,0,''''SQUERY_REESTR_RO_76N,SYS_2458925_5Q00YYQ54''''''
set @sql_end = ''#report_ignore_empty_cell:|#protect_sheet:kristal|#sql_end:
set dateformat mdy
execute dbo.[save] @RID=@SRID,@ObjCode=''''DOCUMENTS_RRO_XML_EIAS_MFRF'''',@isSlimClient=0
execute dbo.sys_values_delete @RID=@SRID''
set @sql_body = ''#sql_body:
insert into dbo.sys_values (rid,code,[group],orders,[varchar])
select @SRID,''''<code>'''',#this_row,#this_col,ltrim(rtrim(''''#this_text''''))''
end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 206, '/*  */

select *
,identity(int,1,1) as ord
into #t_res3
from #t_res2
order by list,cpo,st,lev1,lev2,lev3

if @nCombo_18=3 begin

select @tsql = coalesce((select ''insert '' + @cTableInto + '' '' where len(@cTableInto)>0),'''') + ''
select s.list,s.cpo,s.po_n,s.poc
,s.cpo1,s.po1_n,s.po1c
,s.cpo2,s.po2_n,s.po2c
,s.cpo3,s.po3_n,s.po3c
,s.cpo4,s.po4_n,s.po4c
,s.cpo5,s.po5_n,s.po5c
,s.cpog,s.pog_n,s.vnut as npog
,coalesce(s.cpo1g,'''''''') as cpo1g
,coalesce(s.cpo2g,'''''''') as cpo2g
,coalesce(s.cpo3g,'''''''') as cpo3g
,coalesce(s.cpo4g,'''''''') as cpo4g
,coalesce(s.cpo5g,'''''''') as cpo5g
,1 as st,case when s.lev=0 then 0 else 1 end as lev
,s.cdep,s.cdepc,s.craz,s.cdiv,s.cdiv1,s.cdiv2,s.ctgt,s.cexp,s.citm,s.cdop,s.clcl
,s.dep_n,s.div_n,s.tgt_n,s.exp_n,s.itm_n,s.dop_n,s.lcl_n
,round(sum(s.s_1),''+cast(@digts as varchar)+'') as s_1
,round(sum(s.s_2),''+cast(@digts as varchar)+'') as s_2
,round(sum(s.s_3),''+cast(@digts as varchar)+'') as s_3
,round(sum(s.s_4),''+cast(@digts as varchar)+'') as s_4
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 207, ',round(sum(s.s_5),''+cast(@digts as varchar)+'') as s_5
,round(sum(s.s_6),''+cast(@digts as varchar)+'') as s_6
,round(sum(s.s_7),''+cast(@digts as varchar)+'') as s_7
,round(sum(s.s_8),''+cast(@digts as varchar)+'') as s_8
,round(sum(s.s_9),''+cast(@digts as varchar)+'') as s_9
,round(sum(s.k_1),''+cast(@digts as varchar)+'') as k_1
,round(sum(s.k_2),''+cast(@digts as varchar)+'') as k_2
,round(sum(s.k_3),''+cast(@digts as varchar)+'') as k_3
,round(sum(s.k_4),''+cast(@digts as varchar)+'') as k_4
,round(sum(s.k_5),''+cast(@digts as varchar)+'') as k_5
,round(sum(s.k_6),''+cast(@digts as varchar)+'') as k_6
,round(sum(s.k_7),''+cast(@digts as varchar)+'') as k_7
,round(sum(s.k_8),''+cast(@digts as varchar)+'') as k_8
,round(sum(s.k_9),''+cast(@digts as varchar)+'') as k_9
,n.nam_1,n.res_1,n.dat_1,n.lev1,n.cod_1,n.nam_2,n.res_2,n.dat_2,n.lev2,n.cod_2,n.nam_3,n.res_3,n.dat_3,n.lev3,n.cod_3
,s.metod,0 as st1,s.su
''+case when @nCombo_31=2 then '',s.cate,s.ate_n''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 208, '	when @nCombo_31=3 then '',s.cdep as cate,s.dep_n as ate_n''
	when @nCombo_31=4 then '',(select top 1 code from dbo.s_corr where link=s.corr) as cate,(select top 1 name from dbo.s_corr where link=s.corr) as ate_n''
	when @nCombo_31=6 then '',(select top 1 code from dbo.s_corr where link=s.corr) as cate,(select top 1 name from dbo.s_corr where link=s.corr) as ate_n,s.ecp''
	when @nCombo_31=5 then '',s.ctgt as cate,s.tgt_n as ate_n''
	else '''' end+''
,s.status,s.ord
from #t_res3 s,#t_res3 n
where s.list=n.list and s.cpo=n.cpo and s.po_n=n.po_n and s.poc=n.poc and s.po=n.po and s.lev is not null and n.lev is null
and n.cod_1 is not null and s.cd=n.cd
group by s.list,s.cpo,s.po_n,s.poc
,s.cpo1,s.po1_n,s.po1c
,s.cpo2,s.po2_n,s.po2c
,s.cpo3,s.po3_n,s.po3c
,s.cpo4,s.po4_n,s.po4c
,s.cpo5,s.po5_n,s.po5c
,s.cpog,s.pog_n,s.vnut,s.cpo1g,s.cpo2g,s.cpo3g,s.cpo4g,s.cpo5g
,case when s.lev=0 then 0 else 1 end
,s.cdep,s.cdepc,s.craz,s.cdiv,s.cdiv1,s.cdiv2,s.ctgt,s.cexp,s.citm,s.cdop,s.clcl
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 209, ',s.dep_n,s.div_n,s.tgt_n,s.exp_n,s.itm_n,s.dop_n,s.lcl_n
,n.nam_1,n.res_1,n.dat_1,n.lev1,n.cod_1,n.nam_2,n.res_2,n.dat_2,n.lev2,n.cod_2,n.nam_3,n.res_3,n.dat_3,n.lev3,n.cod_3
,s.metod,s.su''
+case when @nCombo_31=2 then '',s.cate,s.ate_n''
	when @nCombo_31=3 then '',s.cdep,s.dep_n''
	when @nCombo_31=4 then '',s.corr''
	when @nCombo_31=6 then '',s.corr,s.ecp''
	when @nCombo_31=5 then '',s.ctgt,s.tgt_n''
	else '''' end
+'',s.status,s.ord''

--print @tsql
execute sp_executesql @tsql

end else

if @nCombo_18=9 begin

if exists(select * from #t_res) begin
	set @cwhere2=null
	select distinct su,cast(null as varchar(8000)) as cwhere2 into #su from #t_res
	update #su set @cwhere2=coalesce(@cwhere2,'''')+''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'' and su=''+cast(su as varchar)+'') as s_''+cast(@nInt_10 as varchar)+''_1_''+cast(su as varchar)+''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 210, ',(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'' and su=''+cast(su as varchar)+'') as k_''+cast(@nInt_10 as varchar)+''_1_''+cast(su as varchar)
end else set @cwhere2=''''

select @sql = coalesce((select ''
insert '' + @cTableInto + '' '' where len(@cTableInto)>0),'''') + ''
select s.list,s.cpo,s.po_n,s.poc
,s.cpo1,s.po1_n,s.po1c
,s.cpo2,s.po2_n,s.po2c
,s.cpo3,s.po3_n,s.po3c
,s.cpo4,s.po4_n,s.po4c
,s.cpo5,s.po5_n,s.po5c
,s.cpog,s.pog_n,s.vnut as npog
,coalesce(s.cpo1g,'''''''') as cpo1g
,coalesce(s.cpo2g,'''''''') as cpo2g
,coalesce(s.cpo3g,'''''''') as cpo3g
,coalesce(s.cpo4g,'''''''') as cpo4g
,coalesce(s.cpo5g,'''''''') as cpo5g
,1 as st,case when s.lev=0 then 0 else 1 end as lev
,s.metod,0 as st1,s.cdiv
''+case when @nCombo_31=2 then '',s.cate,s.ate_n''
	when @nCombo_31=3 then '',s.cdep as cate,s.dep_n as ate_n''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 211, '	when @nCombo_31=4 then '',(select top 1 code from dbo.s_corr where link=s.corr) as cate,(select top 1 name from dbo.s_corr where link=s.corr) as ate_n''
	when @nCombo_31=6 then '',(select top 1 code from dbo.s_corr where link=s.corr) as cate,(select top 1 name from dbo.s_corr where link=s.corr) as ate_n,s.ecp''
	when @nCombo_31=5 then '',s.ctgt as cate,s.tgt_n as ate_n''
	else '''' end+''
,s.status''
+case when @COLUMN_REESTR_RO_SUMMA_F+@COLUMN_REESTR_SDR_SUMMA_F=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-1 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-1 as varchar)+''_2
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-1 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-1 as varchar)+''_2'' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 212, '+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-1 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@ACTUAL_SUM_REESTR_RO as varchar)),''_1_'',''_2_'')
+case when @COLUMN_REESTR_RO_SUMMA_F_1+@COLUMN_REESTR_SDR_SUMMA_F_1=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-2 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-2 as varchar)+''_2
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-2 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-2 as varchar)+''_2'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-2 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@ACTUAL_SUM_REESTR_RO as varchar)),''_1_'',''_2_'')
+case when @COLUMN_REESTR_RO_SUMMA_F_2+@COLUMN_REESTR_SDR_SUMMA_F_2=2 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 213, ',(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-3 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-3 as varchar)+''_2
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-3 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-3 as varchar)+''_2'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-3 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@ACTUAL_SUM_REESTR_RO as varchar)),''_1_'',''_2_'')
+case when @COLUMN_REESTR_RO_SUMMA_F_3+@COLUMN_REESTR_SDR_SUMMA_F_3=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-4 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-4 as varchar)+''_2
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 214, ',(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-4 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-4 as varchar)+''_2'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-4 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@ACTUAL_SUM_REESTR_RO as varchar)),''_1_'',''_2_'')
+case when @COLUMN_REESTR_RO_SUMMA_F_4+@COLUMN_REESTR_SDR_SUMMA_F_4=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-5 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-5 as varchar)+''_2
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-5 as varchar)+'' and obj=''+cast(@ACTUAL_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-5 as varchar)+''_2'' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 215, '+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-5 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@ACTUAL_SUM_REESTR_RO as varchar)),''_1_'',''_2_'')
+case when @COLUMN_REESTR_RO_SUMMA_P+@COLUMN_REESTR_SDR_SUMMA_P=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-1 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-1 as varchar)+''_1
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-1 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-1 as varchar)+''_1'' end
+replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-1 as varchar))
+case when @COLUMN_REESTR_RO_SUMMA_P0+@COLUMN_REESTR_SDR_SUMMA_P0=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10 as varchar)+''_1
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 216, ',(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10 as varchar)+''_1'' end
+@cwhere2
+case when @COLUMN_REESTR_RO_SUMMA_P1+@COLUMN_REESTR_SDR_SUMMA_P1=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+1 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+1 as varchar)+''_1
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+1 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+1 as varchar)+''_1'' end
+replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+1 as varchar))
+case when @COLUMN_REESTR_RO_SUMMA_P2+@COLUMN_REESTR_SDR_SUMMA_P2=2 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 217, ',(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+2 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+2 as varchar)+''_1
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+2 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+2 as varchar)+''_1'' end
+replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+2 as varchar))
+case when @COLUMN_REESTR_RO_SUMMA_P3+@COLUMN_REESTR_SDR_SUMMA_P3=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+3 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+3 as varchar)+''_1
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+3 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+3 as varchar)+''_1'' end
+replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+3 as varchar))
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 218, '+case when @COLUMN_REESTR_RO_SUMMA_P4+@COLUMN_REESTR_SDR_SUMMA_P4=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+4 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+4 as varchar)+''_1
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+4 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+4 as varchar)+''_1'' end
+replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+4 as varchar))
+case when @COLUMN_REESTR_RO_SUMMA_P5+@COLUMN_REESTR_SDR_SUMMA_P5=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+5 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+5 as varchar)+''_1
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+5 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+5 as varchar)+''_1'' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 219, '+replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+5 as varchar))
+case when @COLUMN_REESTR_RO_SUMMA_P_1+@COLUMN_REESTR_SDR_SUMMA_P_1=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-2 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-2 as varchar)+''_1
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-2 as varchar)+'' and obj=''+cast(@PLAN_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-2 as varchar)+''_1'' end
+replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-2 as varchar))
+case when @COLUMN_REESTR_RO_SUMMA_G+@COLUMN_REESTR_SDR_SUMMA_G=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-1 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-1 as varchar)+''_3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 220, ',(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-1 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-1 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-1 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G1+@COLUMN_REESTR_SDR_SUMMA_G1=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10 as varchar)+''_3'' end
+replace(replace(@cwhere2,cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 221, '+case when @COLUMN_REESTR_RO_SUMMA_G2+@COLUMN_REESTR_SDR_SUMMA_G2=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+1 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+1 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+1 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+1 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+1 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G3+@COLUMN_REESTR_SDR_SUMMA_G3=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+2 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+2 as varchar)+''_3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 222, ',(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+2 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+2 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+2 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G4+@COLUMN_REESTR_SDR_SUMMA_G4=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+3 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+3 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+3 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+3 as varchar)+''_3'' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 223, '+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+3 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G5+@COLUMN_REESTR_SDR_SUMMA_G5=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+4 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+4 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+4 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+4 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+4 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G6+@COLUMN_REESTR_SDR_SUMMA_G6=2 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 224, ',(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+5 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10+5 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10+5 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10+5 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10+5 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G_1+@COLUMN_REESTR_SDR_SUMMA_G_1=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-2 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-2 as varchar)+''_3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 225, ',(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-2 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-2 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-2 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G_2+@COLUMN_REESTR_SDR_SUMMA_G_2=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-3 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-3 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-3 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-3 as varchar)+''_3'' end
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 226, '+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-3 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G_3+@COLUMN_REESTR_SDR_SUMMA_G_3=2 then '''' else ''
,(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-4 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-4 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-4 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-4 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-4 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+case when @COLUMN_REESTR_RO_SUMMA_G_4+@COLUMN_REESTR_SDR_SUMMA_G_4=2 then '''' else ''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 227, ',(select sum(s) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-5 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as s_''+cast(@nInt_10-5 as varchar)+''_3
,(select sum(k) from #t_res where list=s.list and po=s.po and god=''+cast(@nInt_10-5 as varchar)+'' and obj=''+cast(@GRADE_SUM_REESTR_RO as varchar)+'') as k_''+cast(@nInt_10-5 as varchar)+''_3'' end
+replace(replace(replace(@cwhere2,cast(@nInt_10 as varchar),cast(@nInt_10-5 as varchar)),cast(@PLAN_SUM_REESTR_RO as varchar),cast(@GRADE_SUM_REESTR_RO as varchar)),''_1_'',''_3_'')
+''
from #t_res3 s
group by s.list,s.cpo,s.po_n,s.poc
,s.cpo1,s.po1_n,s.po1c
,s.cpo2,s.po2_n,s.po2c
,s.cpo3,s.po3_n,s.po3c
,s.cpo4,s.po4_n,s.po4c
,s.cpo5,s.po5_n,s.po5c
,s.cpog,s.pog_n,s.vnut,s.cpo1g,s.cpo2g,s.cpo3g,s.cpo4g,s.cpo5g
,s.lev,s.metod''
+case when @nCombo_31=2 then '',s.cate,s.ate_n''
	when @nCombo_31=3 then '',s.cdep,s.dep_n''
	when @nCombo_31=4 then '',s.corr''
	when @nCombo_31=6 then '',s.corr,s.ecp''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 228, '	when @nCombo_31=5 then '',s.ctgt,s.tgt_n''
	else '''' end
+'',s.status,s.po,s.cdiv''

--select @sql,@cwhere2
exec(@sql)

end else begin

select @tsql = coalesce((select ''insert '' + @cTableInto + '' '' where len(@cTableInto)>0),'''') + ''
select '' + case when @nCombo_18 in (8,11) then ''@sql_begin as sql_begin,@sql_end as sql_end,@sql_body as sql_body,'' else '''' end + ''
list,cpo,po_n,poc
,cpo1,po1_n,po1c
,cpo2,po2_n,po2c
,cpo3,po3_n,po3c
,cpo4,po4_n,po4c
,cpo5,po5_n,po5c
,cpog,pog_n,vnut as npog
,coalesce(cpo1g,'''''''') as cpo1g
,coalesce(cpo2g,'''''''') as cpo2g
,coalesce(cpo3g,'''''''') as cpo3g
,coalesce(cpo4g,'''''''') as cpo4g
,coalesce(cpo5g,'''''''') as cpo5g
,st,case when lev=0 then 0 else 1 end as lev
,cdep,cdepc,craz,cdiv,cdiv1,cdiv2,ctgt,cexp,citm,cdop,clcl
,dep_n,div_n,tgt_n,exp_n,itm_n,dop_n,lcl_n''+case when @nCombo_18 not in (7,8,12) then ''
,round(s_1,''+cast(@digts as varchar)+'') as s_1'' else '''' end+''
,round(s_2,''+cast(@digts as varchar)+'') as s_2
,round(s_3,''+cast(@digts as varchar)+'') as s_3
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 229, ',round(s_4,''+cast(@digts as varchar)+'') as s_4
,round(s_5,''+cast(@digts as varchar)+'') as s_5
,round(s_6,''+cast(@digts as varchar)+'') as s_6
,round(s_7,''+cast(@digts as varchar)+'') as s_7
,round(s_8,''+cast(@digts as varchar)+'') as s_8
,round(s_9,''+cast(@digts as varchar)+'') as s_9''+case when @nCombo_18 in (7,8,12) then ''
,round(s_10,''+cast(@digts as varchar)+'') as s_10
,round(s_12,''+cast(@digts as varchar)+'') as s_12
,round(s_13,''+cast(@digts as varchar)+'') as s_13
,round(s_14,''+cast(@digts as varchar)+'') as s_14
,round(case when su in (6,7,8,9,10,11,12,13,15,16,17) then s_2 else 0 end,''+convert(varchar,@digts)+'') as s_2b
,round(case when su in (6,7,8,9,10,11,12,13,15,16,17) then s_3 else 0 end,''+convert(varchar,@digts)+'') as s_3b
,round(case when su in (6,7,8,9,10,11,12,13,15,16,17) then s_4 else 0 end,''+convert(varchar,@digts)+'') as s_4b
,round(case when su in (6,7,8,9,10,11,12,13,15,16,17) then s_5 else 0 end,''+convert(varchar,@digts)+'') as s_5b
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 230, ',round(case when su in (6,7,8,9,10,11,12,13,15,16,17) then s_6 else 0 end,''+convert(varchar,@digts)+'') as s_6b
,round(case when su in (6,7,8,9,10,11,12,13,15,16,17) then s_10 else 0 end,''+convert(varchar,@digts)+'') as s_10b
,round(case when su in (9,10,11,12) then s_2 else 0 end,''+convert(varchar,@digts)+'') as s_2c
,round(case when su in (9,10,11,12) then s_3 else 0 end,''+convert(varchar,@digts)+'') as s_3c
,round(case when su in (9,10,11,12) then s_4 else 0 end,''+convert(varchar,@digts)+'') as s_4c
,round(case when su in (9,10,11,12) then s_5 else 0 end,''+convert(varchar,@digts)+'') as s_5c
,round(case when su in (9,10,11,12) then s_6 else 0 end,''+convert(varchar,@digts)+'') as s_6c
,round(case when su in (9,10,11,12) then s_10 else 0 end,''+convert(varchar,@digts)+'') as s_10c
,round(case when su in (15,16,17,13) then s_2 else 0 end,''+convert(varchar,@digts)+'') as s_2m
,round(case when su in (15,16,17,13) then s_3 else 0 end,''+convert(varchar,@digts)+'') as s_3m
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 231, ',round(case when su in (15,16,17,13) then s_4 else 0 end,''+convert(varchar,@digts)+'') as s_4m
,round(case when su in (15,16,17,13) then s_5 else 0 end,''+convert(varchar,@digts)+'') as s_5m
,round(case when su in (15,16,17,13) then s_6 else 0 end,''+convert(varchar,@digts)+'') as s_6m
,round(case when su in (15,16,17,13) then s_10 else 0 end,''+convert(varchar,@digts)+'') as s_10m
,pon,cnpro,cnpro1,npro_n,npro1_n
,(select top 1 cpog from #cnpro where cnpro=t.cnpro order by len(cpog) desc) as cpogs
,(select top 1 pon from #cnpro1 where list=t.list and cnpro=t.cnpro order by len(pon) desc) as pons
,(select top 1 cpo from #cnpro1 where list=t.list and cnpro=t.cnpro order by len(pon) desc) as cpos
,coalesce((select top 1 pon from #cnprog where list=t.list and cnpro=t.cnpro and coalesce(cpog,'''''''')=coalesce(t.cpog,'''''''') order by len(pon) desc),(select top 1 pon from #cnprog where list=t.list and ctgt=t.ctgt and coalesce(cpog,'''''''')=coalesce(t.cpog,'''''''') order by len(pon) desc)) as ponsg
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 232, ',coalesce((select top 1 cpo from #cnprog where list=t.list and cnpro=t.cnpro and coalesce(cpog,'''''''')=coalesce(t.cpog,'''''''') order by len(pon) desc),(select top 1 cpo from #cnprog where list=t.list and ctgt=t.ctgt and coalesce(cpog,'''''''')=coalesce(t.cpog,'''''''') order by len(pon) desc)) as cposg
,cast(case when isnumeric(cpog)=1 then replace(str(cast(cpog as int),10),'''' '''',''''0'''') else cpog end as varchar(254)) as pogsort'' else ''
,round(k_1,''+cast(@digts as varchar)+'') as k_1
,round(k_2,''+cast(@digts as varchar)+'') as k_2
,round(k_3,''+cast(@digts as varchar)+'') as k_3
,round(k_4,''+cast(@digts as varchar)+'') as k_4
,round(k_5,''+cast(@digts as varchar)+'') as k_5
,round(k_6,''+cast(@digts as varchar)+'') as k_6
,round(k_7,''+cast(@digts as varchar)+'') as k_7
,round(k_8,''+cast(@digts as varchar)+'') as k_8
,round(k_9,''+cast(@digts as varchar)+'') as k_9
,nam_1,res_1,dat_1,lev1,cod_1
,nam_2,res_2,dat_2,lev2,cod_2
,nam_3,res_3,dat_3,lev3,cod_3'' end+''
,metod
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 233, ',case when st=1 then 0 else 1 end as st1,coalesce(su,-1) as su
''+case when @nCombo_31=2 then '',cate,ate_n''
	when @nCombo_31=3 then '',cdep as cate,dep_n as ate_n''
	when @nCombo_31=4 then '',(select top 1 code from dbo.s_corr where link=corr) as cate,(select top 1 name from dbo.s_corr where link=corr) as ate_n''
	when @nCombo_31=6 then '',(select top 1 code from dbo.s_corr where link=corr) as cate,(select top 1 name from dbo.s_corr where link=corr) as ate_n,ecp''
	when @nCombo_31=5 then '',ctgt as cate,tgt_n as ate_n''
	else '''' end+''
,status,ord
from #t_res3 t''+case /*when @nCombo_18=5 then '' where vnut=1''*/
 when @nCombo_18 in (7,12) then '' where su in (6,7,8,9,10,11,12,13,14,15,16,17)''
 when @nCombo_18 in (8) then '' where cnpro is not null and vnut=1 and su in (6,7,8,9,10,11,12,13,14,15,16,17)''
 else '''' end+''
order by list,cpo,st''+case when @nCombo_31=2 then '',cate,ate_n''
	when @nCombo_31=3 then '',cdep,dep_n''
	when @nCombo_31=4 then '',corr''
	when @nCombo_31=6 then '',corr,ecp''
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 234, '	when @nCombo_31=5 then '',ctgt,tgt_n''
	else '''' end+''
,status,ord''

--select @tsql
execute sp_executesql @tsql,N''@sql_begin varchar(1000),@sql_end varchar(1000),@sql_body varchar(1000)'',@sql_begin,@sql_end,@sql_body

end
--return

declare @sbp int,@sbp_n varchar(254),@bud_n varchar(254),@uchr int
select @uchr=count(sc.link) from dbo.object_var_records ovr
 join dbo.s_corr sc on sc.link = ovr.record
 join #t_res t on t.corr=ovr.record
  where ovr.link_up = @nOtborLink10

select @sbp_n = '''',@bud_n = ''''

if coalesce(@uchr,0)=0 begin
	select top 1 @sbp=sc.corr, @bud_n=bname from dbo.s_bcorr sc
	where exists(select * from dbo.sys_corr_tree_user(@user,4,''bcorr'') where corr=sc.link)
	select @sbp_n=name from s_corr where link=(select dbo.user_link())
end

if coalesce(@uchr,0)=0 and exists(select * from #link) begin
	select top 1 @bud_n=(select top 1 bname from dbo.s_bcorr where corr=sc.link)/*,@uchr=link*/ from dbo.s_corr sc where link=(
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 235, '	select top 1 corr from dbo.t_corr_dict tcd where corr_dict=(
	select top 1 link from dbo.s_corr where inn=''USER'' and object=(select dbo.obj_id(''DICTIONARY_CORR_TYPE''))
	))
end

if coalesce(@uchr,0)>0
	select distinct sc.name,cast(case when objpo=@DICTIONARY_SODERG_RO then 1 else 2 end as int) as list from dbo.object_var_records ovr
	join dbo.s_corr sc on sc.link = ovr.record
	join #t_res t on t.corr=ovr.record
	where ovr.link_up = @nOtborLink10
else if @nOtborLink3>0 begin
		select distinct sc.name,cast(case when objpo=@DICTIONARY_SODERG_RO then 1 else 2 end as int) as list from dbo.object_var_records ovr
		join dbo.s_corr sc on sc.department = ovr.record
		join #t_res t on t.corr=sc.link
		where ovr.link_up = @nOtborLink3
	end else
		select distinct name,cast(list as int) as list from (select @sbp_n as name)n,(select 1 as list union select 2 as list)l

select @bud_n as name

--   
insert #t_npa1 (orders,name)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 236, 'select distinct cast(number as int),name from dbo.credit_doc cd where object=@DICTIONARY_NPA_GROUP and number in (''1'',''2'',''3'',''4'',''5'',''6'') and not exists(select * from #t_npa1 where orders=cast(cd.number as int))
insert #t_npa2 (orders,name)
select distinct cast(number as int)-6,name from dbo.credit_doc cd where object=@DICTIONARY_NPA_GROUP and number in (''7'',''8'') and not exists(select * from #t_npa2 where orders=cast(cd.number as int)-6)

if @nCombo_18=3 begin
	select distinct orders,name,1 as bud,'' '' as code
	,case when orders in (1,2) then ''  (),  ()'' else '' , '' end as vip
	from #t_npa1 t
	where orders in (2,4)
--	and exists(select * from #t_res3 where lev1=t.orders)
	order by orders
	select distinct orders,name,2 as bud from #t_npa2 t
	where orders in (2,4)
	and exists(select * from #t_res3 where lev2=t.orders)
	order by orders
	select distinct orders,name,3 as bud from #t_npa3 t
	where orders in (2,4)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 237, '	and exists(select * from #t_res3 where lev3=t.orders)
	order by orders
end else begin
	if not exists(select * from #t_npa1) begin
		insert into #t_npa1 (orders,name,code) select 0 as orders,''#/'' as name,''#/'' as code
	end
	if not exists(select * from #t_npa2) begin
		insert into #t_npa2 (orders,name) select 0 as orders,''#/'' as name
	end
	if not exists(select * from #t_npa3) begin
		insert into #t_npa3 (orders,name) select 0 as orders,''#/'' as name
	end
	select distinct orders,name,1 as bud,case when orders in (2,4) then '' '' else ''#/'' end as code
	,case when orders in (1,2) then ''  (),  ()'' else '' , '' end as vip
	from #t_npa1 t order by orders
	select distinct orders,name,2 as bud
	,case when orders=1 then ''  (),  ()'' else '' , '' end as vip
	from #t_npa2 order by orders
	select distinct orders,name,3 as bud from #t_npa3 order by orders
end

if @nCombo_18=9
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 238, '	select distinct g.god,g.obj,t.orders,t.name,t.list,g.obj_n from #t_dop t,#COLUMN_REESTR g where g.list=t.list
	and exists(select * from #t_res where god=g.god and list=g.list and su=t.orders)
else
	select distinct orders,name,list from #t_dop t

--if @nCombo_18 in (7,8,12)
select distinct left(ate.inn,2)+''000000'' as name from dbo.s_corr ate
join dbo.s_corr_cpp scp on scp.ate=ate.link and scp.corr=(select dbo.user_link())

--  :
--  
select list,po_n,ord from #t_res3 t where exists(select * from (
select distinct ord from #t_res3 t where su=0
)f where f.ord=t.ord)
order by list,po_n,ord
--    
select list,po_n,ord
from #t_res3 where st=-1 and (lev1=0 or lev2=0)
order by list,po_n,ord

END --   (   34)
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ54', 'SQUERY_CHANGED')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'S_89440090 money', 'SYS_2458925_5Q00YYQ54', 'SQUERY_CREATE_FIELDS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (1488, null, '2025-02-26 08:54:48.627', 'SYS_2458925_5Q00YYQ54', 'SQUERY_DATETIME')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'S_89440090', 'SYS_2458925_5Q00YYQ54', 'SQUERY_FIELDS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'REPMAKER.XLS', 'SYS_2458925_5Q00YYQ54', 'SQUERY_GENERATOR')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ54', 'SQUERY_PATH')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ54', 'SQUERY_PROG_BEFORE_PRINT')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'IIF(!EMPTY(@cText_12),"@cText_12",IIF(@nCombo_18=3 and @nCombo_31=1 and EMPTY(@cText_12),"sqr_rro_34n_npa.xlt",IIF(@nCombo_18=1 and @nCombo_31=1 and EMPTY(@cText_12),"sqr_rro_34n.xlt",IIF(@nCombo_18=2 and @nCombo_31=1 and EMPTY(@cText_12) and @nCheck_25=0 and @nCheck_26=0 and @nCheck_27=0,"sqr_rro_34n_kbk.xlt",IIF(@nCombo_18=2 and @nCombo_31=1 and EMPTY(@cText_12) and (@nCheck_25=1 or @nCheck_26=1 or @nCheck_27=1),"sqr_rro_34n_lcl.xlt",IIF(@nCombo_18=4 and @nCombo_31=1 and EMPTY(@cText_12),"sqr_rro_34n_kbk_name.xlt",IIF(@nCombo_18=5 and EMPTY(@cText_12),"sqr_rro_34n_cons.xlt",IIF(@nCombo_18=6 and EMPTY(@cText_12),"sqr_rro_34n_kbk_dep.xlt",IIF(@nCombo_18=1 and @nCombo_31<>1 and @nCombo_31<>6 and EMPTY(@cText_12),"sqr_rro_34n_list.xlt",IIF(.F.,"sqr_rro_34n_status.xlt",IIF(@nCombo_18=4 and @nCombo_31<>1 and EMPTY(@cText_12),"sqr_rro_34n_kbk_name_list.xlt",IIF(.F.,"sqr_rro_34n_ngr.xlt",IIF(.F.,"sqr_rro_34n_cons_ngr.xlt",IIF(@nCombo_18=7 and @nCombo_31=1 and EMPTY(@cText_12),"sqr_rro_34n_npron.xlt",IIF(@nCombo_18=8 and EMPTY(@cText_12),"sqr_rro_34n_npro.xlt",IIF(@nCombo_18=9 and EMPTY(@cText_12),"sqr_rro_34n_sum.xlt",IIF(@nCombo_18=11 and EMPTY(@cText_12),"sqr_rro_34n_zato.xlt",IIF(@nCombo_18=10 and EMPTY(@cText_12),"sqr_rro_34n_zaton.xlt",IIF(.F.,"sqr_rro_34n_npr_tgt.xlt",IIF(.F.,"sqr_rro_34n_npr_div.xlt",IIF(@nCombo_18=7 and @nCombo_31<>1 and EMPTY(@cText_12),"sqr_rro_34n_npron_list.xlt",IIF(@nCombo_18=1 and @nCombo_31=6 and EMPTY(@cText_12),"sqr_rro_34n_listep.xlt",IIF(.F.,"sqr_rro_34n_udm.xlt",IIF(@nCombo_18=2 and @nCombo_31<>1 and EMPTY(@cText_12),"sqr_rro_34n_kbk_list.xlt",IIF(@nCombo_18=3 and @nCombo_31<>1 and EMPTY(@cText_12),"sqr_rro_34n_npa_list.xlt","")))))))))))))))))))))))))', 'SYS_2458925_5Q00YYQ54', 'SQUERY_REPORT')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '-- 24 Jan 2025 11:07:38:557  DPRSIB\SQL2016.bks_MariEl_20241231.katyakov, host:KS-1063
CREATE PROCEDURE #P_SQUERY
		@cText_12 varchar(4000) /* */,
		@cText_35 varchar(4000) /*  */,
		@dDate_1 datetime /* */,
		@dDate_2 datetime /* */,
		@nCheck_11 int /* */,
		@nCheck_13 int /*   (),  ()*/,
		@nCheck_14 int /*      */,
		@nCheck_15 int /*     */,
		@nCheck_16 int /*  */,
		@nCheck_17 int /*   */,
		@nCheck_19 int /**/,
		@nCheck_20 int /**/,
		@nCheck_21 int /**/,
		@nCheck_22 int /*  */,
		@nCheck_23 int /*  */,
		@nCheck_24 int /*    */,
		@nCheck_25 int /*.*/,
		@nCheck_26 int /*.*/,
		@nCheck_27 int /**/,
		@nCheck_29 int /*   () - */,
		@nCheck_3 int /*  */,
		@nCheck_30 int /*  -   () - */,
		@nCheck_33 int /*     */,
		@nCheck_34 int /**/,
		@nCheck_4 int /*   - */,
		@nCheck_5 int /*   ()*/,
		@nCheck_6 int /*  -  */,
		@nCheck_7 int /*  -   - */,
		@nCheck_8 int /*  -   ()*/,
		@nCombo_18 int /* */,
		@nCombo_31 int /* */,
		@nCombo_32 int /*  */,
		@nInt_10 int /* */,
		@nOption_9 int /**/,
		@nOtborLink1 int = 0 /*  */,
		@nOtborLink2 int = 0 /*    */,
		@nOtborLink3 int = 0 /**/,
		@nOtborLink4 int = 0 /**/,
		@nOtborLink5 int = 0 /* */,
		@nOtborLink6 int = 0 /* */,
		@nOtborLink7 int = 0 /**/,
		@nOtborLink8 int = 0 /*. */,
		@nOtborLink9 int = 0 /* */,
		@nOtborLink10 int = 0 /**/,
		@nOtborLink11 int = 0 /* ,   */,
		@nOtborLink12 int = 0 /*  */,
		@nOtborLink13 int = 0 /*  */,
		@nOtborLink14 int = 0 /* */,
		@nOtborLink15 int = 0 /**/,
		@nOtborLink21 int = 0 /*   */,
		@nOtborLink22 int = 0 /*  */,
		@nOtborLink23 int = 0 /*  */,
		@cTableInto nvarchar(20) = '''',
		@nDictFilter int = NULL
AS
BEGIN
', 'SYS_2458925_5Q00YYQ54', 'SQUERY_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, null, 'SYS_2458925_5Q00YYQ54', 'SQUERY_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 7, '
END', 'SYS_2458925_5Q00YYQ54', 'SQUERY_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458925_5Q00YYQ54', 'SQUERY_TOTAL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ54', 'SQUERY_USE_ALT_SQL')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '3', 'SYS_2458925_5Q00YYQ54', 'SQUERY_USE_DIV1000')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458925_5Q00YYQ54', 'SQUERY_USE_VARIANT')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458927_5Q20UZ0SA', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_11', 'SYS_2458927_5Q20UZ0SA', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458927_5Q20UZ0SA', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458927_5Q20UZ0SA', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458927_5Q20UZ0SA', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2458969_5R814Y1RA', 'SQUERY_ATTRIBUTES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_33', 'SYS_2458969_5R814Y1RA', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2458969_5R814Y1RA', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2458969_5R814Y1RA', 'SQUERY_NASTR_VALUE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'sn.code=''FAILED''', 'SYS_2459307_60N0ZHNXN', 'SQUERY_DICT_WHERE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2459307_60N0ZHNXN', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '@nCheck_34', 'SYS_2459369_62D10YYZR', 'SQUERY_NASTR_CODE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '', 'SYS_2459369_62D10YYZR', 'SQUERY_NASTR_NOTE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '1', 'SYS_2459369_62D10YYZR', 'SQUERY_NASTR_SAVE')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '.', 'SYS_2459369_62D10YYZR', 'SQUERY_NASTR_VALUE')

GO



GO
		

	CREATE TABLE #T_OBJECT (LINK int, CODE varchar(100), NAME varchar(254), ORDERS int, LINK_SELF int, LINK_CLASS int, CODE_SELF varchar(100), CODE_CLASS varchar(100))


	INSERT INTO #T_OBJECT (CODE, NAME, ORDERS, CODE_SELF, CODE_CLASS) VALUES ('SQUERY_REESTR_RO_76N', '      ', null, null, 'SQUERY_CLASS')

GO
		

	CREATE TABLE #T_GROUPS (GROUP_NAME varchar(250), NAME varchar(254), CODE_OBJ varchar(50), IMAGE_ID int, SQ_CODE varchar(100), GATE_CODE varchar(50), GDIR_CODE varchar(50), STAT int)


	INSERT INTO #T_GROUPS (GROUP_NAME,NAME,CODE_OBJ,IMAGE_ID,SQ_CODE, GATE_CODE, GDIR_CODE, STAT) VALUES ('', '   (   34)', 'SQUERY_REESTR_RO_76N', 12, 'SYS_2458925_5Q00YYQ54', 'SYS_2458925_5Q00YYQ54', 'RRO_REPORT_CATALOG', 1)
	INSERT INTO #T_GROUPS (GROUP_NAME,NAME,CODE_OBJ,IMAGE_ID,SQ_CODE, GATE_CODE, GDIR_CODE, STAT) VALUES (' ', '   (   34)', 'SQUERY_REESTR_RO_76N', 12, 'SYS_2458925_5Q00YYQ54', 'SQU_B28DCC5C-8C23-4CA9-83AB-59B0AE0548E3', 'ARM_CATALOG_C4516DA1-5D8B-4600', 1)
	INSERT INTO #T_GROUPS (GROUP_NAME,NAME,CODE_OBJ,IMAGE_ID,SQ_CODE, GATE_CODE, GDIR_CODE, STAT) VALUES ('', '   (   34)', 'SQUERY_REESTR_RO_76N', 12, 'SYS_2458925_5Q00YYQ54', 'SQU_A184EBE6-3681-46E6-BEFC-34242CC94337', 'US_995723_6576436', 1)
	INSERT INTO #T_GROUPS (GROUP_NAME,NAME,CODE_OBJ,IMAGE_ID,SQ_CODE, GATE_CODE, GDIR_CODE, STAT) VALUES ('', '   (   34)', 'SQUERY_REESTR_RO_76N', 12, 'SYS_2458925_5Q00YYQ54', 'SQU_32FD8E74-77B3-4ACB-9623-8815ED636B07', 'ARM_CATALOG_9EAEC5AD-282A-44E1', 1)
	INSERT INTO #T_GROUPS (GROUP_NAME,NAME,CODE_OBJ,IMAGE_ID,SQ_CODE, GATE_CODE, GDIR_CODE, STAT) VALUES (' ', '   (   34)', 'SQUERY_REESTR_RO_76N', 12, 'SYS_2458925_5Q00YYQ54', 'SQU_3C278E57-A47C-44B2-9768-3C33AAD30A5C', 'ARM_CATALOG_F26F2BC2-4066-496B-9905-CC5F820A3CF3', 1)
	INSERT INTO #T_GROUPS (GROUP_NAME,NAME,CODE_OBJ,IMAGE_ID,SQ_CODE, GATE_CODE, GDIR_CODE, STAT) VALUES (' ', '   (   34)', 'SQUERY_REESTR_RO_76N', 12, 'SYS_2458925_5Q00YYQ54', 'SQU_3C278E57-A47C-44B2-9768-3C33AAD30A5C', 'ARM_CATALOG_F26F2BC2-4066-496B-9905-CC5F820A3CF3', 1)

GO
		

	EXECUTE M_UPDATE_SQUERY '#T_OBJ','#T_PROP','#T_OBJECT','#T_GROUPS'

	DROP TABLE #T_OBJ
	DROP TABLE #T_PROP
	DROP TABLE #T_OBJECT
	DROP TABLE #T_GROUPS
	exec dtt '#t_xlrep_'

--end squery

GO




-- XL_REPORT-SYS_XL_sqr_rro_34n.sql

--squery
--KS-1063\katyakov 29.01.2025

--%OBJECT%SYS_XL_sqr_rro_34n%%
-- : sqr_rro_34n.xlt

if object_id('tempdb..#T_OBJ') is not null drop table #T_OBJ
if object_id('tempdb..#T_PROP') is not null drop table #T_PROP
if object_id('tempdb..#T_OBJECT') is not null drop table #T_OBJECT
if object_id('tempdb..#T_GROUPS') is not null drop table #T_GROUPS

GO


	CREATE TABLE #T_OBJ (LINK int, NAME varchar(254), OBJECT int, CODE varchar(100), USERS int, ORDERS int, LINK_SELF int, LINK_STATE int, CODE_OBJ varchar(100), CODE_SELF varchar(100), CODE_STATE varchar(100))


	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('sqr_rro_34n.xlt', 'SYS_XL_sqr_rro_34n', null, null, 'XL_REPORT', null, null)

GO
		

	CREATE TABLE #T_PROP (LINK_UP int, PROPERTY int, USERS int, ORDERS int, VALUE nvarchar(max), CODE_UP varchar(100), CODE_PROP varchar(100))


	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'katyakov', 'SYS_XL_sqr_rro_34n', 'SQUERY_AUTHOR')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '2025-01-29 15:35:54.767', 'SYS_XL_sqr_rro_34n', 'SQUERY_DATETIME')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,'''',1,1,1,1,''xl22'','''',1
1,1,'''',1,1,1,2,''xl22'','''',1
1,1,'''',1,1,1,3,''xl22'','''',1
1,1,'''',1,1,1,4,''xl22'','''',1
1,1,'''',1,1,1,5,''xl22'','''',1
1,1,'''',1,1,1,6,''xl22'','''',1
1,1,'''',1,1,1,7,''xl22'','''',1
1,1,'''',1,1,1,8,''xl22'','''',1
1,1,'''',1,1,1,9,''xl22'','''',1
1,1,'''',1,1,1,10,''xl22'','''',1
1,1,'''',1,1,1,11,''xl22'','''',1
1,1,'''',1,1,1,12,''xl22'','''',1
1,1,'''',1,1,1,13,''xl22'','''',1
1,1,'''',1,1,1,14,''xl22'','''',1
1,1,'''',1,1,1,15,''xl22'','''',1
1,1,'''',1,1,1,16,''xl22'','''',1
1,1,'''',1,1,1,17,''xl22'','''',1
1,1,'''',1,1,1,18,''xl22'','''',1
1,1,'''',1,1,1,19,''xl22'','''',1
1,1,'''',1,1,1,20,''xl22'','''',1
1,1,'''',1,1,1,21,''xl22'','''',1
1,1,'''',1,1,1,22,''xl22'','''',1
1,1,'' 2'',1,1,1,23,''xl84'','''',1
1,1,'''',1,1,1,24,''xl83'','''',1
1,1,'''',1,1,1,25,''xl83'','''',1
1,1,'''',1,1,1,26,''xl83'','''',1
1,1,'''',1,1,1,27,''xl83'','''',1
1,1,'''',1,1,1,28,''xl83'','''',1
1,1,'''',1,1,1,29,''xl83'','''',1
1,1,'''',1,1,1,30,''xl22'','''',1
1,1,'''',1,1,1,31,''xl87'','''',1
1,1,'''',1,1,1,32,''xl87'','''',1
1,1,'''',1,1,1,33,''xl87'','''',1
1,1,'''',1,1,1,34,''xl87'','''',1
1,1,'''',1,1,1,35,''xl84'','''',1
1,1,'''',1,1,1,36,''xl87'','''',1
1,1,'''',1,1,1,37,''xl87'','''',1
1,1,'''',1,1,1,38,''xl87'','''',1
1,1,'''',1,1,1,39,''xl87'','''',1
1,1,'''',1,1,1,40,''xl87'','''',1
1,1,'''',1,1,1,41,''xl87'','''',1
1,1,'''',1,1,1,42,''xl87'','''',1
1,1,'''',1,1,1,43,''xl87'','''',1
1,1,'''',1,1,1,44,''xl87'','''',1
1,1,'''',1,1,1,45,''xl87'','''',1
1,1,'''',1,1,1,46,''xl87'','''',1
1,1,'''',1,1,1,47,''xl87'','''',1
1,1,'''',1,1,1,48,''xl87'','''',1
1,1,''>>"#/"'',1,1,1,49,''xl90'','''',1
1,1,'''',1,1,1,50,''xl22'','''',1
1,1,'''',1,1,2,1,''xl22'','''',1
1,1,'''',1,1,2,2,''xl22'','''',1
1,1,'''',1,1,2,3,''xl22'','''',1
1,1,'''',1,1,2,4,''xl22'','''',1
1,1,'''',1,1,2,5,''xl22'','''',1
1,1,'''',1,1,2,6,''xl22'','''',1
1,1,'''',1,1,2,7,''xl22'','''',1
1,1,'''',1,1,2,8,''xl22'','''',1
1,1,'''',1,1,2,9,''xl22'','''',1
1,1,'''',1,1,2,10,''xl22'','''',1
1,1,'''',1,1,2,11,''xl22'','''',1
1,1,'''',1,1,2,12,''xl22'','''',1
1,1,'''',1,1,2,13,''xl22'','''',1
1,1,'''',1,1,2,14,''xl22'','''',1
1,1,'''',1,1,2,15,''xl22'','''',1
1,1,'''',1,1,2,16,''xl22'','''',1
1,1,'''',1,1,2,17,''xl22'','''',1
1,1,'''',1,1,2,18,''xl22'','''',1
1,1,'''',1,1,2,19,''xl22'','''',1
1,1,'''',1,1,2,20,''xl22'','''',1
1,1,'''',1,1,2,21,''xl22'','''',1
1,1,'''',1,1,2,22,''xl22'','''',1
1,1,''   '',1,1,2,23,''xl84'','''',1
1,1,'''',1,1,2,24,''xl83'','''',1
1,1,'''',1,1,2,25,''xl83'','''',1
1,1,'''',1,1,2,26,''xl83'','''',1
1,1,'''',1,1,2,27,''xl83'','''',1
1,1,'''',1,1,2,28,''xl83'','''',1
1,1,'''',1,1,2,29,''xl83'','''',1
1,1,'''',1,1,2,30,''xl22'','''',1
1,1,'''',1,1,2,31,''xl87'','''',1
1,1,'''',1,1,2,32,''xl87'','''',1
1,1,'''',1,1,2,33,''xl87'','''',1
1,1,'''',1,1,2,34,''xl87'','''',1
1,1,'''',1,1,2,35,''xl84'','''',1
1,1,'''',1,1,2,36,''xl87'','''',1
1,1,'''',1,1,2,37,''xl87'','''',1
1,1,'''',1,1,2,38,''xl87'','''',1
1,1,'''',1,1,2,39,''xl87'','''',1
1,1,'''',1,1,2,40,''xl87'','''',1
1,1,'''',1,1,2,41,''xl87'','''',1
1,1,'''',1,1,2,42,''xl87'','''',1
1,1,'''',1,1,2,43,''xl87'','''',1
1,1,'''',1,1,2,44,''xl87'','''',1
1,1,'''',1,1,2,45,''xl87'','''',1
1,1,'''',1,1,2,46,''xl87'','''',1
1,1,'''',1,1,2,47,''xl87'','''',1
1,1,'''',1,1,2,48,''xl87'','''',1
1,1,'''',1,1,2,49,''xl22'','''',1
1,1,'''',1,1,2,50,''xl22'','''',1
1,1,''     '',1,21,3,1,''xl81'','''',1
1,1,'''',1,1,3,22,''xl83'','''',1
1,1,'' '',1,1,3,23,''xl84'','''',1
1,1,'''',1,1,3,24,''xl76'','''',1
1,1,'''',1,1,3,25,''xl76'','''',1
1,1,'''',1,1,3,26,''xl76'','''',1
1,1,'''',1,1,3,27,''xl76'','''',1
1,1,'''',1,1,3,28,''xl76'','''',1
1,1,'''',1,1,3,29,''xl76'','''',1
1,1,'''',1,1,3,30,''xl22'','''',1
1,1,'''',1,1,3,31,''xl87'','''',1
1,1,'''',1,1,3,32,''xl87'','''',1
1,1,'''',1,1,3,33,''xl87'','''',1
1,1,'''',1,1,3,34,''xl87'','''',1
1,1,'''',1,1,3,35,''xl84'','''',1
1,1,'''',1,1,3,36,''xl87'','''',1
1,1,'''',1,1,3,37,''xl87'','''',1
1,1,'''',1,1,3,38,''xl87'','''',1
1,1,'''',1,1,3,39,''xl87'','''',1
1,1,'''',1,1,3,40,''xl87'','''',1
1,1,'''',1,1,3,41,''xl87'','''',1
1,1,'''',1,1,3,42,''xl87'','''',1
1,1,'''',1,1,3,43,''xl87'','''',1
1,1,'''',1,1,3,44,''xl87'','''',1
1,1,'''',1,1,3,45,''xl87'','''',1
1,1,'''',1,1,3,46,''xl87'','''',1
1,1,'''',1,1,3,47,''xl87'','''',1
1,1,'''',1,1,3,48,''xl87'','''',1
1,1,'''',1,1,3,49,''xl22'','''',1
1,1,'''',1,1,3,50,''xl22'','''',1
1,1,''>>" "&(dDate_2+1;0)&"."'',1,21,4,1,''xl47'','''',1
1,1,'''',1,1,4,22,''xl47'','''',1
1,1,'' 03.03.2020 34'',1,1,4,23,''xl84'','''',1
1,1,'''',1,1,4,24,''xl47'','''',1
1,1,'''',1,1,4,25,''xl47'','''',1
1,1,'''',1,1,4,26,''xl47'','''',1
1,1,'''',1,1,4,27,''xl47'','''',1
1,1,'''',1,1,4,28,''xl47'','''',1
1,1,'''',1,1,4,29,''xl47'','''',1
1,1,'''',1,1,4,30,''xl22'','''',1
1,1,'''',1,1,4,31,''xl87'','''',1
1,1,'''',1,1,4,32,''xl87'','''',1
1,1,'''',1,1,4,33,''xl87'','''',1
1,1,'''',1,1,4,34,''xl87'','''',1
1,1,'''',1,1,4,35,''xl84'','''',1
1,1,'''',1,1,4,36,''xl87'','''',1
1,1,'''',1,1,4,37,''xl87'','''',1
1,1,'''',1,1,4,38,''xl87'','''',1
1,1,'''',1,1,4,39,''xl87'','''',1
1,1,'''',1,1,4,40,''xl87'','''',1
1,1,'''',1,1,4,41,''xl87'','''',1
1,1,'''',1,1,4,42,''xl87'','''',1
1,1,'''',1,1,4,43,''xl87'','''',1
1,1,'''',1,1,4,44,''xl87'','''',1
1,1,'''',1,1,4,45,''xl87'','''',1
1,1,'''',1,1,4,46,''xl87'','''',1
1,1,'''',1,1,4,47,''xl87'','''',1
1,1,'''',1,1,4,48,''xl87'','''',1
1,1,'''',1,1,4,49,''xl22'','''',1
1,1,'''',1,1,4,50,''xl22'','''',1
1,1,'''',1,1,5,1,''xl22'','''',1
1,1,'''',1,1,5,2,''xl22'','''',1
1,1,'''',1,1,5,3,''xl22'','''',1
1,1,'''',1,1,5,4,''xl22'','''',1
1,1,'''',1,1,5,5,''xl22'','''',1
1,1,'''',1,1,5,6,''xl22'','''',1
1,1,'''',1,1,5,7,''xl22'','''',1
1,1,'''',1,1,5,8,''xl41'','''',1
1,1,'''',1,1,5,9,''xl41'','''',1
1,1,'''',1,1,5,10,''xl41'','''',1
1,1,'''',1,1,5,11,''xl32'','''',1
1,1,'''',1,1,5,12,''xl41'','''',1
1,1,'''',1,1,5,13,''xl41'','''',1
1,1,'''',1,1,5,14,''xl41'','''',1
1,1,'''',1,1,5,15,''xl41'','''',1
1,1,'''',1,1,5,16,''xl41'','''',1
1,1,'''',1,1,5,17,''xl76'','''',1
1,1,'''',1,1,5,18,''xl76'','''',1
1,1,'''',1,1,5,19,''xl76'','''',1
1,1,'''',1,1,5,20,''xl76'','''',1
1,1,'''',1,1,5,21,''xl41'','''',1
1,1,'''',1,1,5,22,''xl41'','''',1
1,1,'''',1,1,5,23,''xl41'','''',1
1,1,'''',1,1,5,24,''xl41'','''',1
1,1,'''',1,1,5,25,''xl41'','''',1
1,1,'''',1,1,5,26,''xl41'','''',1
1,1,'''',1,1,5,27,''xl41'','''',1
1,1,'''',1,1,5,28,''xl41'','''',1
1,1,'''',1,1,5,29,''xl41'','''',1
1,1,'''',1,1,5,30,''xl22'','''',1
1,1,'''',1,1,5,31,''xl87'','''',1
1,1,'''',1,1,5,32,''xl87'','''',1
1,1,'''',1,1,5,33,''xl87'','''',1
1,1,'''',1,1,5,34,''xl87'','''',1
1,1,'''',1,1,5,35,''xl23'','''',1
1,1,'''',1,1,5,36,''xl87'','''',1
1,1,'''',1,1,5,37,''xl87'','''',1
1,1,'''',1,1,5,38,''xl87'','''',1
1,1,'''',1,1,5,39,''xl87'','''',1
1,1,'''',1,1,5,40,''xl87'','''',1
1,1,'''',1,1,5,41,''xl87'','''',1
1,1,'''',1,1,5,42,''xl87'','''',1
1,1,'''',1,1,5,43,''xl87'','''',1
1,1,'''',1,1,5,44,''xl87'','''',1
1,1,'''',1,1,5,45,''xl87'','''',1
1,1,'''',1,1,5,46,''xl87'','''',1
1,1,'''',1,1,5,47,''xl87'','''',1
1,1,'''',1,1,5,48,''xl87'','''',1
1,1,'''',1,1,5,49,''xl22'','''',1
1,1,'''',1,1,5,50,''xl22'','''',1
1,1,''        '',1,1,6,1,''xl23'','''',1
1,1,''$$select name from c_data1 where list=1#name#name#NN'',1,22,6,2,''xl85'','''',1
1,1,'''',1,1,6,24,''xl41'','''',1
1,1,'''',1,1,6,25,''xl41'','''',1
1,1,'''',1,1,6,26,''xl41'','''',1
1,1,'''',1,1,6,27,''xl41'','''',1
1,1,'''',1,1,6,28,''xl41'','''',1
1,1,'''',1,1,6,29,''xl41'','''',1
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,'''',1,1,6,30,''xl22'','''',1
1,1,'''',1,1,6,31,''xl87'','''',1
1,1,'''',1,1,6,32,''xl87'','''',1
1,1,'''',1,1,6,33,''xl87'','''',1
1,1,'''',1,1,6,34,''xl87'','''',1
1,1,'''',1,1,6,35,''xl23'','''',1
1,1,'''',1,1,6,36,''xl87'','''',1
1,1,'''',1,1,6,37,''xl87'','''',1
1,1,'''',1,1,6,38,''xl87'','''',1
1,1,'''',1,1,6,39,''xl87'','''',1
1,1,'''',1,1,6,40,''xl87'','''',1
1,1,'''',1,1,6,41,''xl87'','''',1
1,1,'''',1,1,6,42,''xl87'','''',1
1,1,'''',1,1,6,43,''xl87'','''',1
1,1,'''',1,1,6,44,''xl87'','''',1
1,1,'''',1,1,6,45,''xl87'','''',1
1,1,'''',1,1,6,46,''xl87'','''',1
1,1,'''',1,1,6,47,''xl87'','''',1
1,1,'''',1,1,6,48,''xl87'','''',1
1,1,'''',1,1,6,49,''xl22'','''',1
1,1,'''',1,1,6,50,''xl22'','''',1
1,1,''  '',1,1,7,1,''xl23'','''',1
1,1,''$$select name from c_data2#name#name#NN'',1,22,7,2,''xl85'','''',1
1,1,'''',1,1,7,24,''xl41'','''',1
1,1,'''',1,1,7,25,''xl41'','''',1
1,1,'''',1,1,7,26,''xl41'','''',1
1,1,'''',1,1,7,27,''xl41'','''',1
1,1,'''',1,1,7,28,''xl41'','''',1
1,1,'''',1,1,7,29,''xl41'','''',1
1,1,'''',1,1,7,30,''xl41'','''',1
1,1,'''',1,1,7,31,''xl41'','''',1
1,1,'''',1,1,7,32,''xl41'','''',1
1,1,'''',1,1,7,33,''xl41'','''',1
1,1,'''',1,1,7,34,''xl41'','''',1
1,1,'''',1,1,7,35,''xl23'','''',1
1,1,'''',1,1,7,36,''xl41'','''',1
1,1,'''',1,1,7,37,''xl41'','''',1
1,1,'''',1,1,7,38,''xl41'','''',1
1,1,'''',1,1,7,39,''xl41'','''',1
1,1,'''',1,1,7,40,''xl41'','''',1
1,1,'''',1,1,7,41,''xl41'','''',1
1,1,'''',1,1,7,42,''xl41'','''',1
1,1,'''',1,1,7,43,''xl41'','''',1
1,1,'''',1,1,7,44,''xl41'','''',1
1,1,'''',1,1,7,45,''xl41'','''',1
1,1,'''',1,1,7,46,''xl41'','''',1
1,1,'''',1,1,7,47,''xl41'','''',1
1,1,'''',1,1,7,48,''xl41'','''',1
1,1,'''',1,1,7,49,''xl22'','''',1
1,1,'''',1,1,7,50,''xl22'','''',1
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,23,8,1,''xl86'','''',1
1,1,'''',1,1,8,24,''xl41'','''',1
1,1,'''',1,1,8,25,''xl41'','''',1
1,1,'''',1,1,8,26,''xl41'','''',1
1,1,'''',1,1,8,27,''xl41'','''',1
1,1,'''',1,1,8,28,''xl41'','''',1
1,1,'''',1,1,8,29,''xl41'','''',1
1,1,'''',1,1,8,30,''xl41'','''',1
1,1,'''',1,1,8,31,''xl41'','''',1
1,1,'''',1,1,8,32,''xl41'','''',1
1,1,'''',1,1,8,33,''xl41'','''',1
1,1,'''',1,1,8,34,''xl41'','''',1
1,1,'''',1,1,8,35,''xl41'','''',1
1,1,'''',1,1,8,36,''xl41'','''',1
1,1,'''',1,1,8,37,''xl41'','''',1
1,1,'''',1,1,8,38,''xl41'','''',1
1,1,'''',1,1,8,39,''xl41'','''',1
1,1,'''',1,1,8,40,''xl41'','''',1
1,1,'''',1,1,8,41,''xl41'','''',1
1,1,'''',1,1,8,42,''xl41'','''',1
1,1,'''',1,1,8,43,''xl41'','''',1
1,1,'''',1,1,8,44,''xl41'','''',1
1,1,'''',1,1,8,45,''xl41'','''',1
1,1,'''',1,1,8,46,''xl41'','''',1
1,1,'''',1,1,8,47,''xl41'','''',1
1,1,'''',1,1,8,48,''xl41'','''',1
1,1,'''',1,1,8,49,''xl22'','''',1
1,1,'''',1,1,8,50,''xl22'','''',1
1,1,'''',1,1,9,1,''xl23'','''',1
1,1,'''',1,1,9,2,''xl32'','''',1
1,1,'''',1,1,9,3,''xl41'','''',1
1,1,'''',1,1,9,4,''xl41'','''',1
1,1,'''',1,1,9,5,''xl41'','''',1
1,1,'''',1,1,9,6,''xl41'','''',1
1,1,'''',1,1,9,7,''xl41'','''',1
1,1,'''',1,1,9,8,''xl41'','''',1
1,1,'''',1,1,9,9,''xl41'','''',1
1,1,'''',1,1,9,10,''xl41'','''',1
1,1,'''',1,1,9,11,''xl32'','''',1
1,1,'''',1,1,9,12,''xl41'','''',1
1,1,'''',1,1,9,13,''xl41'','''',1
1,1,'''',1,1,9,14,''xl41'','''',1
1,1,'''',1,1,9,15,''xl41'','''',1
1,1,'''',1,1,9,16,''xl41'','''',1
1,1,'''',1,1,9,17,''xl41'','''',1
1,1,'''',1,1,9,18,''xl41'','''',1
1,1,'''',1,1,9,19,''xl41'','''',1
1,1,'''',1,1,9,20,''xl41'','''',1
1,1,'''',1,1,9,21,''xl41'','''',1
1,1,'''',1,1,9,22,''xl41'','''',1
1,1,'''',1,1,9,23,''xl41'','''',1
1,1,'''',1,1,9,24,''xl41'','''',1
1,1,'''',1,1,9,25,''xl41'','''',1
1,1,'''',1,1,9,26,''xl41'','''',1
1,1,'''',1,1,9,27,''xl41'','''',1
1,1,'''',1,1,9,28,''xl41'','''',1
1,1,'''',1,1,9,29,''xl41'','''',1
1,1,'''',1,1,9,30,''xl41'','''',1
1,1,'''',1,1,9,31,''xl41'','''',1
1,1,'''',1,1,9,32,''xl41'','''',1
1,1,'''',1,1,9,33,''xl41'','''',1
1,1,'''',1,1,9,34,''xl41'','''',1
1,1,'''',1,1,9,35,''xl41'','''',1
1,1,'''',1,1,9,36,''xl41'','''',1
1,1,'''',1,1,9,37,''xl41'','''',1
1,1,'''',1,1,9,38,''xl41'','''',1
1,1,'''',1,1,9,39,''xl41'','''',1
1,1,'''',1,1,9,40,''xl41'','''',1
1,1,'''',1,1,9,41,''xl41'','''',1
1,1,'''',1,1,9,42,''xl41'','''',1
1,1,'''',1,1,9,43,''xl41'','''',1
1,1,'''',1,1,9,44,''xl41'','''',1
1,1,'''',1,1,9,45,''xl41'','''',1
1,1,'''',1,1,9,46,''xl41'','''',1
1,1,'''',1,1,9,47,''xl41'','''',1
1,1,'''',1,1,9,48,''xl41'','''',1
1,1,'''',1,1,9,49,''xl22'','''',1
1,1,'''',1,1,9,50,''xl22'','''',1
1,1,''>>>" , chr(10)  "&cText_35'',10,1,10,1,''xl24'','''',1
1,1,'' '',10,1,10,2,''xl33'','''',1
1,1,''>>>"    ,   "&cText_35'',2,7,10,3,''xl56'','''',1
1,1,''  ,  '',10,1,10,10,''xl59'','''',1
1,1,''    '',4,1,10,11,''xl61'','''',1
1,1,''>>>"      "&cText_35'',3,12,10,12,''xl71'','''',1
1,1,''>>>" ..       "&cText_35&"           () "'',3,12,10,24,''xl71'','''',1
1,1,''>>>"    () "&cText_35'',3,6,10,36,''xl71'','''',1
1,1,''>>>" ..     () "&cText_35&"           () "'',3,6,10,42,''xl71'','''',1
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,10,48,''xl88'','''',1
1,1,'''',1,1,10,49,''xl91'','''',1
1,1,'''',1,1,10,50,''xl91'','''',1
1,1,'''',1,1,11,49,''xl91'','''',1
1,1,'''',1,1,11,50,''xl91'','''',1
1,1,'' '',1,4,12,3,''xl51'','''',1
1,1,''>>>cText_35'',1,3,12,7,''xl51'','''',1
1,1,'''',1,1,12,49,''xl91'','''',1
1,1,'''',1,1,12,50,''xl91'','''',1
1,1,''&&select orders,name from c_data3 order by orders#name#orders#AA'',1,4,13,3,''xl51'','''',1
1,1,''&&select orders,name from c_data4 order by orders#name#orders#AA'',1,3,13,7,''xl51'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,12,''xl71'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,16,''xl71'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,18,''xl71'','''',1
1,1,'' '',1,4,13,20,''xl71'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,24,''xl71'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,28,''xl71'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,30,''xl71'','''',1
1,1,'' '',1,4,13,32,''xl71'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,36,''xl71'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,38,''xl71'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,40,''xl71'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,42,''xl71'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,44,''xl71'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,46,''xl71'','''',1
1,1,'''',1,1,13,49,''xl91'','''',1
1,1,'''',1,1,13,50,''xl91'','''',1
1,1,'',   '',6,1,14,3,''xl42'','''',1
1,1,''&&select vip from c_data3 where orders=AA#vip#vip#CC'',6,1,14,4,''xl48'','''',1
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '1,1,''   ,  '',6,1,14,5,''xl49'','''',1
1,1,''&&select code from c_data3 where orders=AA#code#code#CC'',6,1,14,6,''xl52'','''',1
1,1,'',   '',6,1,14,7,''xl53'','''',1
1,1,''&&select vip from c_data4 where orders=AA#vip#vip#CC'',6,1,14,8,''xl54'','''',1
1,1,''   ,  '',6,1,14,9,''xl57'','''',1
1,1,''/'',6,1,14,11,''xl62'','''',1
1,1,'''',1,2,14,12,''xl71'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,14,''xl71'','''',1
1,1,'''',6,1,14,16,''xl75'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,17,''xl77'','''',1
1,1,'''',6,1,14,18,''xl78'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,19,''xl79'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,20,''xl82'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,22,''xl82'','''',1
1,1,'''',1,2,14,24,''xl71'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,26,''xl71'','''',1
1,1,'''',6,1,14,28,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,29,''xl80'','''',1
1,1,'''',6,1,14,30,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,31,''xl80'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,32,''xl82'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,34,''xl82'','''',1
1,1,'''',6,1,14,36,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,37,''xl80'','''',1
1,1,'''',6,1,14,38,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,39,''xl80'','''',1
1,1,'''',6,1,14,40,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,41,''xl80'','''',1
1,1,'''',6,1,14,42,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,43,''xl80'','''',1
1,1,'''',6,1,14,44,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,45,''xl80'','''',1
1,1,'''',6,1,14,46,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,47,''xl80'','''',1
1,1,'''',1,1,14,49,''xl91'','''',1
1,1,'''',1,1,14,50,''xl91'','''',1
1,1,''  '',5,1,15,12,''xl66'','''',1
1,1,'''',5,1,15,13,''xl72'','''',1
1,1,''  '',5,1,15,14,''xl73'','''',1
1,1,'''',5,1,15,15,''xl74'','''',1
1,1,'''',5,1,15,20,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,21,''xl80'','''',1
1,1,'''',5,1,15,22,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,23,''xl80'','''',1
1,1,''  '',5,1,15,24,''xl80'','''',1
1,1,'''',5,1,15,25,''xl80'','''',1
1,1,''  '',5,1,15,26,''xl80'','''',1
1,1,'''',5,1,15,27,''xl80'','''',1
1,1,'''',5,1,15,32,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,33,''xl80'','''',1
1,1,'''',5,1,15,34,''xl80'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,35,''xl80'','''',1
1,1,'''',1,1,15,49,''xl91'','''',1
1,1,'''',1,1,15,50,''xl91'','''',1
1,1,'''',1,1,16,49,''xl91'','''',1
1,1,'''',1,1,16,50,''xl91'','''',1
1,1,'''',1,1,17,49,''xl91'','''',1
1,1,'''',1,1,17,50,''xl91'','''',1
1,1,'''',1,1,18,49,''xl91'','''',1
1,1,'''',1,1,18,50,''xl91'','''',1
1,1,'''',1,1,19,49,''xl91'','''',1
1,1,'''',1,1,19,50,''xl91'','''',1
1,2,''>>>"   "&cText_35'',1,1,1,1,''xl29'','''',1
1,2,''8000'',1,1,1,2,''xl38'','''',1
1,2,'''',1,1,1,3,''xl46'','''',1
1,2,'''',1,1,1,4,''xl46'','''',1
1,2,'''',1,1,1,5,''xl46'','''',1
1,2,'''',1,1,1,6,''xl46'','''',1
1,2,'''',1,1,1,7,''xl46'','''',1
1,2,'''',1,1,1,8,''xl46'','''',1
1,2,'''',1,1,1,9,''xl46'','''',1
1,2,'''',1,1,1,10,''xl46'','''',1
1,2,'''',1,1,1,11,''xl46'','''',1
1,2,''>>(<list>;1;<s_1>)'',1,1,1,12,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_2>)'',1,1,1,13,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_1>)'',1,1,1,14,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_2>)'',1,1,1,15,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_3>)'',1,1,1,16,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_3>)'',1,1,1,17,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_4>)'',1,1,1,18,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_4>)'',1,1,1,19,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_5>)'',1,1,1,20,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_5>)'',1,1,1,21,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_6>)'',1,1,1,22,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_6>)'',1,1,1,23,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_1>)'',1,1,1,24,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_2>)'',1,1,1,25,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_1>)'',1,1,1,26,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_2>)'',1,1,1,27,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_3>)'',1,1,1,28,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_3>)'',1,1,1,29,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_4>)'',1,1,1,30,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_4>)'',1,1,1,31,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_5>)'',1,1,1,32,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_5>)'',1,1,1,33,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_6>)'',1,1,1,34,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_6>)'',1,1,1,35,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_7>)'',1,1,1,36,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_7>)'',1,1,1,37,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_8>)'',1,1,1,38,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_8>)'',1,1,1,39,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_9>)'',1,1,1,40,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_9>)'',1,1,1,41,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_7>)'',1,1,1,42,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_7>)'',1,1,1,43,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_8>)'',1,1,1,44,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_8>)'',1,1,1,45,''xl70'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_9>)'',1,1,1,46,''xl70'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_9>)'',1,1,1,47,''xl70'',''"#,##0.00"'',1
1,2,'''',1,1,1,48,''xl89'','''',1
1,2,'''',1,1,1,49,''xl22'','''',1
1,2,'''',1,1,1,50,''xl22'','''',1
1,2,'''',1,1,2,1,''xl30'','''',1
1,2,'''',1,1,2,2,''xl39'','''',1
1,2,'''',1,1,2,3,''xl47'','''',1
1,2,'''',1,1,2,4,''xl47'','''',1
1,2,'''',1,1,2,5,''xl47'','''',1
1,2,'''',1,1,2,6,''xl47'','''',1
1,2,'''',1,1,2,7,''xl47'','''',1
1,2,'''',1,1,2,8,''xl47'','''',1
1,2,'''',1,1,2,9,''xl47'','''',1
1,2,'''',1,1,2,10,''xl47'','''',1
1,2,'''',1,1,2,11,''xl39'','''',1
1,2,'''',1,1,2,12,''xl65'','''',1
1,2,'''',1,1,2,13,''xl65'','''',1
1,2,'''',1,1,2,14,''xl65'','''',1
1,2,'''',1,1,2,15,''xl65'','''',1
1,2,'''',1,1,2,16,''xl65'','''',1
1,2,'''',1,1,2,17,''xl65'','''',1
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '1,2,'''',1,1,2,18,''xl65'','''',1
1,2,'''',1,1,2,19,''xl65'','''',1
1,2,'''',1,1,2,20,''xl65'','''',1
1,2,'''',1,1,2,21,''xl65'','''',1
1,2,'''',1,1,2,22,''xl65'','''',1
1,2,'''',1,1,2,23,''xl65'','''',1
1,2,'''',1,1,2,24,''xl65'','''',1
1,2,'''',1,1,2,25,''xl65'','''',1
1,2,'''',1,1,2,26,''xl65'','''',1
1,2,'''',1,1,2,27,''xl65'','''',1
1,2,'''',1,1,2,28,''xl65'','''',1
1,2,'''',1,1,2,29,''xl65'','''',1
1,2,'''',1,1,2,30,''xl65'','''',1
1,2,'''',1,1,2,31,''xl65'','''',1
1,2,'''',1,1,2,32,''xl65'','''',1
1,2,'''',1,1,2,33,''xl65'','''',1
1,2,'''',1,1,2,34,''xl65'','''',1
1,2,'''',1,1,2,35,''xl65'','''',1
1,2,'''',1,1,2,36,''xl65'','''',1
1,2,'''',1,1,2,37,''xl65'','''',1
1,2,'''',1,1,2,38,''xl65'','''',1
1,2,'''',1,1,2,39,''xl65'','''',1
1,2,'''',1,1,2,40,''xl65'','''',1
1,2,'''',1,1,2,41,''xl65'','''',1
1,2,'''',1,1,2,42,''xl65'','''',1
1,2,'''',1,1,2,43,''xl65'','''',1
1,2,'''',1,1,2,44,''xl65'','''',1
1,2,'''',1,1,2,45,''xl65'','''',1
1,2,'''',1,1,2,46,''xl65'','''',1
1,2,'''',1,1,2,47,''xl65'','''',1
1,2,'''',1,1,2,48,''xl65'','''',1
1,2,'''',1,1,2,49,''xl22'','''',1
1,2,'''',1,1,2,50,''xl22'','''',1
1,2,''>>>Footer'',1,48,3,1,''xl31'','''',1
1,2,'''',1,1,3,49,''xl22'','''',1
1,2,'''',1,1,3,50,''xl22'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl25'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,3,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,4,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,5,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)"&("CC"="#/";"";"+1")'',1,1,1,6,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,7,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,8,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,9,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,10,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,11,''xl63'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,12,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,13,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,14,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,15,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,16,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,17,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,18,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,19,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,20,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,21,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,22,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,23,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,24,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,25,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,26,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,27,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,28,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,29,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,30,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,31,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,32,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,33,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,34,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,35,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,36,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,37,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,38,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,39,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,40,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,41,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,42,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,43,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,44,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,45,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,46,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,47,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,48,''xl25'','''',1
2,1,'''',1,1,1,49,''xl22'','''',1
2,1,'''',1,1,1,50,''xl22'','''',1
3,1,''>>>{po5_n}'',1,1,1,1,''xl27'','''',1
3,1,''>>>{cpo5}'',1,1,1,2,''xl34'','''',1
3,1,'''',1,1,1,3,''xl43'','''',1
3,1,'''',1,1,1,4,''xl43'','''',1
3,1,'''',1,1,1,5,''xl43'','''',1
3,1,'''',1,1,1,6,''xl43'','''',1
3,1,'''',1,1,1,7,''xl43'','''',1
3,1,'''',1,1,1,8,''xl43'','''',1
3,1,'''',1,1,1,9,''xl43'','''',1
3,1,''>>>{cpo5g}'',1,1,1,10,''xl34'','''',1
3,1,'''',1,1,1,11,''xl43'','''',1
3,1,''>>(<s_1>)'',1,1,1,12,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_2>)'',1,1,1,13,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,14,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,15,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_3>)'',1,1,1,16,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,17,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_4>)'',1,1,1,18,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,19,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_5>)'',1,1,1,20,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,21,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_6>)'',1,1,1,22,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,23,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_1>)'',1,1,1,24,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_2>)'',1,1,1,25,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,26,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,27,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_3>)'',1,1,1,28,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,29,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_4>)'',1,1,1,30,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,31,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_5>)'',1,1,1,32,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,33,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_6>)'',1,1,1,34,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,35,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_7>)'',1,1,1,36,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,37,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_8>)'',1,1,1,38,''xl67'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '3,1,''>>(<su>;AA;<s_8>)'',1,1,1,39,''xl67'',''"#,##0.00"'',1
3,1,''>>(<s_9>)'',1,1,1,40,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,41,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_7>)'',1,1,1,42,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,43,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_8>)'',1,1,1,44,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,45,''xl67'',''"#,##0.00"'',1
3,1,''>>(<k_9>)'',1,1,1,46,''xl67'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,47,''xl67'',''"#,##0.00"'',1
3,1,'''',1,1,1,48,''xl43'','''',1
3,1,'''',1,1,1,49,''xl22'','''',1
3,1,'''',1,1,1,50,''xl22'','''',1
4,1,''>>>{po4_n}'',1,1,1,1,''xl27'','''',1
4,1,''>>>{cpo4}'',1,1,1,2,''xl34'','''',1
4,1,'''',1,1,1,3,''xl43'','''',1
4,1,'''',1,1,1,4,''xl43'','''',1
4,1,'''',1,1,1,5,''xl43'','''',1
4,1,'''',1,1,1,6,''xl43'','''',1
4,1,'''',1,1,1,7,''xl43'','''',1
4,1,'''',1,1,1,8,''xl43'','''',1
4,1,'''',1,1,1,9,''xl43'','''',1
4,1,''>>>{cpo4g}'',1,1,1,10,''xl34'','''',1
4,1,'''',1,1,1,11,''xl43'','''',1
4,1,''>>(<s_1>)'',1,1,1,12,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_2>)'',1,1,1,13,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,14,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,15,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_3>)'',1,1,1,16,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,17,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_4>)'',1,1,1,18,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,19,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_5>)'',1,1,1,20,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,21,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_6>)'',1,1,1,22,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,23,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_1>)'',1,1,1,24,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_2>)'',1,1,1,25,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,26,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,27,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_3>)'',1,1,1,28,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,29,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_4>)'',1,1,1,30,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,31,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_5>)'',1,1,1,32,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,33,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_6>)'',1,1,1,34,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,35,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_7>)'',1,1,1,36,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,37,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_8>)'',1,1,1,38,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,39,''xl67'',''"#,##0.00"'',1
4,1,''>>(<s_9>)'',1,1,1,40,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,41,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_7>)'',1,1,1,42,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,43,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_8>)'',1,1,1,44,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,45,''xl67'',''"#,##0.00"'',1
4,1,''>>(<k_9>)'',1,1,1,46,''xl67'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,47,''xl67'',''"#,##0.00"'',1
4,1,'''',1,1,1,48,''xl43'','''',1
4,1,'''',1,1,1,49,''xl22'','''',1
4,1,'''',1,1,1,50,''xl22'','''',1
5,1,''>>>{po3_n}'',1,1,1,1,''xl27'','''',1
5,1,''>>>{cpo3}'',1,1,1,2,''xl34'','''',1
5,1,'''',1,1,1,3,''xl43'','''',1
5,1,'''',1,1,1,4,''xl43'','''',1
5,1,'''',1,1,1,5,''xl43'','''',1
5,1,'''',1,1,1,6,''xl43'','''',1
5,1,'''',1,1,1,7,''xl43'','''',1
5,1,'''',1,1,1,8,''xl43'','''',1
5,1,'''',1,1,1,9,''xl43'','''',1
5,1,''>>>{cpo3g}'',1,1,1,10,''xl34'','''',1
5,1,'''',1,1,1,11,''xl43'','''',1
5,1,''>>(<s_1>)'',1,1,1,12,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_2>)'',1,1,1,13,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,14,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,15,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_3>)'',1,1,1,16,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,17,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_4>)'',1,1,1,18,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,19,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_5>)'',1,1,1,20,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,21,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_6>)'',1,1,1,22,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,23,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_1>)'',1,1,1,24,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_2>)'',1,1,1,25,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,26,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,27,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_3>)'',1,1,1,28,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,29,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_4>)'',1,1,1,30,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,31,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_5>)'',1,1,1,32,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,33,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_6>)'',1,1,1,34,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,35,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_7>)'',1,1,1,36,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,37,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_8>)'',1,1,1,38,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,39,''xl67'',''"#,##0.00"'',1
5,1,''>>(<s_9>)'',1,1,1,40,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,41,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_7>)'',1,1,1,42,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,43,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_8>)'',1,1,1,44,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,45,''xl67'',''"#,##0.00"'',1
5,1,''>>(<k_9>)'',1,1,1,46,''xl67'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,47,''xl67'',''"#,##0.00"'',1
5,1,'''',1,1,1,48,''xl43'','''',1
5,1,'''',1,1,1,49,''xl22'','''',1
5,1,'''',1,1,1,50,''xl22'','''',1
6,1,''>>>{po2_n}'',1,1,1,1,''xl27'','''',1
6,1,''>>>{cpo2}'',1,1,1,2,''xl34'','''',1
6,1,'''',1,1,1,3,''xl43'','''',1
6,1,'''',1,1,1,4,''xl43'','''',1
6,1,'''',1,1,1,5,''xl43'','''',1
6,1,'''',1,1,1,6,''xl43'','''',1
6,1,'''',1,1,1,7,''xl43'','''',1
6,1,'''',1,1,1,8,''xl43'','''',1
6,1,'''',1,1,1,9,''xl43'','''',1
6,1,''>>>{cpo2g}'',1,1,1,10,''xl34'','''',1
6,1,'''',1,1,1,11,''xl43'','''',1
6,1,''>>(<s_1>)'',1,1,1,12,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_2>)'',1,1,1,13,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,14,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,15,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_3>)'',1,1,1,16,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,17,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_4>)'',1,1,1,18,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,19,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_5>)'',1,1,1,20,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,21,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_6>)'',1,1,1,22,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,23,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_1>)'',1,1,1,24,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_2>)'',1,1,1,25,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,26,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,27,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_3>)'',1,1,1,28,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,29,''xl67'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '6,1,''>>(<k_4>)'',1,1,1,30,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,31,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_5>)'',1,1,1,32,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,33,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_6>)'',1,1,1,34,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,35,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_7>)'',1,1,1,36,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,37,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_8>)'',1,1,1,38,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,39,''xl67'',''"#,##0.00"'',1
6,1,''>>(<s_9>)'',1,1,1,40,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,41,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_7>)'',1,1,1,42,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,43,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_8>)'',1,1,1,44,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,45,''xl67'',''"#,##0.00"'',1
6,1,''>>(<k_9>)'',1,1,1,46,''xl67'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,47,''xl67'',''"#,##0.00"'',1
6,1,'''',1,1,1,48,''xl43'','''',1
6,1,'''',1,1,1,49,''xl22'','''',1
6,1,'''',1,1,1,50,''xl22'','''',1
7,1,''>>>{po1_n}'',1,1,1,1,''xl27'','''',1
7,1,''>>>{cpo1}'',1,1,1,2,''xl34'','''',1
7,1,'''',1,1,1,3,''xl43'','''',1
7,1,'''',1,1,1,4,''xl43'','''',1
7,1,'''',1,1,1,5,''xl43'','''',1
7,1,'''',1,1,1,6,''xl43'','''',1
7,1,'''',1,1,1,7,''xl43'','''',1
7,1,'''',1,1,1,8,''xl43'','''',1
7,1,'''',1,1,1,9,''xl43'','''',1
7,1,''>>>{cpo1g}'',1,1,1,10,''xl34'','''',1
7,1,'''',1,1,1,11,''xl43'','''',1
7,1,''>>(<s_1>)'',1,1,1,12,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_2>)'',1,1,1,13,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,14,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,15,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_3>)'',1,1,1,16,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,17,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_4>)'',1,1,1,18,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,19,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_5>)'',1,1,1,20,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,21,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_6>)'',1,1,1,22,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,23,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_1>)'',1,1,1,24,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_2>)'',1,1,1,25,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,26,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,27,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_3>)'',1,1,1,28,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,29,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_4>)'',1,1,1,30,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,31,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_5>)'',1,1,1,32,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,33,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_6>)'',1,1,1,34,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,35,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_7>)'',1,1,1,36,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,37,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_8>)'',1,1,1,38,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,39,''xl67'',''"#,##0.00"'',1
7,1,''>>(<s_9>)'',1,1,1,40,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,41,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_7>)'',1,1,1,42,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,43,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_8>)'',1,1,1,44,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,45,''xl67'',''"#,##0.00"'',1
7,1,''>>(<k_9>)'',1,1,1,46,''xl67'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,47,''xl67'',''"#,##0.00"'',1
7,1,'''',1,1,1,48,''xl43'','''',1
7,1,'''',1,1,1,49,''xl22'','''',1
7,1,'''',1,1,1,50,''xl22'','''',1
8,1,''>>>nvl({po_n};" ")&"\"'',1,1,1,1,''xl28'','''',1
8,1,''>>>nvl({cpo};" ")&"\"'',1,1,1,2,''xl36'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<nam_1>)'',1,1,1,3,''xl45'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<res_1>)'',1,1,1,4,''xl45'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<dat_1>)'',1,1,1,5,''xl45'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<cod_1>)'',1,1,1,6,''xl45'','''',1
8,1,''>>>2(<lev2>;AA;<st>;1;<nam_2>)'',1,1,1,7,''xl45'','''',1
8,1,''>>>2(<lev2>;AA;<st>;1;<res_2>)'',1,1,1,8,''xl45'','''',1
8,1,''>>>2(<lev2>;AA;<st>;1;<dat_2>)'',1,1,1,9,''xl58'','''',1
8,1,''>>nvl({cpog};" ")&"\"'',1,1,1,10,''xl60'','''',1
8,1,''>>>(<lev>;1;<cdiv>)&"\"'',1,1,1,11,''xl64'','''',1
8,1,''>>(<s_1>)'',1,1,1,12,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_2>)'',1,1,1,13,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_1>)'',1,1,1,14,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_2>)'',1,1,1,15,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_3>)'',1,1,1,16,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_3>)'',1,1,1,17,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_4>)'',1,1,1,18,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_4>)'',1,1,1,19,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_5>)'',1,1,1,20,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_5>)'',1,1,1,21,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_6>)'',1,1,1,22,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_6>)'',1,1,1,23,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_1>)'',1,1,1,24,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_2>)'',1,1,1,25,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_1>)'',1,1,1,26,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_2>)'',1,1,1,27,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_3>)'',1,1,1,28,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_3>)'',1,1,1,29,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_4>)'',1,1,1,30,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_4>)'',1,1,1,31,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_5>)'',1,1,1,32,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_5>)'',1,1,1,33,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_6>)'',1,1,1,34,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_6>)'',1,1,1,35,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_7>)'',1,1,1,36,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_7>)'',1,1,1,37,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_8>)'',1,1,1,38,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_8>)'',1,1,1,39,''xl69'',''"#,##0.00"'',1
8,1,''>>(<s_9>)'',1,1,1,40,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_9>)'',1,1,1,41,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_7>)'',1,1,1,42,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_7>)'',1,1,1,43,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_8>)'',1,1,1,44,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_8>)'',1,1,1,45,''xl69'',''"#,##0.00"'',1
8,1,''>>(<k_9>)'',1,1,1,46,''xl69'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_9>)'',1,1,1,47,''xl69'',''"#,##0.00"'',1
8,1,''>>>(<lev>;1;<metod>)&"\"'',1,1,1,48,''xl36'','''',1
8,1,''>>st'',1,1,1,49,''xl92'','''',1
8,1,'''',1,1,1,50,''xl22'','''',1
9,1,''\'',1,1,1,1,''xl28'','''',1
9,1,''\'',1,1,1,2,''xl37'','''',1
9,1,''>>>(<lev1>;AA;<nam_1>)'',1,1,1,3,''xl45'','''',1
9,1,''>>>(<lev1>;AA;<res_1>)'',1,1,1,4,''xl45'','''',1
9,1,''>>>(<lev1>;AA;<dat_1>)'',1,1,1,5,''xl45'','''',1
9,1,''>>>(<lev1>;AA;<cod_1>)'',1,1,1,6,''xl45'','''',1
9,1,''>>>(<lev2>;AA;<nam_2>)'',1,1,1,7,''xl45'','''',1
9,1,''>>>(<lev2>;AA;<res_2>)'',1,1,1,8,''xl45'','''',1
9,1,''>>>(<lev2>;AA;<dat_2>)'',1,1,1,9,''xl58'','''',1
9,1,''\'',1,1,1,10,''xl60'','''',1
9,1,''\'',1,1,1,11,''xl64'','''',1
9,1,'''',1,1,1,12,''xl69'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 7, '9,1,'''',1,1,1,13,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,14,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,15,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,16,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,17,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,18,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,19,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,20,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,21,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,22,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,23,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,24,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,25,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,26,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,27,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,28,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,29,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,30,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,31,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,32,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,33,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,34,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,35,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,36,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,37,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,38,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,39,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,40,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,41,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,42,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,43,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,44,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,45,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,46,''xl69'',''"#,##0.00"'',1
9,1,'''',1,1,1,47,''xl69'',''"#,##0.00"'',1
9,1,''\'',1,1,1,48,''xl36'','''',1
9,1,''>>st'',1,1,1,49,''xl92'','''',1
9,1,'''',1,1,1,50,''xl22'','''',1
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 8, '1,1,'''',1,1,1,1,''xl22'','''',2
1,1,'''',1,1,1,2,''xl22'','''',2
1,1,'''',1,1,1,3,''xl22'','''',2
1,1,'''',1,1,1,4,''xl22'','''',2
1,1,'''',1,1,1,5,''xl22'','''',2
1,1,'''',1,1,1,6,''xl22'','''',2
1,1,'''',1,1,1,7,''xl22'','''',2
1,1,'''',1,1,1,8,''xl22'','''',2
1,1,'''',1,1,1,9,''xl22'','''',2
1,1,'''',1,1,1,10,''xl22'','''',2
1,1,'''',1,1,1,11,''xl22'','''',2
1,1,'''',1,1,1,12,''xl22'','''',2
1,1,'''',1,1,1,13,''xl22'','''',2
1,1,'''',1,1,1,14,''xl22'','''',2
1,1,'''',1,1,1,15,''xl22'','''',2
1,1,'''',1,1,1,16,''xl22'','''',2
1,1,'''',1,1,1,17,''xl22'','''',2
1,1,'''',1,1,1,18,''xl22'','''',2
1,1,'''',1,1,1,19,''xl22'','''',2
1,1,'''',1,1,1,20,''xl22'','''',2
1,1,'''',1,1,1,21,''xl22'','''',2
1,1,'''',1,1,1,22,''xl22'','''',2
1,1,'''',1,1,1,23,''xl22'','''',2
1,1,'''',1,1,1,24,''xl22'','''',2
1,1,'''',1,1,1,25,''xl22'','''',2
1,1,'' 3'',1,1,1,26,''xl84'','''',2
1,1,'''',1,1,1,27,''xl83'','''',2
1,1,'''',1,1,1,28,''xl83'','''',2
1,1,'''',1,1,1,29,''xl83'','''',2
1,1,'''',1,1,1,30,''xl83'','''',2
1,1,'''',1,1,1,31,''xl83'','''',2
1,1,'''',1,1,1,32,''xl83'','''',2
1,1,'''',1,1,1,33,''xl22'','''',2
1,1,'''',1,1,1,34,''xl87'','''',2
1,1,'''',1,1,1,35,''xl87'','''',2
1,1,'''',1,1,1,36,''xl87'','''',2
1,1,'''',1,1,1,37,''xl87'','''',2
1,1,'''',1,1,1,38,''xl84'','''',2
1,1,'''',1,1,1,39,''xl22'','''',2
1,1,'''',1,1,1,40,''xl87'','''',2
1,1,'''',1,1,1,41,''xl87'','''',2
1,1,'''',1,1,1,42,''xl87'','''',2
1,1,'''',1,1,1,43,''xl87'','''',2
1,1,'''',1,1,1,44,''xl87'','''',2
1,1,'''',1,1,1,45,''xl87'','''',2
1,1,'''',1,1,1,46,''xl87'','''',2
1,1,'''',1,1,1,47,''xl87'','''',2
1,1,'''',1,1,1,48,''xl87'','''',2
1,1,'''',1,1,1,49,''xl87'','''',2
1,1,'''',1,1,1,50,''xl87'','''',2
1,1,'''',1,1,1,51,''xl87'','''',2
1,1,''>>"#/"'',1,1,1,52,''xl90'','''',2
1,1,'''',1,1,1,53,''xl22'','''',2
1,1,''           ,'',1,24,2,1,''xl81'','''',2
1,1,'''',1,1,2,25,''xl22'','''',2
1,1,''   '',1,1,2,26,''xl84'','''',2
1,1,'''',1,1,2,27,''xl83'','''',2
1,1,'''',1,1,2,28,''xl83'','''',2
1,1,'''',1,1,2,29,''xl83'','''',2
1,1,'''',1,1,2,30,''xl83'','''',2
1,1,'''',1,1,2,31,''xl83'','''',2
1,1,'''',1,1,2,32,''xl83'','''',2
1,1,'''',1,1,2,33,''xl22'','''',2
1,1,'''',1,1,2,34,''xl87'','''',2
1,1,'''',1,1,2,35,''xl87'','''',2
1,1,'''',1,1,2,36,''xl87'','''',2
1,1,'''',1,1,2,37,''xl87'','''',2
1,1,'''',1,1,2,38,''xl84'','''',2
1,1,'''',1,1,2,39,''xl22'','''',2
1,1,'''',1,1,2,40,''xl87'','''',2
1,1,'''',1,1,2,41,''xl87'','''',2
1,1,'''',1,1,2,42,''xl87'','''',2
1,1,'''',1,1,2,43,''xl87'','''',2
1,1,'''',1,1,2,44,''xl87'','''',2
1,1,'''',1,1,2,45,''xl87'','''',2
1,1,'''',1,1,2,46,''xl87'','''',2
1,1,'''',1,1,2,47,''xl87'','''',2
1,1,'''',1,1,2,48,''xl87'','''',2
1,1,'''',1,1,2,49,''xl87'','''',2
1,1,'''',1,1,2,50,''xl87'','''',2
1,1,'''',1,1,2,51,''xl87'','''',2
1,1,'''',1,1,2,52,''xl22'','''',2
1,1,'''',1,1,2,53,''xl22'','''',2
1,1,''           '',1,24,3,1,''xl81'','''',2
1,1,'''',1,1,3,25,''xl83'','''',2
1,1,''  '',1,1,3,26,''xl84'','''',2
1,1,'''',1,1,3,27,''xl76'','''',2
1,1,'''',1,1,3,28,''xl76'','''',2
1,1,'''',1,1,3,29,''xl76'','''',2
1,1,'''',1,1,3,30,''xl76'','''',2
1,1,'''',1,1,3,31,''xl76'','''',2
1,1,'''',1,1,3,32,''xl76'','''',2
1,1,'''',1,1,3,33,''xl22'','''',2
1,1,'''',1,1,3,34,''xl87'','''',2
1,1,'''',1,1,3,35,''xl87'','''',2
1,1,'''',1,1,3,36,''xl87'','''',2
1,1,'''',1,1,3,37,''xl87'','''',2
1,1,'''',1,1,3,38,''xl84'','''',2
1,1,'''',1,1,3,39,''xl22'','''',2
1,1,'''',1,1,3,40,''xl87'','''',2
1,1,'''',1,1,3,41,''xl87'','''',2
1,1,'''',1,1,3,42,''xl87'','''',2
1,1,'''',1,1,3,43,''xl87'','''',2
1,1,'''',1,1,3,44,''xl87'','''',2
1,1,'''',1,1,3,45,''xl87'','''',2
1,1,'''',1,1,3,46,''xl87'','''',2
1,1,'''',1,1,3,47,''xl87'','''',2
1,1,'''',1,1,3,48,''xl87'','''',2
1,1,'''',1,1,3,49,''xl87'','''',2
1,1,'''',1,1,3,50,''xl87'','''',2
1,1,'''',1,1,3,51,''xl87'','''',2
1,1,'''',1,1,3,52,''xl22'','''',2
1,1,'''',1,1,3,53,''xl22'','''',2
1,1,'''',1,1,4,1,''xl47'','''',2
1,1,'''',1,1,4,2,''xl47'','''',2
1,1,'''',1,1,4,3,''xl47'','''',2
1,1,'''',1,1,4,4,''xl47'','''',2
1,1,'''',1,1,4,5,''xl47'','''',2
1,1,'''',1,1,4,6,''xl47'','''',2
1,1,'''',1,1,4,7,''xl47'','''',2
1,1,'''',1,1,4,8,''xl47'','''',2
1,1,'''',1,1,4,9,''xl47'','''',2
1,1,'''',1,1,4,10,''xl47'','''',2
1,1,'''',1,1,4,11,''xl47'','''',2
1,1,'''',1,1,4,12,''xl47'','''',2
1,1,'''',1,1,4,13,''xl47'','''',2
1,1,'''',1,1,4,14,''xl47'','''',2
1,1,'''',1,1,4,15,''xl47'','''',2
1,1,'''',1,1,4,16,''xl47'','''',2
1,1,'''',1,1,4,17,''xl47'','''',2
1,1,'''',1,1,4,18,''xl47'','''',2
1,1,'''',1,1,4,19,''xl47'','''',2
1,1,'''',1,1,4,20,''xl47'','''',2
1,1,'''',1,1,4,21,''xl47'','''',2
1,1,'''',1,1,4,22,''xl47'','''',2
1,1,'''',1,1,4,23,''xl47'','''',2
1,1,'''',1,1,4,24,''xl47'','''',2
1,1,'''',1,1,4,25,''xl47'','''',2
1,1,'' 03.03.2020 34'',1,1,4,26,''xl84'','''',2
1,1,'''',1,1,4,27,''xl47'','''',2
1,1,'''',1,1,4,28,''xl47'','''',2
1,1,'''',1,1,4,29,''xl47'','''',2
1,1,'''',1,1,4,30,''xl47'','''',2
1,1,'''',1,1,4,31,''xl47'','''',2
1,1,'''',1,1,4,32,''xl47'','''',2
1,1,'''',1,1,4,33,''xl22'','''',2
1,1,'''',1,1,4,34,''xl87'','''',2
1,1,'''',1,1,4,35,''xl87'','''',2
1,1,'''',1,1,4,36,''xl87'','''',2
1,1,'''',1,1,4,37,''xl87'','''',2
1,1,'''',1,1,4,38,''xl23'','''',2
1,1,'''',1,1,4,39,''xl22'','''',2
1,1,'''',1,1,4,40,''xl87'','''',2
1,1,'''',1,1,4,41,''xl87'','''',2
1,1,'''',1,1,4,42,''xl87'','''',2
1,1,'''',1,1,4,43,''xl87'','''',2
1,1,'''',1,1,4,44,''xl87'','''',2
1,1,'''',1,1,4,45,''xl87'','''',2
1,1,'''',1,1,4,46,''xl87'','''',2
1,1,'''',1,1,4,47,''xl87'','''',2
1,1,'''',1,1,4,48,''xl87'','''',2
1,1,'''',1,1,4,49,''xl87'','''',2
1,1,'''',1,1,4,50,''xl87'','''',2
1,1,'''',1,1,4,51,''xl87'','''',2
1,1,'''',1,1,4,52,''xl22'','''',2
1,1,'''',1,1,4,53,''xl22'','''',2
1,1,''>>" "&(dDate_2+1;0)&"."'',1,24,5,1,''xl47'','''',2
1,1,'''',1,1,5,25,''xl47'','''',2
1,1,'''',1,1,5,26,''xl84'','''',2
1,1,'''',1,1,5,27,''xl47'','''',2
1,1,'''',1,1,5,28,''xl47'','''',2
1,1,'''',1,1,5,29,''xl47'','''',2
1,1,'''',1,1,5,30,''xl47'','''',2
1,1,'''',1,1,5,31,''xl47'','''',2
1,1,'''',1,1,5,32,''xl47'','''',2
1,1,'''',1,1,5,33,''xl22'','''',2
1,1,'''',1,1,5,34,''xl87'','''',2
1,1,'''',1,1,5,35,''xl87'','''',2
1,1,'''',1,1,5,36,''xl87'','''',2
1,1,'''',1,1,5,37,''xl87'','''',2
1,1,'''',1,1,5,38,''xl84'','''',2
1,1,'''',1,1,5,39,''xl22'','''',2
1,1,'''',1,1,5,40,''xl87'','''',2
1,1,'''',1,1,5,41,''xl87'','''',2
1,1,'''',1,1,5,42,''xl87'','''',2
1,1,'''',1,1,5,43,''xl87'','''',2
1,1,'''',1,1,5,44,''xl87'','''',2
1,1,'''',1,1,5,45,''xl87'','''',2
1,1,'''',1,1,5,46,''xl87'','''',2
1,1,'''',1,1,5,47,''xl87'','''',2
1,1,'''',1,1,5,48,''xl87'','''',2
1,1,'''',1,1,5,49,''xl87'','''',2
1,1,'''',1,1,5,50,''xl87'','''',2
1,1,'''',1,1,5,51,''xl87'','''',2
1,1,'''',1,1,5,52,''xl22'','''',2
1,1,'''',1,1,5,53,''xl22'','''',2
1,1,'''',1,1,6,1,''xl47'','''',2
1,1,'''',1,1,6,2,''xl47'','''',2
1,1,'''',1,1,6,3,''xl47'','''',2
1,1,'''',1,1,6,4,''xl47'','''',2
1,1,'''',1,1,6,5,''xl47'','''',2
1,1,'''',1,1,6,6,''xl47'','''',2
1,1,'''',1,1,6,7,''xl47'','''',2
1,1,'''',1,1,6,8,''xl47'','''',2
1,1,'''',1,1,6,9,''xl47'','''',2
1,1,'''',1,1,6,10,''xl47'','''',2
1,1,'''',1,1,6,11,''xl47'','''',2
1,1,'''',1,1,6,12,''xl47'','''',2
1,1,'''',1,1,6,13,''xl47'','''',2
1,1,'''',1,1,6,14,''xl47'','''',2
1,1,'''',1,1,6,15,''xl47'','''',2
1,1,'''',1,1,6,16,''xl47'','''',2
1,1,'''',1,1,6,17,''xl47'','''',2
1,1,'''',1,1,6,18,''xl47'','''',2
1,1,'''',1,1,6,19,''xl47'','''',2
1,1,'''',1,1,6,20,''xl47'','''',2
1,1,'''',1,1,6,21,''xl47'','''',2
1,1,'''',1,1,6,22,''xl47'','''',2
1,1,'''',1,1,6,23,''xl47'','''',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 9, '1,1,'''',1,1,6,24,''xl47'','''',2
1,1,'''',1,1,6,25,''xl47'','''',2
1,1,'''',1,1,6,26,''xl23'','''',2
1,1,'''',1,1,6,27,''xl47'','''',2
1,1,'''',1,1,6,28,''xl47'','''',2
1,1,'''',1,1,6,29,''xl47'','''',2
1,1,'''',1,1,6,30,''xl47'','''',2
1,1,'''',1,1,6,31,''xl47'','''',2
1,1,'''',1,1,6,32,''xl47'','''',2
1,1,'''',1,1,6,33,''xl22'','''',2
1,1,'''',1,1,6,34,''xl87'','''',2
1,1,'''',1,1,6,35,''xl87'','''',2
1,1,'''',1,1,6,36,''xl87'','''',2
1,1,'''',1,1,6,37,''xl87'','''',2
1,1,'''',1,1,6,38,''xl23'','''',2
1,1,'''',1,1,6,39,''xl22'','''',2
1,1,'''',1,1,6,40,''xl87'','''',2
1,1,'''',1,1,6,41,''xl87'','''',2
1,1,'''',1,1,6,42,''xl87'','''',2
1,1,'''',1,1,6,43,''xl87'','''',2
1,1,'''',1,1,6,44,''xl87'','''',2
1,1,'''',1,1,6,45,''xl87'','''',2
1,1,'''',1,1,6,46,''xl87'','''',2
1,1,'''',1,1,6,47,''xl87'','''',2
1,1,'''',1,1,6,48,''xl87'','''',2
1,1,'''',1,1,6,49,''xl87'','''',2
1,1,'''',1,1,6,50,''xl87'','''',2
1,1,'''',1,1,6,51,''xl87'','''',2
1,1,'''',1,1,6,52,''xl22'','''',2
1,1,'''',1,1,6,53,''xl22'','''',2
1,1,''           ,'',1,24,7,1,''xl81'','''',2
1,1,'''',1,1,7,25,''xl22'','''',2
1,1,'' 1'',1,1,7,26,''xl84'','''',2
1,1,'''',1,1,7,27,''xl83'','''',2
1,1,'''',1,1,7,28,''xl83'','''',2
1,1,'''',1,1,7,29,''xl83'','''',2
1,1,'''',1,1,7,30,''xl83'','''',2
1,1,'''',1,1,7,31,''xl83'','''',2
1,1,'''',1,1,7,32,''xl83'','''',2
1,1,'''',1,1,7,33,''xl22'','''',2
1,1,'''',1,1,7,34,''xl87'','''',2
1,1,'''',1,1,7,35,''xl87'','''',2
1,1,'''',1,1,7,36,''xl87'','''',2
1,1,'''',1,1,7,37,''xl87'','''',2
1,1,'''',1,1,7,38,''xl84'','''',2
1,1,'''',1,1,7,39,''xl22'','''',2
1,1,'''',1,1,7,40,''xl87'','''',2
1,1,'''',1,1,7,41,''xl87'','''',2
1,1,'''',1,1,7,42,''xl87'','''',2
1,1,'''',1,1,7,43,''xl87'','''',2
1,1,'''',1,1,7,44,''xl87'','''',2
1,1,'''',1,1,7,45,''xl87'','''',2
1,1,'''',1,1,7,46,''xl87'','''',2
1,1,'''',1,1,7,47,''xl87'','''',2
1,1,'''',1,1,7,48,''xl87'','''',2
1,1,'''',1,1,7,49,''xl87'','''',2
1,1,'''',1,1,7,50,''xl87'','''',2
1,1,'''',1,1,7,51,''xl87'','''',2
1,1,'''',1,1,7,52,''xl22'','''',2
1,1,'''',1,1,7,53,''xl22'','''',2
1,1,''          ,     '',1,24,8,1,''xl81'','''',2
1,1,'''',1,1,8,25,''xl83'','''',2
1,1,'''',1,1,8,26,''xl84'','''',2
1,1,'''',1,1,8,27,''xl76'','''',2
1,1,'''',1,1,8,28,''xl76'','''',2
1,1,'''',1,1,8,29,''xl76'','''',2
1,1,'''',1,1,8,30,''xl76'','''',2
1,1,'''',1,1,8,31,''xl76'','''',2
1,1,'''',1,1,8,32,''xl76'','''',2
1,1,'''',1,1,8,33,''xl22'','''',2
1,1,'''',1,1,8,34,''xl87'','''',2
1,1,'''',1,1,8,35,''xl87'','''',2
1,1,'''',1,1,8,36,''xl87'','''',2
1,1,'''',1,1,8,37,''xl87'','''',2
1,1,'''',1,1,8,38,''xl84'','''',2
1,1,'''',1,1,8,39,''xl22'','''',2
1,1,'''',1,1,8,40,''xl87'','''',2
1,1,'''',1,1,8,41,''xl87'','''',2
1,1,'''',1,1,8,42,''xl87'','''',2
1,1,'''',1,1,8,43,''xl87'','''',2
1,1,'''',1,1,8,44,''xl87'','''',2
1,1,'''',1,1,8,45,''xl87'','''',2
1,1,'''',1,1,8,46,''xl87'','''',2
1,1,'''',1,1,8,47,''xl87'','''',2
1,1,'''',1,1,8,48,''xl87'','''',2
1,1,'''',1,1,8,49,''xl87'','''',2
1,1,'''',1,1,8,50,''xl87'','''',2
1,1,'''',1,1,8,51,''xl87'','''',2
1,1,'''',1,1,8,52,''xl22'','''',2
1,1,'''',1,1,8,53,''xl22'','''',2
1,1,'''',1,1,9,1,''xl47'','''',2
1,1,'''',1,1,9,2,''xl47'','''',2
1,1,'''',1,1,9,3,''xl47'','''',2
1,1,'''',1,1,9,4,''xl47'','''',2
1,1,'''',1,1,9,5,''xl47'','''',2
1,1,'''',1,1,9,6,''xl47'','''',2
1,1,'''',1,1,9,7,''xl47'','''',2
1,1,'''',1,1,9,8,''xl47'','''',2
1,1,'''',1,1,9,9,''xl47'','''',2
1,1,'''',1,1,9,10,''xl47'','''',2
1,1,'''',1,1,9,11,''xl47'','''',2
1,1,'''',1,1,9,12,''xl47'','''',2
1,1,'''',1,1,9,13,''xl47'','''',2
1,1,'''',1,1,9,14,''xl47'','''',2
1,1,'''',1,1,9,15,''xl47'','''',2
1,1,'''',1,1,9,16,''xl47'','''',2
1,1,'''',1,1,9,17,''xl47'','''',2
1,1,'''',1,1,9,18,''xl47'','''',2
1,1,'''',1,1,9,19,''xl47'','''',2
1,1,'''',1,1,9,20,''xl47'','''',2
1,1,'''',1,1,9,21,''xl47'','''',2
1,1,'''',1,1,9,22,''xl47'','''',2
1,1,'''',1,1,9,23,''xl47'','''',2
1,1,'''',1,1,9,24,''xl47'','''',2
1,1,'''',1,1,9,25,''xl47'','''',2
1,1,'''',1,1,9,26,''xl23'','''',2
1,1,'''',1,1,9,27,''xl47'','''',2
1,1,'''',1,1,9,28,''xl47'','''',2
1,1,'''',1,1,9,29,''xl47'','''',2
1,1,'''',1,1,9,30,''xl47'','''',2
1,1,'''',1,1,9,31,''xl47'','''',2
1,1,'''',1,1,9,32,''xl47'','''',2
1,1,'''',1,1,9,33,''xl22'','''',2
1,1,'''',1,1,9,34,''xl87'','''',2
1,1,'''',1,1,9,35,''xl87'','''',2
1,1,'''',1,1,9,36,''xl87'','''',2
1,1,'''',1,1,9,37,''xl87'','''',2
1,1,'''',1,1,9,38,''xl23'','''',2
1,1,'''',1,1,9,39,''xl22'','''',2
1,1,'''',1,1,9,40,''xl87'','''',2
1,1,'''',1,1,9,41,''xl87'','''',2
1,1,'''',1,1,9,42,''xl87'','''',2
1,1,'''',1,1,9,43,''xl87'','''',2
1,1,'''',1,1,9,44,''xl87'','''',2
1,1,'''',1,1,9,45,''xl87'','''',2
1,1,'''',1,1,9,46,''xl87'','''',2
1,1,'''',1,1,9,47,''xl87'','''',2
1,1,'''',1,1,9,48,''xl87'','''',2
1,1,'''',1,1,9,49,''xl87'','''',2
1,1,'''',1,1,9,50,''xl87'','''',2
1,1,'''',1,1,9,51,''xl87'','''',2
1,1,'''',1,1,9,52,''xl22'','''',2
1,1,'''',1,1,9,53,''xl22'','''',2
1,1,''        '',1,1,10,1,''xl23'','''',2
1,1,''$$select name from c_data1 where list=2#name#name#NN'',1,25,10,2,''xl85'','''',2
1,1,'''',1,1,10,27,''xl41'','''',2
1,1,'''',1,1,10,28,''xl41'','''',2
1,1,'''',1,1,10,29,''xl41'','''',2
1,1,'''',1,1,10,30,''xl41'','''',2
1,1,'''',1,1,10,31,''xl41'','''',2
1,1,'''',1,1,10,32,''xl41'','''',2
1,1,'''',1,1,10,33,''xl22'','''',2
1,1,'''',1,1,10,34,''xl87'','''',2
1,1,'''',1,1,10,35,''xl87'','''',2
1,1,'''',1,1,10,36,''xl87'','''',2
1,1,'''',1,1,10,37,''xl87'','''',2
1,1,'''',1,1,10,38,''xl84'','''',2
1,1,'''',1,1,10,39,''xl22'','''',2
1,1,'''',1,1,10,40,''xl87'','''',2
1,1,'''',1,1,10,41,''xl87'','''',2
1,1,'''',1,1,10,42,''xl87'','''',2
1,1,'''',1,1,10,43,''xl87'','''',2
1,1,'''',1,1,10,44,''xl87'','''',2
1,1,'''',1,1,10,45,''xl87'','''',2
1,1,'''',1,1,10,46,''xl87'','''',2
1,1,'''',1,1,10,47,''xl87'','''',2
1,1,'''',1,1,10,48,''xl87'','''',2
1,1,'''',1,1,10,49,''xl87'','''',2
1,1,'''',1,1,10,50,''xl87'','''',2
1,1,'''',1,1,10,51,''xl87'','''',2
1,1,'''',1,1,10,52,''xl22'','''',2
1,1,'''',1,1,10,53,''xl22'','''',2
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,26,11,1,''xl86'','''',2
1,1,'''',1,1,11,27,''xl41'','''',2
1,1,'''',1,1,11,28,''xl41'','''',2
1,1,'''',1,1,11,29,''xl41'','''',2
1,1,'''',1,1,11,30,''xl41'','''',2
1,1,'''',1,1,11,31,''xl41'','''',2
1,1,'''',1,1,11,32,''xl41'','''',2
1,1,'''',1,1,11,33,''xl41'','''',2
1,1,'''',1,1,11,34,''xl41'','''',2
1,1,'''',1,1,11,35,''xl41'','''',2
1,1,'''',1,1,11,36,''xl41'','''',2
1,1,'''',1,1,11,37,''xl41'','''',2
1,1,'''',1,1,11,38,''xl22'','''',2
1,1,'''',1,1,11,39,''xl22'','''',2
1,1,'''',1,1,11,40,''xl41'','''',2
1,1,'''',1,1,11,41,''xl41'','''',2
1,1,'''',1,1,11,42,''xl41'','''',2
1,1,'''',1,1,11,43,''xl41'','''',2
1,1,'''',1,1,11,44,''xl41'','''',2
1,1,'''',1,1,11,45,''xl41'','''',2
1,1,'''',1,1,11,46,''xl41'','''',2
1,1,'''',1,1,11,47,''xl41'','''',2
1,1,'''',1,1,11,48,''xl41'','''',2
1,1,'''',1,1,11,49,''xl41'','''',2
1,1,'''',1,1,11,50,''xl41'','''',2
1,1,'''',1,1,11,51,''xl41'','''',2
1,1,'''',1,1,11,52,''xl22'','''',2
1,1,'''',1,1,11,53,''xl22'','''',2
1,1,'''',1,1,12,1,''xl23'','''',2
1,1,'''',1,1,12,2,''xl32'','''',2
1,1,'''',1,1,12,3,''xl41'','''',2
1,1,'''',1,1,12,4,''xl41'','''',2
1,1,'''',1,1,12,5,''xl41'','''',2
1,1,'''',1,1,12,6,''xl41'','''',2
1,1,'''',1,1,12,7,''xl41'','''',2
1,1,'''',1,1,12,8,''xl41'','''',2
1,1,'''',1,1,12,9,''xl41'','''',2
1,1,'''',1,1,12,10,''xl105'','''',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 10, '1,1,'''',1,1,12,11,''xl105'','''',2
1,1,'''',1,1,12,12,''xl105'','''',2
1,1,'''',1,1,12,13,''xl41'','''',2
1,1,'''',1,1,12,14,''xl32'','''',2
1,1,'''',1,1,12,15,''xl41'','''',2
1,1,'''',1,1,12,16,''xl41'','''',2
1,1,'''',1,1,12,17,''xl41'','''',2
1,1,'''',1,1,12,18,''xl41'','''',2
1,1,'''',1,1,12,19,''xl41'','''',2
1,1,'''',1,1,12,20,''xl41'','''',2
1,1,'''',1,1,12,21,''xl41'','''',2
1,1,'''',1,1,12,22,''xl41'','''',2
1,1,'''',1,1,12,23,''xl41'','''',2
1,1,'''',1,1,12,24,''xl41'','''',2
1,1,'''',1,1,12,25,''xl41'','''',2
1,1,'''',1,1,12,26,''xl41'','''',2
1,1,'''',1,1,12,27,''xl41'','''',2
1,1,'''',1,1,12,28,''xl41'','''',2
1,1,'''',1,1,12,29,''xl41'','''',2
1,1,'''',1,1,12,30,''xl41'','''',2
1,1,'''',1,1,12,31,''xl41'','''',2
1,1,'''',1,1,12,32,''xl41'','''',2
1,1,'''',1,1,12,33,''xl41'','''',2
1,1,'''',1,1,12,34,''xl41'','''',2
1,1,'''',1,1,12,35,''xl41'','''',2
1,1,'''',1,1,12,36,''xl41'','''',2
1,1,'''',1,1,12,37,''xl41'','''',2
1,1,'''',1,1,12,38,''xl41'','''',2
1,1,'''',1,1,12,39,''xl41'','''',2
1,1,'''',1,1,12,40,''xl41'','''',2
1,1,'''',1,1,12,41,''xl41'','''',2
1,1,'''',1,1,12,42,''xl41'','''',2
1,1,'''',1,1,12,43,''xl41'','''',2
1,1,'''',1,1,12,44,''xl41'','''',2
1,1,'''',1,1,12,45,''xl41'','''',2
1,1,'''',1,1,12,46,''xl41'','''',2
1,1,'''',1,1,12,47,''xl41'','''',2
1,1,'''',1,1,12,48,''xl41'','''',2
1,1,'''',1,1,12,49,''xl41'','''',2
1,1,'''',1,1,12,50,''xl41'','''',2
1,1,'''',1,1,12,51,''xl41'','''',2
1,1,'''',1,1,12,52,''xl22'','''',2
1,1,'''',1,1,12,53,''xl22'','''',2
1,1,'' , chr(10) '',10,1,13,1,''xl93'','''',2
1,1,'' '',10,1,13,2,''xl95'','''',2
1,1,''      ,    '',2,10,13,3,''xl71'','''',2
1,1,''  ,  '',10,1,13,13,''xl115'','''',2
1,1,''    '',4,1,13,14,''xl116'','''',2
1,1,''       '',3,12,13,15,''xl71'','''',2
1,1,'' ..                 '',3,12,13,27,''xl71'','''',2
1,1,''    '',3,6,13,39,''xl71'','''',2
1,1,'' ..                 '',3,6,13,45,''xl71'','''',2
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,13,51,''xl119'','''',2
1,1,'''',1,1,13,52,''xl91'','''',2
1,1,'''',1,1,13,53,''xl91'','''',2
1,1,'''',1,1,14,52,''xl91'','''',2
1,1,'''',1,1,14,53,''xl91'','''',2
1,1,'' '',1,4,15,3,''xl51'','''',2
1,1,''>>>cText_35'',1,3,15,7,''xl51'','''',2
1,1,''  '',1,3,15,10,''xl51'','''',2
1,1,'''',1,1,15,52,''xl91'','''',2
1,1,'''',1,1,15,53,''xl91'','''',2
1,1,''&&select orders,name from c_data3 order by orders#name#orders#AA'',1,4,16,3,''xl51'','''',2
1,1,''&&select orders,name from c_data4 order by orders#name#orders#AA'',1,3,16,7,''xl51'','''',2
1,1,''&&select orders,name from c_data5 order by orders#name#orders#AA'',1,3,16,10,''xl51'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,16,15,''xl71'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,16,19,''xl71'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,16,21,''xl71'','''',2
1,1,'' '',1,4,16,23,''xl71'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,16,27,''xl71'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,16,31,''xl71'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,16,33,''xl71'','''',2
1,1,'' '',1,4,16,35,''xl71'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,16,39,''xl71'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,16,41,''xl71'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,16,43,''xl71'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,16,45,''xl71'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,16,47,''xl71'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,16,49,''xl71'','''',2
1,1,'''',1,1,16,52,''xl91'','''',2
1,1,'''',1,1,16,53,''xl91'','''',2
1,1,'',   '',6,1,17,3,''xl98'','''',2
1,1,''&&select vip from c_data3 where orders=AA#vip#vip#CC'',6,1,17,4,''xl99'','''',2
1,1,''   ,  '',6,1,17,5,''xl100'','''',2
1,1,''&&select code from c_data3 where orders=AA#code#code#CC'',6,1,17,6,''xl101'','''',2
1,1,'',   '',6,1,17,7,''xl102'','''',2
1,1,''&&select vip from c_data4 where orders=AA#vip#vip#CC'',6,1,17,8,''xl103'','''',2
1,1,''   ,  '',6,1,17,9,''xl104'','''',2
1,1,''>>>(nCheck_16=1;",   ";"#/")'',6,1,17,10,''xl106'','''',2
1,1,''>>>(nCheck_16=1;"  (),  ()";"#/")'',6,1,17,11,''xl111'','''',2
1,1,''>>>(nCheck_16=1;"   ,  ";"#/")'',6,1,17,12,''xl112'','''',2
1,1,''/'',6,1,17,14,''xl117'','''',2
1,1,'''',1,2,17,15,''xl71'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,17,17,''xl71'','''',2
1,1,'''',6,1,17,19,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,20,''xl80'','''',2
1,1,'''',6,1,17,21,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,22,''xl80'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,17,23,''xl82'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,17,25,''xl82'','''',2
1,1,'''',1,2,17,27,''xl71'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,17,29,''xl71'','''',2
1,1,'''',6,1,17,31,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,32,''xl80'','''',2
1,1,'''',6,1,17,33,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,34,''xl80'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,17,35,''xl82'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,17,37,''xl82'','''',2
1,1,'''',6,1,17,39,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,40,''xl80'','''',2
1,1,'''',6,1,17,41,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,42,''xl80'','''',2
1,1,'''',6,1,17,43,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,44,''xl80'','''',2
1,1,'''',6,1,17,45,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,46,''xl80'','''',2
1,1,'''',6,1,17,47,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,48,''xl80'','''',2
1,1,'''',6,1,17,49,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,17,50,''xl80'','''',2
1,1,'''',1,1,17,52,''xl91'','''',2
1,1,'''',1,1,17,53,''xl91'','''',2
1,1,''  '',5,1,18,15,''xl80'','''',2
1,1,'''',5,1,18,16,''xl80'','''',2
1,1,''  '',5,1,18,17,''xl80'','''',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 11, '1,1,'''',5,1,18,18,''xl80'','''',2
1,1,'''',5,1,18,23,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,18,24,''xl80'','''',2
1,1,'''',5,1,18,25,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,18,26,''xl80'','''',2
1,1,''  '',5,1,18,27,''xl80'','''',2
1,1,'''',5,1,18,28,''xl80'','''',2
1,1,''  '',5,1,18,29,''xl80'','''',2
1,1,'''',5,1,18,30,''xl80'','''',2
1,1,'''',5,1,18,35,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,18,36,''xl80'','''',2
1,1,'''',5,1,18,37,''xl80'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,18,38,''xl80'','''',2
1,1,'''',1,1,18,52,''xl91'','''',2
1,1,'''',1,1,18,53,''xl91'','''',2
1,1,'''',1,1,19,52,''xl91'','''',2
1,1,'''',1,1,19,53,''xl91'','''',2
1,1,'''',1,1,20,52,''xl91'','''',2
1,1,'''',1,1,20,53,''xl91'','''',2
1,1,'''',1,1,21,52,''xl91'','''',2
1,1,'''',1,1,21,53,''xl91'','''',2
1,1,'''',1,1,22,52,''xl91'','''',2
1,1,'''',1,1,22,53,''xl91'','''',2
1,2,''    ,    '',1,1,1,1,''xl27'','''',2
1,2,''11800'',1,1,1,2,''xl43'','''',2
1,2,'''',1,1,1,3,''xl43'','''',2
1,2,'''',1,1,1,4,''xl43'','''',2
1,2,'''',1,1,1,5,''xl43'','''',2
1,2,'''',1,1,1,6,''xl43'','''',2
1,2,'''',1,1,1,7,''xl43'','''',2
1,2,'''',1,1,1,8,''xl43'','''',2
1,2,'''',1,1,1,9,''xl43'','''',2
1,2,'''',1,1,1,10,''xl107'','''',2
1,2,'''',1,1,1,11,''xl107'','''',2
1,2,'''',1,1,1,12,''xl107'','''',2
1,2,'''',1,1,1,13,''xl43'','''',2
1,2,'''',1,1,1,14,''xl43'','''',2
1,2,''>>2(<npog>;1;<list>;2;<s_1>)'',1,1,1,15,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_2>)'',1,1,1,16,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_1>)'',1,1,1,17,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_2>)'',1,1,1,18,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_3>)'',1,1,1,19,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_3>)'',1,1,1,20,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_4>)'',1,1,1,21,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_4>)'',1,1,1,22,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_5>)'',1,1,1,23,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_5>)'',1,1,1,24,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_6>)'',1,1,1,25,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_6>)'',1,1,1,26,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_1>)'',1,1,1,27,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_2>)'',1,1,1,28,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_1>)'',1,1,1,29,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_2>)'',1,1,1,30,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_3>)'',1,1,1,31,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_3>)'',1,1,1,32,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_4>)'',1,1,1,33,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_4>)'',1,1,1,34,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_5>)'',1,1,1,35,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_5>)'',1,1,1,36,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_6>)'',1,1,1,37,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_6>)'',1,1,1,38,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_7>)'',1,1,1,39,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_7>)'',1,1,1,40,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_8>)'',1,1,1,41,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_8>)'',1,1,1,42,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_9>)'',1,1,1,43,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_9>)'',1,1,1,44,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_7>)'',1,1,1,45,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_7>)'',1,1,1,46,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_8>)'',1,1,1,47,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_8>)'',1,1,1,48,''xl67'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_9>)'',1,1,1,49,''xl67'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_9>)'',1,1,1,50,''xl67'',''"#,##0.00"'',2
1,2,'''',1,1,1,51,''xl107'','''',2
1,2,'''',1,1,1,52,''xl22'','''',2
1,2,'''',1,1,1,53,''xl22'','''',2
1,2,''     '',1,1,2,1,''xl94'','''',2
1,2,''11900'',1,1,2,2,''xl97'','''',2
1,2,'''',1,1,2,3,''xl97'','''',2
1,2,'''',1,1,2,4,''xl97'','''',2
1,2,'''',1,1,2,5,''xl97'','''',2
1,2,'''',1,1,2,6,''xl97'','''',2
1,2,'''',1,1,2,7,''xl97'','''',2
1,2,'''',1,1,2,8,''xl97'','''',2
1,2,'''',1,1,2,9,''xl97'','''',2
1,2,'''',1,1,2,10,''xl109'','''',2
1,2,'''',1,1,2,11,''xl109'','''',2
1,2,'''',1,1,2,12,''xl109'','''',2
1,2,'''',1,1,2,13,''xl97'','''',2
1,2,'''',1,1,2,14,''xl97'','''',2
1,2,''>>(<list>;2;<s_1>)'',1,1,2,15,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_2>)'',1,1,2,16,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_1>)'',1,1,2,17,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_2>)'',1,1,2,18,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_3>)'',1,1,2,19,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_3>)'',1,1,2,20,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_4>)'',1,1,2,21,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_4>)'',1,1,2,22,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_5>)'',1,1,2,23,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_5>)'',1,1,2,24,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_6>)'',1,1,2,25,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_6>)'',1,1,2,26,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_1>)'',1,1,2,27,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_2>)'',1,1,2,28,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_1>)'',1,1,2,29,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_2>)'',1,1,2,30,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_3>)'',1,1,2,31,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_3>)'',1,1,2,32,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_4>)'',1,1,2,33,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_4>)'',1,1,2,34,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_5>)'',1,1,2,35,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_5>)'',1,1,2,36,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_6>)'',1,1,2,37,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_6>)'',1,1,2,38,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_7>)'',1,1,2,39,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_7>)'',1,1,2,40,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_8>)'',1,1,2,41,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_8>)'',1,1,2,42,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_9>)'',1,1,2,43,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_9>)'',1,1,2,44,''xl118'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 12, '1,2,''>>(<list>;2;<k_7>)'',1,1,2,45,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_7>)'',1,1,2,46,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_8>)'',1,1,2,47,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_8>)'',1,1,2,48,''xl118'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_9>)'',1,1,2,49,''xl118'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_9>)'',1,1,2,50,''xl118'',''"#,##0.00"'',2
1,2,'''',1,1,2,51,''xl109'','''',2
1,2,'''',1,1,2,52,''xl22'','''',2
1,2,'''',1,1,2,53,''xl22'','''',2
1,2,'''',1,1,3,1,''xl30'','''',2
1,2,'''',1,1,3,2,''xl39'','''',2
1,2,'''',1,1,3,3,''xl47'','''',2
1,2,'''',1,1,3,4,''xl47'','''',2
1,2,'''',1,1,3,5,''xl47'','''',2
1,2,'''',1,1,3,6,''xl47'','''',2
1,2,'''',1,1,3,7,''xl47'','''',2
1,2,'''',1,1,3,8,''xl47'','''',2
1,2,'''',1,1,3,9,''xl47'','''',2
1,2,'''',1,1,3,10,''xl47'','''',2
1,2,'''',1,1,3,11,''xl47'','''',2
1,2,'''',1,1,3,12,''xl47'','''',2
1,2,'''',1,1,3,13,''xl47'','''',2
1,2,'''',1,1,3,14,''xl39'','''',2
1,2,'''',1,1,3,15,''xl65'','''',2
1,2,'''',1,1,3,16,''xl65'','''',2
1,2,'''',1,1,3,17,''xl65'','''',2
1,2,'''',1,1,3,18,''xl65'','''',2
1,2,'''',1,1,3,19,''xl65'','''',2
1,2,'''',1,1,3,20,''xl65'','''',2
1,2,'''',1,1,3,21,''xl65'','''',2
1,2,'''',1,1,3,22,''xl65'','''',2
1,2,'''',1,1,3,23,''xl65'','''',2
1,2,'''',1,1,3,24,''xl65'','''',2
1,2,'''',1,1,3,25,''xl65'','''',2
1,2,'''',1,1,3,26,''xl65'','''',2
1,2,'''',1,1,3,27,''xl65'','''',2
1,2,'''',1,1,3,28,''xl65'','''',2
1,2,'''',1,1,3,29,''xl65'','''',2
1,2,'''',1,1,3,30,''xl65'','''',2
1,2,'''',1,1,3,31,''xl65'','''',2
1,2,'''',1,1,3,32,''xl65'','''',2
1,2,'''',1,1,3,33,''xl65'','''',2
1,2,'''',1,1,3,34,''xl65'','''',2
1,2,'''',1,1,3,35,''xl65'','''',2
1,2,'''',1,1,3,36,''xl65'','''',2
1,2,'''',1,1,3,37,''xl65'','''',2
1,2,'''',1,1,3,38,''xl65'','''',2
1,2,'''',1,1,3,39,''xl65'','''',2
1,2,'''',1,1,3,40,''xl65'','''',2
1,2,'''',1,1,3,41,''xl65'','''',2
1,2,'''',1,1,3,42,''xl65'','''',2
1,2,'''',1,1,3,43,''xl65'','''',2
1,2,'''',1,1,3,44,''xl65'','''',2
1,2,'''',1,1,3,45,''xl65'','''',2
1,2,'''',1,1,3,46,''xl65'','''',2
1,2,'''',1,1,3,47,''xl65'','''',2
1,2,'''',1,1,3,48,''xl65'','''',2
1,2,'''',1,1,3,49,''xl65'','''',2
1,2,'''',1,1,3,50,''xl65'','''',2
1,2,'''',1,1,3,51,''xl65'','''',2
1,2,'''',1,1,3,52,''xl22'','''',2
1,2,'''',1,1,3,53,''xl22'','''',2
1,2,''>>>Footer'',1,51,4,1,''xl31'','''',2
1,2,'''',1,1,4,52,''xl22'','''',2
1,2,'''',1,1,4,53,''xl22'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl25'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,3,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,4,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,5,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)"&("CC"="#/";"";"+1")'',1,1,1,6,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,7,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,8,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,9,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+"&(nCheck_16;"0")'',1,1,1,10,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+"&(nCheck_16;"0")'',1,1,1,11,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+"&(nCheck_16;"0")'',1,1,1,12,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-"&(nCheck_16=1;"1";"4")&"]"&(34)&";)+1"'',1,1,1,13,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,14,''xl63'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,15,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,16,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,17,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,18,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,19,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,20,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,21,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,22,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,23,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,24,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,25,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,26,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,27,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,28,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,29,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,30,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,31,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,32,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,33,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,34,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,35,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,36,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,37,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,38,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,39,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,40,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,41,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,42,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,43,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,44,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,45,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,46,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,47,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,48,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,49,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,50,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,51,''xl25'','''',2
2,1,'''',1,1,1,52,''xl22'','''',2
2,1,'''',1,1,1,53,''xl22'','''',2
3,1,''>>>{po5_n}'',1,1,1,1,''xl27'','''',2
3,1,''>>>{cpo5}'',1,1,1,2,''xl34'','''',2
3,1,'''',1,1,1,3,''xl43'','''',2
3,1,'''',1,1,1,4,''xl43'','''',2
3,1,'''',1,1,1,5,''xl43'','''',2
3,1,'''',1,1,1,6,''xl43'','''',2
3,1,'''',1,1,1,7,''xl43'','''',2
3,1,'''',1,1,1,8,''xl43'','''',2
3,1,'''',1,1,1,9,''xl43'','''',2
3,1,'''',1,1,1,10,''xl107'','''',2
3,1,'''',1,1,1,11,''xl107'','''',2
3,1,'''',1,1,1,12,''xl107'','''',2
3,1,''>>>{cpo5g}'',1,1,1,13,''xl34'','''',2
3,1,'''',1,1,1,14,''xl43'','''',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 13, '3,1,''>>(<s_1>)'',1,1,1,15,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_2>)'',1,1,1,16,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_3>)'',1,1,1,19,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_4>)'',1,1,1,21,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_5>)'',1,1,1,23,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_6>)'',1,1,1,25,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_1>)'',1,1,1,27,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_2>)'',1,1,1,28,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_3>)'',1,1,1,31,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_4>)'',1,1,1,33,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_5>)'',1,1,1,35,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_6>)'',1,1,1,37,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_7>)'',1,1,1,39,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_8>)'',1,1,1,41,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl67'',''"#,##0.00"'',2
3,1,''>>(<s_9>)'',1,1,1,43,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_7>)'',1,1,1,45,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_8>)'',1,1,1,47,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl67'',''"#,##0.00"'',2
3,1,''>>(<k_9>)'',1,1,1,49,''xl67'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl67'',''"#,##0.00"'',2
3,1,'''',1,1,1,51,''xl43'','''',2
3,1,'''',1,1,1,52,''xl22'','''',2
3,1,'''',1,1,1,53,''xl22'','''',2
4,1,''>>>{po4_n}'',1,1,1,1,''xl27'','''',2
4,1,''>>>{cpo4}'',1,1,1,2,''xl34'','''',2
4,1,'''',1,1,1,3,''xl43'','''',2
4,1,'''',1,1,1,4,''xl43'','''',2
4,1,'''',1,1,1,5,''xl43'','''',2
4,1,'''',1,1,1,6,''xl43'','''',2
4,1,'''',1,1,1,7,''xl43'','''',2
4,1,'''',1,1,1,8,''xl43'','''',2
4,1,'''',1,1,1,9,''xl43'','''',2
4,1,'''',1,1,1,10,''xl107'','''',2
4,1,'''',1,1,1,11,''xl107'','''',2
4,1,'''',1,1,1,12,''xl107'','''',2
4,1,''>>>{cpo4g}'',1,1,1,13,''xl34'','''',2
4,1,'''',1,1,1,14,''xl43'','''',2
4,1,''>>(<s_1>)'',1,1,1,15,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_2>)'',1,1,1,16,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_3>)'',1,1,1,19,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_4>)'',1,1,1,21,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_5>)'',1,1,1,23,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_6>)'',1,1,1,25,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_1>)'',1,1,1,27,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_2>)'',1,1,1,28,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_3>)'',1,1,1,31,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_4>)'',1,1,1,33,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_5>)'',1,1,1,35,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_6>)'',1,1,1,37,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_7>)'',1,1,1,39,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_8>)'',1,1,1,41,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl67'',''"#,##0.00"'',2
4,1,''>>(<s_9>)'',1,1,1,43,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_7>)'',1,1,1,45,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_8>)'',1,1,1,47,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl67'',''"#,##0.00"'',2
4,1,''>>(<k_9>)'',1,1,1,49,''xl67'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl67'',''"#,##0.00"'',2
4,1,'''',1,1,1,51,''xl43'','''',2
4,1,'''',1,1,1,52,''xl22'','''',2
4,1,'''',1,1,1,53,''xl22'','''',2
5,1,''>>>{po3_n}'',1,1,1,1,''xl27'','''',2
5,1,''>>>{cpo3}'',1,1,1,2,''xl34'','''',2
5,1,'''',1,1,1,3,''xl43'','''',2
5,1,'''',1,1,1,4,''xl43'','''',2
5,1,'''',1,1,1,5,''xl43'','''',2
5,1,'''',1,1,1,6,''xl43'','''',2
5,1,'''',1,1,1,7,''xl43'','''',2
5,1,'''',1,1,1,8,''xl43'','''',2
5,1,'''',1,1,1,9,''xl43'','''',2
5,1,'''',1,1,1,10,''xl107'','''',2
5,1,'''',1,1,1,11,''xl107'','''',2
5,1,'''',1,1,1,12,''xl107'','''',2
5,1,''>>>{cpo3g}'',1,1,1,13,''xl34'','''',2
5,1,'''',1,1,1,14,''xl43'','''',2
5,1,''>>(<s_1>)'',1,1,1,15,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_2>)'',1,1,1,16,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_3>)'',1,1,1,19,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_4>)'',1,1,1,21,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_5>)'',1,1,1,23,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_6>)'',1,1,1,25,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_1>)'',1,1,1,27,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_2>)'',1,1,1,28,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_3>)'',1,1,1,31,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_4>)'',1,1,1,33,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_5>)'',1,1,1,35,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_6>)'',1,1,1,37,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_7>)'',1,1,1,39,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_8>)'',1,1,1,41,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl67'',''"#,##0.00"'',2
5,1,''>>(<s_9>)'',1,1,1,43,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_7>)'',1,1,1,45,''xl67'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 14, '5,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_8>)'',1,1,1,47,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl67'',''"#,##0.00"'',2
5,1,''>>(<k_9>)'',1,1,1,49,''xl67'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl67'',''"#,##0.00"'',2
5,1,'''',1,1,1,51,''xl43'','''',2
5,1,'''',1,1,1,52,''xl22'','''',2
5,1,'''',1,1,1,53,''xl22'','''',2
6,1,''>>>{po2_n}'',1,1,1,1,''xl27'','''',2
6,1,''>>>{cpo2}'',1,1,1,2,''xl34'','''',2
6,1,'''',1,1,1,3,''xl43'','''',2
6,1,'''',1,1,1,4,''xl43'','''',2
6,1,'''',1,1,1,5,''xl43'','''',2
6,1,'''',1,1,1,6,''xl43'','''',2
6,1,'''',1,1,1,7,''xl43'','''',2
6,1,'''',1,1,1,8,''xl43'','''',2
6,1,'''',1,1,1,9,''xl43'','''',2
6,1,'''',1,1,1,10,''xl107'','''',2
6,1,'''',1,1,1,11,''xl107'','''',2
6,1,'''',1,1,1,12,''xl107'','''',2
6,1,''>>>{cpo2g}'',1,1,1,13,''xl34'','''',2
6,1,'''',1,1,1,14,''xl43'','''',2
6,1,''>>(<s_1>)'',1,1,1,15,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_2>)'',1,1,1,16,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_3>)'',1,1,1,19,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_4>)'',1,1,1,21,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_5>)'',1,1,1,23,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_6>)'',1,1,1,25,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_1>)'',1,1,1,27,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_2>)'',1,1,1,28,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_3>)'',1,1,1,31,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_4>)'',1,1,1,33,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_5>)'',1,1,1,35,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_6>)'',1,1,1,37,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_7>)'',1,1,1,39,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_8>)'',1,1,1,41,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl67'',''"#,##0.00"'',2
6,1,''>>(<s_9>)'',1,1,1,43,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_7>)'',1,1,1,45,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_8>)'',1,1,1,47,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl67'',''"#,##0.00"'',2
6,1,''>>(<k_9>)'',1,1,1,49,''xl67'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl67'',''"#,##0.00"'',2
6,1,'''',1,1,1,51,''xl43'','''',2
6,1,'''',1,1,1,52,''xl22'','''',2
6,1,'''',1,1,1,53,''xl22'','''',2
7,1,''>>>{po1_n}'',1,1,1,1,''xl27'','''',2
7,1,''>>>{cpo1}'',1,1,1,2,''xl34'','''',2
7,1,'''',1,1,1,3,''xl43'','''',2
7,1,'''',1,1,1,4,''xl43'','''',2
7,1,'''',1,1,1,5,''xl43'','''',2
7,1,'''',1,1,1,6,''xl43'','''',2
7,1,'''',1,1,1,7,''xl43'','''',2
7,1,'''',1,1,1,8,''xl43'','''',2
7,1,'''',1,1,1,9,''xl43'','''',2
7,1,'''',1,1,1,10,''xl107'','''',2
7,1,'''',1,1,1,11,''xl107'','''',2
7,1,'''',1,1,1,12,''xl107'','''',2
7,1,''>>>{cpo1g}'',1,1,1,13,''xl34'','''',2
7,1,'''',1,1,1,14,''xl43'','''',2
7,1,''>>(<s_1>)'',1,1,1,15,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_2>)'',1,1,1,16,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_3>)'',1,1,1,19,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_4>)'',1,1,1,21,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_5>)'',1,1,1,23,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_6>)'',1,1,1,25,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_1>)'',1,1,1,27,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_2>)'',1,1,1,28,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_3>)'',1,1,1,31,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_4>)'',1,1,1,33,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_5>)'',1,1,1,35,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_6>)'',1,1,1,37,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_7>)'',1,1,1,39,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_8>)'',1,1,1,41,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl67'',''"#,##0.00"'',2
7,1,''>>(<s_9>)'',1,1,1,43,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_7>)'',1,1,1,45,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_8>)'',1,1,1,47,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl67'',''"#,##0.00"'',2
7,1,''>>(<k_9>)'',1,1,1,49,''xl67'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl67'',''"#,##0.00"'',2
7,1,'''',1,1,1,51,''xl43'','''',2
7,1,'''',1,1,1,52,''xl22'','''',2
7,1,'''',1,1,1,53,''xl22'','''',2
8,1,''>>>nvl({po_n};" ")&"\"'',1,1,1,1,''xl28'','''',2
8,1,''>>>nvl({cpo};" ")&"\"'',1,1,1,2,''xl36'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<nam_1>)'',1,1,1,3,''xl45'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<res_1>)'',1,1,1,4,''xl45'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<dat_1>)'',1,1,1,5,''xl45'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<cod_1>)'',1,1,1,6,''xl45'','''',2
8,1,''>>>2(<lev2>;AA;<st>;1;<nam_2>)'',1,1,1,7,''xl45'','''',2
8,1,''>>>2(<lev2>;AA;<st>;1;<res_2>)'',1,1,1,8,''xl45'','''',2
8,1,''>>>2(<lev2>;AA;<st>;1;<dat_2>)'',1,1,1,9,''xl58'','''',2
8,1,''>>>2(<lev3>;AA;<st>;1;<nam_3>)'',1,1,1,10,''xl108'','''',2
8,1,''>>>2(<lev3>;AA;<st>;1;<res_3>)'',1,1,1,11,''xl108'','''',2
8,1,''>>>2(<lev3>;AA;<st>;1;<dat_3>)'',1,1,1,12,''xl113'','''',2
8,1,''>>nvl({cpog};" ")&"\"'',1,1,1,13,''xl60'','''',2
8,1,''>>>(<lev>;1;<cdiv>)&"\"'',1,1,1,14,''xl64'','''',2
8,1,''>>(<s_1>)'',1,1,1,15,''xl69'',''"#,##0.00"'',2
8,1,''>>(<s_2>)'',1,1,1,16,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl69'',''"#,##0.00"'',2
8,1,''>>(<s_3>)'',1,1,1,19,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl69'',''"#,##0.00"'',2
8,1,''>>(<s_4>)'',1,1,1,21,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl69'',''"#,##0.00"'',2
8,1,''>>(<s_5>)'',1,1,1,23,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl69'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 15, '8,1,''>>(<s_6>)'',1,1,1,25,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_1>)'',1,1,1,27,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_2>)'',1,1,1,28,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_3>)'',1,1,1,31,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_4>)'',1,1,1,33,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_5>)'',1,1,1,35,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_6>)'',1,1,1,37,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl69'',''"#,##0.00"'',2
8,1,''>>(<s_7>)'',1,1,1,39,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl69'',''"#,##0.00"'',2
8,1,''>>(<s_8>)'',1,1,1,41,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl69'',''"#,##0.00"'',2
8,1,''>>(<s_9>)'',1,1,1,43,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_7>)'',1,1,1,45,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_8>)'',1,1,1,47,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl69'',''"#,##0.00"'',2
8,1,''>>(<k_9>)'',1,1,1,49,''xl69'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl69'',''"#,##0.00"'',2
8,1,''>>>(<lev>;1;<metod>)&"\"'',1,1,1,51,''xl36'','''',2
8,1,''>>st'',1,1,1,52,''xl92'','''',2
8,1,'''',1,1,1,53,''xl22'','''',2
9,1,''\'',1,1,1,1,''xl28'','''',2
9,1,''\'',1,1,1,2,''xl36'','''',2
9,1,''>>>(<lev1>;AA;<nam_1>)'',1,1,1,3,''xl45'','''',2
9,1,''>>>(<lev1>;AA;<res_1>)'',1,1,1,4,''xl45'','''',2
9,1,''>>>(<lev1>;AA;<dat_1>)'',1,1,1,5,''xl45'','''',2
9,1,''>>>(<lev1>;AA;<cod_1>)'',1,1,1,6,''xl45'','''',2
9,1,''>>>(<lev2>;AA;<nam_2>)'',1,1,1,7,''xl45'','''',2
9,1,''>>>(<lev2>;AA;<res_2>)'',1,1,1,8,''xl45'','''',2
9,1,''>>>(<lev2>;AA;<dat_2>)'',1,1,1,9,''xl58'','''',2
9,1,''>>>{nam_3}'',1,1,1,10,''xl108'','''',2
9,1,''>>>{res_3}'',1,1,1,11,''xl108'','''',2
9,1,''>>>{dat_3}'',1,1,1,12,''xl113'','''',2
9,1,''\'',1,1,1,13,''xl60'','''',2
9,1,''\'',1,1,1,14,''xl64'','''',2
9,1,'''',1,1,1,15,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,16,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,17,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,18,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,19,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,20,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,21,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,22,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,23,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,24,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,25,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,26,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,27,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,28,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,29,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,30,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,31,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,32,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,33,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,34,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,35,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,36,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,37,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,38,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,39,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,40,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,41,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,42,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,43,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,44,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,45,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,46,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,47,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,48,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,49,''xl69'',''"#,##0.00"'',2
9,1,'''',1,1,1,50,''xl69'',''"#,##0.00"'',2
9,1,''\'',1,1,1,51,''xl36'','''',2
9,1,''>>st'',1,1,1,52,''xl92'','''',2
9,1,'''',1,1,1,53,''xl22'','''',2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 16, '1,1,'''',1,1,1,1,''xl22'','''',3
1,1,'''',1,1,1,2,''xl22'','''',3
1,1,'''',1,1,1,3,''xl22'','''',3
1,1,'''',1,1,1,4,''xl22'','''',3
1,1,'''',1,1,1,5,''xl22'','''',3
1,1,'''',1,1,1,6,''xl22'','''',3
1,1,'''',1,1,1,7,''xl22'','''',3
1,1,'''',1,1,1,8,''xl22'','''',3
1,1,'''',1,1,1,9,''xl22'','''',3
1,1,'''',1,1,1,10,''xl22'','''',3
1,1,'''',1,1,1,11,''xl22'','''',3
1,1,'''',1,1,1,12,''xl22'','''',3
1,1,'''',1,1,1,13,''xl22'','''',3
1,1,'''',1,1,1,14,''xl22'','''',3
1,1,'''',1,1,1,15,''xl22'','''',3
1,1,'''',1,1,1,16,''xl22'','''',3
1,1,'''',1,1,1,17,''xl22'','''',3
1,1,'''',1,1,1,18,''xl22'','''',3
1,1,'''',1,1,1,19,''xl22'','''',3
1,1,'''',1,1,1,20,''xl22'','''',3
1,1,'''',1,1,1,21,''xl83'','''',3
1,1,'''',1,1,1,22,''xl83'','''',3
1,1,'''',1,1,1,23,''xl83'','''',3
1,1,'''',1,1,1,24,''xl83'','''',3
1,1,'''',1,1,1,25,''xl83'','''',3
1,1,'''',1,1,1,26,''xl83'','''',3
1,1,'''',1,1,1,27,''xl83'','''',3
1,1,'''',1,1,1,28,''xl83'','''',3
1,1,'''',1,1,1,29,''xl83'','''',3
1,1,'''',1,1,1,30,''xl83'','''',3
1,1,'''',1,1,1,31,''xl83'','''',3
1,1,'''',1,1,1,32,''xl22'','''',3
1,1,'''',1,1,1,33,''xl87'','''',3
1,1,'''',1,1,1,34,''xl87'','''',3
1,1,'''',1,1,1,35,''xl87'','''',3
1,1,'''',1,1,1,36,''xl87'','''',3
1,1,'''',1,1,1,37,''xl87'','''',3
1,1,'''',1,1,1,38,''xl87'','''',3
1,1,'''',1,1,1,39,''xl23'','''',3
1,1,'''',1,1,1,40,''xl23'','''',3
1,1,'''',1,1,1,41,''xl22'','''',3
1,1,'''',1,1,1,42,''xl87'','''',3
1,1,'''',1,1,1,43,''xl87'','''',3
1,1,'''',1,1,1,44,''xl87'','''',3
1,1,'''',1,1,1,45,''xl87'','''',3
1,1,'''',1,1,1,46,''xl87'','''',3
1,1,'''',1,1,1,47,''xl87'','''',3
1,1,'''',1,1,1,48,''xl87'','''',3
1,1,'''',1,1,1,49,''xl87'','''',3
1,1,'''',1,1,1,50,''xl87'','''',3
1,1,'''',1,1,1,51,''xl87'','''',3
1,1,'''',1,1,1,52,''xl87'','''',3
1,1,'''',1,1,1,53,''xl87'','''',3
1,1,'''',1,1,1,54,''xl87'','''',3
1,1,'''',1,1,1,55,''xl87'','''',3
1,1,'''',1,1,1,56,''xl87'','''',3
1,1,'''',1,1,1,57,''xl87'','''',3
1,1,'''',1,1,1,58,''xl87'','''',3
1,1,'''',1,1,1,59,''xl87'','''',3
1,1,''>>"#/"'',1,1,1,60,''xl90'','''',3
1,1,'''',1,1,1,61,''xl22'','''',3
1,1,'' '',1,19,2,1,''xl81'','''',3
1,1,'''',1,1,2,20,''xl22'','''',3
1,1,'''',1,1,2,21,''xl83'','''',3
1,1,'''',1,1,2,22,''xl83'','''',3
1,1,'''',1,1,2,23,''xl83'','''',3
1,1,'''',1,1,2,24,''xl83'','''',3
1,1,'''',1,1,2,25,''xl83'','''',3
1,1,'''',1,1,2,26,''xl83'','''',3
1,1,'''',1,1,2,27,''xl83'','''',3
1,1,'''',1,1,2,28,''xl83'','''',3
1,1,'''',1,1,2,29,''xl83'','''',3
1,1,'''',1,1,2,30,''xl83'','''',3
1,1,'''',1,1,2,31,''xl83'','''',3
1,1,'''',1,1,2,32,''xl22'','''',3
1,1,'''',1,1,2,33,''xl87'','''',3
1,1,'''',1,1,2,34,''xl87'','''',3
1,1,'''',1,1,2,35,''xl87'','''',3
1,1,'''',1,1,2,36,''xl87'','''',3
1,1,'''',1,1,2,37,''xl87'','''',3
1,1,'''',1,1,2,38,''xl87'','''',3
1,1,'''',1,1,2,39,''xl23'','''',3
1,1,'''',1,1,2,40,''xl23'','''',3
1,1,'''',1,1,2,41,''xl22'','''',3
1,1,'''',1,1,2,42,''xl87'','''',3
1,1,'''',1,1,2,43,''xl87'','''',3
1,1,'''',1,1,2,44,''xl87'','''',3
1,1,'''',1,1,2,45,''xl87'','''',3
1,1,'''',1,1,2,46,''xl87'','''',3
1,1,'''',1,1,2,47,''xl87'','''',3
1,1,'''',1,1,2,48,''xl87'','''',3
1,1,'''',1,1,2,49,''xl87'','''',3
1,1,'''',1,1,2,50,''xl87'','''',3
1,1,'''',1,1,2,51,''xl87'','''',3
1,1,'''',1,1,2,52,''xl87'','''',3
1,1,'''',1,1,2,53,''xl87'','''',3
1,1,'''',1,1,2,54,''xl87'','''',3
1,1,'''',1,1,2,55,''xl87'','''',3
1,1,'''',1,1,2,56,''xl87'','''',3
1,1,'''',1,1,2,57,''xl87'','''',3
1,1,'''',1,1,2,58,''xl87'','''',3
1,1,'''',1,1,2,59,''xl87'','''',3
1,1,'''',1,1,2,60,''xl22'','''',3
1,1,'''',1,1,2,61,''xl22'','''',3
1,1,''     '',1,19,3,1,''xl81'','''',3
1,1,'''',1,1,3,20,''xl83'','''',3
1,1,'''',1,1,3,21,''xl76'','''',3
1,1,'''',1,1,3,22,''xl76'','''',3
1,1,'''',1,1,3,23,''xl76'','''',3
1,1,'''',1,1,3,24,''xl76'','''',3
1,1,'''',1,1,3,25,''xl76'','''',3
1,1,'''',1,1,3,26,''xl76'','''',3
1,1,'''',1,1,3,27,''xl76'','''',3
1,1,'''',1,1,3,28,''xl76'','''',3
1,1,'''',1,1,3,29,''xl76'','''',3
1,1,'''',1,1,3,30,''xl76'','''',3
1,1,'''',1,1,3,31,''xl76'','''',3
1,1,'''',1,1,3,32,''xl22'','''',3
1,1,'''',1,1,3,33,''xl87'','''',3
1,1,'''',1,1,3,34,''xl87'','''',3
1,1,'''',1,1,3,35,''xl87'','''',3
1,1,'''',1,1,3,36,''xl87'','''',3
1,1,'''',1,1,3,37,''xl87'','''',3
1,1,'''',1,1,3,38,''xl87'','''',3
1,1,'''',1,1,3,39,''xl23'','''',3
1,1,'''',1,1,3,40,''xl23'','''',3
1,1,'''',1,1,3,41,''xl22'','''',3
1,1,'''',1,1,3,42,''xl87'','''',3
1,1,'''',1,1,3,43,''xl87'','''',3
1,1,'''',1,1,3,44,''xl87'','''',3
1,1,'''',1,1,3,45,''xl87'','''',3
1,1,'''',1,1,3,46,''xl87'','''',3
1,1,'''',1,1,3,47,''xl87'','''',3
1,1,'''',1,1,3,48,''xl87'','''',3
1,1,'''',1,1,3,49,''xl87'','''',3
1,1,'''',1,1,3,50,''xl87'','''',3
1,1,'''',1,1,3,51,''xl87'','''',3
1,1,'''',1,1,3,52,''xl87'','''',3
1,1,'''',1,1,3,53,''xl87'','''',3
1,1,'''',1,1,3,54,''xl87'','''',3
1,1,'''',1,1,3,55,''xl87'','''',3
1,1,'''',1,1,3,56,''xl87'','''',3
1,1,'''',1,1,3,57,''xl87'','''',3
1,1,'''',1,1,3,58,''xl87'','''',3
1,1,'''',1,1,3,59,''xl87'','''',3
1,1,'''',1,1,3,60,''xl22'','''',3
1,1,'''',1,1,3,61,''xl22'','''',3
1,1,''>>" "&(dDate_2+1;0)&"."'',1,19,4,1,''xl47'','''',3
1,1,'''',1,1,4,20,''xl47'','''',3
1,1,'''',1,1,4,21,''xl47'','''',3
1,1,'''',1,1,4,22,''xl47'','''',3
1,1,'''',1,1,4,23,''xl47'','''',3
1,1,'''',1,1,4,24,''xl47'','''',3
1,1,'''',1,1,4,25,''xl47'','''',3
1,1,'''',1,1,4,26,''xl47'','''',3
1,1,'''',1,1,4,27,''xl47'','''',3
1,1,'''',1,1,4,28,''xl47'','''',3
1,1,'''',1,1,4,29,''xl47'','''',3
1,1,'''',1,1,4,30,''xl47'','''',3
1,1,'''',1,1,4,31,''xl47'','''',3
1,1,'''',1,1,4,32,''xl22'','''',3
1,1,'''',1,1,4,33,''xl87'','''',3
1,1,'''',1,1,4,34,''xl87'','''',3
1,1,'''',1,1,4,35,''xl87'','''',3
1,1,'''',1,1,4,36,''xl87'','''',3
1,1,'''',1,1,4,37,''xl87'','''',3
1,1,'''',1,1,4,38,''xl87'','''',3
1,1,'''',1,1,4,39,''xl23'','''',3
1,1,'''',1,1,4,40,''xl23'','''',3
1,1,'''',1,1,4,41,''xl22'','''',3
1,1,'''',1,1,4,42,''xl87'','''',3
1,1,'''',1,1,4,43,''xl87'','''',3
1,1,'''',1,1,4,44,''xl87'','''',3
1,1,'''',1,1,4,45,''xl87'','''',3
1,1,'''',1,1,4,46,''xl87'','''',3
1,1,'''',1,1,4,47,''xl87'','''',3
1,1,'''',1,1,4,48,''xl87'','''',3
1,1,'''',1,1,4,49,''xl87'','''',3
1,1,'''',1,1,4,50,''xl87'','''',3
1,1,'''',1,1,4,51,''xl87'','''',3
1,1,'''',1,1,4,52,''xl87'','''',3
1,1,'''',1,1,4,53,''xl87'','''',3
1,1,'''',1,1,4,54,''xl87'','''',3
1,1,'''',1,1,4,55,''xl87'','''',3
1,1,'''',1,1,4,56,''xl87'','''',3
1,1,'''',1,1,4,57,''xl87'','''',3
1,1,'''',1,1,4,58,''xl87'','''',3
1,1,'''',1,1,4,59,''xl87'','''',3
1,1,'''',1,1,4,60,''xl22'','''',3
1,1,'''',1,1,4,61,''xl22'','''',3
1,1,'''',1,1,5,1,''xl47'','''',3
1,1,'''',1,1,5,2,''xl47'','''',3
1,1,'''',1,1,5,3,''xl47'','''',3
1,1,'''',1,1,5,4,''xl47'','''',3
1,1,'''',1,1,5,5,''xl47'','''',3
1,1,'''',1,1,5,6,''xl47'','''',3
1,1,'''',1,1,5,7,''xl47'','''',3
1,1,'''',1,1,5,8,''xl47'','''',3
1,1,'''',1,1,5,9,''xl47'','''',3
1,1,'''',1,1,5,10,''xl47'','''',3
1,1,'''',1,1,5,11,''xl47'','''',3
1,1,'''',1,1,5,12,''xl47'','''',3
1,1,'''',1,1,5,13,''xl47'','''',3
1,1,'''',1,1,5,14,''xl47'','''',3
1,1,'''',1,1,5,15,''xl47'','''',3
1,1,'''',1,1,5,16,''xl47'','''',3
1,1,'''',1,1,5,17,''xl47'','''',3
1,1,'''',1,1,5,18,''xl47'','''',3
1,1,'''',1,1,5,19,''xl47'','''',3
1,1,'''',1,1,5,20,''xl47'','''',3
1,1,'''',1,1,5,21,''xl47'','''',3
1,1,'''',1,1,5,22,''xl47'','''',3
1,1,'''',1,1,5,23,''xl47'','''',3
1,1,'''',1,1,5,24,''xl47'','''',3
1,1,'''',1,1,5,25,''xl47'','''',3
1,1,'''',1,1,5,26,''xl47'','''',3
1,1,'''',1,1,5,27,''xl47'','''',3
1,1,'''',1,1,5,28,''xl47'','''',3
1,1,'''',1,1,5,29,''xl47'','''',3
1,1,'''',1,1,5,30,''xl47'','''',3
1,1,'''',1,1,5,31,''xl47'','''',3
1,1,'''',1,1,5,32,''xl22'','''',3
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 17, '1,1,'''',1,1,5,33,''xl87'','''',3
1,1,'''',1,1,5,34,''xl87'','''',3
1,1,'''',1,1,5,35,''xl87'','''',3
1,1,'''',1,1,5,36,''xl87'','''',3
1,1,'''',1,1,5,37,''xl87'','''',3
1,1,'''',1,1,5,38,''xl87'','''',3
1,1,'''',1,1,5,39,''xl23'','''',3
1,1,'''',1,1,5,40,''xl23'','''',3
1,1,'''',1,1,5,41,''xl22'','''',3
1,1,'''',1,1,5,42,''xl87'','''',3
1,1,'''',1,1,5,43,''xl87'','''',3
1,1,'''',1,1,5,44,''xl87'','''',3
1,1,'''',1,1,5,45,''xl87'','''',3
1,1,'''',1,1,5,46,''xl87'','''',3
1,1,'''',1,1,5,47,''xl87'','''',3
1,1,'''',1,1,5,48,''xl87'','''',3
1,1,'''',1,1,5,49,''xl87'','''',3
1,1,'''',1,1,5,50,''xl87'','''',3
1,1,'''',1,1,5,51,''xl87'','''',3
1,1,'''',1,1,5,52,''xl87'','''',3
1,1,'''',1,1,5,53,''xl87'','''',3
1,1,'''',1,1,5,54,''xl87'','''',3
1,1,'''',1,1,5,55,''xl87'','''',3
1,1,'''',1,1,5,56,''xl87'','''',3
1,1,'''',1,1,5,57,''xl87'','''',3
1,1,'''',1,1,5,58,''xl87'','''',3
1,1,'''',1,1,5,59,''xl87'','''',3
1,1,'''',1,1,5,60,''xl22'','''',3
1,1,'''',1,1,5,61,''xl22'','''',3
1,1,''        '',1,1,6,1,''xl23'','''',3
1,1,'''',1,1,6,2,''xl32'','''',3
1,1,''$$select name from c_data1 where list=1#name#name#NN'',1,1,6,3,''xl85'','''',3
1,1,'''',1,1,6,4,''xl32'','''',3
1,1,'''',1,1,6,5,''xl41'','''',3
1,1,'''',1,1,6,6,''xl41'','''',3
1,1,'''',1,1,6,7,''xl41'','''',3
1,1,'''',1,1,6,8,''xl41'','''',3
1,1,'''',1,1,6,9,''xl41'','''',3
1,1,'''',1,1,6,10,''xl41'','''',3
1,1,'''',1,1,6,11,''xl41'','''',3
1,1,'''',1,1,6,12,''xl76'','''',3
1,1,'''',1,1,6,13,''xl76'','''',3
1,1,'''',1,1,6,14,''xl76'','''',3
1,1,'''',1,1,6,15,''xl76'','''',3
1,1,'''',1,1,6,16,''xl76'','''',3
1,1,'''',1,1,6,17,''xl76'','''',3
1,1,'''',1,1,6,18,''xl41'','''',3
1,1,'''',1,1,6,19,''xl41'','''',3
1,1,'''',1,1,6,20,''xl41'','''',3
1,1,'''',1,1,6,21,''xl41'','''',3
1,1,'''',1,1,6,22,''xl41'','''',3
1,1,'''',1,1,6,23,''xl41'','''',3
1,1,'''',1,1,6,24,''xl41'','''',3
1,1,'''',1,1,6,25,''xl41'','''',3
1,1,'''',1,1,6,26,''xl41'','''',3
1,1,'''',1,1,6,27,''xl41'','''',3
1,1,'''',1,1,6,28,''xl41'','''',3
1,1,'''',1,1,6,29,''xl41'','''',3
1,1,'''',1,1,6,30,''xl41'','''',3
1,1,'''',1,1,6,31,''xl41'','''',3
1,1,'''',1,1,6,32,''xl22'','''',3
1,1,'''',1,1,6,33,''xl87'','''',3
1,1,'''',1,1,6,34,''xl87'','''',3
1,1,'''',1,1,6,35,''xl87'','''',3
1,1,'''',1,1,6,36,''xl87'','''',3
1,1,'''',1,1,6,37,''xl87'','''',3
1,1,'''',1,1,6,38,''xl87'','''',3
1,1,'''',1,1,6,39,''xl23'','''',3
1,1,'''',1,1,6,40,''xl23'','''',3
1,1,'''',1,1,6,41,''xl22'','''',3
1,1,'''',1,1,6,42,''xl87'','''',3
1,1,'''',1,1,6,43,''xl87'','''',3
1,1,'''',1,1,6,44,''xl87'','''',3
1,1,'''',1,1,6,45,''xl87'','''',3
1,1,'''',1,1,6,46,''xl87'','''',3
1,1,'''',1,1,6,47,''xl87'','''',3
1,1,'''',1,1,6,48,''xl87'','''',3
1,1,'''',1,1,6,49,''xl87'','''',3
1,1,'''',1,1,6,50,''xl87'','''',3
1,1,'''',1,1,6,51,''xl87'','''',3
1,1,'''',1,1,6,52,''xl87'','''',3
1,1,'''',1,1,6,53,''xl87'','''',3
1,1,'''',1,1,6,54,''xl87'','''',3
1,1,'''',1,1,6,55,''xl87'','''',3
1,1,'''',1,1,6,56,''xl87'','''',3
1,1,'''',1,1,6,57,''xl87'','''',3
1,1,'''',1,1,6,58,''xl87'','''',3
1,1,'''',1,1,6,59,''xl87'','''',3
1,1,'''',1,1,6,60,''xl22'','''',3
1,1,'''',1,1,6,61,''xl22'','''',3
1,1,''>>" : "&(nDivide>1;" ";"")&""&(nDigit=1;" (     )";"")'',1,1,7,1,''xl86'','''',3
1,1,'''',1,1,7,2,''xl76'','''',3
1,1,'''',1,1,7,3,''xl86'','''',3
1,1,'''',1,1,7,4,''xl76'','''',3
1,1,'''',1,1,7,5,''xl86'','''',3
1,1,'''',1,1,7,6,''xl76'','''',3
1,1,'''',1,1,7,7,''xl86'','''',3
1,1,'''',1,1,7,8,''xl76'','''',3
1,1,'''',1,1,7,9,''xl86'','''',3
1,1,'''',1,1,7,10,''xl76'','''',3
1,1,'''',1,1,7,11,''xl86'','''',3
1,1,'''',1,1,7,12,''xl76'','''',3
1,1,'''',1,1,7,13,''xl86'','''',3
1,1,'''',1,1,7,14,''xl41'','''',3
1,1,'''',1,1,7,15,''xl41'','''',3
1,1,'''',1,1,7,16,''xl41'','''',3
1,1,'''',1,1,7,17,''xl41'','''',3
1,1,'''',1,1,7,18,''xl41'','''',3
1,1,'''',1,1,7,19,''xl41'','''',3
1,1,'''',1,1,7,20,''xl41'','''',3
1,1,'''',1,1,7,21,''xl41'','''',3
1,1,'''',1,1,7,22,''xl41'','''',3
1,1,'''',1,1,7,23,''xl41'','''',3
1,1,'''',1,1,7,24,''xl41'','''',3
1,1,'''',1,1,7,25,''xl41'','''',3
1,1,'''',1,1,7,26,''xl41'','''',3
1,1,'''',1,1,7,27,''xl41'','''',3
1,1,'''',1,1,7,28,''xl41'','''',3
1,1,'''',1,1,7,29,''xl41'','''',3
1,1,'''',1,1,7,30,''xl41'','''',3
1,1,'''',1,1,7,31,''xl41'','''',3
1,1,'''',1,1,7,32,''xl41'','''',3
1,1,'''',1,1,7,33,''xl41'','''',3
1,1,'''',1,1,7,34,''xl41'','''',3
1,1,'''',1,1,7,35,''xl41'','''',3
1,1,'''',1,1,7,36,''xl41'','''',3
1,1,'''',1,1,7,37,''xl41'','''',3
1,1,'''',1,1,7,38,''xl41'','''',3
1,1,'''',1,1,7,39,''xl23'','''',3
1,1,'''',1,1,7,40,''xl23'','''',3
1,1,'''',1,1,7,41,''xl22'','''',3
1,1,'''',1,1,7,42,''xl41'','''',3
1,1,'''',1,1,7,43,''xl41'','''',3
1,1,'''',1,1,7,44,''xl41'','''',3
1,1,'''',1,1,7,45,''xl41'','''',3
1,1,'''',1,1,7,46,''xl41'','''',3
1,1,'''',1,1,7,47,''xl41'','''',3
1,1,'''',1,1,7,48,''xl41'','''',3
1,1,'''',1,1,7,49,''xl41'','''',3
1,1,'''',1,1,7,50,''xl41'','''',3
1,1,'''',1,1,7,51,''xl41'','''',3
1,1,'''',1,1,7,52,''xl41'','''',3
1,1,'''',1,1,7,53,''xl41'','''',3
1,1,'''',1,1,7,54,''xl41'','''',3
1,1,'''',1,1,7,55,''xl41'','''',3
1,1,'''',1,1,7,56,''xl41'','''',3
1,1,'''',1,1,7,57,''xl41'','''',3
1,1,'''',1,1,7,58,''xl41'','''',3
1,1,'''',1,1,7,59,''xl41'','''',3
1,1,'''',1,1,7,60,''xl22'','''',3
1,1,'''',1,1,7,61,''xl22'','''',3
1,1,'''',1,1,8,1,''xl23'','''',3
1,1,'''',1,1,8,2,''xl32'','''',3
1,1,'''',1,1,8,3,''xl41'','''',3
1,1,'''',1,1,8,4,''xl32'','''',3
1,1,'''',1,1,8,5,''xl41'','''',3
1,1,'''',1,1,8,6,''xl41'','''',3
1,1,'''',1,1,8,7,''xl41'','''',3
1,1,'''',1,1,8,8,''xl41'','''',3
1,1,'''',1,1,8,9,''xl41'','''',3
1,1,'''',1,1,8,10,''xl41'','''',3
1,1,'''',1,1,8,11,''xl41'','''',3
1,1,'''',1,1,8,12,''xl41'','''',3
1,1,'''',1,1,8,13,''xl41'','''',3
1,1,'''',1,1,8,14,''xl41'','''',3
1,1,'''',1,1,8,15,''xl41'','''',3
1,1,'''',1,1,8,16,''xl41'','''',3
1,1,'''',1,1,8,17,''xl41'','''',3
1,1,'''',1,1,8,18,''xl41'','''',3
1,1,'''',1,1,8,19,''xl41'','''',3
1,1,'''',1,1,8,20,''xl41'','''',3
1,1,'''',1,1,8,21,''xl41'','''',3
1,1,'''',1,1,8,22,''xl41'','''',3
1,1,'''',1,1,8,23,''xl41'','''',3
1,1,'''',1,1,8,24,''xl41'','''',3
1,1,'''',1,1,8,25,''xl41'','''',3
1,1,'''',1,1,8,26,''xl41'','''',3
1,1,'''',1,1,8,27,''xl41'','''',3
1,1,'''',1,1,8,28,''xl41'','''',3
1,1,'''',1,1,8,29,''xl41'','''',3
1,1,'''',1,1,8,30,''xl41'','''',3
1,1,'''',1,1,8,31,''xl41'','''',3
1,1,'''',1,1,8,32,''xl41'','''',3
1,1,'''',1,1,8,33,''xl41'','''',3
1,1,'''',1,1,8,34,''xl41'','''',3
1,1,'''',1,1,8,35,''xl41'','''',3
1,1,'''',1,1,8,36,''xl41'','''',3
1,1,'''',1,1,8,37,''xl41'','''',3
1,1,'''',1,1,8,38,''xl41'','''',3
1,1,'''',1,1,8,39,''xl41'','''',3
1,1,'''',1,1,8,40,''xl41'','''',3
1,1,'''',1,1,8,41,''xl41'','''',3
1,1,'''',1,1,8,42,''xl41'','''',3
1,1,'''',1,1,8,43,''xl41'','''',3
1,1,'''',1,1,8,44,''xl41'','''',3
1,1,'''',1,1,8,45,''xl41'','''',3
1,1,'''',1,1,8,46,''xl41'','''',3
1,1,'''',1,1,8,47,''xl41'','''',3
1,1,'''',1,1,8,48,''xl41'','''',3
1,1,'''',1,1,8,49,''xl41'','''',3
1,1,'''',1,1,8,50,''xl41'','''',3
1,1,'''',1,1,8,51,''xl41'','''',3
1,1,'''',1,1,8,52,''xl41'','''',3
1,1,'''',1,1,8,53,''xl41'','''',3
1,1,'''',1,1,8,54,''xl41'','''',3
1,1,'''',1,1,8,55,''xl41'','''',3
1,1,'''',1,1,8,56,''xl41'','''',3
1,1,'''',1,1,8,57,''xl41'','''',3
1,1,'''',1,1,8,58,''xl41'','''',3
1,1,'''',1,1,8,59,''xl41'','''',3
1,1,'''',1,1,8,60,''xl22'','''',3
1,1,'''',1,1,8,61,''xl22'','''',3
1,1,'' , chr(10) '',10,1,9,1,''xl120'','''',3
1,1,'' '',10,1,9,2,''xl121'','''',3
1,1,'' '',10,1,9,3,''xl122'','''',3
1,1,''    '',4,1,9,4,''xl123'','''',3
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 18, '1,1,''       '',3,18,9,5,''xl71'','''',3
1,1,'' ..                 '',3,18,9,23,''xl71'','''',3
1,1,''    '',3,9,9,41,''xl71'','''',3
1,1,'' ..                 '',3,9,9,50,''xl71'','''',3
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,9,59,''xl133'','''',3
1,1,'''',1,1,9,60,''xl91'','''',3
1,1,'''',1,1,9,61,''xl91'','''',3
1,1,'''',1,1,10,60,''xl91'','''',3
1,1,'''',1,1,10,61,''xl91'','''',3
1,1,'''',1,1,11,60,''xl91'','''',3
1,1,'''',1,1,11,61,''xl91'','''',3
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,6,12,5,''xl71'','''',3
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,3,12,11,''xl71'','''',3
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,3,12,14,''xl71'','''',3
1,1,'' '',1,6,12,17,''xl71'','''',3
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,6,12,23,''xl71'','''',3
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,3,12,29,''xl71'','''',3
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,3,12,32,''xl71'','''',3
1,1,'' '',1,6,12,35,''xl71'','''',3
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,3,12,41,''xl71'','''',3
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,3,12,44,''xl71'','''',3
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,3,12,47,''xl71'','''',3
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,3,12,50,''xl71'','''',3
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,3,12,53,''xl71'','''',3
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,3,12,56,''xl71'','''',3
1,1,'''',1,1,12,60,''xl91'','''',3
1,1,'''',1,1,12,61,''xl91'','''',3
1,1,''/'',6,1,13,4,''xl124'','''',3
1,1,'''',1,2,13,5,''xl71'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,13,7,''xl71'','''',3
1,1,'''',1,2,13,9,''xl128'','''',3
1,1,'''',6,1,13,11,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,12,''xl80'','''',3
1,1,'''',6,1,13,13,''xl130'','''',3
1,1,'''',6,1,13,14,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,15,''xl80'','''',3
1,1,'''',6,1,13,16,''xl131'','''',3
1,1,''>>>(nInt_10+2;"0")&" ."'',1,3,13,17,''xl82'','''',3
1,1,''>>>(nInt_10+3;"0")&" ."'',1,3,13,20,''xl82'','''',3
1,1,'''',1,2,13,23,''xl71'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,13,25,''xl71'','''',3
1,1,'''',1,2,13,27,''xl128'','''',3
1,1,'''',6,1,13,29,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,30,''xl80'','''',3
1,1,'''',6,1,13,31,''xl132'','''',3
1,1,'''',6,1,13,32,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,33,''xl80'','''',3
1,1,'''',6,1,13,34,''xl132'','''',3
1,1,''>>>(nInt_10+2;"0")&" ."'',1,3,13,35,''xl82'','''',3
1,1,''>>>(nInt_10+3;"0")&" ."'',1,3,13,38,''xl82'','''',3
1,1,'''',6,1,13,41,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,42,''xl80'','''',3
1,1,'''',6,1,13,43,''xl132'','''',3
1,1,'''',6,1,13,44,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,45,''xl80'','''',3
1,1,'''',6,1,13,46,''xl132'','''',3
1,1,'''',6,1,13,47,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,48,''xl80'','''',3
1,1,'''',6,1,13,49,''xl132'','''',3
1,1,'''',6,1,13,50,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,51,''xl80'','''',3
1,1,'''',6,1,13,52,''xl132'','''',3
1,1,'''',6,1,13,53,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,54,''xl80'','''',3
1,1,'''',6,1,13,55,''xl132'','''',3
1,1,'''',6,1,13,56,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,57,''xl80'','''',3
1,1,'''',6,1,13,58,''xl132'','''',3
1,1,'''',1,1,13,60,''xl91'','''',3
1,1,'''',1,1,13,61,''xl91'','''',3
1,1,''  '',5,1,14,5,''xl80'','''',3
1,1,'''',5,1,14,6,''xl80'','''',3
1,1,''  '',5,1,14,7,''xl80'','''',3
1,1,'''',5,1,14,8,''xl80'','''',3
1,1,''  '',5,1,14,9,''xl125'','''',3
1,1,'''',5,1,14,10,''xl129'','''',3
1,1,'''',5,1,14,17,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,18,''xl80'','''',3
1,1,'''',5,1,14,19,''xl132'','''',3
1,1,'''',5,1,14,20,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,21,''xl80'','''',3
1,1,'''',5,1,14,22,''xl132'','''',3
1,1,''  '',5,1,14,23,''xl80'','''',3
1,1,'''',5,1,14,24,''xl80'','''',3
1,1,''  '',5,1,14,25,''xl80'','''',3
1,1,'''',5,1,14,26,''xl80'','''',3
1,1,''  '',5,1,14,27,''xl132'','''',3
1,1,'''',5,1,14,28,''xl132'','''',3
1,1,'''',5,1,14,35,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,36,''xl80'','''',3
1,1,'''',5,1,14,37,''xl132'','''',3
1,1,'''',5,1,14,38,''xl80'','''',3
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,39,''xl80'','''',3
1,1,'''',5,1,14,40,''xl132'','''',3
1,1,'''',1,1,14,60,''xl91'','''',3
1,1,'''',1,1,14,61,''xl91'','''',3
1,1,'''',1,1,15,60,''xl91'','''',3
1,1,'''',1,1,15,61,''xl91'','''',3
1,1,'''',1,1,16,60,''xl91'','''',3
1,1,'''',1,1,16,61,''xl91'','''',3
1,1,'''',1,1,17,60,''xl91'','''',3
1,1,'''',1,1,17,61,''xl91'','''',3
1,1,'''',1,1,18,60,''xl91'','''',3
1,1,'''',1,1,18,61,''xl91'','''',3
1,2,'''',1,1,1,1,''xl30'','''',3
1,2,'''',1,1,1,2,''xl39'','''',3
1,2,'''',1,1,1,3,''xl47'','''',3
1,2,'''',1,1,1,4,''xl39'','''',3
1,2,'''',1,1,1,5,''xl65'','''',3
1,2,'''',1,1,1,6,''xl65'','''',3
1,2,'''',1,1,1,7,''xl65'','''',3
1,2,'''',1,1,1,8,''xl65'','''',3
1,2,'''',1,1,1,9,''xl65'','''',3
1,2,'''',1,1,1,10,''xl65'','''',3
1,2,'''',1,1,1,11,''xl65'','''',3
1,2,'''',1,1,1,12,''xl65'','''',3
1,2,'''',1,1,1,13,''xl65'','''',3
1,2,'''',1,1,1,14,''xl65'','''',3
1,2,'''',1,1,1,15,''xl65'','''',3
1,2,'''',1,1,1,16,''xl65'','''',3
1,2,'''',1,1,1,17,''xl65'','''',3
1,2,'''',1,1,1,18,''xl65'','''',3
1,2,'''',1,1,1,19,''xl65'','''',3
1,2,'''',1,1,1,20,''xl65'','''',3
1,2,'''',1,1,1,21,''xl65'','''',3
1,2,'''',1,1,1,22,''xl65'','''',3
1,2,'''',1,1,1,23,''xl65'','''',3
1,2,'''',1,1,1,24,''xl65'','''',3
1,2,'''',1,1,1,25,''xl65'','''',3
1,2,'''',1,1,1,26,''xl65'','''',3
1,2,'''',1,1,1,27,''xl65'','''',3
1,2,'''',1,1,1,28,''xl65'','''',3
1,2,'''',1,1,1,29,''xl65'','''',3
1,2,'''',1,1,1,30,''xl65'','''',3
1,2,'''',1,1,1,31,''xl65'','''',3
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 19, '1,2,'''',1,1,1,32,''xl65'','''',3
1,2,'''',1,1,1,33,''xl65'','''',3
1,2,'''',1,1,1,34,''xl65'','''',3
1,2,'''',1,1,1,35,''xl65'','''',3
1,2,'''',1,1,1,36,''xl65'','''',3
1,2,'''',1,1,1,37,''xl65'','''',3
1,2,'''',1,1,1,38,''xl65'','''',3
1,2,'''',1,1,1,39,''xl65'','''',3
1,2,'''',1,1,1,40,''xl65'','''',3
1,2,'''',1,1,1,41,''xl65'','''',3
1,2,'''',1,1,1,42,''xl65'','''',3
1,2,'''',1,1,1,43,''xl65'','''',3
1,2,'''',1,1,1,44,''xl65'','''',3
1,2,'''',1,1,1,45,''xl65'','''',3
1,2,'''',1,1,1,46,''xl65'','''',3
1,2,'''',1,1,1,47,''xl65'','''',3
1,2,'''',1,1,1,48,''xl65'','''',3
1,2,'''',1,1,1,49,''xl65'','''',3
1,2,'''',1,1,1,50,''xl65'','''',3
1,2,'''',1,1,1,51,''xl65'','''',3
1,2,'''',1,1,1,52,''xl65'','''',3
1,2,'''',1,1,1,53,''xl65'','''',3
1,2,'''',1,1,1,54,''xl65'','''',3
1,2,'''',1,1,1,55,''xl65'','''',3
1,2,'''',1,1,1,56,''xl65'','''',3
1,2,'''',1,1,1,57,''xl65'','''',3
1,2,'''',1,1,1,58,''xl65'','''',3
1,2,'''',1,1,1,59,''xl65'','''',3
1,2,'''',1,1,1,60,''xl22'','''',3
1,2,'''',1,1,1,61,''xl22'','''',3
2,2,''$$select dist po_n,ord from c_data8 where list=1 order by po_n,ord#po_n#ord#ZZ'',1,1,1,1,''xl28'','''',3
2,2,''>>>(<ord>;ZZ;<cpo>)'',1,1,1,2,''xl36'','''',3
2,2,''>>>(<ord>;ZZ;<cpog>)'',1,1,1,3,''xl60'','''',3
2,2,''>>>2(<ord>;ZZ;<lev>;1;<cdiv>)'',1,1,1,4,''xl60'','''',3
2,2,''>>(<ord>;ZZ;<s_1>)'',1,1,1,5,''xl69'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_2>)'',1,1,1,6,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_1>)'',1,1,1,7,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_2>)'',1,1,1,8,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_1>)'',1,1,1,9,''xl127'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_2>)'',1,1,1,10,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_3>)'',1,1,1,11,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_3>)'',1,1,1,12,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_3>)'',1,1,1,13,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_4>)'',1,1,1,14,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_4>)'',1,1,1,15,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_4>)'',1,1,1,16,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_5>)'',1,1,1,17,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_5>)'',1,1,1,18,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_5>)'',1,1,1,19,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_6>)'',1,1,1,20,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_6>)'',1,1,1,21,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_6>)'',1,1,1,22,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_1>)'',1,1,1,23,''xl69'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_2>)'',1,1,1,24,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_1>)'',1,1,1,25,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_2>)'',1,1,1,26,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_1>)'',1,1,1,27,''xl127'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_2>)'',1,1,1,28,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_3>)'',1,1,1,29,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_3>)'',1,1,1,30,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_3>)'',1,1,1,31,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_4>)'',1,1,1,32,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_4>)'',1,1,1,33,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_4>)'',1,1,1,34,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_5>)'',1,1,1,35,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_5>)'',1,1,1,36,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_5>)'',1,1,1,37,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_6>)'',1,1,1,38,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_6>)'',1,1,1,39,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_6>)'',1,1,1,40,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_7>)'',1,1,1,41,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_7>)'',1,1,1,42,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_7>)'',1,1,1,43,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_8>)'',1,1,1,44,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_8>)'',1,1,1,45,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_8>)'',1,1,1,46,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<s_9>)'',1,1,1,47,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_9>)'',1,1,1,48,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<s_9>)'',1,1,1,49,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_7>)'',1,1,1,50,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_7>)'',1,1,1,51,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_7>)'',1,1,1,52,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_8>)'',1,1,1,53,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_8>)'',1,1,1,54,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_8>)'',1,1,1,55,''xl127'',''"#,##0.00"'',3
2,2,''>>(<ord>;ZZ;<k_9>)'',1,1,1,56,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_9>)'',1,1,1,57,''xl69'',''"#,##0.00"'',3
2,2,''>>2(<ord>;ZZ;<su>;0;<k_9>)'',1,1,1,58,''xl127'',''"#,##0.00"'',3
2,2,''>>>2(<ord>;ZZ;<lev>;1;<metod>)'',1,1,1,59,''xl36'','''',3
2,2,'''',1,1,1,60,''xl92'','''',3
2,2,'''',1,1,1,61,''xl22'','''',3
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 20, '1,1,'''',1,1,1,1,''xl22'','''',4
1,1,'''',1,1,1,2,''xl22'','''',4
1,1,'''',1,1,1,3,''xl22'','''',4
1,1,'''',1,1,1,4,''xl22'','''',4
1,1,'''',1,1,1,5,''xl22'','''',4
1,1,'''',1,1,1,6,''xl22'','''',4
1,1,'''',1,1,1,7,''xl22'','''',4
1,1,'''',1,1,1,8,''xl22'','''',4
1,1,'''',1,1,1,9,''xl22'','''',4
1,1,'''',1,1,1,10,''xl22'','''',4
1,1,'''',1,1,1,11,''xl22'','''',4
1,1,'''',1,1,1,12,''xl22'','''',4
1,1,'''',1,1,1,13,''xl22'','''',4
1,1,'''',1,1,1,14,''xl22'','''',4
1,1,'''',1,1,1,15,''xl22'','''',4
1,1,'''',1,1,1,16,''xl83'','''',4
1,1,'''',1,1,1,17,''xl83'','''',4
1,1,'''',1,1,1,18,''xl83'','''',4
1,1,'''',1,1,1,19,''xl83'','''',4
1,1,'''',1,1,1,20,''xl83'','''',4
1,1,'''',1,1,1,21,''xl83'','''',4
1,1,'''',1,1,1,22,''xl83'','''',4
1,1,'''',1,1,1,23,''xl22'','''',4
1,1,'''',1,1,1,24,''xl87'','''',4
1,1,'''',1,1,1,25,''xl87'','''',4
1,1,'''',1,1,1,26,''xl87'','''',4
1,1,'''',1,1,1,27,''xl87'','''',4
1,1,'''',1,1,1,28,''xl23'','''',4
1,1,'''',1,1,1,29,''xl22'','''',4
1,1,'''',1,1,1,30,''xl87'','''',4
1,1,'''',1,1,1,31,''xl87'','''',4
1,1,'''',1,1,1,32,''xl87'','''',4
1,1,'''',1,1,1,33,''xl87'','''',4
1,1,'''',1,1,1,34,''xl87'','''',4
1,1,'''',1,1,1,35,''xl87'','''',4
1,1,'''',1,1,1,36,''xl87'','''',4
1,1,'''',1,1,1,37,''xl87'','''',4
1,1,'''',1,1,1,38,''xl87'','''',4
1,1,'''',1,1,1,39,''xl87'','''',4
1,1,'''',1,1,1,40,''xl87'','''',4
1,1,'''',1,1,1,41,''xl87'','''',4
1,1,''>>"#/"'',1,1,1,42,''xl90'','''',4
1,1,'''',1,1,1,43,''xl22'','''',4
1,1,'''',1,1,1,44,''xl22'','''',4
1,1,'''',1,1,1,45,''xl22'','''',4
1,1,'''',1,1,1,46,''xl22'','''',4
1,1,'''',1,1,1,47,''xl22'','''',4
1,1,'''',1,1,1,48,''xl22'','''',4
1,1,'''',1,1,1,49,''xl22'','''',4
1,1,'''',1,1,1,50,''xl22'','''',4
1,1,'''',1,1,1,51,''xl22'','''',4
1,1,'''',1,1,1,52,''xl22'','''',4
1,1,'''',1,1,1,53,''xl22'','''',4
1,1,'''',1,1,1,54,''xl22'','''',4
1,1,'''',1,1,1,55,''xl22'','''',4
1,1,'''',1,1,1,56,''xl22'','''',4
1,1,'''',1,1,1,57,''xl22'','''',4
1,1,'''',1,1,1,58,''xl22'','''',4
1,1,'''',1,1,1,59,''xl22'','''',4
1,1,'''',1,1,1,60,''xl22'','''',4
1,1,'' '',1,14,2,1,''xl81'','''',4
1,1,'''',1,1,2,15,''xl22'','''',4
1,1,'''',1,1,2,16,''xl83'','''',4
1,1,'''',1,1,2,17,''xl83'','''',4
1,1,'''',1,1,2,18,''xl83'','''',4
1,1,'''',1,1,2,19,''xl83'','''',4
1,1,'''',1,1,2,20,''xl83'','''',4
1,1,'''',1,1,2,21,''xl83'','''',4
1,1,'''',1,1,2,22,''xl83'','''',4
1,1,'''',1,1,2,23,''xl22'','''',4
1,1,'''',1,1,2,24,''xl87'','''',4
1,1,'''',1,1,2,25,''xl87'','''',4
1,1,'''',1,1,2,26,''xl87'','''',4
1,1,'''',1,1,2,27,''xl87'','''',4
1,1,'''',1,1,2,28,''xl23'','''',4
1,1,'''',1,1,2,29,''xl22'','''',4
1,1,'''',1,1,2,30,''xl87'','''',4
1,1,'''',1,1,2,31,''xl87'','''',4
1,1,'''',1,1,2,32,''xl87'','''',4
1,1,'''',1,1,2,33,''xl87'','''',4
1,1,'''',1,1,2,34,''xl87'','''',4
1,1,'''',1,1,2,35,''xl87'','''',4
1,1,'''',1,1,2,36,''xl87'','''',4
1,1,'''',1,1,2,37,''xl87'','''',4
1,1,'''',1,1,2,38,''xl87'','''',4
1,1,'''',1,1,2,39,''xl87'','''',4
1,1,'''',1,1,2,40,''xl87'','''',4
1,1,'''',1,1,2,41,''xl87'','''',4
1,1,'''',1,1,2,42,''xl22'','''',4
1,1,'''',1,1,2,43,''xl22'','''',4
1,1,'''',1,1,2,44,''xl22'','''',4
1,1,'''',1,1,2,45,''xl22'','''',4
1,1,'''',1,1,2,46,''xl22'','''',4
1,1,'''',1,1,2,47,''xl22'','''',4
1,1,'''',1,1,2,48,''xl22'','''',4
1,1,'''',1,1,2,49,''xl22'','''',4
1,1,'''',1,1,2,50,''xl22'','''',4
1,1,'''',1,1,2,51,''xl22'','''',4
1,1,'''',1,1,2,52,''xl22'','''',4
1,1,'''',1,1,2,53,''xl22'','''',4
1,1,'''',1,1,2,54,''xl22'','''',4
1,1,'''',1,1,2,55,''xl22'','''',4
1,1,'''',1,1,2,56,''xl22'','''',4
1,1,'''',1,1,2,57,''xl22'','''',4
1,1,'''',1,1,2,58,''xl22'','''',4
1,1,'''',1,1,2,59,''xl22'','''',4
1,1,'''',1,1,2,60,''xl22'','''',4
1,1,''           '',1,14,3,1,''xl81'','''',4
1,1,'''',1,1,3,15,''xl83'','''',4
1,1,'''',1,1,3,16,''xl76'','''',4
1,1,'''',1,1,3,17,''xl76'','''',4
1,1,'''',1,1,3,18,''xl76'','''',4
1,1,'''',1,1,3,19,''xl76'','''',4
1,1,'''',1,1,3,20,''xl76'','''',4
1,1,'''',1,1,3,21,''xl76'','''',4
1,1,'''',1,1,3,22,''xl76'','''',4
1,1,'''',1,1,3,23,''xl22'','''',4
1,1,'''',1,1,3,24,''xl87'','''',4
1,1,'''',1,1,3,25,''xl87'','''',4
1,1,'''',1,1,3,26,''xl87'','''',4
1,1,'''',1,1,3,27,''xl87'','''',4
1,1,'''',1,1,3,28,''xl23'','''',4
1,1,'''',1,1,3,29,''xl22'','''',4
1,1,'''',1,1,3,30,''xl87'','''',4
1,1,'''',1,1,3,31,''xl87'','''',4
1,1,'''',1,1,3,32,''xl87'','''',4
1,1,'''',1,1,3,33,''xl87'','''',4
1,1,'''',1,1,3,34,''xl87'','''',4
1,1,'''',1,1,3,35,''xl87'','''',4
1,1,'''',1,1,3,36,''xl87'','''',4
1,1,'''',1,1,3,37,''xl87'','''',4
1,1,'''',1,1,3,38,''xl87'','''',4
1,1,'''',1,1,3,39,''xl87'','''',4
1,1,'''',1,1,3,40,''xl87'','''',4
1,1,'''',1,1,3,41,''xl87'','''',4
1,1,'''',1,1,3,42,''xl22'','''',4
1,1,'''',1,1,3,43,''xl22'','''',4
1,1,'''',1,1,3,44,''xl22'','''',4
1,1,'''',1,1,3,45,''xl22'','''',4
1,1,'''',1,1,3,46,''xl22'','''',4
1,1,'''',1,1,3,47,''xl22'','''',4
1,1,'''',1,1,3,48,''xl22'','''',4
1,1,'''',1,1,3,49,''xl22'','''',4
1,1,'''',1,1,3,50,''xl22'','''',4
1,1,'''',1,1,3,51,''xl22'','''',4
1,1,'''',1,1,3,52,''xl22'','''',4
1,1,'''',1,1,3,53,''xl22'','''',4
1,1,'''',1,1,3,54,''xl22'','''',4
1,1,'''',1,1,3,55,''xl22'','''',4
1,1,'''',1,1,3,56,''xl22'','''',4
1,1,'''',1,1,3,57,''xl22'','''',4
1,1,'''',1,1,3,58,''xl22'','''',4
1,1,'''',1,1,3,59,''xl22'','''',4
1,1,'''',1,1,3,60,''xl22'','''',4
1,1,''>>" "&(dDate_2+1;0)&"."'',1,14,4,1,''xl47'','''',4
1,1,'''',1,1,4,15,''xl47'','''',4
1,1,'''',1,1,4,16,''xl47'','''',4
1,1,'''',1,1,4,17,''xl47'','''',4
1,1,'''',1,1,4,18,''xl47'','''',4
1,1,'''',1,1,4,19,''xl47'','''',4
1,1,'''',1,1,4,20,''xl47'','''',4
1,1,'''',1,1,4,21,''xl47'','''',4
1,1,'''',1,1,4,22,''xl47'','''',4
1,1,'''',1,1,4,23,''xl22'','''',4
1,1,'''',1,1,4,24,''xl87'','''',4
1,1,'''',1,1,4,25,''xl87'','''',4
1,1,'''',1,1,4,26,''xl87'','''',4
1,1,'''',1,1,4,27,''xl87'','''',4
1,1,'''',1,1,4,28,''xl23'','''',4
1,1,'''',1,1,4,29,''xl22'','''',4
1,1,'''',1,1,4,30,''xl87'','''',4
1,1,'''',1,1,4,31,''xl87'','''',4
1,1,'''',1,1,4,32,''xl87'','''',4
1,1,'''',1,1,4,33,''xl87'','''',4
1,1,'''',1,1,4,34,''xl87'','''',4
1,1,'''',1,1,4,35,''xl87'','''',4
1,1,'''',1,1,4,36,''xl87'','''',4
1,1,'''',1,1,4,37,''xl87'','''',4
1,1,'''',1,1,4,38,''xl87'','''',4
1,1,'''',1,1,4,39,''xl87'','''',4
1,1,'''',1,1,4,40,''xl87'','''',4
1,1,'''',1,1,4,41,''xl87'','''',4
1,1,'''',1,1,4,42,''xl22'','''',4
1,1,'''',1,1,4,43,''xl22'','''',4
1,1,'''',1,1,4,44,''xl22'','''',4
1,1,'''',1,1,4,45,''xl22'','''',4
1,1,'''',1,1,4,46,''xl22'','''',4
1,1,'''',1,1,4,47,''xl22'','''',4
1,1,'''',1,1,4,48,''xl22'','''',4
1,1,'''',1,1,4,49,''xl22'','''',4
1,1,'''',1,1,4,50,''xl22'','''',4
1,1,'''',1,1,4,51,''xl22'','''',4
1,1,'''',1,1,4,52,''xl22'','''',4
1,1,'''',1,1,4,53,''xl22'','''',4
1,1,'''',1,1,4,54,''xl22'','''',4
1,1,'''',1,1,4,55,''xl22'','''',4
1,1,'''',1,1,4,56,''xl22'','''',4
1,1,'''',1,1,4,57,''xl22'','''',4
1,1,'''',1,1,4,58,''xl22'','''',4
1,1,'''',1,1,4,59,''xl22'','''',4
1,1,'''',1,1,4,60,''xl22'','''',4
1,1,'''',1,1,5,1,''xl47'','''',4
1,1,'''',1,1,5,2,''xl47'','''',4
1,1,'''',1,1,5,3,''xl47'','''',4
1,1,'''',1,1,5,4,''xl47'','''',4
1,1,'''',1,1,5,5,''xl47'','''',4
1,1,'''',1,1,5,6,''xl47'','''',4
1,1,'''',1,1,5,7,''xl47'','''',4
1,1,'''',1,1,5,8,''xl47'','''',4
1,1,'''',1,1,5,9,''xl47'','''',4
1,1,'''',1,1,5,10,''xl47'','''',4
1,1,'''',1,1,5,11,''xl47'','''',4
1,1,'''',1,1,5,12,''xl47'','''',4
1,1,'''',1,1,5,13,''xl47'','''',4
1,1,'''',1,1,5,14,''xl47'','''',4
1,1,'''',1,1,5,15,''xl47'','''',4
1,1,'''',1,1,5,16,''xl47'','''',4
1,1,'''',1,1,5,17,''xl47'','''',4
1,1,'''',1,1,5,18,''xl47'','''',4
1,1,'''',1,1,5,19,''xl47'','''',4
1,1,'''',1,1,5,20,''xl47'','''',4
1,1,'''',1,1,5,21,''xl47'','''',4
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 21, '1,1,'''',1,1,5,22,''xl47'','''',4
1,1,'''',1,1,5,23,''xl22'','''',4
1,1,'''',1,1,5,24,''xl87'','''',4
1,1,'''',1,1,5,25,''xl87'','''',4
1,1,'''',1,1,5,26,''xl87'','''',4
1,1,'''',1,1,5,27,''xl87'','''',4
1,1,'''',1,1,5,28,''xl23'','''',4
1,1,'''',1,1,5,29,''xl22'','''',4
1,1,'''',1,1,5,30,''xl87'','''',4
1,1,'''',1,1,5,31,''xl87'','''',4
1,1,'''',1,1,5,32,''xl87'','''',4
1,1,'''',1,1,5,33,''xl87'','''',4
1,1,'''',1,1,5,34,''xl87'','''',4
1,1,'''',1,1,5,35,''xl87'','''',4
1,1,'''',1,1,5,36,''xl87'','''',4
1,1,'''',1,1,5,37,''xl87'','''',4
1,1,'''',1,1,5,38,''xl87'','''',4
1,1,'''',1,1,5,39,''xl87'','''',4
1,1,'''',1,1,5,40,''xl87'','''',4
1,1,'''',1,1,5,41,''xl87'','''',4
1,1,'''',1,1,5,42,''xl22'','''',4
1,1,'''',1,1,5,43,''xl22'','''',4
1,1,'''',1,1,5,44,''xl22'','''',4
1,1,'''',1,1,5,45,''xl22'','''',4
1,1,'''',1,1,5,46,''xl22'','''',4
1,1,'''',1,1,5,47,''xl22'','''',4
1,1,'''',1,1,5,48,''xl22'','''',4
1,1,'''',1,1,5,49,''xl22'','''',4
1,1,'''',1,1,5,50,''xl22'','''',4
1,1,'''',1,1,5,51,''xl22'','''',4
1,1,'''',1,1,5,52,''xl22'','''',4
1,1,'''',1,1,5,53,''xl22'','''',4
1,1,'''',1,1,5,54,''xl22'','''',4
1,1,'''',1,1,5,55,''xl22'','''',4
1,1,'''',1,1,5,56,''xl22'','''',4
1,1,'''',1,1,5,57,''xl22'','''',4
1,1,'''',1,1,5,58,''xl22'','''',4
1,1,'''',1,1,5,59,''xl22'','''',4
1,1,'''',1,1,5,60,''xl22'','''',4
1,1,''        '',1,1,6,1,''xl23'','''',4
1,1,'''',1,1,6,2,''xl32'','''',4
1,1,'''',1,1,6,3,''xl41'','''',4
1,1,'''',1,1,6,4,''xl32'','''',4
1,1,'''',1,1,6,5,''xl41'','''',4
1,1,'''',1,1,6,6,''xl41'','''',4
1,1,'''',1,1,6,7,''xl41'','''',4
1,1,'''',1,1,6,8,''xl41'','''',4
1,1,'''',1,1,6,9,''xl41'','''',4
1,1,'''',1,1,6,10,''xl76'','''',4
1,1,'''',1,1,6,11,''xl76'','''',4
1,1,'''',1,1,6,12,''xl76'','''',4
1,1,'''',1,1,6,13,''xl76'','''',4
1,1,'''',1,1,6,14,''xl41'','''',4
1,1,'''',1,1,6,15,''xl41'','''',4
1,1,'''',1,1,6,16,''xl41'','''',4
1,1,'''',1,1,6,17,''xl41'','''',4
1,1,'''',1,1,6,18,''xl41'','''',4
1,1,'''',1,1,6,19,''xl41'','''',4
1,1,'''',1,1,6,20,''xl41'','''',4
1,1,'''',1,1,6,21,''xl41'','''',4
1,1,'''',1,1,6,22,''xl41'','''',4
1,1,'''',1,1,6,23,''xl22'','''',4
1,1,'''',1,1,6,24,''xl87'','''',4
1,1,'''',1,1,6,25,''xl87'','''',4
1,1,'''',1,1,6,26,''xl87'','''',4
1,1,'''',1,1,6,27,''xl87'','''',4
1,1,'''',1,1,6,28,''xl23'','''',4
1,1,'''',1,1,6,29,''xl22'','''',4
1,1,'''',1,1,6,30,''xl87'','''',4
1,1,'''',1,1,6,31,''xl87'','''',4
1,1,'''',1,1,6,32,''xl87'','''',4
1,1,'''',1,1,6,33,''xl87'','''',4
1,1,'''',1,1,6,34,''xl87'','''',4
1,1,'''',1,1,6,35,''xl87'','''',4
1,1,'''',1,1,6,36,''xl87'','''',4
1,1,'''',1,1,6,37,''xl87'','''',4
1,1,'''',1,1,6,38,''xl87'','''',4
1,1,'''',1,1,6,39,''xl87'','''',4
1,1,'''',1,1,6,40,''xl87'','''',4
1,1,'''',1,1,6,41,''xl87'','''',4
1,1,'''',1,1,6,42,''xl22'','''',4
1,1,'''',1,1,6,43,''xl22'','''',4
1,1,'''',1,1,6,44,''xl22'','''',4
1,1,'''',1,1,6,45,''xl22'','''',4
1,1,'''',1,1,6,46,''xl22'','''',4
1,1,'''',1,1,6,47,''xl22'','''',4
1,1,'''',1,1,6,48,''xl22'','''',4
1,1,'''',1,1,6,49,''xl22'','''',4
1,1,'''',1,1,6,50,''xl22'','''',4
1,1,'''',1,1,6,51,''xl22'','''',4
1,1,'''',1,1,6,52,''xl22'','''',4
1,1,'''',1,1,6,53,''xl22'','''',4
1,1,'''',1,1,6,54,''xl22'','''',4
1,1,'''',1,1,6,55,''xl22'','''',4
1,1,'''',1,1,6,56,''xl22'','''',4
1,1,'''',1,1,6,57,''xl22'','''',4
1,1,'''',1,1,6,58,''xl22'','''',4
1,1,'''',1,1,6,59,''xl22'','''',4
1,1,'''',1,1,6,60,''xl22'','''',4
1,1,''>>" : "&(nDivide>1;" ";"")&""&(nDigit=1;" (     )";"")'',1,2,7,1,''xl86'','''',4
1,1,'''',1,1,7,3,''xl41'','''',4
1,1,'''',1,1,7,4,''xl32'','''',4
1,1,'''',1,1,7,5,''xl41'','''',4
1,1,'''',1,1,7,6,''xl41'','''',4
1,1,'''',1,1,7,7,''xl41'','''',4
1,1,'''',1,1,7,8,''xl41'','''',4
1,1,'''',1,1,7,9,''xl41'','''',4
1,1,'''',1,1,7,10,''xl41'','''',4
1,1,'''',1,1,7,11,''xl41'','''',4
1,1,'''',1,1,7,12,''xl41'','''',4
1,1,'''',1,1,7,13,''xl41'','''',4
1,1,'''',1,1,7,14,''xl41'','''',4
1,1,'''',1,1,7,15,''xl41'','''',4
1,1,'''',1,1,7,16,''xl41'','''',4
1,1,'''',1,1,7,17,''xl41'','''',4
1,1,'''',1,1,7,18,''xl41'','''',4
1,1,'''',1,1,7,19,''xl41'','''',4
1,1,'''',1,1,7,20,''xl41'','''',4
1,1,'''',1,1,7,21,''xl41'','''',4
1,1,'''',1,1,7,22,''xl41'','''',4
1,1,'''',1,1,7,23,''xl41'','''',4
1,1,'''',1,1,7,24,''xl41'','''',4
1,1,'''',1,1,7,25,''xl41'','''',4
1,1,'''',1,1,7,26,''xl41'','''',4
1,1,'''',1,1,7,27,''xl41'','''',4
1,1,'''',1,1,7,28,''xl23'','''',4
1,1,'''',1,1,7,29,''xl22'','''',4
1,1,'''',1,1,7,30,''xl41'','''',4
1,1,'''',1,1,7,31,''xl41'','''',4
1,1,'''',1,1,7,32,''xl41'','''',4
1,1,'''',1,1,7,33,''xl41'','''',4
1,1,'''',1,1,7,34,''xl41'','''',4
1,1,'''',1,1,7,35,''xl41'','''',4
1,1,'''',1,1,7,36,''xl41'','''',4
1,1,'''',1,1,7,37,''xl41'','''',4
1,1,'''',1,1,7,38,''xl41'','''',4
1,1,'''',1,1,7,39,''xl41'','''',4
1,1,'''',1,1,7,40,''xl41'','''',4
1,1,'''',1,1,7,41,''xl41'','''',4
1,1,'''',1,1,7,42,''xl22'','''',4
1,1,'''',1,1,7,43,''xl22'','''',4
1,1,'''',1,1,7,44,''xl22'','''',4
1,1,'''',1,1,7,45,''xl22'','''',4
1,1,'''',1,1,7,46,''xl22'','''',4
1,1,'''',1,1,7,47,''xl22'','''',4
1,1,'''',1,1,7,48,''xl22'','''',4
1,1,'''',1,1,7,49,''xl22'','''',4
1,1,'''',1,1,7,50,''xl22'','''',4
1,1,'''',1,1,7,51,''xl22'','''',4
1,1,'''',1,1,7,52,''xl22'','''',4
1,1,'''',1,1,7,53,''xl22'','''',4
1,1,'''',1,1,7,54,''xl22'','''',4
1,1,'''',1,1,7,55,''xl22'','''',4
1,1,'''',1,1,7,56,''xl22'','''',4
1,1,'''',1,1,7,57,''xl22'','''',4
1,1,'''',1,1,7,58,''xl22'','''',4
1,1,'''',1,1,7,59,''xl22'','''',4
1,1,'''',1,1,7,60,''xl22'','''',4
1,1,'''',1,1,8,1,''xl23'','''',4
1,1,'''',1,1,8,2,''xl32'','''',4
1,1,'''',1,1,8,3,''xl41'','''',4
1,1,'''',1,1,8,4,''xl32'','''',4
1,1,'''',1,1,8,5,''xl41'','''',4
1,1,'''',1,1,8,6,''xl41'','''',4
1,1,'''',1,1,8,7,''xl41'','''',4
1,1,'''',1,1,8,8,''xl41'','''',4
1,1,'''',1,1,8,9,''xl41'','''',4
1,1,'''',1,1,8,10,''xl41'','''',4
1,1,'''',1,1,8,11,''xl41'','''',4
1,1,'''',1,1,8,12,''xl41'','''',4
1,1,'''',1,1,8,13,''xl41'','''',4
1,1,'''',1,1,8,14,''xl41'','''',4
1,1,'''',1,1,8,15,''xl41'','''',4
1,1,'''',1,1,8,16,''xl41'','''',4
1,1,'''',1,1,8,17,''xl41'','''',4
1,1,'''',1,1,8,18,''xl41'','''',4
1,1,'''',1,1,8,19,''xl41'','''',4
1,1,'''',1,1,8,20,''xl41'','''',4
1,1,'''',1,1,8,21,''xl41'','''',4
1,1,'''',1,1,8,22,''xl41'','''',4
1,1,'''',1,1,8,23,''xl41'','''',4
1,1,'''',1,1,8,24,''xl41'','''',4
1,1,'''',1,1,8,25,''xl41'','''',4
1,1,'''',1,1,8,26,''xl41'','''',4
1,1,'''',1,1,8,27,''xl41'','''',4
1,1,'''',1,1,8,28,''xl41'','''',4
1,1,'''',1,1,8,29,''xl41'','''',4
1,1,'''',1,1,8,30,''xl41'','''',4
1,1,'''',1,1,8,31,''xl41'','''',4
1,1,'''',1,1,8,32,''xl41'','''',4
1,1,'''',1,1,8,33,''xl41'','''',4
1,1,'''',1,1,8,34,''xl41'','''',4
1,1,'''',1,1,8,35,''xl41'','''',4
1,1,'''',1,1,8,36,''xl41'','''',4
1,1,'''',1,1,8,37,''xl41'','''',4
1,1,'''',1,1,8,38,''xl41'','''',4
1,1,'''',1,1,8,39,''xl41'','''',4
1,1,'''',1,1,8,40,''xl41'','''',4
1,1,'''',1,1,8,41,''xl41'','''',4
1,1,'''',1,1,8,42,''xl22'','''',4
1,1,'''',1,1,8,43,''xl22'','''',4
1,1,'''',1,1,8,44,''xl22'','''',4
1,1,'''',1,1,8,45,''xl22'','''',4
1,1,'''',1,1,8,46,''xl22'','''',4
1,1,'''',1,1,8,47,''xl22'','''',4
1,1,'''',1,1,8,48,''xl22'','''',4
1,1,'''',1,1,8,49,''xl22'','''',4
1,1,'''',1,1,8,50,''xl22'','''',4
1,1,'''',1,1,8,51,''xl22'','''',4
1,1,'''',1,1,8,52,''xl22'','''',4
1,1,'''',1,1,8,53,''xl22'','''',4
1,1,'''',1,1,8,54,''xl22'','''',4
1,1,'''',1,1,8,55,''xl22'','''',4
1,1,'''',1,1,8,56,''xl22'','''',4
1,1,'''',1,1,8,57,''xl22'','''',4
1,1,'''',1,1,8,58,''xl22'','''',4
1,1,'''',1,1,8,59,''xl22'','''',4
1,1,'''',1,1,8,60,''xl22'','''',4
1,1,'' , chr(10) '',10,1,9,1,''xl134'','''',4
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 22, '1,1,'' '',10,1,9,2,''xl135'','''',4
1,1,'' '',10,1,9,3,''xl136'','''',4
1,1,''    '',4,1,9,4,''xl137'','''',4
1,1,''       '',3,18,9,5,''xl71'','''',4
1,1,'' ..                 '',3,18,9,23,''xl71'','''',4
1,1,''    '',3,9,9,41,''xl71'','''',4
1,1,'' ..                 '',3,9,9,50,''xl71'','''',4
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,9,59,''xl139'','''',4
1,1,'''',1,1,9,60,''xl91'','''',4
1,1,'''',1,1,10,60,''xl91'','''',4
1,1,'''',1,1,11,60,''xl91'','''',4
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,6,12,5,''xl71'','''',4
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,3,12,11,''xl71'','''',4
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,3,12,14,''xl71'','''',4
1,1,'' '',1,6,12,17,''xl71'','''',4
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,6,12,23,''xl71'','''',4
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,3,12,29,''xl71'','''',4
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,3,12,32,''xl71'','''',4
1,1,'' '',1,6,12,35,''xl71'','''',4
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,3,12,41,''xl71'','''',4
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,3,12,44,''xl71'','''',4
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,3,12,47,''xl71'','''',4
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,3,12,50,''xl71'','''',4
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,3,12,53,''xl71'','''',4
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,3,12,56,''xl71'','''',4
1,1,'''',1,1,12,60,''xl91'','''',4
1,1,''/'',6,1,13,4,''xl138'','''',4
1,1,'''',1,2,13,5,''xl71'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,13,7,''xl71'','''',4
1,1,'''',1,2,13,9,''xl128'','''',4
1,1,'''',6,1,13,11,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,12,''xl80'','''',4
1,1,'''',6,1,13,13,''xl132'','''',4
1,1,'''',6,1,13,14,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,15,''xl80'','''',4
1,1,'''',6,1,13,16,''xl132'','''',4
1,1,''>>>(nInt_10+2;"0")&" ."'',1,3,13,17,''xl82'','''',4
1,1,''>>>(nInt_10+3;"0")&" ."'',1,3,13,20,''xl82'','''',4
1,1,'''',1,2,13,23,''xl71'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,13,25,''xl71'','''',4
1,1,'''',1,2,13,27,''xl128'','''',4
1,1,'''',6,1,13,29,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,30,''xl80'','''',4
1,1,'''',6,1,13,31,''xl132'','''',4
1,1,'''',6,1,13,32,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,33,''xl80'','''',4
1,1,'''',6,1,13,34,''xl132'','''',4
1,1,''>>>(nInt_10+2;"0")&" ."'',1,3,13,35,''xl82'','''',4
1,1,''>>>(nInt_10+3;"0")&" ."'',1,3,13,38,''xl82'','''',4
1,1,'''',6,1,13,41,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,42,''xl80'','''',4
1,1,'''',6,1,13,43,''xl132'','''',4
1,1,'''',6,1,13,44,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,45,''xl80'','''',4
1,1,'''',6,1,13,46,''xl132'','''',4
1,1,'''',6,1,13,47,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,48,''xl80'','''',4
1,1,'''',6,1,13,49,''xl132'','''',4
1,1,'''',6,1,13,50,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,51,''xl80'','''',4
1,1,'''',6,1,13,52,''xl132'','''',4
1,1,'''',6,1,13,53,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,54,''xl80'','''',4
1,1,'''',6,1,13,55,''xl132'','''',4
1,1,'''',6,1,13,56,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,57,''xl80'','''',4
1,1,'''',6,1,13,58,''xl132'','''',4
1,1,'''',1,1,13,60,''xl91'','''',4
1,1,''  '',5,1,14,5,''xl80'','''',4
1,1,'''',5,1,14,6,''xl80'','''',4
1,1,''  '',5,1,14,7,''xl80'','''',4
1,1,'''',5,1,14,8,''xl80'','''',4
1,1,''  '',5,1,14,9,''xl132'','''',4
1,1,'''',5,1,14,10,''xl132'','''',4
1,1,'''',5,1,14,17,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,18,''xl80'','''',4
1,1,'''',5,1,14,19,''xl132'','''',4
1,1,'''',5,1,14,20,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,21,''xl80'','''',4
1,1,'''',5,1,14,22,''xl132'','''',4
1,1,''  '',5,1,14,23,''xl80'','''',4
1,1,'''',5,1,14,24,''xl80'','''',4
1,1,''  '',5,1,14,25,''xl80'','''',4
1,1,'''',5,1,14,26,''xl80'','''',4
1,1,''  '',5,1,14,27,''xl132'','''',4
1,1,'''',5,1,14,28,''xl132'','''',4
1,1,'''',5,1,14,35,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,36,''xl80'','''',4
1,1,'''',5,1,14,37,''xl132'','''',4
1,1,'''',5,1,14,38,''xl80'','''',4
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,39,''xl80'','''',4
1,1,'''',5,1,14,40,''xl132'','''',4
1,1,'''',1,1,14,60,''xl91'','''',4
1,1,'''',1,1,15,60,''xl91'','''',4
1,1,'''',1,1,16,60,''xl91'','''',4
1,1,'''',1,1,17,60,''xl91'','''',4
1,1,'''',1,1,18,60,''xl91'','''',4
1,2,'''',1,1,1,1,''xl30'','''',4
1,2,'''',1,1,1,2,''xl39'','''',4
1,2,'''',1,1,1,3,''xl47'','''',4
1,2,'''',1,1,1,4,''xl39'','''',4
1,2,'''',1,1,1,5,''xl65'','''',4
1,2,'''',1,1,1,6,''xl65'','''',4
1,2,'''',1,1,1,7,''xl65'','''',4
1,2,'''',1,1,1,8,''xl65'','''',4
1,2,'''',1,1,1,9,''xl65'','''',4
1,2,'''',1,1,1,10,''xl65'','''',4
1,2,'''',1,1,1,11,''xl65'','''',4
1,2,'''',1,1,1,12,''xl65'','''',4
1,2,'''',1,1,1,13,''xl65'','''',4
1,2,'''',1,1,1,14,''xl65'','''',4
1,2,'''',1,1,1,15,''xl65'','''',4
1,2,'''',1,1,1,16,''xl65'','''',4
1,2,'''',1,1,1,17,''xl65'','''',4
1,2,'''',1,1,1,18,''xl65'','''',4
1,2,'''',1,1,1,19,''xl65'','''',4
1,2,'''',1,1,1,20,''xl65'','''',4
1,2,'''',1,1,1,21,''xl65'','''',4
1,2,'''',1,1,1,22,''xl65'','''',4
1,2,'''',1,1,1,23,''xl65'','''',4
1,2,'''',1,1,1,24,''xl65'','''',4
1,2,'''',1,1,1,25,''xl65'','''',4
1,2,'''',1,1,1,26,''xl65'','''',4
1,2,'''',1,1,1,27,''xl65'','''',4
1,2,'''',1,1,1,28,''xl65'','''',4
1,2,'''',1,1,1,29,''xl65'','''',4
1,2,'''',1,1,1,30,''xl65'','''',4
1,2,'''',1,1,1,31,''xl65'','''',4
1,2,'''',1,1,1,32,''xl65'','''',4
1,2,'''',1,1,1,33,''xl65'','''',4
1,2,'''',1,1,1,34,''xl65'','''',4
1,2,'''',1,1,1,35,''xl65'','''',4
1,2,'''',1,1,1,36,''xl65'','''',4
1,2,'''',1,1,1,37,''xl65'','''',4
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 23, '1,2,'''',1,1,1,38,''xl65'','''',4
1,2,'''',1,1,1,39,''xl65'','''',4
1,2,'''',1,1,1,40,''xl65'','''',4
1,2,'''',1,1,1,41,''xl65'','''',4
1,2,'''',1,1,1,42,''xl22'','''',4
1,2,'''',1,1,1,43,''xl22'','''',4
1,2,'''',1,1,1,44,''xl22'','''',4
1,2,'''',1,1,1,45,''xl22'','''',4
1,2,'''',1,1,1,46,''xl22'','''',4
1,2,'''',1,1,1,47,''xl22'','''',4
1,2,'''',1,1,1,48,''xl22'','''',4
1,2,'''',1,1,1,49,''xl22'','''',4
1,2,'''',1,1,1,50,''xl22'','''',4
1,2,'''',1,1,1,51,''xl22'','''',4
1,2,'''',1,1,1,52,''xl22'','''',4
1,2,'''',1,1,1,53,''xl22'','''',4
1,2,'''',1,1,1,54,''xl22'','''',4
1,2,'''',1,1,1,55,''xl22'','''',4
1,2,'''',1,1,1,56,''xl22'','''',4
1,2,'''',1,1,1,57,''xl22'','''',4
1,2,'''',1,1,1,58,''xl22'','''',4
1,2,'''',1,1,1,59,''xl22'','''',4
1,2,'''',1,1,1,60,''xl22'','''',4
2,2,''$$select dist po_n,ord from c_data8 where list=2 order by po_n,ord#po_n#ord#ZZ'',1,1,1,1,''xl28'','''',4
2,2,''>>>(<ord>;ZZ;<cpo>)'',1,1,1,2,''xl36'','''',4
2,2,''>>>(<ord>;ZZ;<cpog>)'',1,1,1,3,''xl60'','''',4
2,2,''>>>2(<ord>;ZZ;<lev>;1;<cdiv>)'',1,1,1,4,''xl60'','''',4
2,2,''>>(<ord>;ZZ;<s_1>)'',1,1,1,5,''xl69'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_2>)'',1,1,1,6,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_1>)'',1,1,1,7,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_2>)'',1,1,1,8,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_1>)'',1,1,1,9,''xl127'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_2>)'',1,1,1,10,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_3>)'',1,1,1,11,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_3>)'',1,1,1,12,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_3>)'',1,1,1,13,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_4>)'',1,1,1,14,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_4>)'',1,1,1,15,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_4>)'',1,1,1,16,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_5>)'',1,1,1,17,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_5>)'',1,1,1,18,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_5>)'',1,1,1,19,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_6>)'',1,1,1,20,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_6>)'',1,1,1,21,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_6>)'',1,1,1,22,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_1>)'',1,1,1,23,''xl69'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_2>)'',1,1,1,24,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_1>)'',1,1,1,25,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_2>)'',1,1,1,26,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_1>)'',1,1,1,27,''xl127'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_2>)'',1,1,1,28,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_3>)'',1,1,1,29,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_3>)'',1,1,1,30,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_3>)'',1,1,1,31,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_4>)'',1,1,1,32,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_4>)'',1,1,1,33,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_4>)'',1,1,1,34,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_5>)'',1,1,1,35,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_5>)'',1,1,1,36,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_5>)'',1,1,1,37,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_6>)'',1,1,1,38,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_6>)'',1,1,1,39,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_6>)'',1,1,1,40,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_7>)'',1,1,1,41,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_7>)'',1,1,1,42,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_7>)'',1,1,1,43,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_8>)'',1,1,1,44,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_8>)'',1,1,1,45,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_8>)'',1,1,1,46,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<s_9>)'',1,1,1,47,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<s_9>)'',1,1,1,48,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<s_9>)'',1,1,1,49,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_7>)'',1,1,1,50,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_7>)'',1,1,1,51,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_7>)'',1,1,1,52,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_8>)'',1,1,1,53,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_8>)'',1,1,1,54,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_8>)'',1,1,1,55,''xl127'',''"#,##0.00"'',4
2,2,''>>(<ord>;ZZ;<k_9>)'',1,1,1,56,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;AA;<k_9>)'',1,1,1,57,''xl69'',''"#,##0.00"'',4
2,2,''>>2(<ord>;ZZ;<su>;0;<k_9>)'',1,1,1,58,''xl127'',''"#,##0.00"'',4
2,2,''>>>2(<ord>;ZZ;<lev>;1;<metod>)'',1,1,1,59,''xl36'','''',4
2,2,'''',1,1,1,60,''xl92'','''',4
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 24, '1,1,'''',1,1,1,1,''xl22'','''',5
1,1,'''',1,1,1,2,''xl22'','''',5
1,1,'''',1,1,1,3,''xl22'','''',5
1,1,'''',1,1,1,4,''xl22'','''',5
1,1,'''',1,1,1,5,''xl22'','''',5
1,1,'''',1,1,1,6,''xl22'','''',5
1,1,'''',1,1,1,7,''xl22'','''',5
1,1,'''',1,1,1,8,''xl22'','''',5
1,1,'''',1,1,1,9,''xl22'','''',5
1,1,''>>"#/"'',1,1,1,10,''xl90'','''',5
1,1,'''',1,1,1,11,''xl22'','''',5
1,1,''  '',1,9,2,1,''xl81'','''',5
1,1,'''',1,1,2,10,''xl22'','''',5
1,1,'''',1,1,2,11,''xl22'','''',5
1,1,''     '',1,9,3,1,''xl81'','''',5
1,1,'''',1,1,3,10,''xl22'','''',5
1,1,'''',1,1,3,11,''xl22'','''',5
1,1,''>>" "&(dDate_2+1;0)&"."'',1,9,4,1,''xl47'','''',5
1,1,'''',1,1,4,10,''xl22'','''',5
1,1,'''',1,1,4,11,''xl22'','''',5
1,1,'''',1,1,5,1,''xl47'','''',5
1,1,'''',1,1,5,2,''xl47'','''',5
1,1,'''',1,1,5,3,''xl47'','''',5
1,1,'''',1,1,5,4,''xl47'','''',5
1,1,'''',1,1,5,5,''xl47'','''',5
1,1,'''',1,1,5,6,''xl47'','''',5
1,1,'''',1,1,5,7,''xl47'','''',5
1,1,'''',1,1,5,8,''xl47'','''',5
1,1,'''',1,1,5,9,''xl47'','''',5
1,1,'''',1,1,5,10,''xl22'','''',5
1,1,'''',1,1,5,11,''xl22'','''',5
1,1,''        '',1,1,6,1,''xl23'','''',5
1,1,'''',1,1,6,2,''xl32'','''',5
1,1,''$$select name from c_data1 where list=1#name#name#NN'',1,1,6,3,''xl85'','''',5
1,1,'''',1,1,6,4,''xl22'','''',5
1,1,'''',1,1,6,5,''xl144'','''',5
1,1,'''',1,1,6,6,''xl85'','''',5
1,1,'''',1,1,6,7,''xl41'','''',5
1,1,'''',1,1,6,8,''xl41'','''',5
1,1,'''',1,1,6,9,''xl41'','''',5
1,1,'''',1,1,6,10,''xl22'','''',5
1,1,'''',1,1,6,11,''xl22'','''',5
1,1,'''',1,3,7,1,''xl86'','''',5
1,1,'''',1,1,7,4,''xl41'','''',5
1,1,'''',1,1,7,5,''xl41'','''',5
1,1,'''',1,1,7,6,''xl41'','''',5
1,1,'''',1,1,7,7,''xl41'','''',5
1,1,'''',1,1,7,8,''xl41'','''',5
1,1,'''',1,1,7,9,''xl41'','''',5
1,1,'''',1,1,7,10,''xl22'','''',5
1,1,'''',1,1,7,11,''xl22'','''',5
1,1,'''',1,1,8,1,''xl23'','''',5
1,1,'''',1,1,8,2,''xl32'','''',5
1,1,'''',1,1,8,3,''xl41'','''',5
1,1,'''',1,1,8,4,''xl41'','''',5
1,1,'''',1,1,8,5,''xl41'','''',5
1,1,'''',1,1,8,6,''xl41'','''',5
1,1,'''',1,1,8,7,''xl41'','''',5
1,1,'''',1,1,8,8,''xl41'','''',5
1,1,'''',1,1,8,9,''xl41'','''',5
1,1,'''',1,1,8,10,''xl22'','''',5
1,1,'''',1,1,8,11,''xl22'','''',5
1,1,'' , chr(10) '',10,1,9,1,''xl140'','''',5
1,1,'' '',10,1,9,2,''xl141'','''',5
1,1,''          ,     -          ''+'''',2,6,9,3,''xl128'','''',5
1,1,'' '',10,1,9,9,''xl149'','''',5
1,1,'''',1,1,9,10,''xl91'','''',5
1,1,'''',1,1,9,11,''xl91'','''',5
1,1,'''',1,1,10,10,''xl91'','''',5
1,1,'''',1,1,10,11,''xl91'','''',5
1,1,'' '',2,3,11,3,''xl51'','''',5
1,1,''  '',2,3,11,6,''xl51'','''',5
1,1,'''',1,1,11,10,''xl91'','''',5
1,1,'''',1,1,11,11,''xl91'','''',5
1,1,'''',1,1,12,10,''xl91'','''',5
1,1,'''',1,1,12,11,''xl91'','''',5
1,1,'',   '',6,1,13,3,''xl142'','''',5
1,1,''  (),  ()'',6,1,13,4,''xl143'','''',5
1,1,''   ,  '',6,1,13,5,''xl145'','''',5
1,1,'',   '',6,1,13,6,''xl146'','''',5
1,1,''  (),  ()'',6,1,13,7,''xl147'','''',5
1,1,''   ,  '',6,1,13,8,''xl148'','''',5
1,1,'''',1,1,13,10,''xl91'','''',5
1,1,'''',1,1,13,11,''xl91'','''',5
1,1,'''',1,1,14,10,''xl91'','''',5
1,1,'''',1,1,14,11,''xl91'','''',5
1,1,'''',1,1,15,10,''xl91'','''',5
1,1,'''',1,1,15,11,''xl91'','''',5
1,1,'''',1,1,16,10,''xl91'','''',5
1,1,'''',1,1,16,11,''xl91'','''',5
1,1,'''',1,1,17,10,''xl91'','''',5
1,1,'''',1,1,17,11,''xl91'','''',5
1,1,'''',1,1,18,10,''xl91'','''',5
1,1,'''',1,1,18,11,''xl91'','''',5
1,2,'''',1,1,1,1,''xl30'','''',5
1,2,'''',1,1,1,2,''xl39'','''',5
1,2,'''',1,1,1,3,''xl47'','''',5
1,2,'''',1,1,1,4,''xl47'','''',5
1,2,'''',1,1,1,5,''xl47'','''',5
1,2,'''',1,1,1,6,''xl47'','''',5
1,2,'''',1,1,1,7,''xl47'','''',5
1,2,'''',1,1,1,8,''xl47'','''',5
1,2,'''',1,1,1,9,''xl47'','''',5
1,2,'''',1,1,1,10,''xl22'','''',5
1,2,'''',1,1,1,11,''xl22'','''',5
2,2,''$$select dist po_n,ord from c_data9 where list=1 order by po_n,ord#po_n#ord#ZZ'',1,1,1,1,''xl28'','''',5
2,2,''>>>(<ord>;ZZ;<cpo>)'',1,1,1,2,''xl36'','''',5
2,2,''>>>(<ord>;ZZ;<nam_1>)'',1,1,1,3,''xl45'','''',5
2,2,''>>>(<ord>;ZZ;<res_1>)'',1,1,1,4,''xl45'','''',5
2,2,''>>>(<ord>;ZZ;<dat_1>)'',1,1,1,5,''xl45'','''',5
2,2,''>>>(<ord>;ZZ;<nam_2>)'',1,1,1,6,''xl45'','''',5
2,2,''>>>(<ord>;ZZ;<res_2>)'',1,1,1,7,''xl45'','''',5
2,2,''>>>(<ord>;ZZ;<dat_2>)'',1,1,1,8,''xl45'','''',5
2,2,''>>>(<ord>;ZZ;<cpog>)'',1,1,1,9,''xl60'','''',5
2,2,'''',1,1,1,10,''xl92'','''',5
2,2,'''',1,1,1,11,''xl22'','''',5
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 25, '1,1,'''',1,1,1,1,''xl22'','''',6
1,1,'''',1,1,1,2,''xl22'','''',6
1,1,'''',1,1,1,3,''xl22'','''',6
1,1,'''',1,1,1,4,''xl22'','''',6
1,1,'''',1,1,1,5,''xl22'','''',6
1,1,'''',1,1,1,6,''xl22'','''',6
1,1,'''',1,1,1,7,''xl22'','''',6
1,1,'''',1,1,1,8,''xl22'','''',6
1,1,'''',1,1,1,9,''xl22'','''',6
1,1,''>>"#/"'',1,1,1,10,''xl90'','''',6
1,1,'''',1,1,1,11,''xl22'','''',6
1,1,''  '',1,9,2,1,''xl81'','''',6
1,1,'''',1,1,2,10,''xl22'','''',6
1,1,'''',1,1,2,11,''xl22'','''',6
1,1,''           '',1,9,3,1,''xl81'','''',6
1,1,'''',1,1,3,10,''xl22'','''',6
1,1,'''',1,1,3,11,''xl22'','''',6
1,1,''>>" "&(dDate_2+1;0)&"."'',1,9,4,1,''xl47'','''',6
1,1,'''',1,1,4,10,''xl22'','''',6
1,1,'''',1,1,4,11,''xl22'','''',6
1,1,'''',1,1,5,1,''xl47'','''',6
1,1,'''',1,1,5,2,''xl47'','''',6
1,1,'''',1,1,5,3,''xl47'','''',6
1,1,'''',1,1,5,4,''xl47'','''',6
1,1,'''',1,1,5,5,''xl47'','''',6
1,1,'''',1,1,5,6,''xl47'','''',6
1,1,'''',1,1,5,7,''xl47'','''',6
1,1,'''',1,1,5,8,''xl47'','''',6
1,1,'''',1,1,5,9,''xl47'','''',6
1,1,'''',1,1,5,10,''xl22'','''',6
1,1,'''',1,1,5,11,''xl22'','''',6
1,1,''        '',1,1,6,1,''xl23'','''',6
1,1,'''',1,1,6,2,''xl32'','''',6
1,1,''$$select name from c_data1 where list=2#name#name#NN'',1,1,6,3,''xl85'','''',6
1,1,'''',1,1,6,4,''xl22'','''',6
1,1,'''',1,1,6,5,''xl144'','''',6
1,1,'''',1,1,6,6,''xl85'','''',6
1,1,'''',1,1,6,7,''xl41'','''',6
1,1,'''',1,1,6,8,''xl41'','''',6
1,1,'''',1,1,6,9,''xl41'','''',6
1,1,'''',1,1,6,10,''xl22'','''',6
1,1,'''',1,1,6,11,''xl22'','''',6
1,1,'''',1,3,7,1,''xl86'','''',6
1,1,'''',1,1,7,4,''xl41'','''',6
1,1,'''',1,1,7,5,''xl41'','''',6
1,1,'''',1,1,7,6,''xl41'','''',6
1,1,'''',1,1,7,7,''xl41'','''',6
1,1,'''',1,1,7,8,''xl41'','''',6
1,1,'''',1,1,7,9,''xl41'','''',6
1,1,'''',1,1,7,10,''xl22'','''',6
1,1,'''',1,1,7,11,''xl22'','''',6
1,1,'''',1,1,8,1,''xl23'','''',6
1,1,'''',1,1,8,2,''xl32'','''',6
1,1,'''',1,1,8,3,''xl41'','''',6
1,1,'''',1,1,8,4,''xl41'','''',6
1,1,'''',1,1,8,5,''xl41'','''',6
1,1,'''',1,1,8,6,''xl41'','''',6
1,1,'''',1,1,8,7,''xl41'','''',6
1,1,'''',1,1,8,8,''xl41'','''',6
1,1,'''',1,1,8,9,''xl41'','''',6
1,1,'''',1,1,8,10,''xl22'','''',6
1,1,'''',1,1,8,11,''xl22'','''',6
1,1,'' , chr(10) '',10,1,9,1,''xl150'','''',6
1,1,'' '',10,1,9,2,''xl151'','''',6
1,1,''          ,     -          ''+'''',2,6,9,3,''xl128'','''',6
1,1,'' '',10,1,9,9,''xl158'','''',6
1,1,'''',1,1,9,10,''xl91'','''',6
1,1,'''',1,1,9,11,''xl91'','''',6
1,1,'''',1,1,10,10,''xl91'','''',6
1,1,'''',1,1,10,11,''xl91'','''',6
1,1,'' '',2,3,11,3,''xl51'','''',6
1,1,''  '',2,3,11,6,''xl51'','''',6
1,1,'''',1,1,11,10,''xl91'','''',6
1,1,'''',1,1,11,11,''xl91'','''',6
1,1,'''',1,1,12,10,''xl91'','''',6
1,1,'''',1,1,12,11,''xl91'','''',6
1,1,'',   '',6,1,13,3,''xl152'','''',6
1,1,''  (),  ()'',6,1,13,4,''xl153'','''',6
1,1,''   ,  '',6,1,13,5,''xl154'','''',6
1,1,'',   '',6,1,13,6,''xl155'','''',6
1,1,''  (),  ()'',6,1,13,7,''xl156'','''',6
1,1,''   ,  '',6,1,13,8,''xl157'','''',6
1,1,'''',1,1,13,10,''xl91'','''',6
1,1,'''',1,1,13,11,''xl91'','''',6
1,1,'''',1,1,14,10,''xl91'','''',6
1,1,'''',1,1,14,11,''xl91'','''',6
1,1,'''',1,1,15,10,''xl91'','''',6
1,1,'''',1,1,15,11,''xl91'','''',6
1,1,'''',1,1,16,10,''xl91'','''',6
1,1,'''',1,1,16,11,''xl91'','''',6
1,1,'''',1,1,17,10,''xl91'','''',6
1,1,'''',1,1,17,11,''xl91'','''',6
1,1,'''',1,1,18,10,''xl91'','''',6
1,1,'''',1,1,18,11,''xl91'','''',6
1,2,'''',1,1,1,1,''xl30'','''',6
1,2,'''',1,1,1,2,''xl39'','''',6
1,2,'''',1,1,1,3,''xl47'','''',6
1,2,'''',1,1,1,4,''xl47'','''',6
1,2,'''',1,1,1,5,''xl47'','''',6
1,2,'''',1,1,1,6,''xl47'','''',6
1,2,'''',1,1,1,7,''xl47'','''',6
1,2,'''',1,1,1,8,''xl47'','''',6
1,2,'''',1,1,1,9,''xl47'','''',6
1,2,'''',1,1,1,10,''xl22'','''',6
1,2,'''',1,1,1,11,''xl22'','''',6
2,2,''$$select dist po_n,ord from c_data9 where list=2 order by po_n,ord#po_n#ord#ZZ'',1,1,1,1,''xl28'','''',6
2,2,''>>>(<ord>;ZZ;<cpo>)'',1,1,1,2,''xl36'','''',6
2,2,''>>>(<ord>;ZZ;<nam_1>)'',1,1,1,3,''xl45'','''',6
2,2,''>>>(<ord>;ZZ;<res_1>)'',1,1,1,4,''xl45'','''',6
2,2,''>>>(<ord>;ZZ;<dat_1>)'',1,1,1,5,''xl45'','''',6
2,2,''>>>(<ord>;ZZ;<nam_2>)'',1,1,1,6,''xl45'','''',6
2,2,''>>>(<ord>;ZZ;<res_2>)'',1,1,1,7,''xl45'','''',6
2,2,''>>>(<ord>;ZZ;<dat_2>)'',1,1,1,8,''xl45'','''',6
2,2,''>>>(<ord>;ZZ;<cpog>)'',1,1,1,9,''xl60'','''',6
2,2,'''',1,1,1,10,''xl92'','''',6
2,2,'''',1,1,1,11,''xl22'','''',6
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=1;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=1'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=1;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=2;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=2'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=2;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '35.44,195.6
4.56,28.8
33.67,186
8.22,48.6
7.89,46.8
6.11,37.2
33.67,186
8.22,48.6
8.11,48
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '35.44,195.6
4.56,28.8
33.67,186
8.22,48.6
7.89,46.8
6.11,37.2
33.67,186
8.22,48.6
8.11,48
32.89,181.8
8.33,49.2
8.11,48
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '33.67,186
4.56,28.8
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '33.67,186
4.56,28.8
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '33.67,186
4.56,28.8
33.67,186
8.22,48.6
7.89,46.8
33.67,186
8.22,48.6
8.11,48
4.89,30.6
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '33.67,186
4.56,28.8
33.67,186
8.22,48.6
7.89,46.8
33.67,186
8.22,48.6
8.11,48
4.89,30.6
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.75in .7in .75in .7in;
	mso-header-margin:.3in;
	mso-footer-margin:.3in;}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:Print>
     <x:Scale>100</x:Scale>
     <x:SheetScale>100</x:SheetScale>
     <x:PaperSizeIndex>8</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.75in .7in .75in .7in;
	mso-header-margin:.3in;
	mso-footer-margin:.3in;}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:Print>
     <x:Scale>100</x:Scale>
     <x:SheetScale>100</x:SheetScale>
     <x:PaperSizeIndex>8</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.75in .7in .75in .7in;
	mso-header-margin:.3in;
	mso-footer-margin:.3in;}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:Print>
     <x:Scale>100</x:Scale>
     <x:SheetScale>100</x:SheetScale>
     <x:PaperSizeIndex>8</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.75in .7in .75in .7in;
	mso-header-margin:.3in;
	mso-footer-margin:.3in;}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:Print>
     <x:Scale>100</x:Scale>
     <x:SheetScale>100</x:SheetScale>
     <x:PaperSizeIndex>8</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,61.2
9,1,22.5
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,61.2
9,1,22.5
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,13.2
2,2,51
0,1,13.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,13.2
2,2,51
0,1,13.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,13.2
2,2,51
0,1,13.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,13.2
2,2,51
0,1,13.2
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 0, 'tr
	{mso-height-source:auto;}
col
	{mso-width-source:auto;}
br
	{mso-data-placement:same-cell;}
.style0
	{font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;
	mso-style-name:;
	mso-style-id:0;}
td
	{mso-style-parent:style0;
	padding-top:1px;padding-right:1px;padding-left:1px;mso-ignore:padding;
	font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 21, '.xl21
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 22, '.xl22
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 23, '.xl23
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 24, '.xl24
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 25, '.xl25
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 26, '.xl26
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 27, '.xl27
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 28, '.xl28
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 29, '.xl29
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 30, '.xl30
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 31, '.xl31
	{mso-style-parent:style0;
	text-align:left;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 32, '.xl32
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 33, '.xl33
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 34, '.xl34
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 35, '.xl35
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 36, '.xl36
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 37, '.xl37
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 38, '.xl38
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 39, '.xl39
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 40, '.xl40
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 41, '.xl41
	{mso-style-parent:style0;
	font-size:8pt;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 42, '.xl42
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 43, '.xl43
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 44, '.xl44
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 45, '.xl45
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 46, '.xl46
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 47, '.xl47
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 48, '.xl48
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 49, '.xl49
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 50, '.xl50
	{mso-style-parent:style0;
	mso-text-control:shrinktofit;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 51, '.xl51
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 52, '.xl52
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 53, '.xl53
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 54, '.xl54
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 55, '.xl55
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 56, '.xl56
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 57, '.xl57
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 58, '.xl58
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 59, '.xl59
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 60, '.xl60
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 61, '.xl61
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 62, '.xl62
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 63, '.xl63
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 64, '.xl64
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 65, '.xl65
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 66, '.xl66
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 67, '.xl67
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 68, '.xl68
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 69, '.xl69
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 70, '.xl70
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 71, '.xl71
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 72, '.xl72
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 73, '.xl73
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 74, '.xl74
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 75, '.xl75
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 76, '.xl76
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 77, '.xl77
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 78, '.xl78
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 79, '.xl79
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 80, '.xl80
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 81, '.xl81
	{mso-style-parent:style0;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 82, '.xl82
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 83, '.xl83
	{mso-style-parent:style0;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 84, '.xl84
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 85, '.xl85
	{mso-style-parent:style0;
	font-size:8pt;
	text-decoration:underline;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 86, '.xl86
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 87, '.xl87
	{mso-style-parent:style0;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 88, '.xl88
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 89, '.xl89
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 90, '.xl90
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 91, '.xl91
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 92, '.xl92
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 93, '.xl93
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 94, '.xl94
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 95, '.xl95
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 96, '.xl96
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 97, '.xl97
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 98, '.xl98
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 99, '.xl99
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 100, '.xl100
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 101, '.xl101
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 102, '.xl102
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 103, '.xl103
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 104, '.xl104
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 105, '.xl105
	{mso-style-parent:style0;
	font-size:8pt;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 106, '.xl106
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 107, '.xl107
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 108, '.xl108
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 109, '.xl109
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 110, '.xl110
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 111, '.xl111
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 112, '.xl112
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 113, '.xl113
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 114, '.xl114
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 115, '.xl115
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 116, '.xl116
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 117, '.xl117
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 118, '.xl118
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 119, '.xl119
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 120, '.xl120
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 121, '.xl121
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 122, '.xl122
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 123, '.xl123
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 124, '.xl124
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 125, '.xl125
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 126, '.xl126
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 127, '.xl127
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 128, '.xl128
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 129, '.xl129
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 130, '.xl130
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 131, '.xl131
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 132, '.xl132
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	color: #FF0000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 133, '.xl133
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 134, '.xl134
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 135, '.xl135
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 136, '.xl136
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 137, '.xl137
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 138, '.xl138
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 139, '.xl139
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 140, '.xl140
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 141, '.xl141
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 142, '.xl142
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 143, '.xl143
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 144, '.xl144
	{mso-style-parent:style0;
	text-decoration:underline;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 145, '.xl145
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 146, '.xl146
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 147, '.xl147
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 148, '.xl148
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 149, '.xl149
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 150, '.xl150
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 151, '.xl151
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 152, '.xl152
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 153, '.xl153
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 154, '.xl154
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 155, '.xl155
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 156, '.xl156
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 157, '.xl157
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 158, '.xl158
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '||list=1|list, poc, st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '||list=2|list,poc,st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '||list=1 and su=0||0||||||||  |0', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '||list=2 and su=0||0||||||||  |0', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '||list=1 and st=-1||0||||||||  |0', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '||list=2 and st=-1||0||||||||  |0', 'SYS_XL_sqr_rro_34n', 'XL_REPORT_PROP')

GO
		

	CREATE TABLE #T_OBJECT (LINK int, CODE varchar(100), NAME varchar(254), ORDERS int, LINK_SELF int, LINK_CLASS int, CODE_SELF varchar(100), CODE_CLASS varchar(100))



GO
		

	CREATE TABLE #T_GROUPS (GROUP_NAME varchar(250), NAME varchar(254), CODE_OBJ varchar(50), IMAGE_ID int, SQ_CODE varchar(100), GATE_CODE varchar(50), GDIR_CODE varchar(50), STAT int)



GO
		

	EXECUTE M_UPDATE_SQUERY '#T_OBJ','#T_PROP','#T_OBJECT','#T_GROUPS'

	DROP TABLE #T_OBJ
	DROP TABLE #T_PROP
	DROP TABLE #T_OBJECT
	DROP TABLE #T_GROUPS
	exec dtt '#t_xlrep_'

--end squery

GO




-- XL_REPORT-SYS_XL_sqr_rro_34n_cons.sql

--squery
--KS-1063\katyakov 29.01.2025

--%OBJECT%SYS_XL_sqr_rro_34n_cons%%
-- : sqr_rro_34n_cons.xlt

if object_id('tempdb..#T_OBJ') is not null drop table #T_OBJ
if object_id('tempdb..#T_PROP') is not null drop table #T_PROP
if object_id('tempdb..#T_OBJECT') is not null drop table #T_OBJECT
if object_id('tempdb..#T_GROUPS') is not null drop table #T_GROUPS

GO


	CREATE TABLE #T_OBJ (LINK int, NAME varchar(254), OBJECT int, CODE varchar(100), USERS int, ORDERS int, LINK_SELF int, LINK_STATE int, CODE_OBJ varchar(100), CODE_SELF varchar(100), CODE_STATE varchar(100))


	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('sqr_rro_34n_cons.xlt', 'SYS_XL_sqr_rro_34n_cons', null, null, 'XL_REPORT', null, null)

GO
		

	CREATE TABLE #T_PROP (LINK_UP int, PROPERTY int, USERS int, ORDERS int, VALUE nvarchar(max), CODE_UP varchar(100), CODE_PROP varchar(100))


	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'katyakov', 'SYS_XL_sqr_rro_34n_cons', 'SQUERY_AUTHOR')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '2025-01-29 15:37:35.917', 'SYS_XL_sqr_rro_34n_cons', 'SQUERY_DATETIME')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,'''',1,1,1,1,''xl22'','''',1
1,1,'''',1,1,1,2,''xl22'','''',1
1,1,'''',1,1,1,3,''xl22'','''',1
1,1,'''',1,1,1,4,''xl22'','''',1
1,1,'''',1,1,1,5,''xl22'','''',1
1,1,'''',1,1,1,6,''xl22'','''',1
1,1,'''',1,1,1,7,''xl22'','''',1
1,1,'''',1,1,1,8,''xl22'','''',1
1,1,'''',1,1,1,9,''xl22'','''',1
1,1,'''',1,1,1,10,''xl22'','''',1
1,1,'''',1,1,1,11,''xl22'','''',1
1,1,'''',1,1,1,12,''xl22'','''',1
1,1,'''',1,1,1,13,''xl22'','''',1
1,1,'''',1,1,1,14,''xl22'','''',1
1,1,'''',1,1,1,15,''xl22'','''',1
1,1,'' 2'',1,1,1,16,''xl71'','''',1
1,1,'''',1,1,1,17,''xl73'','''',1
1,1,'''',1,1,1,18,''xl73'','''',1
1,1,'''',1,1,1,19,''xl73'','''',1
1,1,'''',1,1,1,20,''xl73'','''',1
1,1,'''',1,1,1,21,''xl73'','''',1
1,1,'''',1,1,1,22,''xl73'','''',1
1,1,'''',1,1,1,23,''xl22'','''',1
1,1,'''',1,1,1,24,''xl74'','''',1
1,1,'''',1,1,1,25,''xl74'','''',1
1,1,'''',1,1,1,26,''xl74'','''',1
1,1,'''',1,1,1,27,''xl74'','''',1
1,1,'''',1,1,1,28,''xl23'','''',1
1,1,'''',1,1,1,29,''xl74'','''',1
1,1,'''',1,1,1,30,''xl74'','''',1
1,1,'''',1,1,1,31,''xl74'','''',1
1,1,'''',1,1,1,32,''xl74'','''',1
1,1,'''',1,1,1,33,''xl74'','''',1
1,1,'''',1,1,1,34,''xl74'','''',1
1,1,'''',1,1,1,35,''xl74'','''',1
1,1,'''',1,1,1,36,''xl74'','''',1
1,1,'''',1,1,1,37,''xl74'','''',1
1,1,'''',1,1,1,38,''xl74'','''',1
1,1,'''',1,1,1,39,''xl74'','''',1
1,1,'''',1,1,1,40,''xl74'','''',1
1,1,'''',1,1,1,41,''xl74'','''',1
1,1,''>>"#/"'',1,1,1,42,''xl78'','''',1
1,1,'''',1,1,1,43,''xl22'','''',1
1,1,''      '',1,16,2,1,''xl72'','''',1
1,1,'''',1,1,2,17,''xl34'','''',1
1,1,'''',1,1,2,18,''xl34'','''',1
1,1,'''',1,1,2,19,''xl34'','''',1
1,1,'''',1,1,2,20,''xl34'','''',1
1,1,'''',1,1,2,21,''xl34'','''',1
1,1,'''',1,1,2,22,''xl34'','''',1
1,1,'''',1,1,2,23,''xl22'','''',1
1,1,'''',1,1,2,24,''xl74'','''',1
1,1,'''',1,1,2,25,''xl74'','''',1
1,1,'''',1,1,2,26,''xl74'','''',1
1,1,'''',1,1,2,27,''xl74'','''',1
1,1,'''',1,1,2,28,''xl23'','''',1
1,1,'''',1,1,2,29,''xl74'','''',1
1,1,'''',1,1,2,30,''xl74'','''',1
1,1,'''',1,1,2,31,''xl74'','''',1
1,1,'''',1,1,2,32,''xl74'','''',1
1,1,'''',1,1,2,33,''xl74'','''',1
1,1,'''',1,1,2,34,''xl74'','''',1
1,1,'''',1,1,2,35,''xl74'','''',1
1,1,'''',1,1,2,36,''xl74'','''',1
1,1,'''',1,1,2,37,''xl74'','''',1
1,1,'''',1,1,2,38,''xl74'','''',1
1,1,'''',1,1,2,39,''xl74'','''',1
1,1,'''',1,1,2,40,''xl74'','''',1
1,1,'''',1,1,2,41,''xl74'','''',1
1,1,'''',1,1,2,42,''xl22'','''',1
1,1,'''',1,1,2,43,''xl22'','''',1
1,1,''          ,    '',1,16,3,1,''xl72'','''',1
1,1,'''',1,1,3,17,''xl34'','''',1
1,1,'''',1,1,3,18,''xl34'','''',1
1,1,'''',1,1,3,19,''xl34'','''',1
1,1,'''',1,1,3,20,''xl34'','''',1
1,1,'''',1,1,3,21,''xl34'','''',1
1,1,'''',1,1,3,22,''xl34'','''',1
1,1,'''',1,1,3,23,''xl22'','''',1
1,1,'''',1,1,3,24,''xl74'','''',1
1,1,'''',1,1,3,25,''xl74'','''',1
1,1,'''',1,1,3,26,''xl74'','''',1
1,1,'''',1,1,3,27,''xl74'','''',1
1,1,'''',1,1,3,28,''xl71'','''',1
1,1,'''',1,1,3,29,''xl22'','''',1
1,1,'''',1,1,3,30,''xl74'','''',1
1,1,'''',1,1,3,31,''xl74'','''',1
1,1,'''',1,1,3,32,''xl74'','''',1
1,1,'''',1,1,3,33,''xl74'','''',1
1,1,'''',1,1,3,34,''xl74'','''',1
1,1,'''',1,1,3,35,''xl74'','''',1
1,1,'''',1,1,3,36,''xl74'','''',1
1,1,'''',1,1,3,37,''xl74'','''',1
1,1,'''',1,1,3,38,''xl74'','''',1
1,1,'''',1,1,3,39,''xl74'','''',1
1,1,'''',1,1,3,40,''xl74'','''',1
1,1,'''',1,1,3,41,''xl74'','''',1
1,1,'''',1,1,3,42,''xl22'','''',1
1,1,'''',1,1,3,43,''xl22'','''',1
1,1,'''',1,1,4,1,''xl22'','''',1
1,1,'''',1,1,4,2,''xl22'','''',1
1,1,'''',1,1,4,3,''xl44'','''',1
1,1,'''',1,1,4,4,''xl35'','''',1
1,1,'''',1,1,4,5,''xl44'','''',1
1,1,'''',1,1,4,6,''xl44'','''',1
1,1,'''',1,1,4,7,''xl44'','''',1
1,1,'''',1,1,4,8,''xl44'','''',1
1,1,'''',1,1,4,9,''xl44'','''',1
1,1,'''',1,1,4,10,''xl34'','''',1
1,1,'''',1,1,4,11,''xl34'','''',1
1,1,'''',1,1,4,12,''xl34'','''',1
1,1,'''',1,1,4,13,''xl34'','''',1
1,1,'''',1,1,4,14,''xl44'','''',1
1,1,'''',1,1,4,15,''xl44'','''',1
1,1,'''',1,1,4,16,''xl44'','''',1
1,1,'''',1,1,4,17,''xl44'','''',1
1,1,'''',1,1,4,18,''xl44'','''',1
1,1,'''',1,1,4,19,''xl44'','''',1
1,1,'''',1,1,4,20,''xl44'','''',1
1,1,'''',1,1,4,21,''xl44'','''',1
1,1,'''',1,1,4,22,''xl44'','''',1
1,1,'''',1,1,4,23,''xl22'','''',1
1,1,'''',1,1,4,24,''xl74'','''',1
1,1,'''',1,1,4,25,''xl74'','''',1
1,1,'''',1,1,4,26,''xl74'','''',1
1,1,'''',1,1,4,27,''xl74'','''',1
1,1,'''',1,1,4,28,''xl23'','''',1
1,1,'''',1,1,4,29,''xl74'','''',1
1,1,'''',1,1,4,30,''xl74'','''',1
1,1,'''',1,1,4,31,''xl74'','''',1
1,1,'''',1,1,4,32,''xl74'','''',1
1,1,'''',1,1,4,33,''xl74'','''',1
1,1,'''',1,1,4,34,''xl74'','''',1
1,1,'''',1,1,4,35,''xl74'','''',1
1,1,'''',1,1,4,36,''xl74'','''',1
1,1,'''',1,1,4,37,''xl74'','''',1
1,1,'''',1,1,4,38,''xl74'','''',1
1,1,'''',1,1,4,39,''xl74'','''',1
1,1,'''',1,1,4,40,''xl74'','''',1
1,1,'''',1,1,4,41,''xl74'','''',1
1,1,'''',1,1,4,42,''xl22'','''',1
1,1,'''',1,1,4,43,''xl22'','''',1
1,1,''        '',1,1,5,1,''xl23'','''',1
1,1,'''',1,1,5,2,''xl33'','''',1
1,1,''$$select name from c_data1 where list=1#name#name#NN'',1,14,5,3,''xl33'','''',1
1,1,'''',1,1,5,17,''xl34'','''',1
1,1,'''',1,1,5,18,''xl34'','''',1
1,1,'''',1,1,5,19,''xl34'','''',1
1,1,'''',1,1,5,20,''xl34'','''',1
1,1,'''',1,1,5,21,''xl34'','''',1
1,1,'''',1,1,5,22,''xl34'','''',1
1,1,'''',1,1,5,23,''xl34'','''',1
1,1,'''',1,1,5,24,''xl34'','''',1
1,1,'''',1,1,5,25,''xl34'','''',1
1,1,'''',1,1,5,26,''xl34'','''',1
1,1,'''',1,1,5,27,''xl74'','''',1
1,1,'''',1,1,5,28,''xl23'','''',1
1,1,'''',1,1,5,29,''xl74'','''',1
1,1,'''',1,1,5,30,''xl74'','''',1
1,1,'''',1,1,5,31,''xl74'','''',1
1,1,'''',1,1,5,32,''xl74'','''',1
1,1,'''',1,1,5,33,''xl74'','''',1
1,1,'''',1,1,5,34,''xl74'','''',1
1,1,'''',1,1,5,35,''xl74'','''',1
1,1,'''',1,1,5,36,''xl74'','''',1
1,1,'''',1,1,5,37,''xl74'','''',1
1,1,'''',1,1,5,38,''xl74'','''',1
1,1,'''',1,1,5,39,''xl74'','''',1
1,1,'''',1,1,5,40,''xl74'','''',1
1,1,'''',1,1,5,41,''xl74'','''',1
1,1,'''',1,1,5,42,''xl22'','''',1
1,1,'''',1,1,5,43,''xl22'','''',1
1,1,''  '',1,1,6,1,''xl23'','''',1
1,1,'''',1,1,6,2,''xl33'','''',1
1,1,''$$select name from c_data2#name#name#NN'',1,14,6,3,''xl33'','''',1
1,1,'''',1,1,6,17,''xl34'','''',1
1,1,'''',1,1,6,18,''xl34'','''',1
1,1,'''',1,1,6,19,''xl34'','''',1
1,1,'''',1,1,6,20,''xl34'','''',1
1,1,'''',1,1,6,21,''xl34'','''',1
1,1,'''',1,1,6,22,''xl34'','''',1
1,1,'''',1,1,6,23,''xl34'','''',1
1,1,'''',1,1,6,24,''xl34'','''',1
1,1,'''',1,1,6,25,''xl34'','''',1
1,1,'''',1,1,6,26,''xl34'','''',1
1,1,'''',1,1,6,27,''xl44'','''',1
1,1,'''',1,1,6,28,''xl23'','''',1
1,1,'''',1,1,6,29,''xl44'','''',1
1,1,'''',1,1,6,30,''xl44'','''',1
1,1,'''',1,1,6,31,''xl44'','''',1
1,1,'''',1,1,6,32,''xl44'','''',1
1,1,'''',1,1,6,33,''xl44'','''',1
1,1,'''',1,1,6,34,''xl44'','''',1
1,1,'''',1,1,6,35,''xl44'','''',1
1,1,'''',1,1,6,36,''xl44'','''',1
1,1,'''',1,1,6,37,''xl44'','''',1
1,1,'''',1,1,6,38,''xl44'','''',1
1,1,'''',1,1,6,39,''xl44'','''',1
1,1,'''',1,1,6,40,''xl44'','''',1
1,1,'''',1,1,6,41,''xl44'','''',1
1,1,'''',1,1,6,42,''xl22'','''',1
1,1,'''',1,1,6,43,''xl22'','''',1
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,1,7,1,''xl24'','''',1
1,1,'''',1,1,7,2,''xl34'','''',1
1,1,'''',1,1,7,3,''xl34'','''',1
1,1,'''',1,1,7,4,''xl34'','''',1
1,1,'''',1,1,7,5,''xl34'','''',1
1,1,'''',1,1,7,6,''xl34'','''',1
1,1,'''',1,1,7,7,''xl34'','''',1
1,1,'''',1,1,7,8,''xl34'','''',1
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,'''',1,1,7,9,''xl44'','''',1
1,1,'''',1,1,7,10,''xl44'','''',1
1,1,'''',1,1,7,11,''xl44'','''',1
1,1,'''',1,1,7,12,''xl44'','''',1
1,1,'''',1,1,7,13,''xl44'','''',1
1,1,'''',1,1,7,14,''xl44'','''',1
1,1,'''',1,1,7,15,''xl44'','''',1
1,1,'''',1,1,7,16,''xl44'','''',1
1,1,'''',1,1,7,17,''xl44'','''',1
1,1,'''',1,1,7,18,''xl44'','''',1
1,1,'''',1,1,7,19,''xl44'','''',1
1,1,'''',1,1,7,20,''xl44'','''',1
1,1,'''',1,1,7,21,''xl44'','''',1
1,1,'''',1,1,7,22,''xl44'','''',1
1,1,'''',1,1,7,23,''xl44'','''',1
1,1,'''',1,1,7,24,''xl44'','''',1
1,1,'''',1,1,7,25,''xl44'','''',1
1,1,'''',1,1,7,26,''xl44'','''',1
1,1,'''',1,1,7,27,''xl44'','''',1
1,1,'''',1,1,7,28,''xl44'','''',1
1,1,'''',1,1,7,29,''xl44'','''',1
1,1,'''',1,1,7,30,''xl44'','''',1
1,1,'''',1,1,7,31,''xl44'','''',1
1,1,'''',1,1,7,32,''xl44'','''',1
1,1,'''',1,1,7,33,''xl44'','''',1
1,1,'''',1,1,7,34,''xl44'','''',1
1,1,'''',1,1,7,35,''xl44'','''',1
1,1,'''',1,1,7,36,''xl44'','''',1
1,1,'''',1,1,7,37,''xl44'','''',1
1,1,'''',1,1,7,38,''xl44'','''',1
1,1,'''',1,1,7,39,''xl44'','''',1
1,1,'''',1,1,7,40,''xl44'','''',1
1,1,'''',1,1,7,41,''xl44'','''',1
1,1,'''',1,1,7,42,''xl22'','''',1
1,1,'''',1,1,7,43,''xl22'','''',1
1,1,'''',1,1,8,1,''xl23'','''',1
1,1,'''',1,1,8,2,''xl35'','''',1
1,1,'''',1,1,8,3,''xl44'','''',1
1,1,'''',1,1,8,4,''xl35'','''',1
1,1,'''',1,1,8,5,''xl44'','''',1
1,1,'''',1,1,8,6,''xl44'','''',1
1,1,'''',1,1,8,7,''xl44'','''',1
1,1,'''',1,1,8,8,''xl44'','''',1
1,1,'''',1,1,8,9,''xl44'','''',1
1,1,'''',1,1,8,10,''xl44'','''',1
1,1,'''',1,1,8,11,''xl44'','''',1
1,1,'''',1,1,8,12,''xl44'','''',1
1,1,'''',1,1,8,13,''xl44'','''',1
1,1,'''',1,1,8,14,''xl44'','''',1
1,1,'''',1,1,8,15,''xl44'','''',1
1,1,'''',1,1,8,16,''xl44'','''',1
1,1,'''',1,1,8,17,''xl44'','''',1
1,1,'''',1,1,8,18,''xl44'','''',1
1,1,'''',1,1,8,19,''xl44'','''',1
1,1,'''',1,1,8,20,''xl44'','''',1
1,1,'''',1,1,8,21,''xl44'','''',1
1,1,'''',1,1,8,22,''xl44'','''',1
1,1,'''',1,1,8,23,''xl44'','''',1
1,1,'''',1,1,8,24,''xl44'','''',1
1,1,'''',1,1,8,25,''xl44'','''',1
1,1,'''',1,1,8,26,''xl44'','''',1
1,1,'''',1,1,8,27,''xl44'','''',1
1,1,'''',1,1,8,28,''xl44'','''',1
1,1,'''',1,1,8,29,''xl44'','''',1
1,1,'''',1,1,8,30,''xl44'','''',1
1,1,'''',1,1,8,31,''xl44'','''',1
1,1,'''',1,1,8,32,''xl44'','''',1
1,1,'''',1,1,8,33,''xl44'','''',1
1,1,'''',1,1,8,34,''xl44'','''',1
1,1,'''',1,1,8,35,''xl44'','''',1
1,1,'''',1,1,8,36,''xl44'','''',1
1,1,'''',1,1,8,37,''xl44'','''',1
1,1,'''',1,1,8,38,''xl44'','''',1
1,1,'''',1,1,8,39,''xl44'','''',1
1,1,'''',1,1,8,40,''xl44'','''',1
1,1,'''',1,1,8,41,''xl44'','''',1
1,1,'''',1,1,8,42,''xl22'','''',1
1,1,'''',1,1,8,43,''xl22'','''',1
1,1,''>>>" , chr(10)  "&cText_35'',10,1,9,1,''xl25'','''',1
1,1,'' '',10,1,9,2,''xl36'','''',1
1,1,''  ,  '',10,1,9,3,''xl45'','''',1
1,1,''    '',4,1,9,4,''xl50'','''',1
1,1,''>>>"      "&cText_35'',3,12,9,5,''xl60'','''',1
1,1,''>>>" ..       "&cText_35&"           () "'',3,12,9,17,''xl60'','''',1
1,1,''>>>"    () "&cText_35'',3,6,9,29,''xl60'','''',1
1,1,''>>>" ..     () "&cText_35&"           () "'',3,6,9,35,''xl60'','''',1
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,9,41,''xl75'','''',1
1,1,'''',1,1,9,42,''xl79'','''',1
1,1,'''',1,1,9,43,''xl79'','''',1
1,1,'''',1,1,10,42,''xl79'','''',1
1,1,'''',1,1,10,43,''xl79'','''',1
1,1,'''',1,1,11,42,''xl79'','''',1
1,1,'''',1,1,11,43,''xl79'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,5,''xl60'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,9,''xl60'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,11,''xl60'','''',1
1,1,'' '',1,4,12,13,''xl60'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,17,''xl60'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,21,''xl60'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,23,''xl60'','''',1
1,1,'' '',1,4,12,25,''xl60'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,12,29,''xl60'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,12,31,''xl60'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,12,33,''xl60'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,12,35,''xl60'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,12,37,''xl60'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,12,39,''xl60'','''',1
1,1,'''',1,1,12,42,''xl79'','''',1
1,1,'''',1,1,12,43,''xl79'','''',1
1,1,''/'',6,1,13,4,''xl51'','''',1
1,1,'''',1,2,13,5,''xl60'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,13,7,''xl60'','''',1
1,1,'''',6,1,13,9,''xl64'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,10,''xl66'','''',1
1,1,'''',6,1,13,11,''xl67'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,12,''xl68'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,13,13,''xl70'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,13,15,''xl70'','''',1
1,1,'''',1,2,13,17,''xl60'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,13,19,''xl60'','''',1
1,1,'''',6,1,13,21,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,22,''xl69'','''',1
1,1,'''',6,1,13,23,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,24,''xl69'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,13,25,''xl70'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,13,27,''xl70'','''',1
1,1,'''',6,1,13,29,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,30,''xl69'','''',1
1,1,'''',6,1,13,31,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,32,''xl69'','''',1
1,1,'''',6,1,13,33,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,34,''xl69'','''',1
1,1,'''',6,1,13,35,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,36,''xl69'','''',1
1,1,'''',6,1,13,37,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,38,''xl69'','''',1
1,1,'''',6,1,13,39,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,13,40,''xl69'','''',1
1,1,'''',1,1,13,42,''xl79'','''',1
1,1,'''',1,1,13,43,''xl79'','''',1
1,1,''  '',5,1,14,5,''xl55'','''',1
1,1,'''',5,1,14,6,''xl61'','''',1
1,1,''  '',5,1,14,7,''xl62'','''',1
1,1,'''',5,1,14,8,''xl63'','''',1
1,1,'''',5,1,14,13,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,14,''xl69'','''',1
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '1,1,'''',5,1,14,15,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,16,''xl69'','''',1
1,1,''  '',5,1,14,17,''xl69'','''',1
1,1,'''',5,1,14,18,''xl69'','''',1
1,1,''  '',5,1,14,19,''xl69'','''',1
1,1,'''',5,1,14,20,''xl69'','''',1
1,1,'''',5,1,14,25,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,26,''xl69'','''',1
1,1,'''',5,1,14,27,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,14,28,''xl69'','''',1
1,1,'''',1,1,14,42,''xl79'','''',1
1,1,'''',1,1,14,43,''xl79'','''',1
1,1,'''',1,1,15,42,''xl79'','''',1
1,1,'''',1,1,15,43,''xl79'','''',1
1,1,'''',1,1,16,42,''xl79'','''',1
1,1,'''',1,1,16,43,''xl79'','''',1
1,1,'''',1,1,17,42,''xl79'','''',1
1,1,'''',1,1,17,43,''xl79'','''',1
1,1,'''',1,1,18,42,''xl79'','''',1
1,1,'''',1,1,18,43,''xl79'','''',1
1,2,''>>>"   "&cText_35'',1,1,1,1,''xl30'','''',1
1,2,''8000'',1,1,1,2,''xl41'','''',1
1,2,'''',1,1,1,3,''xl48'','''',1
1,2,'''',1,1,1,4,''xl48'','''',1
1,2,''>>(<list>;1;<s_1>)'',1,1,1,5,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_2>)'',1,1,1,6,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_1>)'',1,1,1,7,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_2>)'',1,1,1,8,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_3>)'',1,1,1,9,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_3>)'',1,1,1,10,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_4>)'',1,1,1,11,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_4>)'',1,1,1,12,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_5>)'',1,1,1,13,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_5>)'',1,1,1,14,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_6>)'',1,1,1,15,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_6>)'',1,1,1,16,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_1>)'',1,1,1,17,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_2>)'',1,1,1,18,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_1>)'',1,1,1,19,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_2>)'',1,1,1,20,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_3>)'',1,1,1,21,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_3>)'',1,1,1,22,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_4>)'',1,1,1,23,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_4>)'',1,1,1,24,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_5>)'',1,1,1,25,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_5>)'',1,1,1,26,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_6>)'',1,1,1,27,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_6>)'',1,1,1,28,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_7>)'',1,1,1,29,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_7>)'',1,1,1,30,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_8>)'',1,1,1,31,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_8>)'',1,1,1,32,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_9>)'',1,1,1,33,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_9>)'',1,1,1,34,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_7>)'',1,1,1,35,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_7>)'',1,1,1,36,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_8>)'',1,1,1,37,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_8>)'',1,1,1,38,''xl58'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_9>)'',1,1,1,39,''xl58'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_9>)'',1,1,1,40,''xl58'',''"#,##0.00"'',1
1,2,'''',1,1,1,41,''xl76'','''',1
1,2,'''',1,1,1,42,''xl22'','''',1
1,2,'''',1,1,1,43,''xl22'','''',1
1,2,'''',1,1,2,1,''xl31'','''',1
1,2,'''',1,1,2,2,''xl42'','''',1
1,2,'''',1,1,2,3,''xl49'','''',1
1,2,'''',1,1,2,4,''xl42'','''',1
1,2,'''',1,1,2,5,''xl54'','''',1
1,2,'''',1,1,2,6,''xl54'','''',1
1,2,'''',1,1,2,7,''xl54'','''',1
1,2,'''',1,1,2,8,''xl54'','''',1
1,2,'''',1,1,2,9,''xl54'','''',1
1,2,'''',1,1,2,10,''xl54'','''',1
1,2,'''',1,1,2,11,''xl54'','''',1
1,2,'''',1,1,2,12,''xl54'','''',1
1,2,'''',1,1,2,13,''xl54'','''',1
1,2,'''',1,1,2,14,''xl54'','''',1
1,2,'''',1,1,2,15,''xl54'','''',1
1,2,'''',1,1,2,16,''xl54'','''',1
1,2,'''',1,1,2,17,''xl54'','''',1
1,2,'''',1,1,2,18,''xl54'','''',1
1,2,'''',1,1,2,19,''xl54'','''',1
1,2,'''',1,1,2,20,''xl54'','''',1
1,2,'''',1,1,2,21,''xl54'','''',1
1,2,'''',1,1,2,22,''xl54'','''',1
1,2,'''',1,1,2,23,''xl54'','''',1
1,2,'''',1,1,2,24,''xl54'','''',1
1,2,'''',1,1,2,25,''xl54'','''',1
1,2,'''',1,1,2,26,''xl54'','''',1
1,2,'''',1,1,2,27,''xl54'','''',1
1,2,'''',1,1,2,28,''xl54'','''',1
1,2,'''',1,1,2,29,''xl54'','''',1
1,2,'''',1,1,2,30,''xl54'','''',1
1,2,'''',1,1,2,31,''xl54'','''',1
1,2,'''',1,1,2,32,''xl54'','''',1
1,2,'''',1,1,2,33,''xl54'','''',1
1,2,'''',1,1,2,34,''xl54'','''',1
1,2,'''',1,1,2,35,''xl54'','''',1
1,2,'''',1,1,2,36,''xl54'','''',1
1,2,'''',1,1,2,37,''xl54'','''',1
1,2,'''',1,1,2,38,''xl54'','''',1
1,2,'''',1,1,2,39,''xl54'','''',1
1,2,'''',1,1,2,40,''xl54'','''',1
1,2,'''',1,1,2,41,''xl54'','''',1
1,2,'''',1,1,2,42,''xl22'','''',1
1,2,'''',1,1,2,43,''xl22'','''',1
1,2,''>>>Footer'',1,41,3,1,''xl32'','''',1
1,2,'''',1,1,3,42,''xl22'','''',1
1,2,'''',1,1,3,43,''xl22'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,3,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,4,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,5,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,6,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,7,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,8,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,9,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,10,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,11,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,12,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,13,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,14,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,15,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,16,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,17,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,18,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,19,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,20,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,21,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,22,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,23,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,24,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,25,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,26,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,27,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,28,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,29,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,30,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,31,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,32,''xl26'','''',1
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '2,1,''>>(("R[0]C[0]";))'',1,1,1,33,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,34,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,35,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,36,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,37,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,38,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,39,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,40,''xl26'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,41,''xl26'','''',1
2,1,'''',1,1,1,42,''xl22'','''',1
2,1,'''',1,1,1,43,''xl22'','''',1
3,1,''>>>{po5_n}'',1,1,1,1,''xl28'','''',1
3,1,''>>>{cpo5}'',1,1,1,2,''xl37'','''',1
3,1,''>>>{cpo5g}'',1,1,1,3,''xl37'','''',1
3,1,'''',1,1,1,4,''xl52'','''',1
3,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',1
3,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',1
3,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',1
3,1,'''',1,1,1,41,''xl52'','''',1
3,1,'''',1,1,1,42,''xl22'','''',1
3,1,'''',1,1,1,43,''xl22'','''',1
4,1,''>>>{po4_n}'',1,1,1,1,''xl28'','''',1
4,1,''>>>{cpo4}'',1,1,1,2,''xl37'','''',1
4,1,''>>>{cpo4g}'',1,1,1,3,''xl37'','''',1
4,1,'''',1,1,1,4,''xl52'','''',1
4,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',1
4,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',1
4,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',1
4,1,'''',1,1,1,41,''xl52'','''',1
4,1,'''',1,1,1,42,''xl22'','''',1
4,1,'''',1,1,1,43,''xl22'','''',1
5,1,''>>>{po3_n}'',1,1,1,1,''xl28'','''',1
5,1,''>>>{cpo3}'',1,1,1,2,''xl37'','''',1
5,1,''>>>{cpo3g}'',1,1,1,3,''xl37'','''',1
5,1,'''',1,1,1,4,''xl52'','''',1
5,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',1
5,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '5,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',1
5,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',1
5,1,'''',1,1,1,41,''xl52'','''',1
5,1,'''',1,1,1,42,''xl22'','''',1
5,1,'''',1,1,1,43,''xl22'','''',1
6,1,''>>>{po2_n}'',1,1,1,1,''xl28'','''',1
6,1,''>>>{cpo2}'',1,1,1,2,''xl37'','''',1
6,1,''>>>{cpo2g}'',1,1,1,3,''xl37'','''',1
6,1,'''',1,1,1,4,''xl52'','''',1
6,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',1
6,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',1
6,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',1
6,1,'''',1,1,1,41,''xl52'','''',1
6,1,'''',1,1,1,42,''xl22'','''',1
6,1,'''',1,1,1,43,''xl22'','''',1
7,1,''>>>{po1_n}'',1,1,1,1,''xl28'','''',1
7,1,''>>>{cpo1}'',1,1,1,2,''xl37'','''',1
7,1,''>>>{cpo1g}'',1,1,1,3,''xl37'','''',1
7,1,'''',1,1,1,4,''xl52'','''',1
7,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',1
7,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',1
7,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',1
7,1,'''',1,1,1,41,''xl52'','''',1
7,1,'''',1,1,1,42,''xl22'','''',1
7,1,'''',1,1,1,43,''xl22'','''',1
8,1,''>>>nvl({po_n};" ")&"\"'',1,1,1,1,''xl29'','''',1
8,1,''>>>nvl({cpo};" ")&"\"'',1,1,1,2,''xl39'','''',1
8,1,''>>nvl({cpog};" ")&"\"'',1,1,1,3,''xl47'','''',1
8,1,''>>>(<lev>;1;<cdiv>)'',1,1,1,4,''xl39'','''',1
8,1,''>>(<s_1>)'',1,1,1,5,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_2>)'',1,1,1,6,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_3>)'',1,1,1,9,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_4>)'',1,1,1,11,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_5>)'',1,1,1,13,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_6>)'',1,1,1,15,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_1>)'',1,1,1,17,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_2>)'',1,1,1,18,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_3>)'',1,1,1,21,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_4>)'',1,1,1,23,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_5>)'',1,1,1,25,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_6>)'',1,1,1,27,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_7>)'',1,1,1,29,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_8>)'',1,1,1,31,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl57'',''"#,##0.00"'',1
8,1,''>>(<s_9>)'',1,1,1,33,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_7>)'',1,1,1,35,''xl57'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '8,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_8>)'',1,1,1,37,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl57'',''"#,##0.00"'',1
8,1,''>>(<k_9>)'',1,1,1,39,''xl57'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl57'',''"#,##0.00"'',1
8,1,''>>>(<lev>;1;<metod>)&"\"'',1,1,1,41,''xl39'','''',1
8,1,'''',1,1,1,42,''xl22'','''',1
8,1,'''',1,1,1,43,''xl22'','''',1
9,1,''\'',1,1,1,1,''xl29'','''',1
9,1,''\'',1,1,1,2,''xl39'','''',1
9,1,''\'',1,1,1,3,''xl47'','''',1
9,1,'''',1,1,1,4,''xl53'','''',1
9,1,'''',1,1,1,5,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,6,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,7,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,8,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,9,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,10,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,11,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,12,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,13,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,14,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,15,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,16,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,17,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,18,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,19,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,20,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,21,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,22,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,23,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,24,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,25,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,26,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,27,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,28,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,29,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,30,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,31,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,32,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,33,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,34,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,35,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,36,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,37,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,38,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,39,''xl57'',''"#,##0.00"'',1
9,1,'''',1,1,1,40,''xl57'',''"#,##0.00"'',1
9,1,''\'',1,1,1,41,''xl39'','''',1
9,1,''>>st'',1,1,1,42,''xl80'','''',1
9,1,'''',1,1,1,43,''xl22'','''',1
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 7, '1,1,'''',1,1,1,1,''xl22'','''',2
1,1,'''',1,1,1,2,''xl22'','''',2
1,1,'''',1,1,1,3,''xl22'','''',2
1,1,'''',1,1,1,4,''xl22'','''',2
1,1,'''',1,1,1,5,''xl22'','''',2
1,1,'''',1,1,1,6,''xl22'','''',2
1,1,'''',1,1,1,7,''xl22'','''',2
1,1,'''',1,1,1,8,''xl22'','''',2
1,1,'''',1,1,1,9,''xl22'','''',2
1,1,'''',1,1,1,10,''xl22'','''',2
1,1,'''',1,1,1,11,''xl22'','''',2
1,1,'''',1,1,1,12,''xl22'','''',2
1,1,'''',1,1,1,13,''xl22'','''',2
1,1,'''',1,1,1,14,''xl22'','''',2
1,1,'''',1,1,1,15,''xl22'','''',2
1,1,'' 2'',1,1,1,16,''xl71'','''',2
1,1,'''',1,1,1,17,''xl73'','''',2
1,1,'''',1,1,1,18,''xl73'','''',2
1,1,'''',1,1,1,19,''xl73'','''',2
1,1,'''',1,1,1,20,''xl73'','''',2
1,1,'''',1,1,1,21,''xl73'','''',2
1,1,'''',1,1,1,22,''xl73'','''',2
1,1,'''',1,1,1,23,''xl22'','''',2
1,1,'''',1,1,1,24,''xl74'','''',2
1,1,'''',1,1,1,25,''xl74'','''',2
1,1,'''',1,1,1,26,''xl74'','''',2
1,1,'''',1,1,1,27,''xl74'','''',2
1,1,'''',1,1,1,28,''xl71'','''',2
1,1,'''',1,1,1,29,''xl22'','''',2
1,1,'''',1,1,1,30,''xl74'','''',2
1,1,'''',1,1,1,31,''xl74'','''',2
1,1,'''',1,1,1,32,''xl74'','''',2
1,1,'''',1,1,1,33,''xl74'','''',2
1,1,'''',1,1,1,34,''xl74'','''',2
1,1,'''',1,1,1,35,''xl74'','''',2
1,1,'''',1,1,1,36,''xl74'','''',2
1,1,'''',1,1,1,37,''xl74'','''',2
1,1,'''',1,1,1,38,''xl74'','''',2
1,1,'''',1,1,1,39,''xl74'','''',2
1,1,'''',1,1,1,40,''xl74'','''',2
1,1,'''',1,1,1,41,''xl74'','''',2
1,1,''>>"#/"'',1,1,1,42,''xl78'','''',2
1,1,'''',1,1,1,43,''xl22'','''',2
1,1,''            ,'',1,16,2,1,''xl72'','''',2
1,1,'''',1,1,2,17,''xl73'','''',2
1,1,'''',1,1,2,18,''xl73'','''',2
1,1,'''',1,1,2,19,''xl73'','''',2
1,1,'''',1,1,2,20,''xl73'','''',2
1,1,'''',1,1,2,21,''xl73'','''',2
1,1,'''',1,1,2,22,''xl73'','''',2
1,1,'''',1,1,2,23,''xl22'','''',2
1,1,'''',1,1,2,24,''xl74'','''',2
1,1,'''',1,1,2,25,''xl74'','''',2
1,1,'''',1,1,2,26,''xl74'','''',2
1,1,'''',1,1,2,27,''xl74'','''',2
1,1,'''',1,1,2,28,''xl71'','''',2
1,1,'''',1,1,2,29,''xl22'','''',2
1,1,'''',1,1,2,30,''xl74'','''',2
1,1,'''',1,1,2,31,''xl74'','''',2
1,1,'''',1,1,2,32,''xl74'','''',2
1,1,'''',1,1,2,33,''xl74'','''',2
1,1,'''',1,1,2,34,''xl74'','''',2
1,1,'''',1,1,2,35,''xl74'','''',2
1,1,'''',1,1,2,36,''xl74'','''',2
1,1,'''',1,1,2,37,''xl74'','''',2
1,1,'''',1,1,2,38,''xl74'','''',2
1,1,'''',1,1,2,39,''xl74'','''',2
1,1,'''',1,1,2,40,''xl74'','''',2
1,1,'''',1,1,2,41,''xl74'','''',2
1,1,'''',1,1,2,42,''xl22'','''',2
1,1,'''',1,1,2,43,''xl22'','''',2
1,1,''          ,    '',1,16,3,1,''xl72'','''',2
1,1,'''',1,1,3,17,''xl34'','''',2
1,1,'''',1,1,3,18,''xl34'','''',2
1,1,'''',1,1,3,19,''xl34'','''',2
1,1,'''',1,1,3,20,''xl34'','''',2
1,1,'''',1,1,3,21,''xl34'','''',2
1,1,'''',1,1,3,22,''xl34'','''',2
1,1,'''',1,1,3,23,''xl22'','''',2
1,1,'''',1,1,3,24,''xl74'','''',2
1,1,'''',1,1,3,25,''xl74'','''',2
1,1,'''',1,1,3,26,''xl74'','''',2
1,1,'''',1,1,3,27,''xl74'','''',2
1,1,'''',1,1,3,28,''xl71'','''',2
1,1,'''',1,1,3,29,''xl22'','''',2
1,1,'''',1,1,3,30,''xl74'','''',2
1,1,'''',1,1,3,31,''xl74'','''',2
1,1,'''',1,1,3,32,''xl74'','''',2
1,1,'''',1,1,3,33,''xl74'','''',2
1,1,'''',1,1,3,34,''xl74'','''',2
1,1,'''',1,1,3,35,''xl74'','''',2
1,1,'''',1,1,3,36,''xl74'','''',2
1,1,'''',1,1,3,37,''xl74'','''',2
1,1,'''',1,1,3,38,''xl74'','''',2
1,1,'''',1,1,3,39,''xl74'','''',2
1,1,'''',1,1,3,40,''xl74'','''',2
1,1,'''',1,1,3,41,''xl74'','''',2
1,1,'''',1,1,3,42,''xl22'','''',2
1,1,'''',1,1,3,43,''xl22'','''',2
1,1,'''',1,1,4,1,''xl22'','''',2
1,1,'''',1,1,4,2,''xl22'','''',2
1,1,'''',1,1,4,3,''xl44'','''',2
1,1,'''',1,1,4,4,''xl35'','''',2
1,1,'''',1,1,4,5,''xl44'','''',2
1,1,'''',1,1,4,6,''xl44'','''',2
1,1,'''',1,1,4,7,''xl44'','''',2
1,1,'''',1,1,4,8,''xl44'','''',2
1,1,'''',1,1,4,9,''xl44'','''',2
1,1,'''',1,1,4,10,''xl34'','''',2
1,1,'''',1,1,4,11,''xl34'','''',2
1,1,'''',1,1,4,12,''xl34'','''',2
1,1,'''',1,1,4,13,''xl34'','''',2
1,1,'''',1,1,4,14,''xl44'','''',2
1,1,'''',1,1,4,15,''xl44'','''',2
1,1,'''',1,1,4,16,''xl44'','''',2
1,1,'''',1,1,4,17,''xl44'','''',2
1,1,'''',1,1,4,18,''xl44'','''',2
1,1,'''',1,1,4,19,''xl44'','''',2
1,1,'''',1,1,4,20,''xl44'','''',2
1,1,'''',1,1,4,21,''xl44'','''',2
1,1,'''',1,1,4,22,''xl44'','''',2
1,1,'''',1,1,4,23,''xl22'','''',2
1,1,'''',1,1,4,24,''xl74'','''',2
1,1,'''',1,1,4,25,''xl74'','''',2
1,1,'''',1,1,4,26,''xl74'','''',2
1,1,'''',1,1,4,27,''xl74'','''',2
1,1,'''',1,1,4,28,''xl71'','''',2
1,1,'''',1,1,4,29,''xl22'','''',2
1,1,'''',1,1,4,30,''xl74'','''',2
1,1,'''',1,1,4,31,''xl74'','''',2
1,1,'''',1,1,4,32,''xl74'','''',2
1,1,'''',1,1,4,33,''xl74'','''',2
1,1,'''',1,1,4,34,''xl74'','''',2
1,1,'''',1,1,4,35,''xl74'','''',2
1,1,'''',1,1,4,36,''xl74'','''',2
1,1,'''',1,1,4,37,''xl74'','''',2
1,1,'''',1,1,4,38,''xl74'','''',2
1,1,'''',1,1,4,39,''xl74'','''',2
1,1,'''',1,1,4,40,''xl74'','''',2
1,1,'''',1,1,4,41,''xl74'','''',2
1,1,'''',1,1,4,42,''xl22'','''',2
1,1,'''',1,1,4,43,''xl22'','''',2
1,1,''        '',1,1,5,1,''xl23'','''',2
1,1,'''',1,1,5,2,''xl33'','''',2
1,1,''$$select name from c_data1 where list=2#name#name#NN'',1,14,5,3,''xl33'','''',2
1,1,'''',1,1,5,17,''xl34'','''',2
1,1,'''',1,1,5,18,''xl34'','''',2
1,1,'''',1,1,5,19,''xl34'','''',2
1,1,'''',1,1,5,20,''xl34'','''',2
1,1,'''',1,1,5,21,''xl34'','''',2
1,1,'''',1,1,5,22,''xl34'','''',2
1,1,'''',1,1,5,23,''xl34'','''',2
1,1,'''',1,1,5,24,''xl34'','''',2
1,1,'''',1,1,5,25,''xl34'','''',2
1,1,'''',1,1,5,26,''xl34'','''',2
1,1,'''',1,1,5,27,''xl74'','''',2
1,1,'''',1,1,5,28,''xl71'','''',2
1,1,'''',1,1,5,29,''xl22'','''',2
1,1,'''',1,1,5,30,''xl74'','''',2
1,1,'''',1,1,5,31,''xl74'','''',2
1,1,'''',1,1,5,32,''xl74'','''',2
1,1,'''',1,1,5,33,''xl74'','''',2
1,1,'''',1,1,5,34,''xl74'','''',2
1,1,'''',1,1,5,35,''xl74'','''',2
1,1,'''',1,1,5,36,''xl74'','''',2
1,1,'''',1,1,5,37,''xl74'','''',2
1,1,'''',1,1,5,38,''xl74'','''',2
1,1,'''',1,1,5,39,''xl74'','''',2
1,1,'''',1,1,5,40,''xl74'','''',2
1,1,'''',1,1,5,41,''xl74'','''',2
1,1,'''',1,1,5,42,''xl22'','''',2
1,1,'''',1,1,5,43,''xl22'','''',2
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,1,6,1,''xl24'','''',2
1,1,'''',1,1,6,2,''xl74'','''',2
1,1,'''',1,1,6,3,''xl74'','''',2
1,1,'''',1,1,6,4,''xl74'','''',2
1,1,'''',1,1,6,5,''xl74'','''',2
1,1,'''',1,1,6,6,''xl74'','''',2
1,1,'''',1,1,6,7,''xl74'','''',2
1,1,'''',1,1,6,8,''xl34'','''',2
1,1,'''',1,1,6,9,''xl44'','''',2
1,1,'''',1,1,6,10,''xl44'','''',2
1,1,'''',1,1,6,11,''xl44'','''',2
1,1,'''',1,1,6,12,''xl44'','''',2
1,1,'''',1,1,6,13,''xl44'','''',2
1,1,'''',1,1,6,14,''xl44'','''',2
1,1,'''',1,1,6,15,''xl44'','''',2
1,1,'''',1,1,6,16,''xl44'','''',2
1,1,'''',1,1,6,17,''xl44'','''',2
1,1,'''',1,1,6,18,''xl44'','''',2
1,1,'''',1,1,6,19,''xl44'','''',2
1,1,'''',1,1,6,20,''xl44'','''',2
1,1,'''',1,1,6,21,''xl44'','''',2
1,1,'''',1,1,6,22,''xl44'','''',2
1,1,'''',1,1,6,23,''xl44'','''',2
1,1,'''',1,1,6,24,''xl44'','''',2
1,1,'''',1,1,6,25,''xl44'','''',2
1,1,'''',1,1,6,26,''xl44'','''',2
1,1,'''',1,1,6,27,''xl44'','''',2
1,1,'''',1,1,6,28,''xl71'','''',2
1,1,'''',1,1,6,29,''xl22'','''',2
1,1,'''',1,1,6,30,''xl44'','''',2
1,1,'''',1,1,6,31,''xl44'','''',2
1,1,'''',1,1,6,32,''xl44'','''',2
1,1,'''',1,1,6,33,''xl44'','''',2
1,1,'''',1,1,6,34,''xl44'','''',2
1,1,'''',1,1,6,35,''xl44'','''',2
1,1,'''',1,1,6,36,''xl44'','''',2
1,1,'''',1,1,6,37,''xl44'','''',2
1,1,'''',1,1,6,38,''xl44'','''',2
1,1,'''',1,1,6,39,''xl44'','''',2
1,1,'''',1,1,6,40,''xl44'','''',2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 8, '1,1,'''',1,1,6,41,''xl44'','''',2
1,1,'''',1,1,6,42,''xl22'','''',2
1,1,'''',1,1,6,43,''xl22'','''',2
1,1,'''',1,1,7,1,''xl23'','''',2
1,1,'''',1,1,7,2,''xl35'','''',2
1,1,'''',1,1,7,3,''xl44'','''',2
1,1,'''',1,1,7,4,''xl35'','''',2
1,1,'''',1,1,7,5,''xl44'','''',2
1,1,'''',1,1,7,6,''xl44'','''',2
1,1,'''',1,1,7,7,''xl44'','''',2
1,1,'''',1,1,7,8,''xl44'','''',2
1,1,'''',1,1,7,9,''xl44'','''',2
1,1,'''',1,1,7,10,''xl44'','''',2
1,1,'''',1,1,7,11,''xl44'','''',2
1,1,'''',1,1,7,12,''xl44'','''',2
1,1,'''',1,1,7,13,''xl44'','''',2
1,1,'''',1,1,7,14,''xl44'','''',2
1,1,'''',1,1,7,15,''xl44'','''',2
1,1,'''',1,1,7,16,''xl44'','''',2
1,1,'''',1,1,7,17,''xl44'','''',2
1,1,'''',1,1,7,18,''xl44'','''',2
1,1,'''',1,1,7,19,''xl44'','''',2
1,1,'''',1,1,7,20,''xl44'','''',2
1,1,'''',1,1,7,21,''xl44'','''',2
1,1,'''',1,1,7,22,''xl44'','''',2
1,1,'''',1,1,7,23,''xl44'','''',2
1,1,'''',1,1,7,24,''xl44'','''',2
1,1,'''',1,1,7,25,''xl44'','''',2
1,1,'''',1,1,7,26,''xl44'','''',2
1,1,'''',1,1,7,27,''xl44'','''',2
1,1,'''',1,1,7,28,''xl71'','''',2
1,1,'''',1,1,7,29,''xl44'','''',2
1,1,'''',1,1,7,30,''xl44'','''',2
1,1,'''',1,1,7,31,''xl44'','''',2
1,1,'''',1,1,7,32,''xl44'','''',2
1,1,'''',1,1,7,33,''xl44'','''',2
1,1,'''',1,1,7,34,''xl44'','''',2
1,1,'''',1,1,7,35,''xl44'','''',2
1,1,'''',1,1,7,36,''xl44'','''',2
1,1,'''',1,1,7,37,''xl44'','''',2
1,1,'''',1,1,7,38,''xl44'','''',2
1,1,'''',1,1,7,39,''xl44'','''',2
1,1,'''',1,1,7,40,''xl44'','''',2
1,1,'''',1,1,7,41,''xl44'','''',2
1,1,'''',1,1,7,42,''xl22'','''',2
1,1,'''',1,1,7,43,''xl22'','''',2
1,1,'' , chr(10) '',10,1,8,1,''xl81'','''',2
1,1,'' '',10,1,8,2,''xl82'','''',2
1,1,''  ,  '',10,1,8,3,''xl83'','''',2
1,1,''    '',4,1,8,4,''xl84'','''',2
1,1,''       '',3,12,8,5,''xl60'','''',2
1,1,'' ..                 '',3,12,8,17,''xl60'','''',2
1,1,''    '',3,6,8,29,''xl60'','''',2
1,1,'' ..                 '',3,6,8,35,''xl60'','''',2
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,8,41,''xl86'','''',2
1,1,'''',1,1,8,42,''xl79'','''',2
1,1,'''',1,1,8,43,''xl79'','''',2
1,1,'''',1,1,9,42,''xl79'','''',2
1,1,'''',1,1,9,43,''xl79'','''',2
1,1,'''',1,1,10,42,''xl79'','''',2
1,1,'''',1,1,10,43,''xl79'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,11,5,''xl60'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,11,9,''xl60'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,11,11,''xl60'','''',2
1,1,'' '',1,4,11,13,''xl60'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,11,17,''xl60'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,11,21,''xl60'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,11,23,''xl60'','''',2
1,1,'' '',1,4,11,25,''xl60'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,11,29,''xl60'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,11,31,''xl60'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,11,33,''xl60'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,11,35,''xl60'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,11,37,''xl60'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,11,39,''xl60'','''',2
1,1,'''',1,1,11,42,''xl79'','''',2
1,1,'''',1,1,11,43,''xl79'','''',2
1,1,''/'',6,1,12,4,''xl85'','''',2
1,1,'''',1,2,12,5,''xl60'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,12,7,''xl60'','''',2
1,1,'''',6,1,12,9,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,10,''xl69'','''',2
1,1,'''',6,1,12,11,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,12,''xl69'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,12,13,''xl70'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,12,15,''xl70'','''',2
1,1,'''',1,2,12,17,''xl60'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,12,19,''xl60'','''',2
1,1,'''',6,1,12,21,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,22,''xl69'','''',2
1,1,'''',6,1,12,23,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,24,''xl69'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,12,25,''xl70'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,12,27,''xl70'','''',2
1,1,'''',6,1,12,29,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,30,''xl69'','''',2
1,1,'''',6,1,12,31,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,32,''xl69'','''',2
1,1,'''',6,1,12,33,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,34,''xl69'','''',2
1,1,'''',6,1,12,35,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,36,''xl69'','''',2
1,1,'''',6,1,12,37,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,38,''xl69'','''',2
1,1,'''',6,1,12,39,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,12,40,''xl69'','''',2
1,1,'''',1,1,12,42,''xl79'','''',2
1,1,'''',1,1,12,43,''xl79'','''',2
1,1,''  '',5,1,13,5,''xl69'','''',2
1,1,'''',5,1,13,6,''xl69'','''',2
1,1,''  '',5,1,13,7,''xl69'','''',2
1,1,'''',5,1,13,8,''xl69'','''',2
1,1,'''',5,1,13,13,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,13,14,''xl69'','''',2
1,1,'''',5,1,13,15,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,13,16,''xl69'','''',2
1,1,''  '',5,1,13,17,''xl69'','''',2
1,1,'''',5,1,13,18,''xl69'','''',2
1,1,''  '',5,1,13,19,''xl69'','''',2
1,1,'''',5,1,13,20,''xl69'','''',2
1,1,'''',5,1,13,25,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,13,26,''xl69'','''',2
1,1,'''',5,1,13,27,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,13,28,''xl69'','''',2
1,1,'''',1,1,13,42,''xl79'','''',2
1,1,'''',1,1,13,43,''xl79'','''',2
1,1,'''',1,1,14,42,''xl79'','''',2
1,1,'''',1,1,14,43,''xl79'','''',2
1,1,'''',1,1,15,42,''xl79'','''',2
1,1,'''',1,1,15,43,''xl79'','''',2
1,1,'''',1,1,16,42,''xl79'','''',2
1,1,'''',1,1,16,43,''xl79'','''',2
1,1,'''',1,1,17,42,''xl79'','''',2
1,1,'''',1,1,17,43,''xl79'','''',2
1,2,''    ,    '',1,1,1,1,''xl28'','''',2
1,2,''2500'',1,1,1,2,''xl48'','''',2
1,2,'''',1,1,1,3,''xl48'','''',2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 9, '1,2,'''',1,1,1,4,''xl48'','''',2
1,2,''>>2(<npog>;1;<list>;2;<s_1>)'',1,1,1,5,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_2>)'',1,1,1,6,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_1>)'',1,1,1,7,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_2>)'',1,1,1,8,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_3>)'',1,1,1,9,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_3>)'',1,1,1,10,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_4>)'',1,1,1,11,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_4>)'',1,1,1,12,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_5>)'',1,1,1,13,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_5>)'',1,1,1,14,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_6>)'',1,1,1,15,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_6>)'',1,1,1,16,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_1>)'',1,1,1,17,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_2>)'',1,1,1,18,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_1>)'',1,1,1,19,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_2>)'',1,1,1,20,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_3>)'',1,1,1,21,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_3>)'',1,1,1,22,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_4>)'',1,1,1,23,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_4>)'',1,1,1,24,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_5>)'',1,1,1,25,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_5>)'',1,1,1,26,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_6>)'',1,1,1,27,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_6>)'',1,1,1,28,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_7>)'',1,1,1,29,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_7>)'',1,1,1,30,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_8>)'',1,1,1,31,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_8>)'',1,1,1,32,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_9>)'',1,1,1,33,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_9>)'',1,1,1,34,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_7>)'',1,1,1,35,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_7>)'',1,1,1,36,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_8>)'',1,1,1,37,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_8>)'',1,1,1,38,''xl58'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_9>)'',1,1,1,39,''xl58'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_9>)'',1,1,1,40,''xl58'',''"#,##0.00"'',2
1,2,'''',1,1,1,41,''xl76'','''',2
1,2,'''',1,1,1,42,''xl22'','''',2
1,2,'''',1,1,1,43,''xl22'','''',2
1,2,'''',1,1,2,1,''xl31'','''',2
1,2,'''',1,1,2,2,''xl42'','''',2
1,2,'''',1,1,2,3,''xl49'','''',2
1,2,'''',1,1,2,4,''xl42'','''',2
1,2,'''',1,1,2,5,''xl54'','''',2
1,2,'''',1,1,2,6,''xl54'','''',2
1,2,'''',1,1,2,7,''xl54'','''',2
1,2,'''',1,1,2,8,''xl54'','''',2
1,2,'''',1,1,2,9,''xl54'','''',2
1,2,'''',1,1,2,10,''xl54'','''',2
1,2,'''',1,1,2,11,''xl54'','''',2
1,2,'''',1,1,2,12,''xl54'','''',2
1,2,'''',1,1,2,13,''xl54'','''',2
1,2,'''',1,1,2,14,''xl54'','''',2
1,2,'''',1,1,2,15,''xl54'','''',2
1,2,'''',1,1,2,16,''xl54'','''',2
1,2,'''',1,1,2,17,''xl54'','''',2
1,2,'''',1,1,2,18,''xl54'','''',2
1,2,'''',1,1,2,19,''xl54'','''',2
1,2,'''',1,1,2,20,''xl54'','''',2
1,2,'''',1,1,2,21,''xl54'','''',2
1,2,'''',1,1,2,22,''xl54'','''',2
1,2,'''',1,1,2,23,''xl54'','''',2
1,2,'''',1,1,2,24,''xl54'','''',2
1,2,'''',1,1,2,25,''xl54'','''',2
1,2,'''',1,1,2,26,''xl54'','''',2
1,2,'''',1,1,2,27,''xl54'','''',2
1,2,'''',1,1,2,28,''xl54'','''',2
1,2,'''',1,1,2,29,''xl54'','''',2
1,2,'''',1,1,2,30,''xl54'','''',2
1,2,'''',1,1,2,31,''xl54'','''',2
1,2,'''',1,1,2,32,''xl54'','''',2
1,2,'''',1,1,2,33,''xl54'','''',2
1,2,'''',1,1,2,34,''xl54'','''',2
1,2,'''',1,1,2,35,''xl54'','''',2
1,2,'''',1,1,2,36,''xl54'','''',2
1,2,'''',1,1,2,37,''xl54'','''',2
1,2,'''',1,1,2,38,''xl54'','''',2
1,2,'''',1,1,2,39,''xl54'','''',2
1,2,'''',1,1,2,40,''xl54'','''',2
1,2,'''',1,1,2,41,''xl54'','''',2
1,2,'''',1,1,2,42,''xl22'','''',2
1,2,'''',1,1,2,43,''xl22'','''',2
1,2,''>>>Footer'',1,41,3,1,''xl32'','''',2
1,2,'''',1,1,3,42,''xl22'','''',2
1,2,'''',1,1,3,43,''xl22'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,3,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,4,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,5,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,6,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,7,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,8,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,9,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,10,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,11,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,12,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,13,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,14,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,15,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,16,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,17,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,18,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,19,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,20,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,21,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,22,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,23,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,24,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,25,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,26,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,27,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,28,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,29,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,30,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,31,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,32,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,33,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,34,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,35,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,36,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,37,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,38,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,39,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,40,''xl26'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,41,''xl26'','''',2
2,1,'''',1,1,1,42,''xl22'','''',2
2,1,'''',1,1,1,43,''xl22'','''',2
3,1,''>>>{po5_n}'',1,1,1,1,''xl28'','''',2
3,1,''>>>{cpo5}'',1,1,1,2,''xl37'','''',2
3,1,''>>>{cpo5g}'',1,1,1,3,''xl37'','''',2
3,1,'''',1,1,1,4,''xl52'','''',2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 10, '3,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',2
3,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',2
3,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',2
3,1,'''',1,1,1,41,''xl52'','''',2
3,1,'''',1,1,1,42,''xl22'','''',2
3,1,'''',1,1,1,43,''xl22'','''',2
4,1,''>>>{po4_n}'',1,1,1,1,''xl28'','''',2
4,1,''>>>{cpo4}'',1,1,1,2,''xl37'','''',2
4,1,''>>>{cpo4g}'',1,1,1,3,''xl37'','''',2
4,1,'''',1,1,1,4,''xl52'','''',2
4,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',2
4,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',2
4,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',2
4,1,'''',1,1,1,41,''xl52'','''',2
4,1,'''',1,1,1,42,''xl22'','''',2
4,1,'''',1,1,1,43,''xl22'','''',2
5,1,''>>>{po3_n}'',1,1,1,1,''xl28'','''',2
5,1,''>>>{cpo3}'',1,1,1,2,''xl37'','''',2
5,1,''>>>{cpo3g}'',1,1,1,3,''xl37'','''',2
5,1,'''',1,1,1,4,''xl52'','''',2
5,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',2
5,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',2
5,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',2
5,1,'''',1,1,1,41,''xl52'','''',2
5,1,'''',1,1,1,42,''xl22'','''',2
5,1,'''',1,1,1,43,''xl22'','''',2
6,1,''>>>{po2_n}'',1,1,1,1,''xl28'','''',2
6,1,''>>>{cpo2}'',1,1,1,2,''xl37'','''',2
6,1,''>>>{cpo2g}'',1,1,1,3,''xl37'','''',2
6,1,'''',1,1,1,4,''xl52'','''',2
6,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 11, '6,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',2
6,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',2
6,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',2
6,1,'''',1,1,1,41,''xl52'','''',2
6,1,'''',1,1,1,42,''xl22'','''',2
6,1,'''',1,1,1,43,''xl22'','''',2
7,1,''>>>{po1_n}'',1,1,1,1,''xl28'','''',2
7,1,''>>>{cpo1}'',1,1,1,2,''xl37'','''',2
7,1,''>>>{cpo1g}'',1,1,1,3,''xl37'','''',2
7,1,'''',1,1,1,4,''xl52'','''',2
7,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',2
7,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',2
7,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',2
7,1,'''',1,1,1,41,''xl52'','''',2
7,1,'''',1,1,1,42,''xl22'','''',2
7,1,'''',1,1,1,43,''xl22'','''',2
8,1,''>>>nvl({po_n};" ")&"\"'',1,1,1,1,''xl29'','''',2
8,1,''>>>nvl({cpo};" ")&"\"'',1,1,1,2,''xl39'','''',2
8,1,''>>nvl({cpog};" ")&"\"'',1,1,1,3,''xl47'','''',2
8,1,''>>>(<lev>;1;<cdiv>)'',1,1,1,4,''xl39'','''',2
8,1,''>>(<s_1>)'',1,1,1,5,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_2>)'',1,1,1,6,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_3>)'',1,1,1,9,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_4>)'',1,1,1,11,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_5>)'',1,1,1,13,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_6>)'',1,1,1,15,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_1>)'',1,1,1,17,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_2>)'',1,1,1,18,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_3>)'',1,1,1,21,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_4>)'',1,1,1,23,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_5>)'',1,1,1,25,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_6>)'',1,1,1,27,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_7>)'',1,1,1,29,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_8>)'',1,1,1,31,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl57'',''"#,##0.00"'',2
8,1,''>>(<s_9>)'',1,1,1,33,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_7>)'',1,1,1,35,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_8>)'',1,1,1,37,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl57'',''"#,##0.00"'',2
8,1,''>>(<k_9>)'',1,1,1,39,''xl57'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl57'',''"#,##0.00"'',2
8,1,''>>>(<lev>;1;<metod>)&"\"'',1,1,1,41,''xl39'','''',2
8,1,'''',1,1,1,42,''xl22'','''',2
8,1,'''',1,1,1,43,''xl22'','''',2
9,1,''\'',1,1,1,1,''xl29'','''',2
9,1,''\'',1,1,1,2,''xl39'','''',2
9,1,''\'',1,1,1,3,''xl47'','''',2
9,1,'''',1,1,1,4,''xl53'','''',2
9,1,'''',1,1,1,5,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,6,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,7,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,8,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,9,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,10,''xl57'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 12, '9,1,'''',1,1,1,11,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,12,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,13,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,14,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,15,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,16,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,17,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,18,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,19,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,20,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,21,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,22,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,23,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,24,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,25,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,26,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,27,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,28,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,29,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,30,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,31,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,32,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,33,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,34,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,35,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,36,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,37,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,38,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,39,''xl57'',''"#,##0.00"'',2
9,1,'''',1,1,1,40,''xl57'',''"#,##0.00"'',2
9,1,''\'',1,1,1,41,''xl39'','''',2
9,1,''>>st'',1,1,1,42,''xl80'','''',2
9,1,'''',1,1,1,43,''xl22'','''',2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=1;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=1'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=1;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=2;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=2'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=2;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '33.67,186
4.56,28.8
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '33.67,186
4.56,28.8
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,18
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,61.2
9,1,22.5
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,18
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,61.2
9,1,22.5
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 0, 'tr
	{mso-height-source:auto;}
col
	{mso-width-source:auto;}
br
	{mso-data-placement:same-cell;}
.style0
	{font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;
	mso-style-name:;
	mso-style-id:0;}
td
	{mso-style-parent:style0;
	padding-top:1px;padding-right:1px;padding-left:1px;mso-ignore:padding;
	font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 21, '.xl21
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 22, '.xl22
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 23, '.xl23
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 24, '.xl24
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 25, '.xl25
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 26, '.xl26
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 27, '.xl27
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 28, '.xl28
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 29, '.xl29
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 30, '.xl30
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 31, '.xl31
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 32, '.xl32
	{mso-style-parent:style0;
	text-align:left;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 33, '.xl33
	{mso-style-parent:style0;
	font-size:8pt;
	text-decoration:underline;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 34, '.xl34
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 35, '.xl35
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 36, '.xl36
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 37, '.xl37
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 38, '.xl38
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 39, '.xl39
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 40, '.xl40
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 41, '.xl41
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 42, '.xl42
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 43, '.xl43
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 44, '.xl44
	{mso-style-parent:style0;
	font-size:8pt;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 45, '.xl45
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 46, '.xl46
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 47, '.xl47
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 48, '.xl48
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 49, '.xl49
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 50, '.xl50
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 51, '.xl51
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 52, '.xl52
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 53, '.xl53
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 54, '.xl54
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 55, '.xl55
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 56, '.xl56
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 57, '.xl57
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 58, '.xl58
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 59, '.xl59
	{mso-style-parent:style0;
	mso-text-control:shrinktofit;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 60, '.xl60
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 61, '.xl61
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 62, '.xl62
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 63, '.xl63
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 64, '.xl64
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 65, '.xl65
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 66, '.xl66
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 67, '.xl67
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 68, '.xl68
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 69, '.xl69
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 70, '.xl70
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 71, '.xl71
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 72, '.xl72
	{mso-style-parent:style0;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 73, '.xl73
	{mso-style-parent:style0;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 74, '.xl74
	{mso-style-parent:style0;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 75, '.xl75
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 76, '.xl76
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 77, '.xl77
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 78, '.xl78
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 79, '.xl79
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 80, '.xl80
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 81, '.xl81
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 82, '.xl82
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 83, '.xl83
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 84, '.xl84
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 85, '.xl85
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 86, '.xl86
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '||list=1|list,poc,st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '||list=2|list,poc,st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n_cons', 'XL_REPORT_PROP')

GO
		

	CREATE TABLE #T_OBJECT (LINK int, CODE varchar(100), NAME varchar(254), ORDERS int, LINK_SELF int, LINK_CLASS int, CODE_SELF varchar(100), CODE_CLASS varchar(100))



GO
		

	CREATE TABLE #T_GROUPS (GROUP_NAME varchar(250), NAME varchar(254), CODE_OBJ varchar(50), IMAGE_ID int, SQ_CODE varchar(100), GATE_CODE varchar(50), GDIR_CODE varchar(50), STAT int)



GO
		

	EXECUTE M_UPDATE_SQUERY '#T_OBJ','#T_PROP','#T_OBJECT','#T_GROUPS'

	DROP TABLE #T_OBJ
	DROP TABLE #T_PROP
	DROP TABLE #T_OBJECT
	DROP TABLE #T_GROUPS
	exec dtt '#t_xlrep_'

--end squery

GO




-- XL_REPORT-SYS_XL_sqr_rro_34n_cons_ngr.sql

--squery
--KS-1063\katyakov 29.01.2025

--%OBJECT%SYS_XL_sqr_rro_34n_cons_ngr%%
-- : sqr_rro_34n_cons_ngr.xlt

if object_id('tempdb..#T_OBJ') is not null drop table #T_OBJ
if object_id('tempdb..#T_PROP') is not null drop table #T_PROP
if object_id('tempdb..#T_OBJECT') is not null drop table #T_OBJECT
if object_id('tempdb..#T_GROUPS') is not null drop table #T_GROUPS

GO


	CREATE TABLE #T_OBJ (LINK int, NAME varchar(254), OBJECT int, CODE varchar(100), USERS int, ORDERS int, LINK_SELF int, LINK_STATE int, CODE_OBJ varchar(100), CODE_SELF varchar(100), CODE_STATE varchar(100))


	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('sqr_rro_34n_cons_ngr.xlt', 'SYS_XL_sqr_rro_34n_cons_ngr', null, null, 'XL_REPORT', null, null)

GO
		

	CREATE TABLE #T_PROP (LINK_UP int, PROPERTY int, USERS int, ORDERS int, VALUE nvarchar(max), CODE_UP varchar(100), CODE_PROP varchar(100))


	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'katyakov', 'SYS_XL_sqr_rro_34n_cons_ngr', 'SQUERY_AUTHOR')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '2025-01-29 15:41:53.633', 'SYS_XL_sqr_rro_34n_cons_ngr', 'SQUERY_DATETIME')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,'''',1,1,1,1,''xl22'','''',1
1,1,'''',1,1,1,2,''xl22'','''',1
1,1,'''',1,1,1,3,''xl22'','''',1
1,1,'''',1,1,1,4,''xl22'','''',1
1,1,'''',1,1,1,5,''xl22'','''',1
1,1,'''',1,1,1,6,''xl22'','''',1
1,1,'''',1,1,1,7,''xl22'','''',1
1,1,'''',1,1,1,8,''xl22'','''',1
1,1,'''',1,1,1,9,''xl22'','''',1
1,1,'''',1,1,1,10,''xl22'','''',1
1,1,'''',1,1,1,11,''xl22'','''',1
1,1,'''',1,1,1,12,''xl22'','''',1
1,1,'''',1,1,1,13,''xl22'','''',1
1,1,'''',1,1,1,14,''xl22'','''',1
1,1,'''',1,1,1,15,''xl22'','''',1
1,1,'''',1,1,1,16,''xl72'','''',1
1,1,'''',1,1,1,17,''xl72'','''',1
1,1,'''',1,1,1,18,''xl72'','''',1
1,1,'''',1,1,1,19,''xl72'','''',1
1,1,'''',1,1,1,20,''xl72'','''',1
1,1,'''',1,1,1,21,''xl72'','''',1
1,1,'''',1,1,1,22,''xl72'','''',1
1,1,'''',1,1,1,23,''xl22'','''',1
1,1,'''',1,1,1,24,''xl74'','''',1
1,1,'''',1,1,1,25,''xl74'','''',1
1,1,'''',1,1,1,26,''xl74'','''',1
1,1,'''',1,1,1,27,''xl74'','''',1
1,1,'''',1,1,1,28,''xl23'','''',1
1,1,'''',1,1,1,29,''xl74'','''',1
1,1,'''',1,1,1,30,''xl74'','''',1
1,1,'''',1,1,1,31,''xl74'','''',1
1,1,'''',1,1,1,32,''xl74'','''',1
1,1,'''',1,1,1,33,''xl74'','''',1
1,1,'''',1,1,1,34,''xl74'','''',1
1,1,'''',1,1,1,35,''xl74'','''',1
1,1,'''',1,1,1,36,''xl74'','''',1
1,1,'''',1,1,1,37,''xl74'','''',1
1,1,'''',1,1,1,38,''xl74'','''',1
1,1,'''',1,1,1,39,''xl74'','''',1
1,1,'''',1,1,1,40,''xl74'','''',1
1,1,'''',1,1,1,41,''xl74'','''',1
1,1,''>>"#/"'',1,1,1,42,''xl81'','''',1
1,1,'''',1,1,1,43,''xl22'','''',1
1,1,'''',1,1,2,1,''xl22'','''',1
1,1,'''',1,1,2,2,''xl22'','''',1
1,1,'''',1,1,2,3,''xl22'','''',1
1,1,'''',1,1,2,4,''xl22'','''',1
1,1,'''',1,1,2,5,''xl22'','''',1
1,1,'''',1,1,2,6,''xl22'','''',1
1,1,'''',1,1,2,7,''xl22'','''',1
1,1,'''',1,1,2,8,''xl22'','''',1
1,1,'''',1,1,2,9,''xl22'','''',1
1,1,'''',1,1,2,10,''xl22'','''',1
1,1,'''',1,1,2,11,''xl22'','''',1
1,1,'''',1,1,2,12,''xl22'','''',1
1,1,'''',1,1,2,13,''xl22'','''',1
1,1,'''',1,1,2,14,''xl22'','''',1
1,1,'''',1,1,2,15,''xl22'','''',1
1,1,'''',1,1,2,16,''xl72'','''',1
1,1,'''',1,1,2,17,''xl72'','''',1
1,1,'''',1,1,2,18,''xl72'','''',1
1,1,'''',1,1,2,19,''xl72'','''',1
1,1,'''',1,1,2,20,''xl72'','''',1
1,1,'''',1,1,2,21,''xl72'','''',1
1,1,'''',1,1,2,22,''xl72'','''',1
1,1,'''',1,1,2,23,''xl22'','''',1
1,1,'''',1,1,2,24,''xl74'','''',1
1,1,'''',1,1,2,25,''xl74'','''',1
1,1,'''',1,1,2,26,''xl74'','''',1
1,1,'''',1,1,2,27,''xl74'','''',1
1,1,'''',1,1,2,28,''xl23'','''',1
1,1,'''',1,1,2,29,''xl74'','''',1
1,1,'''',1,1,2,30,''xl74'','''',1
1,1,'''',1,1,2,31,''xl74'','''',1
1,1,'''',1,1,2,32,''xl74'','''',1
1,1,'''',1,1,2,33,''xl74'','''',1
1,1,'''',1,1,2,34,''xl74'','''',1
1,1,'''',1,1,2,35,''xl74'','''',1
1,1,'''',1,1,2,36,''xl74'','''',1
1,1,'''',1,1,2,37,''xl74'','''',1
1,1,'''',1,1,2,38,''xl74'','''',1
1,1,'''',1,1,2,39,''xl74'','''',1
1,1,'''',1,1,2,40,''xl74'','''',1
1,1,'''',1,1,2,41,''xl74'','''',1
1,1,'''',1,1,2,42,''xl22'','''',1
1,1,'''',1,1,2,43,''xl22'','''',1
1,1,''     '',1,14,3,1,''xl70'','''',1
1,1,'''',1,1,3,15,''xl72'','''',1
1,1,'''',1,1,3,16,''xl65'','''',1
1,1,'''',1,1,3,17,''xl65'','''',1
1,1,'''',1,1,3,18,''xl65'','''',1
1,1,'''',1,1,3,19,''xl65'','''',1
1,1,'''',1,1,3,20,''xl65'','''',1
1,1,'''',1,1,3,21,''xl65'','''',1
1,1,'''',1,1,3,22,''xl65'','''',1
1,1,'''',1,1,3,23,''xl22'','''',1
1,1,'''',1,1,3,24,''xl74'','''',1
1,1,'''',1,1,3,25,''xl74'','''',1
1,1,'''',1,1,3,26,''xl74'','''',1
1,1,'''',1,1,3,27,''xl74'','''',1
1,1,'''',1,1,3,28,''xl23'','''',1
1,1,'''',1,1,3,29,''xl74'','''',1
1,1,'''',1,1,3,30,''xl74'','''',1
1,1,'''',1,1,3,31,''xl74'','''',1
1,1,'''',1,1,3,32,''xl74'','''',1
1,1,'''',1,1,3,33,''xl74'','''',1
1,1,'''',1,1,3,34,''xl74'','''',1
1,1,'''',1,1,3,35,''xl74'','''',1
1,1,'''',1,1,3,36,''xl74'','''',1
1,1,'''',1,1,3,37,''xl74'','''',1
1,1,'''',1,1,3,38,''xl74'','''',1
1,1,'''',1,1,3,39,''xl74'','''',1
1,1,'''',1,1,3,40,''xl74'','''',1
1,1,'''',1,1,3,41,''xl74'','''',1
1,1,'''',1,1,3,42,''xl22'','''',1
1,1,'''',1,1,3,43,''xl22'','''',1
1,1,''>>" "&(dDate_2+1;0)&"."'',1,14,4,1,''xl47'','''',1
1,1,'''',1,1,4,15,''xl47'','''',1
1,1,'''',1,1,4,16,''xl47'','''',1
1,1,'''',1,1,4,17,''xl47'','''',1
1,1,'''',1,1,4,18,''xl47'','''',1
1,1,'''',1,1,4,19,''xl47'','''',1
1,1,'''',1,1,4,20,''xl47'','''',1
1,1,'''',1,1,4,21,''xl47'','''',1
1,1,'''',1,1,4,22,''xl47'','''',1
1,1,'''',1,1,4,23,''xl22'','''',1
1,1,'''',1,1,4,24,''xl74'','''',1
1,1,'''',1,1,4,25,''xl74'','''',1
1,1,'''',1,1,4,26,''xl74'','''',1
1,1,'''',1,1,4,27,''xl74'','''',1
1,1,'''',1,1,4,28,''xl23'','''',1
1,1,'''',1,1,4,29,''xl74'','''',1
1,1,'''',1,1,4,30,''xl74'','''',1
1,1,'''',1,1,4,31,''xl74'','''',1
1,1,'''',1,1,4,32,''xl74'','''',1
1,1,'''',1,1,4,33,''xl74'','''',1
1,1,'''',1,1,4,34,''xl74'','''',1
1,1,'''',1,1,4,35,''xl74'','''',1
1,1,'''',1,1,4,36,''xl74'','''',1
1,1,'''',1,1,4,37,''xl74'','''',1
1,1,'''',1,1,4,38,''xl74'','''',1
1,1,'''',1,1,4,39,''xl74'','''',1
1,1,'''',1,1,4,40,''xl74'','''',1
1,1,'''',1,1,4,41,''xl74'','''',1
1,1,'''',1,1,4,42,''xl22'','''',1
1,1,'''',1,1,4,43,''xl22'','''',1
1,1,'''',1,1,5,1,''xl22'','''',1
1,1,'''',1,1,5,2,''xl22'','''',1
1,1,'''',1,1,5,3,''xl43'','''',1
1,1,'''',1,1,5,4,''xl33'','''',1
1,1,'''',1,1,5,5,''xl43'','''',1
1,1,'''',1,1,5,6,''xl43'','''',1
1,1,'''',1,1,5,7,''xl43'','''',1
1,1,'''',1,1,5,8,''xl43'','''',1
1,1,'''',1,1,5,9,''xl43'','''',1
1,1,'''',1,1,5,10,''xl65'','''',1
1,1,'''',1,1,5,11,''xl65'','''',1
1,1,'''',1,1,5,12,''xl65'','''',1
1,1,'''',1,1,5,13,''xl65'','''',1
1,1,'''',1,1,5,14,''xl43'','''',1
1,1,'''',1,1,5,15,''xl43'','''',1
1,1,'''',1,1,5,16,''xl43'','''',1
1,1,'''',1,1,5,17,''xl43'','''',1
1,1,'''',1,1,5,18,''xl43'','''',1
1,1,'''',1,1,5,19,''xl43'','''',1
1,1,'''',1,1,5,20,''xl43'','''',1
1,1,'''',1,1,5,21,''xl43'','''',1
1,1,'''',1,1,5,22,''xl43'','''',1
1,1,'''',1,1,5,23,''xl22'','''',1
1,1,'''',1,1,5,24,''xl74'','''',1
1,1,'''',1,1,5,25,''xl74'','''',1
1,1,'''',1,1,5,26,''xl74'','''',1
1,1,'''',1,1,5,27,''xl74'','''',1
1,1,'''',1,1,5,28,''xl23'','''',1
1,1,'''',1,1,5,29,''xl74'','''',1
1,1,'''',1,1,5,30,''xl74'','''',1
1,1,'''',1,1,5,31,''xl74'','''',1
1,1,'''',1,1,5,32,''xl74'','''',1
1,1,'''',1,1,5,33,''xl74'','''',1
1,1,'''',1,1,5,34,''xl74'','''',1
1,1,'''',1,1,5,35,''xl74'','''',1
1,1,'''',1,1,5,36,''xl74'','''',1
1,1,'''',1,1,5,37,''xl74'','''',1
1,1,'''',1,1,5,38,''xl74'','''',1
1,1,'''',1,1,5,39,''xl74'','''',1
1,1,'''',1,1,5,40,''xl74'','''',1
1,1,'''',1,1,5,41,''xl74'','''',1
1,1,'''',1,1,5,42,''xl22'','''',1
1,1,'''',1,1,5,43,''xl22'','''',1
1,1,''        '',1,1,6,1,''xl23'','''',1
1,1,'''',1,1,6,2,''xl33'','''',1
1,1,''$$select name from c_data1 where list=1#name#name#NN'',1,24,6,3,''xl75'','''',1
1,1,'''',1,1,6,27,''xl74'','''',1
1,1,'''',1,1,6,28,''xl23'','''',1
1,1,'''',1,1,6,29,''xl74'','''',1
1,1,'''',1,1,6,30,''xl74'','''',1
1,1,'''',1,1,6,31,''xl74'','''',1
1,1,'''',1,1,6,32,''xl74'','''',1
1,1,'''',1,1,6,33,''xl74'','''',1
1,1,'''',1,1,6,34,''xl74'','''',1
1,1,'''',1,1,6,35,''xl74'','''',1
1,1,'''',1,1,6,36,''xl74'','''',1
1,1,'''',1,1,6,37,''xl74'','''',1
1,1,'''',1,1,6,38,''xl74'','''',1
1,1,'''',1,1,6,39,''xl74'','''',1
1,1,'''',1,1,6,40,''xl74'','''',1
1,1,'''',1,1,6,41,''xl74'','''',1
1,1,'''',1,1,6,42,''xl22'','''',1
1,1,'''',1,1,6,43,''xl22'','''',1
1,1,''  '',1,1,7,1,''xl23'','''',1
1,1,'''',1,1,7,2,''xl34'','''',1
1,1,''$$select name from c_data2#name#name#NN'',1,24,7,3,''xl75'','''',1
1,1,'''',1,1,7,27,''xl43'','''',1
1,1,'''',1,1,7,28,''xl23'','''',1
1,1,'''',1,1,7,29,''xl43'','''',1
1,1,'''',1,1,7,30,''xl43'','''',1
1,1,'''',1,1,7,31,''xl43'','''',1
1,1,'''',1,1,7,32,''xl43'','''',1
1,1,'''',1,1,7,33,''xl43'','''',1
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,'''',1,1,7,34,''xl43'','''',1
1,1,'''',1,1,7,35,''xl43'','''',1
1,1,'''',1,1,7,36,''xl43'','''',1
1,1,'''',1,1,7,37,''xl43'','''',1
1,1,'''',1,1,7,38,''xl43'','''',1
1,1,'''',1,1,7,39,''xl43'','''',1
1,1,'''',1,1,7,40,''xl43'','''',1
1,1,'''',1,1,7,41,''xl43'','''',1
1,1,'''',1,1,7,42,''xl22'','''',1
1,1,'''',1,1,7,43,''xl22'','''',1
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,16,8,1,''xl73'','''',1
1,1,'''',1,1,8,17,''xl43'','''',1
1,1,'''',1,1,8,18,''xl43'','''',1
1,1,'''',1,1,8,19,''xl43'','''',1
1,1,'''',1,1,8,20,''xl43'','''',1
1,1,'''',1,1,8,21,''xl43'','''',1
1,1,'''',1,1,8,22,''xl43'','''',1
1,1,'''',1,1,8,23,''xl43'','''',1
1,1,'''',1,1,8,24,''xl43'','''',1
1,1,'''',1,1,8,25,''xl43'','''',1
1,1,'''',1,1,8,26,''xl43'','''',1
1,1,'''',1,1,8,27,''xl43'','''',1
1,1,'''',1,1,8,28,''xl43'','''',1
1,1,'''',1,1,8,29,''xl43'','''',1
1,1,'''',1,1,8,30,''xl43'','''',1
1,1,'''',1,1,8,31,''xl43'','''',1
1,1,'''',1,1,8,32,''xl43'','''',1
1,1,'''',1,1,8,33,''xl43'','''',1
1,1,'''',1,1,8,34,''xl43'','''',1
1,1,'''',1,1,8,35,''xl43'','''',1
1,1,'''',1,1,8,36,''xl43'','''',1
1,1,'''',1,1,8,37,''xl43'','''',1
1,1,'''',1,1,8,38,''xl43'','''',1
1,1,'''',1,1,8,39,''xl43'','''',1
1,1,'''',1,1,8,40,''xl43'','''',1
1,1,'''',1,1,8,41,''xl43'','''',1
1,1,'''',1,1,8,42,''xl22'','''',1
1,1,'''',1,1,8,43,''xl22'','''',1
1,1,'''',1,1,9,1,''xl23'','''',1
1,1,'''',1,1,9,2,''xl33'','''',1
1,1,'''',1,1,9,3,''xl43'','''',1
1,1,'''',1,1,9,4,''xl33'','''',1
1,1,'''',1,1,9,5,''xl43'','''',1
1,1,'''',1,1,9,6,''xl43'','''',1
1,1,'''',1,1,9,7,''xl43'','''',1
1,1,'''',1,1,9,8,''xl43'','''',1
1,1,'''',1,1,9,9,''xl43'','''',1
1,1,'''',1,1,9,10,''xl43'','''',1
1,1,'''',1,1,9,11,''xl43'','''',1
1,1,'''',1,1,9,12,''xl43'','''',1
1,1,'''',1,1,9,13,''xl43'','''',1
1,1,'''',1,1,9,14,''xl43'','''',1
1,1,'''',1,1,9,15,''xl43'','''',1
1,1,'''',1,1,9,16,''xl43'','''',1
1,1,'''',1,1,9,17,''xl43'','''',1
1,1,'''',1,1,9,18,''xl43'','''',1
1,1,'''',1,1,9,19,''xl43'','''',1
1,1,'''',1,1,9,20,''xl43'','''',1
1,1,'''',1,1,9,21,''xl43'','''',1
1,1,'''',1,1,9,22,''xl43'','''',1
1,1,'''',1,1,9,23,''xl43'','''',1
1,1,'''',1,1,9,24,''xl43'','''',1
1,1,'''',1,1,9,25,''xl43'','''',1
1,1,'''',1,1,9,26,''xl43'','''',1
1,1,'''',1,1,9,27,''xl43'','''',1
1,1,'''',1,1,9,28,''xl43'','''',1
1,1,'''',1,1,9,29,''xl43'','''',1
1,1,'''',1,1,9,30,''xl43'','''',1
1,1,'''',1,1,9,31,''xl43'','''',1
1,1,'''',1,1,9,32,''xl43'','''',1
1,1,'''',1,1,9,33,''xl43'','''',1
1,1,'''',1,1,9,34,''xl43'','''',1
1,1,'''',1,1,9,35,''xl43'','''',1
1,1,'''',1,1,9,36,''xl43'','''',1
1,1,'''',1,1,9,37,''xl43'','''',1
1,1,'''',1,1,9,38,''xl43'','''',1
1,1,'''',1,1,9,39,''xl43'','''',1
1,1,'''',1,1,9,40,''xl43'','''',1
1,1,'''',1,1,9,41,''xl43'','''',1
1,1,'''',1,1,9,42,''xl22'','''',1
1,1,'''',1,1,9,43,''xl22'','''',1
1,1,''>>>" , chr(10)  "&cText_35'',10,1,10,1,''xl24'','''',1
1,1,'' '',10,1,10,2,''xl35'','''',1
1,1,''  ,  '',10,1,10,3,''xl44'','''',1
1,1,''    '',4,1,10,4,''xl48'','''',1
1,1,''>>>"      "&cText_35'',3,12,10,5,''xl59'','''',1
1,1,''>>>" ..       "&cText_35&"           () "'',3,12,10,17,''xl59'','''',1
1,1,''>>>"    () "&cText_35'',3,6,10,29,''xl59'','''',1
1,1,''>>>" ..     () "&cText_35&"           () "'',3,6,10,35,''xl59'','''',1
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,10,41,''xl76'','''',1
1,1,'''',1,1,10,42,''xl82'','''',1
1,1,'''',1,1,10,43,''xl82'','''',1
1,1,'''',1,1,11,42,''xl82'','''',1
1,1,'''',1,1,11,43,''xl82'','''',1
1,1,'''',1,1,12,42,''xl82'','''',1
1,1,'''',1,1,12,43,''xl82'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,5,''xl59'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,9,''xl59'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,11,''xl59'','''',1
1,1,'' '',1,4,13,13,''xl59'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,17,''xl59'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,21,''xl59'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,23,''xl59'','''',1
1,1,'' '',1,4,13,25,''xl59'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,29,''xl59'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,31,''xl59'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,33,''xl59'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,35,''xl59'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,37,''xl59'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,39,''xl59'','''',1
1,1,'''',1,1,13,42,''xl82'','''',1
1,1,'''',1,1,13,43,''xl82'','''',1
1,1,''/'',6,1,14,4,''xl49'','''',1
1,1,'''',1,2,14,5,''xl59'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,7,''xl59'','''',1
1,1,'''',6,1,14,9,''xl63'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,10,''xl66'','''',1
1,1,'''',6,1,14,11,''xl67'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,12,''xl68'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,13,''xl71'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,15,''xl71'','''',1
1,1,'''',1,2,14,17,''xl59'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,19,''xl59'','''',1
1,1,'''',6,1,14,21,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,22,''xl69'','''',1
1,1,'''',6,1,14,23,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,24,''xl69'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,25,''xl71'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,27,''xl71'','''',1
1,1,'''',6,1,14,29,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,30,''xl69'','''',1
1,1,'''',6,1,14,31,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,32,''xl69'','''',1
1,1,'''',6,1,14,33,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,34,''xl69'','''',1
1,1,'''',6,1,14,35,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,36,''xl69'','''',1
1,1,'''',6,1,14,37,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,38,''xl69'','''',1
1,1,'''',6,1,14,39,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,40,''xl69'','''',1
1,1,'''',1,1,14,42,''xl82'','''',1
1,1,'''',1,1,14,43,''xl82'','''',1
1,1,''  '',5,1,15,5,''xl54'','''',1
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '1,1,'''',5,1,15,6,''xl60'','''',1
1,1,''  '',5,1,15,7,''xl61'','''',1
1,1,'''',5,1,15,8,''xl62'','''',1
1,1,'''',5,1,15,13,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,14,''xl69'','''',1
1,1,'''',5,1,15,15,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,16,''xl69'','''',1
1,1,''  '',5,1,15,17,''xl69'','''',1
1,1,'''',5,1,15,18,''xl69'','''',1
1,1,''  '',5,1,15,19,''xl69'','''',1
1,1,'''',5,1,15,20,''xl69'','''',1
1,1,'''',5,1,15,25,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,26,''xl69'','''',1
1,1,'''',5,1,15,27,''xl69'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,28,''xl69'','''',1
1,1,'''',1,1,15,42,''xl82'','''',1
1,1,'''',1,1,15,43,''xl82'','''',1
1,1,'''',1,1,16,42,''xl82'','''',1
1,1,'''',1,1,16,43,''xl82'','''',1
1,1,'''',1,1,17,42,''xl82'','''',1
1,1,'''',1,1,17,43,''xl82'','''',1
1,1,'''',1,1,18,42,''xl82'','''',1
1,1,'''',1,1,18,43,''xl82'','''',1
1,1,'''',1,1,19,42,''xl82'','''',1
1,1,'''',1,1,19,43,''xl82'','''',1
1,2,''>>>"   "&cText_35'',1,1,1,1,''xl30'','''',1
1,2,''8000'',1,1,1,2,''xl40'','''',1
1,2,'''',1,1,1,3,''xl46'','''',1
1,2,'''',1,1,1,4,''xl46'','''',1
1,2,''>>(<list>;1;<s_1>)'',1,1,1,5,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_2>)'',1,1,1,6,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_1>)'',1,1,1,7,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_2>)'',1,1,1,8,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_3>)'',1,1,1,9,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_3>)'',1,1,1,10,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_4>)'',1,1,1,11,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_4>)'',1,1,1,12,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_5>)'',1,1,1,13,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_5>)'',1,1,1,14,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_6>)'',1,1,1,15,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_6>)'',1,1,1,16,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_1>)'',1,1,1,17,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_2>)'',1,1,1,18,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_1>)'',1,1,1,19,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_2>)'',1,1,1,20,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_3>)'',1,1,1,21,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_3>)'',1,1,1,22,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_4>)'',1,1,1,23,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_4>)'',1,1,1,24,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_5>)'',1,1,1,25,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_5>)'',1,1,1,26,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_6>)'',1,1,1,27,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_6>)'',1,1,1,28,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_7>)'',1,1,1,29,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_7>)'',1,1,1,30,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_8>)'',1,1,1,31,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_8>)'',1,1,1,32,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_9>)'',1,1,1,33,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_9>)'',1,1,1,34,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_7>)'',1,1,1,35,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_7>)'',1,1,1,36,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_8>)'',1,1,1,37,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_8>)'',1,1,1,38,''xl57'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_9>)'',1,1,1,39,''xl57'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_9>)'',1,1,1,40,''xl57'',''"#,##0.00"'',1
1,2,'''',1,1,1,41,''xl79'','''',1
1,2,'''',1,1,1,42,''xl22'','''',1
1,2,'''',1,1,1,43,''xl22'','''',1
1,2,'''',1,1,2,1,''xl31'','''',1
1,2,'''',1,1,2,2,''xl41'','''',1
1,2,'''',1,1,2,3,''xl47'','''',1
1,2,'''',1,1,2,4,''xl41'','''',1
1,2,'''',1,1,2,5,''xl53'','''',1
1,2,'''',1,1,2,6,''xl53'','''',1
1,2,'''',1,1,2,7,''xl53'','''',1
1,2,'''',1,1,2,8,''xl53'','''',1
1,2,'''',1,1,2,9,''xl53'','''',1
1,2,'''',1,1,2,10,''xl53'','''',1
1,2,'''',1,1,2,11,''xl53'','''',1
1,2,'''',1,1,2,12,''xl53'','''',1
1,2,'''',1,1,2,13,''xl53'','''',1
1,2,'''',1,1,2,14,''xl53'','''',1
1,2,'''',1,1,2,15,''xl53'','''',1
1,2,'''',1,1,2,16,''xl53'','''',1
1,2,'''',1,1,2,17,''xl53'','''',1
1,2,'''',1,1,2,18,''xl53'','''',1
1,2,'''',1,1,2,19,''xl53'','''',1
1,2,'''',1,1,2,20,''xl53'','''',1
1,2,'''',1,1,2,21,''xl53'','''',1
1,2,'''',1,1,2,22,''xl53'','''',1
1,2,'''',1,1,2,23,''xl53'','''',1
1,2,'''',1,1,2,24,''xl53'','''',1
1,2,'''',1,1,2,25,''xl53'','''',1
1,2,'''',1,1,2,26,''xl53'','''',1
1,2,'''',1,1,2,27,''xl53'','''',1
1,2,'''',1,1,2,28,''xl53'','''',1
1,2,'''',1,1,2,29,''xl53'','''',1
1,2,'''',1,1,2,30,''xl53'','''',1
1,2,'''',1,1,2,31,''xl53'','''',1
1,2,'''',1,1,2,32,''xl53'','''',1
1,2,'''',1,1,2,33,''xl53'','''',1
1,2,'''',1,1,2,34,''xl53'','''',1
1,2,'''',1,1,2,35,''xl53'','''',1
1,2,'''',1,1,2,36,''xl53'','''',1
1,2,'''',1,1,2,37,''xl53'','''',1
1,2,'''',1,1,2,38,''xl53'','''',1
1,2,'''',1,1,2,39,''xl53'','''',1
1,2,'''',1,1,2,40,''xl53'','''',1
1,2,'''',1,1,2,41,''xl53'','''',1
1,2,'''',1,1,2,42,''xl22'','''',1
1,2,'''',1,1,2,43,''xl22'','''',1
1,2,''>>>Footer'',1,41,3,1,''xl32'','''',1
1,2,'''',1,1,3,42,''xl22'','''',1
1,2,'''',1,1,3,43,''xl22'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl25'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,3,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,4,''xl50'','''',1
2,1,''>>"=("&(34)&"R[0]C[-2]"&(34)&";)+1"'',1,1,1,5,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,6,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,7,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,8,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,9,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,10,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,11,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,12,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,13,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,14,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,15,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,16,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,17,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,18,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,19,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,20,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,21,''xl25'','''',1
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,22,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,23,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,24,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,25,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,26,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,27,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,28,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,29,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,30,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,31,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,32,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,33,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,34,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,35,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,36,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,37,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,38,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,39,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,40,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,41,''xl25'','''',1
2,1,'''',1,1,1,42,''xl22'','''',1
2,1,'''',1,1,1,43,''xl22'','''',1
3,1,''>>>{po5_n}'',1,1,1,1,''xl27'','''',1
3,1,''>>>{cpo5}'',1,1,1,2,''xl36'','''',1
3,1,''>>>{cpo5g}'',1,1,1,3,''xl36'','''',1
3,1,'''',1,1,1,4,''xl51'','''',1
3,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',1
3,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',1
3,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',1
3,1,'''',1,1,1,41,''xl51'','''',1
3,1,'''',1,1,1,42,''xl22'','''',1
3,1,'''',1,1,1,43,''xl22'','''',1
4,1,''>>>{po4_n}'',1,1,1,1,''xl27'','''',1
4,1,''>>>{cpo4}'',1,1,1,2,''xl36'','''',1
4,1,''>>>{cpo4g}'',1,1,1,3,''xl36'','''',1
4,1,'''',1,1,1,4,''xl51'','''',1
4,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',1
4,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',1
4,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',1
4,1,'''',1,1,1,41,''xl51'','''',1
4,1,'''',1,1,1,42,''xl22'','''',1
4,1,'''',1,1,1,43,''xl22'','''',1
5,1,''>>>{po3_n}'',1,1,1,1,''xl27'','''',1
5,1,''>>>{cpo3}'',1,1,1,2,''xl36'','''',1
5,1,''>>>{cpo3g}'',1,1,1,3,''xl36'','''',1
5,1,'''',1,1,1,4,''xl51'','''',1
5,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',1
5,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',1
5,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',1
5,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',1
5,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '5,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',1
5,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',1
5,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',1
5,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',1
5,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',1
5,1,'''',1,1,1,41,''xl51'','''',1
5,1,'''',1,1,1,42,''xl22'','''',1
5,1,'''',1,1,1,43,''xl22'','''',1
6,1,''>>>{po2_n}'',1,1,1,1,''xl27'','''',1
6,1,''>>>{cpo2}'',1,1,1,2,''xl36'','''',1
6,1,''>>>{cpo2g}'',1,1,1,3,''xl36'','''',1
6,1,'''',1,1,1,4,''xl51'','''',1
6,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',1
6,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',1
6,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',1
6,1,'''',1,1,1,41,''xl51'','''',1
6,1,'''',1,1,1,42,''xl22'','''',1
6,1,'''',1,1,1,43,''xl22'','''',1
7,1,''>>>{po1_n}'',1,1,1,1,''xl27'','''',1
7,1,''>>>{cpo1}'',1,1,1,2,''xl36'','''',1
7,1,''>>>{cpo1g}'',1,1,1,3,''xl36'','''',1
7,1,'''',1,1,1,4,''xl51'','''',1
7,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',1
7,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',1
7,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',1
7,1,'''',1,1,1,41,''xl51'','''',1
7,1,'''',1,1,1,42,''xl22'','''',1
7,1,'''',1,1,1,43,''xl22'','''',1
8,1,''>>>nvl({po_n};" ")'',1,1,1,1,''xl28'','''',1
8,1,''>>>nvl({cpo};" ")'',1,1,1,2,''xl38'','''',1
8,1,''>>nvl({cpog};" ")'',1,1,1,3,''xl39'','''',1
8,1,''>>>(<lev>;1;<cdiv>)'',1,1,1,4,''xl52'','''',1
8,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '8,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',1
8,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',1
8,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',1
8,1,''>>>(<lev>;1;<metod>)'',1,1,1,41,''xl77'','''',1
8,1,'''',1,1,1,42,''xl22'','''',1
8,1,'''',1,1,1,43,''xl22'','''',1
9,1,'''',1,1,1,1,''xl29'','''',1
9,1,'''',1,1,1,2,''xl39'','''',1
9,1,'''',1,1,1,3,''xl39'','''',1
9,1,'''',1,1,1,4,''xl52'','''',1
9,1,'''',1,1,1,5,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,6,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,7,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,8,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,9,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,10,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,11,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,12,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,13,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,14,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,15,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,16,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,17,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,18,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,19,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,20,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,21,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,22,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,23,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,24,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,25,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,26,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,27,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,28,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,29,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,30,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,31,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,32,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,33,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,34,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,35,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,36,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,37,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,38,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,39,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,40,''xl56'',''"#,##0.00"'',1
9,1,'''',1,1,1,41,''xl78'','''',1
9,1,''>>st'',1,1,1,42,''xl83'','''',1
9,1,'''',1,1,1,43,''xl22'','''',1
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 7, '1,1,'''',1,1,1,1,''xl22'','''',2
1,1,'''',1,1,1,2,''xl22'','''',2
1,1,'''',1,1,1,3,''xl22'','''',2
1,1,'''',1,1,1,4,''xl22'','''',2
1,1,'''',1,1,1,5,''xl22'','''',2
1,1,'''',1,1,1,6,''xl22'','''',2
1,1,'''',1,1,1,7,''xl22'','''',2
1,1,'''',1,1,1,8,''xl22'','''',2
1,1,'''',1,1,1,9,''xl22'','''',2
1,1,'''',1,1,1,10,''xl22'','''',2
1,1,'''',1,1,1,11,''xl22'','''',2
1,1,'''',1,1,1,12,''xl22'','''',2
1,1,'''',1,1,1,13,''xl22'','''',2
1,1,'''',1,1,1,14,''xl22'','''',2
1,1,'''',1,1,1,15,''xl22'','''',2
1,1,'''',1,1,1,16,''xl72'','''',2
1,1,'''',1,1,1,17,''xl72'','''',2
1,1,'''',1,1,1,18,''xl72'','''',2
1,1,'''',1,1,1,19,''xl72'','''',2
1,1,'''',1,1,1,20,''xl72'','''',2
1,1,'''',1,1,1,21,''xl72'','''',2
1,1,'''',1,1,1,22,''xl72'','''',2
1,1,'''',1,1,1,23,''xl22'','''',2
1,1,'''',1,1,1,24,''xl74'','''',2
1,1,'''',1,1,1,25,''xl74'','''',2
1,1,'''',1,1,1,26,''xl74'','''',2
1,1,'''',1,1,1,27,''xl74'','''',2
1,1,'''',1,1,1,28,''xl23'','''',2
1,1,'''',1,1,1,29,''xl22'','''',2
1,1,'''',1,1,1,30,''xl74'','''',2
1,1,'''',1,1,1,31,''xl74'','''',2
1,1,'''',1,1,1,32,''xl74'','''',2
1,1,'''',1,1,1,33,''xl74'','''',2
1,1,'''',1,1,1,34,''xl74'','''',2
1,1,'''',1,1,1,35,''xl74'','''',2
1,1,'''',1,1,1,36,''xl74'','''',2
1,1,'''',1,1,1,37,''xl74'','''',2
1,1,'''',1,1,1,38,''xl74'','''',2
1,1,'''',1,1,1,39,''xl74'','''',2
1,1,'''',1,1,1,40,''xl74'','''',2
1,1,'''',1,1,1,41,''xl74'','''',2
1,1,''>>"#/"'',1,1,1,42,''xl81'','''',2
1,1,'''',1,1,1,43,''xl22'','''',2
1,1,''            ,'',1,14,2,1,''xl70'','''',2
1,1,'''',1,1,2,15,''xl22'','''',2
1,1,'''',1,1,2,16,''xl72'','''',2
1,1,'''',1,1,2,17,''xl72'','''',2
1,1,'''',1,1,2,18,''xl72'','''',2
1,1,'''',1,1,2,19,''xl72'','''',2
1,1,'''',1,1,2,20,''xl72'','''',2
1,1,'''',1,1,2,21,''xl72'','''',2
1,1,'''',1,1,2,22,''xl72'','''',2
1,1,'''',1,1,2,23,''xl22'','''',2
1,1,'''',1,1,2,24,''xl74'','''',2
1,1,'''',1,1,2,25,''xl74'','''',2
1,1,'''',1,1,2,26,''xl74'','''',2
1,1,'''',1,1,2,27,''xl74'','''',2
1,1,'''',1,1,2,28,''xl23'','''',2
1,1,'''',1,1,2,29,''xl22'','''',2
1,1,'''',1,1,2,30,''xl74'','''',2
1,1,'''',1,1,2,31,''xl74'','''',2
1,1,'''',1,1,2,32,''xl74'','''',2
1,1,'''',1,1,2,33,''xl74'','''',2
1,1,'''',1,1,2,34,''xl74'','''',2
1,1,'''',1,1,2,35,''xl74'','''',2
1,1,'''',1,1,2,36,''xl74'','''',2
1,1,'''',1,1,2,37,''xl74'','''',2
1,1,'''',1,1,2,38,''xl74'','''',2
1,1,'''',1,1,2,39,''xl74'','''',2
1,1,'''',1,1,2,40,''xl74'','''',2
1,1,'''',1,1,2,41,''xl74'','''',2
1,1,'''',1,1,2,42,''xl22'','''',2
1,1,'''',1,1,2,43,''xl22'','''',2
1,1,''          ,    '',1,14,3,1,''xl70'','''',2
1,1,'''',1,1,3,15,''xl72'','''',2
1,1,'''',1,1,3,16,''xl65'','''',2
1,1,'''',1,1,3,17,''xl65'','''',2
1,1,'''',1,1,3,18,''xl65'','''',2
1,1,'''',1,1,3,19,''xl65'','''',2
1,1,'''',1,1,3,20,''xl65'','''',2
1,1,'''',1,1,3,21,''xl65'','''',2
1,1,'''',1,1,3,22,''xl65'','''',2
1,1,'''',1,1,3,23,''xl22'','''',2
1,1,'''',1,1,3,24,''xl74'','''',2
1,1,'''',1,1,3,25,''xl74'','''',2
1,1,'''',1,1,3,26,''xl74'','''',2
1,1,'''',1,1,3,27,''xl74'','''',2
1,1,'''',1,1,3,28,''xl23'','''',2
1,1,'''',1,1,3,29,''xl22'','''',2
1,1,'''',1,1,3,30,''xl74'','''',2
1,1,'''',1,1,3,31,''xl74'','''',2
1,1,'''',1,1,3,32,''xl74'','''',2
1,1,'''',1,1,3,33,''xl74'','''',2
1,1,'''',1,1,3,34,''xl74'','''',2
1,1,'''',1,1,3,35,''xl74'','''',2
1,1,'''',1,1,3,36,''xl74'','''',2
1,1,'''',1,1,3,37,''xl74'','''',2
1,1,'''',1,1,3,38,''xl74'','''',2
1,1,'''',1,1,3,39,''xl74'','''',2
1,1,'''',1,1,3,40,''xl74'','''',2
1,1,'''',1,1,3,41,''xl74'','''',2
1,1,'''',1,1,3,42,''xl22'','''',2
1,1,'''',1,1,3,43,''xl22'','''',2
1,1,''>>" "&(dDate_2+1;0)&"."'',1,14,4,1,''xl47'','''',2
1,1,'''',1,1,4,15,''xl47'','''',2
1,1,'''',1,1,4,16,''xl47'','''',2
1,1,'''',1,1,4,17,''xl47'','''',2
1,1,'''',1,1,4,18,''xl47'','''',2
1,1,'''',1,1,4,19,''xl47'','''',2
1,1,'''',1,1,4,20,''xl47'','''',2
1,1,'''',1,1,4,21,''xl47'','''',2
1,1,'''',1,1,4,22,''xl47'','''',2
1,1,'''',1,1,4,23,''xl22'','''',2
1,1,'''',1,1,4,24,''xl74'','''',2
1,1,'''',1,1,4,25,''xl74'','''',2
1,1,'''',1,1,4,26,''xl74'','''',2
1,1,'''',1,1,4,27,''xl74'','''',2
1,1,'''',1,1,4,28,''xl23'','''',2
1,1,'''',1,1,4,29,''xl22'','''',2
1,1,'''',1,1,4,30,''xl74'','''',2
1,1,'''',1,1,4,31,''xl74'','''',2
1,1,'''',1,1,4,32,''xl74'','''',2
1,1,'''',1,1,4,33,''xl74'','''',2
1,1,'''',1,1,4,34,''xl74'','''',2
1,1,'''',1,1,4,35,''xl74'','''',2
1,1,'''',1,1,4,36,''xl74'','''',2
1,1,'''',1,1,4,37,''xl74'','''',2
1,1,'''',1,1,4,38,''xl74'','''',2
1,1,'''',1,1,4,39,''xl74'','''',2
1,1,'''',1,1,4,40,''xl74'','''',2
1,1,'''',1,1,4,41,''xl74'','''',2
1,1,'''',1,1,4,42,''xl22'','''',2
1,1,'''',1,1,4,43,''xl22'','''',2
1,1,'''',1,1,5,1,''xl22'','''',2
1,1,'''',1,1,5,2,''xl22'','''',2
1,1,'''',1,1,5,3,''xl43'','''',2
1,1,'''',1,1,5,4,''xl33'','''',2
1,1,'''',1,1,5,5,''xl43'','''',2
1,1,'''',1,1,5,6,''xl43'','''',2
1,1,'''',1,1,5,7,''xl43'','''',2
1,1,'''',1,1,5,8,''xl43'','''',2
1,1,'''',1,1,5,9,''xl43'','''',2
1,1,'''',1,1,5,10,''xl65'','''',2
1,1,'''',1,1,5,11,''xl65'','''',2
1,1,'''',1,1,5,12,''xl65'','''',2
1,1,'''',1,1,5,13,''xl65'','''',2
1,1,'''',1,1,5,14,''xl43'','''',2
1,1,'''',1,1,5,15,''xl43'','''',2
1,1,'''',1,1,5,16,''xl43'','''',2
1,1,'''',1,1,5,17,''xl43'','''',2
1,1,'''',1,1,5,18,''xl43'','''',2
1,1,'''',1,1,5,19,''xl43'','''',2
1,1,'''',1,1,5,20,''xl43'','''',2
1,1,'''',1,1,5,21,''xl43'','''',2
1,1,'''',1,1,5,22,''xl43'','''',2
1,1,'''',1,1,5,23,''xl22'','''',2
1,1,'''',1,1,5,24,''xl74'','''',2
1,1,'''',1,1,5,25,''xl74'','''',2
1,1,'''',1,1,5,26,''xl74'','''',2
1,1,'''',1,1,5,27,''xl74'','''',2
1,1,'''',1,1,5,28,''xl23'','''',2
1,1,'''',1,1,5,29,''xl22'','''',2
1,1,'''',1,1,5,30,''xl74'','''',2
1,1,'''',1,1,5,31,''xl74'','''',2
1,1,'''',1,1,5,32,''xl74'','''',2
1,1,'''',1,1,5,33,''xl74'','''',2
1,1,'''',1,1,5,34,''xl74'','''',2
1,1,'''',1,1,5,35,''xl74'','''',2
1,1,'''',1,1,5,36,''xl74'','''',2
1,1,'''',1,1,5,37,''xl74'','''',2
1,1,'''',1,1,5,38,''xl74'','''',2
1,1,'''',1,1,5,39,''xl74'','''',2
1,1,'''',1,1,5,40,''xl74'','''',2
1,1,'''',1,1,5,41,''xl74'','''',2
1,1,'''',1,1,5,42,''xl22'','''',2
1,1,'''',1,1,5,43,''xl22'','''',2
1,1,''        '',1,1,6,1,''xl23'','''',2
1,1,'''',1,1,6,2,''xl33'','''',2
1,1,''$$select name from c_data1 where list=2#name#name#NN'',1,24,6,3,''xl75'','''',2
1,1,'''',1,1,6,27,''xl74'','''',2
1,1,'''',1,1,6,28,''xl23'','''',2
1,1,'''',1,1,6,29,''xl22'','''',2
1,1,'''',1,1,6,30,''xl74'','''',2
1,1,'''',1,1,6,31,''xl74'','''',2
1,1,'''',1,1,6,32,''xl74'','''',2
1,1,'''',1,1,6,33,''xl74'','''',2
1,1,'''',1,1,6,34,''xl74'','''',2
1,1,'''',1,1,6,35,''xl74'','''',2
1,1,'''',1,1,6,36,''xl74'','''',2
1,1,'''',1,1,6,37,''xl74'','''',2
1,1,'''',1,1,6,38,''xl74'','''',2
1,1,'''',1,1,6,39,''xl74'','''',2
1,1,'''',1,1,6,40,''xl74'','''',2
1,1,'''',1,1,6,41,''xl74'','''',2
1,1,'''',1,1,6,42,''xl22'','''',2
1,1,'''',1,1,6,43,''xl22'','''',2
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,16,7,1,''xl73'','''',2
1,1,'''',1,1,7,17,''xl43'','''',2
1,1,'''',1,1,7,18,''xl43'','''',2
1,1,'''',1,1,7,19,''xl43'','''',2
1,1,'''',1,1,7,20,''xl43'','''',2
1,1,'''',1,1,7,21,''xl43'','''',2
1,1,'''',1,1,7,22,''xl43'','''',2
1,1,'''',1,1,7,23,''xl43'','''',2
1,1,'''',1,1,7,24,''xl43'','''',2
1,1,'''',1,1,7,25,''xl43'','''',2
1,1,'''',1,1,7,26,''xl43'','''',2
1,1,'''',1,1,7,27,''xl43'','''',2
1,1,'''',1,1,7,28,''xl23'','''',2
1,1,'''',1,1,7,29,''xl22'','''',2
1,1,'''',1,1,7,30,''xl43'','''',2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 8, '1,1,'''',1,1,7,31,''xl43'','''',2
1,1,'''',1,1,7,32,''xl43'','''',2
1,1,'''',1,1,7,33,''xl43'','''',2
1,1,'''',1,1,7,34,''xl43'','''',2
1,1,'''',1,1,7,35,''xl43'','''',2
1,1,'''',1,1,7,36,''xl43'','''',2
1,1,'''',1,1,7,37,''xl43'','''',2
1,1,'''',1,1,7,38,''xl43'','''',2
1,1,'''',1,1,7,39,''xl43'','''',2
1,1,'''',1,1,7,40,''xl43'','''',2
1,1,'''',1,1,7,41,''xl43'','''',2
1,1,'''',1,1,7,42,''xl22'','''',2
1,1,'''',1,1,7,43,''xl22'','''',2
1,1,'''',1,1,8,1,''xl23'','''',2
1,1,'''',1,1,8,2,''xl33'','''',2
1,1,'''',1,1,8,3,''xl43'','''',2
1,1,'''',1,1,8,4,''xl33'','''',2
1,1,'''',1,1,8,5,''xl43'','''',2
1,1,'''',1,1,8,6,''xl43'','''',2
1,1,'''',1,1,8,7,''xl43'','''',2
1,1,'''',1,1,8,8,''xl43'','''',2
1,1,'''',1,1,8,9,''xl43'','''',2
1,1,'''',1,1,8,10,''xl43'','''',2
1,1,'''',1,1,8,11,''xl43'','''',2
1,1,'''',1,1,8,12,''xl43'','''',2
1,1,'''',1,1,8,13,''xl43'','''',2
1,1,'''',1,1,8,14,''xl43'','''',2
1,1,'''',1,1,8,15,''xl43'','''',2
1,1,'''',1,1,8,16,''xl43'','''',2
1,1,'''',1,1,8,17,''xl43'','''',2
1,1,'''',1,1,8,18,''xl43'','''',2
1,1,'''',1,1,8,19,''xl43'','''',2
1,1,'''',1,1,8,20,''xl43'','''',2
1,1,'''',1,1,8,21,''xl43'','''',2
1,1,'''',1,1,8,22,''xl43'','''',2
1,1,'''',1,1,8,23,''xl43'','''',2
1,1,'''',1,1,8,24,''xl43'','''',2
1,1,'''',1,1,8,25,''xl43'','''',2
1,1,'''',1,1,8,26,''xl43'','''',2
1,1,'''',1,1,8,27,''xl43'','''',2
1,1,'''',1,1,8,28,''xl43'','''',2
1,1,'''',1,1,8,29,''xl43'','''',2
1,1,'''',1,1,8,30,''xl43'','''',2
1,1,'''',1,1,8,31,''xl43'','''',2
1,1,'''',1,1,8,32,''xl43'','''',2
1,1,'''',1,1,8,33,''xl43'','''',2
1,1,'''',1,1,8,34,''xl43'','''',2
1,1,'''',1,1,8,35,''xl43'','''',2
1,1,'''',1,1,8,36,''xl43'','''',2
1,1,'''',1,1,8,37,''xl43'','''',2
1,1,'''',1,1,8,38,''xl43'','''',2
1,1,'''',1,1,8,39,''xl43'','''',2
1,1,'''',1,1,8,40,''xl43'','''',2
1,1,'''',1,1,8,41,''xl43'','''',2
1,1,'''',1,1,8,42,''xl22'','''',2
1,1,'''',1,1,8,43,''xl22'','''',2
1,1,'' , chr(10) '',10,1,9,1,''xl84'','''',2
1,1,'' '',10,1,9,2,''xl85'','''',2
1,1,''  ,  '',10,1,9,3,''xl86'','''',2
1,1,''    '',4,1,9,4,''xl87'','''',2
1,1,''       '',3,12,9,5,''xl59'','''',2
1,1,'' ..                 '',3,12,9,17,''xl59'','''',2
1,1,''    '',3,6,9,29,''xl59'','''',2
1,1,'' ..                 '',3,6,9,35,''xl59'','''',2
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,9,41,''xl89'','''',2
1,1,'''',1,1,9,42,''xl82'','''',2
1,1,'''',1,1,9,43,''xl82'','''',2
1,1,'''',1,1,10,42,''xl82'','''',2
1,1,'''',1,1,10,43,''xl82'','''',2
1,1,'''',1,1,11,42,''xl82'','''',2
1,1,'''',1,1,11,43,''xl82'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,5,''xl59'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,9,''xl59'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,11,''xl59'','''',2
1,1,'' '',1,4,12,13,''xl59'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,17,''xl59'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,21,''xl59'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,23,''xl59'','''',2
1,1,'' '',1,4,12,25,''xl59'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,12,29,''xl59'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,12,31,''xl59'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,12,33,''xl59'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,12,35,''xl59'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,12,37,''xl59'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,12,39,''xl59'','''',2
1,1,'''',1,1,12,42,''xl82'','''',2
1,1,'''',1,1,12,43,''xl82'','''',2
1,1,''/'',6,1,13,4,''xl88'','''',2
1,1,'''',1,2,13,5,''xl59'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,13,7,''xl59'','''',2
1,1,'''',6,1,13,9,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,10,''xl69'','''',2
1,1,'''',6,1,13,11,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,12,''xl69'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,13,13,''xl71'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,13,15,''xl71'','''',2
1,1,'''',1,2,13,17,''xl59'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,13,19,''xl59'','''',2
1,1,'''',6,1,13,21,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,22,''xl69'','''',2
1,1,'''',6,1,13,23,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,24,''xl69'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,13,25,''xl71'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,13,27,''xl71'','''',2
1,1,'''',6,1,13,29,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,30,''xl69'','''',2
1,1,'''',6,1,13,31,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,32,''xl69'','''',2
1,1,'''',6,1,13,33,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,34,''xl69'','''',2
1,1,'''',6,1,13,35,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,36,''xl69'','''',2
1,1,'''',6,1,13,37,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,38,''xl69'','''',2
1,1,'''',6,1,13,39,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,40,''xl69'','''',2
1,1,'''',1,1,13,42,''xl82'','''',2
1,1,'''',1,1,13,43,''xl82'','''',2
1,1,''  '',5,1,14,5,''xl69'','''',2
1,1,'''',5,1,14,6,''xl69'','''',2
1,1,''  '',5,1,14,7,''xl69'','''',2
1,1,'''',5,1,14,8,''xl69'','''',2
1,1,'''',5,1,14,13,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,14,''xl69'','''',2
1,1,'''',5,1,14,15,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,16,''xl69'','''',2
1,1,''  '',5,1,14,17,''xl69'','''',2
1,1,'''',5,1,14,18,''xl69'','''',2
1,1,''  '',5,1,14,19,''xl69'','''',2
1,1,'''',5,1,14,20,''xl69'','''',2
1,1,'''',5,1,14,25,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,26,''xl69'','''',2
1,1,'''',5,1,14,27,''xl69'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,28,''xl69'','''',2
1,1,'''',1,1,14,42,''xl82'','''',2
1,1,'''',1,1,14,43,''xl82'','''',2
1,1,'''',1,1,15,42,''xl82'','''',2
1,1,'''',1,1,15,43,''xl82'','''',2
1,1,'''',1,1,16,42,''xl82'','''',2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 9, '1,1,'''',1,1,16,43,''xl82'','''',2
1,1,'''',1,1,17,42,''xl82'','''',2
1,1,'''',1,1,17,43,''xl82'','''',2
1,1,'''',1,1,18,42,''xl82'','''',2
1,1,'''',1,1,18,43,''xl82'','''',2
1,2,''    ,    '',1,1,1,1,''xl27'','''',2
1,2,''2500'',1,1,1,2,''xl46'','''',2
1,2,'''',1,1,1,3,''xl46'','''',2
1,2,'''',1,1,1,4,''xl46'','''',2
1,2,''>>2(<npog>;1;<list>;2;<s_1>)'',1,1,1,5,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_2>)'',1,1,1,6,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_1>)'',1,1,1,7,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_2>)'',1,1,1,8,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_3>)'',1,1,1,9,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_3>)'',1,1,1,10,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_4>)'',1,1,1,11,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_4>)'',1,1,1,12,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_5>)'',1,1,1,13,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_5>)'',1,1,1,14,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_6>)'',1,1,1,15,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_6>)'',1,1,1,16,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_1>)'',1,1,1,17,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_2>)'',1,1,1,18,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_1>)'',1,1,1,19,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_2>)'',1,1,1,20,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_3>)'',1,1,1,21,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_3>)'',1,1,1,22,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_4>)'',1,1,1,23,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_4>)'',1,1,1,24,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_5>)'',1,1,1,25,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_5>)'',1,1,1,26,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_6>)'',1,1,1,27,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_6>)'',1,1,1,28,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_7>)'',1,1,1,29,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_7>)'',1,1,1,30,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_8>)'',1,1,1,31,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_8>)'',1,1,1,32,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_9>)'',1,1,1,33,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_9>)'',1,1,1,34,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_7>)'',1,1,1,35,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_7>)'',1,1,1,36,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_8>)'',1,1,1,37,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_8>)'',1,1,1,38,''xl57'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_9>)'',1,1,1,39,''xl57'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_9>)'',1,1,1,40,''xl57'',''"#,##0.00"'',2
1,2,'''',1,1,1,41,''xl79'','''',2
1,2,'''',1,1,1,42,''xl22'','''',2
1,2,'''',1,1,1,43,''xl22'','''',2
1,2,'''',1,1,2,1,''xl31'','''',2
1,2,'''',1,1,2,2,''xl41'','''',2
1,2,'''',1,1,2,3,''xl47'','''',2
1,2,'''',1,1,2,4,''xl41'','''',2
1,2,'''',1,1,2,5,''xl53'','''',2
1,2,'''',1,1,2,6,''xl53'','''',2
1,2,'''',1,1,2,7,''xl53'','''',2
1,2,'''',1,1,2,8,''xl53'','''',2
1,2,'''',1,1,2,9,''xl53'','''',2
1,2,'''',1,1,2,10,''xl53'','''',2
1,2,'''',1,1,2,11,''xl53'','''',2
1,2,'''',1,1,2,12,''xl53'','''',2
1,2,'''',1,1,2,13,''xl53'','''',2
1,2,'''',1,1,2,14,''xl53'','''',2
1,2,'''',1,1,2,15,''xl53'','''',2
1,2,'''',1,1,2,16,''xl53'','''',2
1,2,'''',1,1,2,17,''xl53'','''',2
1,2,'''',1,1,2,18,''xl53'','''',2
1,2,'''',1,1,2,19,''xl53'','''',2
1,2,'''',1,1,2,20,''xl53'','''',2
1,2,'''',1,1,2,21,''xl53'','''',2
1,2,'''',1,1,2,22,''xl53'','''',2
1,2,'''',1,1,2,23,''xl53'','''',2
1,2,'''',1,1,2,24,''xl53'','''',2
1,2,'''',1,1,2,25,''xl53'','''',2
1,2,'''',1,1,2,26,''xl53'','''',2
1,2,'''',1,1,2,27,''xl53'','''',2
1,2,'''',1,1,2,28,''xl53'','''',2
1,2,'''',1,1,2,29,''xl53'','''',2
1,2,'''',1,1,2,30,''xl53'','''',2
1,2,'''',1,1,2,31,''xl53'','''',2
1,2,'''',1,1,2,32,''xl53'','''',2
1,2,'''',1,1,2,33,''xl53'','''',2
1,2,'''',1,1,2,34,''xl53'','''',2
1,2,'''',1,1,2,35,''xl53'','''',2
1,2,'''',1,1,2,36,''xl53'','''',2
1,2,'''',1,1,2,37,''xl53'','''',2
1,2,'''',1,1,2,38,''xl53'','''',2
1,2,'''',1,1,2,39,''xl53'','''',2
1,2,'''',1,1,2,40,''xl53'','''',2
1,2,'''',1,1,2,41,''xl53'','''',2
1,2,'''',1,1,2,42,''xl22'','''',2
1,2,'''',1,1,2,43,''xl22'','''',2
1,2,''>>>Footer'',1,41,3,1,''xl32'','''',2
1,2,'''',1,1,3,42,''xl22'','''',2
1,2,'''',1,1,3,43,''xl22'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl25'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-"&(nCheck_16=1;"1";"4")&"]"&(34)&";)+1"'',1,1,1,3,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,4,''xl50'','''',2
2,1,''>>"=("&(34)&"R[0]C[-2]"&(34)&";)+1"'',1,1,1,5,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,6,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,7,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,8,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,9,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,10,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,11,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,12,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,13,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,14,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,15,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,16,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,17,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,18,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,19,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,20,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,21,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,22,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,23,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,24,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,25,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,26,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,27,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,28,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,29,''xl25'','''',2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 10, '2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,30,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,31,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,32,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,33,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,34,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,35,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,36,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,37,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,38,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,39,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,40,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,41,''xl25'','''',2
2,1,'''',1,1,1,42,''xl22'','''',2
2,1,'''',1,1,1,43,''xl22'','''',2
3,1,''>>>{po5_n}'',1,1,1,1,''xl27'','''',2
3,1,''>>>{cpo5}'',1,1,1,2,''xl36'','''',2
3,1,''>>>{cpo5g}'',1,1,1,3,''xl36'','''',2
3,1,'''',1,1,1,4,''xl51'','''',2
3,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',2
3,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',2
3,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',2
3,1,'''',1,1,1,41,''xl51'','''',2
3,1,'''',1,1,1,42,''xl22'','''',2
3,1,'''',1,1,1,43,''xl22'','''',2
4,1,''>>>{po4_n}'',1,1,1,1,''xl27'','''',2
4,1,''>>>{cpo4}'',1,1,1,2,''xl36'','''',2
4,1,''>>>{cpo4g}'',1,1,1,3,''xl36'','''',2
4,1,'''',1,1,1,4,''xl51'','''',2
4,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',2
4,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',2
4,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',2
4,1,'''',1,1,1,41,''xl51'','''',2
4,1,'''',1,1,1,42,''xl22'','''',2
4,1,'''',1,1,1,43,''xl22'','''',2
5,1,''>>>{po3_n}'',1,1,1,1,''xl27'','''',2
5,1,''>>>{cpo3}'',1,1,1,2,''xl36'','''',2
5,1,''>>>{cpo3g}'',1,1,1,3,''xl36'','''',2
5,1,'''',1,1,1,4,''xl51'','''',2
5,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 11, '5,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',2
5,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',2
5,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',2
5,1,'''',1,1,1,41,''xl51'','''',2
5,1,'''',1,1,1,42,''xl22'','''',2
5,1,'''',1,1,1,43,''xl22'','''',2
6,1,''>>>{po2_n}'',1,1,1,1,''xl27'','''',2
6,1,''>>>{cpo2}'',1,1,1,2,''xl36'','''',2
6,1,''>>>{cpo2g}'',1,1,1,3,''xl36'','''',2
6,1,'''',1,1,1,4,''xl51'','''',2
6,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',2
6,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',2
6,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',2
6,1,'''',1,1,1,41,''xl51'','''',2
6,1,'''',1,1,1,42,''xl22'','''',2
6,1,'''',1,1,1,43,''xl22'','''',2
7,1,''>>>{po1_n}'',1,1,1,1,''xl27'','''',2
7,1,''>>>{cpo1}'',1,1,1,2,''xl36'','''',2
7,1,''>>>{cpo1g}'',1,1,1,3,''xl36'','''',2
7,1,'''',1,1,1,4,''xl51'','''',2
7,1,''>>(<s_1>)'',1,1,1,5,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_2>)'',1,1,1,6,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_3>)'',1,1,1,9,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_4>)'',1,1,1,11,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_5>)'',1,1,1,13,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_6>)'',1,1,1,15,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_1>)'',1,1,1,17,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_2>)'',1,1,1,18,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_3>)'',1,1,1,21,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_4>)'',1,1,1,23,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_5>)'',1,1,1,25,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_6>)'',1,1,1,27,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_7>)'',1,1,1,29,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_8>)'',1,1,1,31,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl55'',''"#,##0.00"'',2
7,1,''>>(<s_9>)'',1,1,1,33,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_7>)'',1,1,1,35,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_8>)'',1,1,1,37,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl55'',''"#,##0.00"'',2
7,1,''>>(<k_9>)'',1,1,1,39,''xl55'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl55'',''"#,##0.00"'',2
7,1,'''',1,1,1,41,''xl51'','''',2
7,1,'''',1,1,1,42,''xl22'','''',2
7,1,'''',1,1,1,43,''xl22'','''',2
8,1,''>>>nvl({po_n};" ")'',1,1,1,1,''xl28'','''',2
8,1,''>>>nvl({cpo};" ")'',1,1,1,2,''xl38'','''',2
8,1,''>>nvl({cpog};" ")'',1,1,1,3,''xl39'','''',2
8,1,''>>>(<lev>;1;<cdiv>)'',1,1,1,4,''xl52'','''',2
8,1,''>>(<s_1>)'',1,1,1,5,''xl56'',''"#,##0.00"'',2
8,1,''>>(<s_2>)'',1,1,1,6,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_1>)'',1,1,1,7,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_2>)'',1,1,1,8,''xl56'',''"#,##0.00"'',2
8,1,''>>(<s_3>)'',1,1,1,9,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_3>)'',1,1,1,10,''xl56'',''"#,##0.00"'',2
8,1,''>>(<s_4>)'',1,1,1,11,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_4>)'',1,1,1,12,''xl56'',''"#,##0.00"'',2
8,1,''>>(<s_5>)'',1,1,1,13,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_5>)'',1,1,1,14,''xl56'',''"#,##0.00"'',2
8,1,''>>(<s_6>)'',1,1,1,15,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_6>)'',1,1,1,16,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_1>)'',1,1,1,17,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_2>)'',1,1,1,18,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_1>)'',1,1,1,19,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_2>)'',1,1,1,20,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_3>)'',1,1,1,21,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_3>)'',1,1,1,22,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_4>)'',1,1,1,23,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_4>)'',1,1,1,24,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_5>)'',1,1,1,25,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_5>)'',1,1,1,26,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_6>)'',1,1,1,27,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_6>)'',1,1,1,28,''xl56'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 12, '8,1,''>>(<s_7>)'',1,1,1,29,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_7>)'',1,1,1,30,''xl56'',''"#,##0.00"'',2
8,1,''>>(<s_8>)'',1,1,1,31,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_8>)'',1,1,1,32,''xl56'',''"#,##0.00"'',2
8,1,''>>(<s_9>)'',1,1,1,33,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<s_9>)'',1,1,1,34,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_7>)'',1,1,1,35,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_7>)'',1,1,1,36,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_8>)'',1,1,1,37,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_8>)'',1,1,1,38,''xl56'',''"#,##0.00"'',2
8,1,''>>(<k_9>)'',1,1,1,39,''xl56'',''"#,##0.00"'',2
8,1,''>>(<su>;AA;<k_9>)'',1,1,1,40,''xl56'',''"#,##0.00"'',2
8,1,''>>>(<lev>;1;<metod>)'',1,1,1,41,''xl77'','''',2
8,1,'''',1,1,1,42,''xl22'','''',2
8,1,'''',1,1,1,43,''xl22'','''',2
9,1,'''',1,1,1,1,''xl29'','''',2
9,1,'''',1,1,1,2,''xl39'','''',2
9,1,'''',1,1,1,3,''xl39'','''',2
9,1,'''',1,1,1,4,''xl52'','''',2
9,1,'''',1,1,1,5,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,6,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,7,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,8,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,9,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,10,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,11,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,12,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,13,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,14,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,15,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,16,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,17,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,18,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,19,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,20,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,21,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,22,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,23,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,24,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,25,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,26,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,27,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,28,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,29,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,30,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,31,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,32,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,33,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,34,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,35,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,36,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,37,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,38,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,39,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,40,''xl56'',''"#,##0.00"'',2
9,1,'''',1,1,1,41,''xl78'','''',2
9,1,''>>st'',1,1,1,42,''xl83'','''',2
9,1,'''',1,1,1,43,''xl22'','''',2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=1;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=1'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=1;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=2;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=2'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=2;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '33.67,186
4.56,28.8
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '33.67,186
4.56,28.8
4.89,30.6
4.11,26.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,61.2
9,1,22.5
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,61.2
9,1,22.5
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 0, 'tr
	{mso-height-source:auto;}
col
	{mso-width-source:auto;}
br
	{mso-data-placement:same-cell;}
.style0
	{font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;
	mso-style-name:;
	mso-style-id:0;}
td
	{mso-style-parent:style0;
	padding-top:1px;padding-right:1px;padding-left:1px;mso-ignore:padding;
	font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 21, '.xl21
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 22, '.xl22
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 23, '.xl23
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 24, '.xl24
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 25, '.xl25
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 26, '.xl26
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 27, '.xl27
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 28, '.xl28
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 29, '.xl29
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 30, '.xl30
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 31, '.xl31
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 32, '.xl32
	{mso-style-parent:style0;
	text-align:left;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 33, '.xl33
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 34, '.xl34
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 35, '.xl35
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 36, '.xl36
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 37, '.xl37
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 38, '.xl38
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 39, '.xl39
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 40, '.xl40
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 41, '.xl41
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 42, '.xl42
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 43, '.xl43
	{mso-style-parent:style0;
	font-size:8pt;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 44, '.xl44
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 45, '.xl45
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 46, '.xl46
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 47, '.xl47
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 48, '.xl48
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 49, '.xl49
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 50, '.xl50
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 51, '.xl51
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 52, '.xl52
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 53, '.xl53
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 54, '.xl54
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 55, '.xl55
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 56, '.xl56
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 57, '.xl57
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 58, '.xl58
	{mso-style-parent:style0;
	mso-text-control:shrinktofit;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 59, '.xl59
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 60, '.xl60
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 61, '.xl61
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 62, '.xl62
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 63, '.xl63
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 64, '.xl64
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 65, '.xl65
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 66, '.xl66
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 67, '.xl67
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 68, '.xl68
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 69, '.xl69
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 70, '.xl70
	{mso-style-parent:style0;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 71, '.xl71
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 72, '.xl72
	{mso-style-parent:style0;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 73, '.xl73
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 74, '.xl74
	{mso-style-parent:style0;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 75, '.xl75
	{mso-style-parent:style0;
	font-size:8pt;
	text-decoration:underline;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 76, '.xl76
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 77, '.xl77
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 78, '.xl78
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 79, '.xl79
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 80, '.xl80
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 81, '.xl81
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 82, '.xl82
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 83, '.xl83
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 84, '.xl84
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 85, '.xl85
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 86, '.xl86
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 87, '.xl87
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 88, '.xl88
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 89, '.xl89
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '||list=1|list,poc,st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '||list=2|list,poc,st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n_cons_ngr', 'XL_REPORT_PROP')

GO
		

	CREATE TABLE #T_OBJECT (LINK int, CODE varchar(100), NAME varchar(254), ORDERS int, LINK_SELF int, LINK_CLASS int, CODE_SELF varchar(100), CODE_CLASS varchar(100))



GO
		

	CREATE TABLE #T_GROUPS (GROUP_NAME varchar(250), NAME varchar(254), CODE_OBJ varchar(50), IMAGE_ID int, SQ_CODE varchar(100), GATE_CODE varchar(50), GDIR_CODE varchar(50), STAT int)



GO
		

	EXECUTE M_UPDATE_SQUERY '#T_OBJ','#T_PROP','#T_OBJECT','#T_GROUPS'

	DROP TABLE #T_OBJ
	DROP TABLE #T_PROP
	DROP TABLE #T_OBJECT
	DROP TABLE #T_GROUPS
	exec dtt '#t_xlrep_'

--end squery

GO




-- XL_REPORT-SYS_XL_sqr_rro_34n_kbk.sql

--squery
--KS-1063\katyakov 29.01.2025

--%OBJECT%SYS_XL_sqr_rro_34n_kbk%%
-- : sqr_rro_34n_kbk.xlt

if object_id('tempdb..#T_OBJ') is not null drop table #T_OBJ
if object_id('tempdb..#T_PROP') is not null drop table #T_PROP
if object_id('tempdb..#T_OBJECT') is not null drop table #T_OBJECT
if object_id('tempdb..#T_GROUPS') is not null drop table #T_GROUPS

GO


	CREATE TABLE #T_OBJ (LINK int, NAME varchar(254), OBJECT int, CODE varchar(100), USERS int, ORDERS int, LINK_SELF int, LINK_STATE int, CODE_OBJ varchar(100), CODE_SELF varchar(100), CODE_STATE varchar(100))


	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('sqr_rro_34n_kbk.xlt', 'SYS_XL_sqr_rro_34n_kbk', null, null, 'XL_REPORT', null, null)

GO
		

	CREATE TABLE #T_PROP (LINK_UP int, PROPERTY int, USERS int, ORDERS int, VALUE nvarchar(max), CODE_UP varchar(100), CODE_PROP varchar(100))


	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'katyakov', 'SYS_XL_sqr_rro_34n_kbk', 'SQUERY_AUTHOR')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '2025-01-29 15:36:49.407', 'SYS_XL_sqr_rro_34n_kbk', 'SQUERY_DATETIME')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,'''',1,1,1,1,''xl22'','''',1
1,1,'''',1,1,1,2,''xl22'','''',1
1,1,'''',1,1,1,3,''xl22'','''',1
1,1,'''',1,1,1,4,''xl22'','''',1
1,1,'''',1,1,1,5,''xl22'','''',1
1,1,'''',1,1,1,6,''xl22'','''',1
1,1,'''',1,1,1,7,''xl22'','''',1
1,1,'''',1,1,1,8,''xl22'','''',1
1,1,'''',1,1,1,9,''xl22'','''',1
1,1,'''',1,1,1,10,''xl22'','''',1
1,1,'''',1,1,1,11,''xl22'','''',1
1,1,'''',1,1,1,12,''xl22'','''',1
1,1,'''',1,1,1,13,''xl22'','''',1
1,1,'''',1,1,1,14,''xl22'','''',1
1,1,'''',1,1,1,15,''xl22'','''',1
1,1,'''',1,1,1,16,''xl22'','''',1
1,1,'''',1,1,1,17,''xl22'','''',1
1,1,'''',1,1,1,18,''xl22'','''',1
1,1,'''',1,1,1,19,''xl22'','''',1
1,1,'''',1,1,1,20,''xl22'','''',1
1,1,'''',1,1,1,21,''xl22'','''',1
1,1,'''',1,1,1,22,''xl22'','''',1
1,1,'''',1,1,1,23,''xl22'','''',1
1,1,'''',1,1,1,24,''xl22'','''',1
1,1,'''',1,1,1,25,''xl22'','''',1
1,1,'''',1,1,1,26,''xl87'','''',1
1,1,'''',1,1,1,27,''xl87'','''',1
1,1,'''',1,1,1,28,''xl87'','''',1
1,1,'''',1,1,1,29,''xl87'','''',1
1,1,'''',1,1,1,30,''xl87'','''',1
1,1,'''',1,1,1,31,''xl87'','''',1
1,1,'''',1,1,1,32,''xl87'','''',1
1,1,'''',1,1,1,33,''xl22'','''',1
1,1,'''',1,1,1,34,''xl90'','''',1
1,1,'''',1,1,1,35,''xl90'','''',1
1,1,'''',1,1,1,36,''xl90'','''',1
1,1,'''',1,1,1,37,''xl90'','''',1
1,1,'''',1,1,1,38,''xl23'','''',1
1,1,'''',1,1,1,39,''xl90'','''',1
1,1,'''',1,1,1,40,''xl90'','''',1
1,1,'''',1,1,1,41,''xl90'','''',1
1,1,'''',1,1,1,42,''xl90'','''',1
1,1,'''',1,1,1,43,''xl90'','''',1
1,1,'''',1,1,1,44,''xl90'','''',1
1,1,'''',1,1,1,45,''xl90'','''',1
1,1,'''',1,1,1,46,''xl90'','''',1
1,1,'''',1,1,1,47,''xl90'','''',1
1,1,'''',1,1,1,48,''xl90'','''',1
1,1,'''',1,1,1,49,''xl90'','''',1
1,1,'''',1,1,1,50,''xl90'','''',1
1,1,'''',1,1,1,51,''xl90'','''',1
1,1,''>>"#/"'',1,1,1,52,''xl93'','''',1
1,1,'''',1,1,1,53,''xl22'','''',1
1,1,'''',1,1,2,1,''xl22'','''',1
1,1,'''',1,1,2,2,''xl22'','''',1
1,1,'''',1,1,2,3,''xl22'','''',1
1,1,'''',1,1,2,4,''xl22'','''',1
1,1,'''',1,1,2,5,''xl22'','''',1
1,1,'''',1,1,2,6,''xl22'','''',1
1,1,'''',1,1,2,7,''xl22'','''',1
1,1,'''',1,1,2,8,''xl22'','''',1
1,1,'''',1,1,2,9,''xl22'','''',1
1,1,'''',1,1,2,10,''xl22'','''',1
1,1,'''',1,1,2,11,''xl22'','''',1
1,1,'''',1,1,2,12,''xl22'','''',1
1,1,'''',1,1,2,13,''xl22'','''',1
1,1,'''',1,1,2,14,''xl22'','''',1
1,1,'''',1,1,2,15,''xl22'','''',1
1,1,'''',1,1,2,16,''xl22'','''',1
1,1,'''',1,1,2,17,''xl22'','''',1
1,1,'''',1,1,2,18,''xl22'','''',1
1,1,'''',1,1,2,19,''xl22'','''',1
1,1,'''',1,1,2,20,''xl22'','''',1
1,1,'''',1,1,2,21,''xl22'','''',1
1,1,'''',1,1,2,22,''xl22'','''',1
1,1,'''',1,1,2,23,''xl22'','''',1
1,1,'''',1,1,2,24,''xl22'','''',1
1,1,'''',1,1,2,25,''xl22'','''',1
1,1,'''',1,1,2,26,''xl87'','''',1
1,1,'''',1,1,2,27,''xl87'','''',1
1,1,'''',1,1,2,28,''xl87'','''',1
1,1,'''',1,1,2,29,''xl87'','''',1
1,1,'''',1,1,2,30,''xl87'','''',1
1,1,'''',1,1,2,31,''xl87'','''',1
1,1,'''',1,1,2,32,''xl87'','''',1
1,1,'''',1,1,2,33,''xl22'','''',1
1,1,'''',1,1,2,34,''xl90'','''',1
1,1,'''',1,1,2,35,''xl90'','''',1
1,1,'''',1,1,2,36,''xl90'','''',1
1,1,'''',1,1,2,37,''xl90'','''',1
1,1,'''',1,1,2,38,''xl23'','''',1
1,1,'''',1,1,2,39,''xl90'','''',1
1,1,'''',1,1,2,40,''xl90'','''',1
1,1,'''',1,1,2,41,''xl90'','''',1
1,1,'''',1,1,2,42,''xl90'','''',1
1,1,'''',1,1,2,43,''xl90'','''',1
1,1,'''',1,1,2,44,''xl90'','''',1
1,1,'''',1,1,2,45,''xl90'','''',1
1,1,'''',1,1,2,46,''xl90'','''',1
1,1,'''',1,1,2,47,''xl90'','''',1
1,1,'''',1,1,2,48,''xl90'','''',1
1,1,'''',1,1,2,49,''xl90'','''',1
1,1,'''',1,1,2,50,''xl90'','''',1
1,1,'''',1,1,2,51,''xl90'','''',1
1,1,'''',1,1,2,52,''xl22'','''',1
1,1,'''',1,1,2,53,''xl22'','''',1
1,1,''     '',1,24,3,1,''xl85'','''',1
1,1,'''',1,1,3,25,''xl87'','''',1
1,1,'''',1,1,3,26,''xl80'','''',1
1,1,'''',1,1,3,27,''xl80'','''',1
1,1,'''',1,1,3,28,''xl80'','''',1
1,1,'''',1,1,3,29,''xl80'','''',1
1,1,'''',1,1,3,30,''xl80'','''',1
1,1,'''',1,1,3,31,''xl80'','''',1
1,1,'''',1,1,3,32,''xl80'','''',1
1,1,'''',1,1,3,33,''xl22'','''',1
1,1,'''',1,1,3,34,''xl90'','''',1
1,1,'''',1,1,3,35,''xl90'','''',1
1,1,'''',1,1,3,36,''xl90'','''',1
1,1,'''',1,1,3,37,''xl90'','''',1
1,1,'''',1,1,3,38,''xl23'','''',1
1,1,'''',1,1,3,39,''xl90'','''',1
1,1,'''',1,1,3,40,''xl90'','''',1
1,1,'''',1,1,3,41,''xl90'','''',1
1,1,'''',1,1,3,42,''xl90'','''',1
1,1,'''',1,1,3,43,''xl90'','''',1
1,1,'''',1,1,3,44,''xl90'','''',1
1,1,'''',1,1,3,45,''xl90'','''',1
1,1,'''',1,1,3,46,''xl90'','''',1
1,1,'''',1,1,3,47,''xl90'','''',1
1,1,'''',1,1,3,48,''xl90'','''',1
1,1,'''',1,1,3,49,''xl90'','''',1
1,1,'''',1,1,3,50,''xl90'','''',1
1,1,'''',1,1,3,51,''xl90'','''',1
1,1,'''',1,1,3,52,''xl22'','''',1
1,1,'''',1,1,3,53,''xl22'','''',1
1,1,''>>" "&(dDate_2+1;0)&"."'',1,24,4,1,''xl47'','''',1
1,1,'''',1,1,4,25,''xl47'','''',1
1,1,'''',1,1,4,26,''xl47'','''',1
1,1,'''',1,1,4,27,''xl47'','''',1
1,1,'''',1,1,4,28,''xl47'','''',1
1,1,'''',1,1,4,29,''xl47'','''',1
1,1,'''',1,1,4,30,''xl47'','''',1
1,1,'''',1,1,4,31,''xl47'','''',1
1,1,'''',1,1,4,32,''xl47'','''',1
1,1,'''',1,1,4,33,''xl22'','''',1
1,1,'''',1,1,4,34,''xl90'','''',1
1,1,'''',1,1,4,35,''xl90'','''',1
1,1,'''',1,1,4,36,''xl90'','''',1
1,1,'''',1,1,4,37,''xl90'','''',1
1,1,'''',1,1,4,38,''xl23'','''',1
1,1,'''',1,1,4,39,''xl90'','''',1
1,1,'''',1,1,4,40,''xl90'','''',1
1,1,'''',1,1,4,41,''xl90'','''',1
1,1,'''',1,1,4,42,''xl90'','''',1
1,1,'''',1,1,4,43,''xl90'','''',1
1,1,'''',1,1,4,44,''xl90'','''',1
1,1,'''',1,1,4,45,''xl90'','''',1
1,1,'''',1,1,4,46,''xl90'','''',1
1,1,'''',1,1,4,47,''xl90'','''',1
1,1,'''',1,1,4,48,''xl90'','''',1
1,1,'''',1,1,4,49,''xl90'','''',1
1,1,'''',1,1,4,50,''xl90'','''',1
1,1,'''',1,1,4,51,''xl90'','''',1
1,1,'''',1,1,4,52,''xl22'','''',1
1,1,'''',1,1,4,53,''xl22'','''',1
1,1,'''',1,1,5,1,''xl22'','''',1
1,1,'''',1,1,5,2,''xl22'','''',1
1,1,'''',1,1,5,3,''xl22'','''',1
1,1,'''',1,1,5,4,''xl22'','''',1
1,1,'''',1,1,5,5,''xl22'','''',1
1,1,'''',1,1,5,6,''xl22'','''',1
1,1,'''',1,1,5,7,''xl22'','''',1
1,1,'''',1,1,5,8,''xl41'','''',1
1,1,'''',1,1,5,9,''xl41'','''',1
1,1,'''',1,1,5,10,''xl41'','''',1
1,1,'''',1,1,5,11,''xl32'','''',1
1,1,'''',1,1,5,12,''xl32'','''',1
1,1,'''',1,1,5,13,''xl32'','''',1
1,1,'''',1,1,5,14,''xl41'','''',1
1,1,'''',1,1,5,15,''xl41'','''',1
1,1,'''',1,1,5,16,''xl41'','''',1
1,1,'''',1,1,5,17,''xl41'','''',1
1,1,'''',1,1,5,18,''xl41'','''',1
1,1,'''',1,1,5,19,''xl41'','''',1
1,1,'''',1,1,5,20,''xl80'','''',1
1,1,'''',1,1,5,21,''xl80'','''',1
1,1,'''',1,1,5,22,''xl80'','''',1
1,1,'''',1,1,5,23,''xl80'','''',1
1,1,'''',1,1,5,24,''xl41'','''',1
1,1,'''',1,1,5,25,''xl41'','''',1
1,1,'''',1,1,5,26,''xl41'','''',1
1,1,'''',1,1,5,27,''xl41'','''',1
1,1,'''',1,1,5,28,''xl41'','''',1
1,1,'''',1,1,5,29,''xl41'','''',1
1,1,'''',1,1,5,30,''xl41'','''',1
1,1,'''',1,1,5,31,''xl41'','''',1
1,1,'''',1,1,5,32,''xl41'','''',1
1,1,'''',1,1,5,33,''xl22'','''',1
1,1,'''',1,1,5,34,''xl90'','''',1
1,1,'''',1,1,5,35,''xl90'','''',1
1,1,'''',1,1,5,36,''xl90'','''',1
1,1,'''',1,1,5,37,''xl90'','''',1
1,1,'''',1,1,5,38,''xl23'','''',1
1,1,'''',1,1,5,39,''xl90'','''',1
1,1,'''',1,1,5,40,''xl90'','''',1
1,1,'''',1,1,5,41,''xl90'','''',1
1,1,'''',1,1,5,42,''xl90'','''',1
1,1,'''',1,1,5,43,''xl90'','''',1
1,1,'''',1,1,5,44,''xl90'','''',1
1,1,'''',1,1,5,45,''xl90'','''',1
1,1,'''',1,1,5,46,''xl90'','''',1
1,1,'''',1,1,5,47,''xl90'','''',1
1,1,'''',1,1,5,48,''xl90'','''',1
1,1,'''',1,1,5,49,''xl90'','''',1
1,1,'''',1,1,5,50,''xl90'','''',1
1,1,'''',1,1,5,51,''xl90'','''',1
1,1,'''',1,1,5,52,''xl22'','''',1
1,1,'''',1,1,5,53,''xl22'','''',1
1,1,''        '',1,1,6,1,''xl23'','''',1
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,''$$select name from c_data1 where list=1#name#name#NN'',1,25,6,2,''xl88'','''',1
1,1,'''',1,1,6,27,''xl41'','''',1
1,1,'''',1,1,6,28,''xl41'','''',1
1,1,'''',1,1,6,29,''xl41'','''',1
1,1,'''',1,1,6,30,''xl41'','''',1
1,1,'''',1,1,6,31,''xl41'','''',1
1,1,'''',1,1,6,32,''xl41'','''',1
1,1,'''',1,1,6,33,''xl22'','''',1
1,1,'''',1,1,6,34,''xl90'','''',1
1,1,'''',1,1,6,35,''xl90'','''',1
1,1,'''',1,1,6,36,''xl90'','''',1
1,1,'''',1,1,6,37,''xl90'','''',1
1,1,'''',1,1,6,38,''xl23'','''',1
1,1,'''',1,1,6,39,''xl90'','''',1
1,1,'''',1,1,6,40,''xl90'','''',1
1,1,'''',1,1,6,41,''xl90'','''',1
1,1,'''',1,1,6,42,''xl90'','''',1
1,1,'''',1,1,6,43,''xl90'','''',1
1,1,'''',1,1,6,44,''xl90'','''',1
1,1,'''',1,1,6,45,''xl90'','''',1
1,1,'''',1,1,6,46,''xl90'','''',1
1,1,'''',1,1,6,47,''xl90'','''',1
1,1,'''',1,1,6,48,''xl90'','''',1
1,1,'''',1,1,6,49,''xl90'','''',1
1,1,'''',1,1,6,50,''xl90'','''',1
1,1,'''',1,1,6,51,''xl90'','''',1
1,1,'''',1,1,6,52,''xl22'','''',1
1,1,'''',1,1,6,53,''xl22'','''',1
1,1,''  '',1,1,7,1,''xl23'','''',1
1,1,''$$select name from c_data2#name#name#NN'',1,25,7,2,''xl88'','''',1
1,1,'''',1,1,7,27,''xl41'','''',1
1,1,'''',1,1,7,28,''xl41'','''',1
1,1,'''',1,1,7,29,''xl41'','''',1
1,1,'''',1,1,7,30,''xl41'','''',1
1,1,'''',1,1,7,31,''xl41'','''',1
1,1,'''',1,1,7,32,''xl41'','''',1
1,1,'''',1,1,7,33,''xl41'','''',1
1,1,'''',1,1,7,34,''xl41'','''',1
1,1,'''',1,1,7,35,''xl41'','''',1
1,1,'''',1,1,7,36,''xl41'','''',1
1,1,'''',1,1,7,37,''xl41'','''',1
1,1,'''',1,1,7,38,''xl23'','''',1
1,1,'''',1,1,7,39,''xl41'','''',1
1,1,'''',1,1,7,40,''xl41'','''',1
1,1,'''',1,1,7,41,''xl41'','''',1
1,1,'''',1,1,7,42,''xl41'','''',1
1,1,'''',1,1,7,43,''xl41'','''',1
1,1,'''',1,1,7,44,''xl41'','''',1
1,1,'''',1,1,7,45,''xl41'','''',1
1,1,'''',1,1,7,46,''xl41'','''',1
1,1,'''',1,1,7,47,''xl41'','''',1
1,1,'''',1,1,7,48,''xl41'','''',1
1,1,'''',1,1,7,49,''xl41'','''',1
1,1,'''',1,1,7,50,''xl41'','''',1
1,1,'''',1,1,7,51,''xl41'','''',1
1,1,'''',1,1,7,52,''xl22'','''',1
1,1,'''',1,1,7,53,''xl22'','''',1
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,26,8,1,''xl89'','''',1
1,1,'''',1,1,8,27,''xl41'','''',1
1,1,'''',1,1,8,28,''xl41'','''',1
1,1,'''',1,1,8,29,''xl41'','''',1
1,1,'''',1,1,8,30,''xl41'','''',1
1,1,'''',1,1,8,31,''xl41'','''',1
1,1,'''',1,1,8,32,''xl41'','''',1
1,1,'''',1,1,8,33,''xl41'','''',1
1,1,'''',1,1,8,34,''xl41'','''',1
1,1,'''',1,1,8,35,''xl41'','''',1
1,1,'''',1,1,8,36,''xl41'','''',1
1,1,'''',1,1,8,37,''xl41'','''',1
1,1,'''',1,1,8,38,''xl41'','''',1
1,1,'''',1,1,8,39,''xl41'','''',1
1,1,'''',1,1,8,40,''xl41'','''',1
1,1,'''',1,1,8,41,''xl41'','''',1
1,1,'''',1,1,8,42,''xl41'','''',1
1,1,'''',1,1,8,43,''xl41'','''',1
1,1,'''',1,1,8,44,''xl41'','''',1
1,1,'''',1,1,8,45,''xl41'','''',1
1,1,'''',1,1,8,46,''xl41'','''',1
1,1,'''',1,1,8,47,''xl41'','''',1
1,1,'''',1,1,8,48,''xl41'','''',1
1,1,'''',1,1,8,49,''xl41'','''',1
1,1,'''',1,1,8,50,''xl41'','''',1
1,1,'''',1,1,8,51,''xl41'','''',1
1,1,'''',1,1,8,52,''xl22'','''',1
1,1,'''',1,1,8,53,''xl22'','''',1
1,1,'''',1,1,9,1,''xl23'','''',1
1,1,'''',1,1,9,2,''xl32'','''',1
1,1,'''',1,1,9,3,''xl41'','''',1
1,1,'''',1,1,9,4,''xl41'','''',1
1,1,'''',1,1,9,5,''xl41'','''',1
1,1,'''',1,1,9,6,''xl41'','''',1
1,1,'''',1,1,9,7,''xl41'','''',1
1,1,'''',1,1,9,8,''xl41'','''',1
1,1,'''',1,1,9,9,''xl41'','''',1
1,1,'''',1,1,9,10,''xl41'','''',1
1,1,'''',1,1,9,11,''xl32'','''',1
1,1,'''',1,1,9,12,''xl32'','''',1
1,1,'''',1,1,9,13,''xl32'','''',1
1,1,'''',1,1,9,14,''xl41'','''',1
1,1,'''',1,1,9,15,''xl41'','''',1
1,1,'''',1,1,9,16,''xl41'','''',1
1,1,'''',1,1,9,17,''xl41'','''',1
1,1,'''',1,1,9,18,''xl41'','''',1
1,1,'''',1,1,9,19,''xl41'','''',1
1,1,'''',1,1,9,20,''xl41'','''',1
1,1,'''',1,1,9,21,''xl41'','''',1
1,1,'''',1,1,9,22,''xl41'','''',1
1,1,'''',1,1,9,23,''xl41'','''',1
1,1,'''',1,1,9,24,''xl41'','''',1
1,1,'''',1,1,9,25,''xl41'','''',1
1,1,'''',1,1,9,26,''xl41'','''',1
1,1,'''',1,1,9,27,''xl41'','''',1
1,1,'''',1,1,9,28,''xl41'','''',1
1,1,'''',1,1,9,29,''xl41'','''',1
1,1,'''',1,1,9,30,''xl41'','''',1
1,1,'''',1,1,9,31,''xl41'','''',1
1,1,'''',1,1,9,32,''xl41'','''',1
1,1,'''',1,1,9,33,''xl41'','''',1
1,1,'''',1,1,9,34,''xl41'','''',1
1,1,'''',1,1,9,35,''xl41'','''',1
1,1,'''',1,1,9,36,''xl41'','''',1
1,1,'''',1,1,9,37,''xl41'','''',1
1,1,'''',1,1,9,38,''xl41'','''',1
1,1,'''',1,1,9,39,''xl41'','''',1
1,1,'''',1,1,9,40,''xl41'','''',1
1,1,'''',1,1,9,41,''xl41'','''',1
1,1,'''',1,1,9,42,''xl41'','''',1
1,1,'''',1,1,9,43,''xl41'','''',1
1,1,'''',1,1,9,44,''xl41'','''',1
1,1,'''',1,1,9,45,''xl41'','''',1
1,1,'''',1,1,9,46,''xl41'','''',1
1,1,'''',1,1,9,47,''xl41'','''',1
1,1,'''',1,1,9,48,''xl41'','''',1
1,1,'''',1,1,9,49,''xl41'','''',1
1,1,'''',1,1,9,50,''xl41'','''',1
1,1,'''',1,1,9,51,''xl41'','''',1
1,1,'''',1,1,9,52,''xl22'','''',1
1,1,'''',1,1,9,53,''xl22'','''',1
1,1,''>>>" , chr(10)  "&cText_35'',10,1,10,1,''xl24'','''',1
1,1,'' '',10,1,10,2,''xl33'','''',1
1,1,''>>>"    ,   "&cText_35'',2,7,10,3,''xl56'','''',1
1,1,''  ,  '',10,1,10,10,''xl59'','''',1
1,1,''    '',4,4,10,11,''xl68'','''',1
1,1,''>>>"      "&cText_35'',3,12,10,15,''xl75'','''',1
1,1,''>>>" ..       "&cText_35&"           () "'',3,12,10,27,''xl75'','''',1
1,1,''>>>"    () "&cText_35'',3,6,10,39,''xl75'','''',1
1,1,''>>>" ..     () "&cText_35&"           () "'',3,6,10,45,''xl75'','''',1
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,10,51,''xl91'','''',1
1,1,'''',1,1,10,52,''xl94'','''',1
1,1,'''',1,1,10,53,''xl94'','''',1
1,1,'''',1,1,11,52,''xl94'','''',1
1,1,'''',1,1,11,53,''xl94'','''',1
1,1,'' '',1,4,12,3,''xl51'','''',1
1,1,''>>>cText_35'',1,3,12,7,''xl51'','''',1
1,1,'''',1,1,12,52,''xl94'','''',1
1,1,'''',1,1,12,53,''xl94'','''',1
1,1,''&&select orders,name from c_data3 order by orders#name#orders#AA'',1,4,13,3,''xl51'','''',1
1,1,''&&select orders,name from c_data4 order by orders#name#orders#AA'',1,3,13,7,''xl51'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,15,''xl75'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,19,''xl75'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,21,''xl75'','''',1
1,1,'' '',1,4,13,23,''xl75'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,27,''xl75'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,31,''xl75'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,33,''xl75'','''',1
1,1,'' '',1,4,13,35,''xl75'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,39,''xl75'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,41,''xl75'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,43,''xl75'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,45,''xl75'','''',1
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,47,''xl75'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,49,''xl75'','''',1
1,1,'''',1,1,13,52,''xl94'','''',1
1,1,'''',1,1,13,53,''xl94'','''',1
1,1,'',   '',6,1,14,3,''xl42'','''',1
1,1,''&&select vip from c_data3 where orders=AA#vip#vip#CC'',6,1,14,4,''xl48'','''',1
1,1,''   ,  '',6,1,14,5,''xl49'','''',1
1,1,''&&select code from c_data3 where orders=AA#code#code#CC'',6,1,14,6,''xl52'','''',1
1,1,'',   '',6,1,14,7,''xl53'','''',1
1,1,''&&select vip from c_data4 where orders=AA#vip#vip#CC'',6,1,14,8,''xl54'','''',1
1,1,''   ,  '',6,1,14,9,''xl57'','''',1
1,1,''>>>(nCheck_34=1;"/";"#/")'',6,1,14,11,''xl61'','''',1
1,1,''>>>(nCheck_19=1;" ";"#/")'',6,1,14,12,''xl66'','''',1
1,1,''>>>(nCheck_20=1;" ";"#/")'',6,1,14,13,''xl67'','''',1
1,1,''>>>(nCheck_21=1;"";"#/")'',6,1,14,14,''xl69'','''',1
1,1,'''',1,2,14,15,''xl75'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,17,''xl75'','''',1
1,1,'''',6,1,14,19,''xl79'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,20,''xl81'','''',1
1,1,'''',6,1,14,21,''xl82'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,22,''xl83'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,23,''xl86'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,25,''xl86'','''',1
1,1,'''',1,2,14,27,''xl75'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,29,''xl75'','''',1
1,1,'''',6,1,14,31,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,32,''xl84'','''',1
1,1,'''',6,1,14,33,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,34,''xl84'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,35,''xl86'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,37,''xl86'','''',1
1,1,'''',6,1,14,39,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,40,''xl84'','''',1
1,1,'''',6,1,14,41,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,42,''xl84'','''',1
1,1,'''',6,1,14,43,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,44,''xl84'','''',1
1,1,'''',6,1,14,45,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,46,''xl84'','''',1
1,1,'''',6,1,14,47,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,48,''xl84'','''',1
1,1,'''',6,1,14,49,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,50,''xl84'','''',1
1,1,'''',1,1,14,52,''xl94'','''',1
1,1,'''',1,1,14,53,''xl94'','''',1
1,1,''  '',5,1,15,15,''xl71'','''',1
1,1,'''',5,1,15,16,''xl76'','''',1
1,1,''  '',5,1,15,17,''xl77'','''',1
1,1,'''',5,1,15,18,''xl78'','''',1
1,1,'''',5,1,15,23,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,24,''xl84'','''',1
1,1,'''',5,1,15,25,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,26,''xl84'','''',1
1,1,''  '',5,1,15,27,''xl84'','''',1
1,1,'''',5,1,15,28,''xl84'','''',1
1,1,''  '',5,1,15,29,''xl84'','''',1
1,1,'''',5,1,15,30,''xl84'','''',1
1,1,'''',5,1,15,35,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,36,''xl84'','''',1
1,1,'''',5,1,15,37,''xl84'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,38,''xl84'','''',1
1,1,'''',1,1,15,52,''xl94'','''',1
1,1,'''',1,1,15,53,''xl94'','''',1
1,1,'''',1,1,16,52,''xl94'','''',1
1,1,'''',1,1,16,53,''xl94'','''',1
1,1,'''',1,1,17,52,''xl94'','''',1
1,1,'''',1,1,17,53,''xl94'','''',1
1,1,'''',1,1,18,52,''xl94'','''',1
1,1,'''',1,1,18,53,''xl94'','''',1
1,1,'''',1,1,19,52,''xl94'','''',1
1,1,'''',1,1,19,53,''xl94'','''',1
1,2,''>>>"   "&cText_35'',1,1,1,1,''xl29'','''',1
1,2,''8000'',1,1,1,2,''xl38'','''',1
1,2,'''',1,1,1,3,''xl46'','''',1
1,2,'''',1,1,1,4,''xl46'','''',1
1,2,'''',1,1,1,5,''xl46'','''',1
1,2,'''',1,1,1,6,''xl46'','''',1
1,2,'''',1,1,1,7,''xl46'','''',1
1,2,'''',1,1,1,8,''xl46'','''',1
1,2,'''',1,1,1,9,''xl46'','''',1
1,2,'''',1,1,1,10,''xl46'','''',1
1,2,'''',1,1,1,11,''xl46'','''',1
1,2,'''',1,1,1,12,''xl46'','''',1
1,2,'''',1,1,1,13,''xl46'','''',1
1,2,'''',1,1,1,14,''xl46'','''',1
1,2,''>>(<list>;1;<s_1>)'',1,1,1,15,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_2>)'',1,1,1,16,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_1>)'',1,1,1,17,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_2>)'',1,1,1,18,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_3>)'',1,1,1,19,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_3>)'',1,1,1,20,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_4>)'',1,1,1,21,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_4>)'',1,1,1,22,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_5>)'',1,1,1,23,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_5>)'',1,1,1,24,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_6>)'',1,1,1,25,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_6>)'',1,1,1,26,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_1>)'',1,1,1,27,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_2>)'',1,1,1,28,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_1>)'',1,1,1,29,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_2>)'',1,1,1,30,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_3>)'',1,1,1,31,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_3>)'',1,1,1,32,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_4>)'',1,1,1,33,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_4>)'',1,1,1,34,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_5>)'',1,1,1,35,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_5>)'',1,1,1,36,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_6>)'',1,1,1,37,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_6>)'',1,1,1,38,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_7>)'',1,1,1,39,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_7>)'',1,1,1,40,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_8>)'',1,1,1,41,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_8>)'',1,1,1,42,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_9>)'',1,1,1,43,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_9>)'',1,1,1,44,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_7>)'',1,1,1,45,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_7>)'',1,1,1,46,''xl74'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_8>)'',1,1,1,47,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_8>)'',1,1,1,48,''xl74'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '1,2,''>>(<list>;1;<k_9>)'',1,1,1,49,''xl74'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_9>)'',1,1,1,50,''xl74'',''"#,##0.00"'',1
1,2,'''',1,1,1,51,''xl92'','''',1
1,2,'''',1,1,1,52,''xl22'','''',1
1,2,'''',1,1,1,53,''xl22'','''',1
1,2,'''',1,1,2,1,''xl30'','''',1
1,2,'''',1,1,2,2,''xl39'','''',1
1,2,'''',1,1,2,3,''xl47'','''',1
1,2,'''',1,1,2,4,''xl47'','''',1
1,2,'''',1,1,2,5,''xl47'','''',1
1,2,'''',1,1,2,6,''xl47'','''',1
1,2,'''',1,1,2,7,''xl47'','''',1
1,2,'''',1,1,2,8,''xl47'','''',1
1,2,'''',1,1,2,9,''xl47'','''',1
1,2,'''',1,1,2,10,''xl47'','''',1
1,2,'''',1,1,2,11,''xl39'','''',1
1,2,'''',1,1,2,12,''xl39'','''',1
1,2,'''',1,1,2,13,''xl39'','''',1
1,2,'''',1,1,2,14,''xl65'','''',1
1,2,'''',1,1,2,15,''xl65'','''',1
1,2,'''',1,1,2,16,''xl65'','''',1
1,2,'''',1,1,2,17,''xl65'','''',1
1,2,'''',1,1,2,18,''xl65'','''',1
1,2,'''',1,1,2,19,''xl65'','''',1
1,2,'''',1,1,2,20,''xl65'','''',1
1,2,'''',1,1,2,21,''xl65'','''',1
1,2,'''',1,1,2,22,''xl65'','''',1
1,2,'''',1,1,2,23,''xl65'','''',1
1,2,'''',1,1,2,24,''xl65'','''',1
1,2,'''',1,1,2,25,''xl65'','''',1
1,2,'''',1,1,2,26,''xl65'','''',1
1,2,'''',1,1,2,27,''xl65'','''',1
1,2,'''',1,1,2,28,''xl65'','''',1
1,2,'''',1,1,2,29,''xl65'','''',1
1,2,'''',1,1,2,30,''xl65'','''',1
1,2,'''',1,1,2,31,''xl65'','''',1
1,2,'''',1,1,2,32,''xl65'','''',1
1,2,'''',1,1,2,33,''xl65'','''',1
1,2,'''',1,1,2,34,''xl65'','''',1
1,2,'''',1,1,2,35,''xl65'','''',1
1,2,'''',1,1,2,36,''xl65'','''',1
1,2,'''',1,1,2,37,''xl65'','''',1
1,2,'''',1,1,2,38,''xl65'','''',1
1,2,'''',1,1,2,39,''xl65'','''',1
1,2,'''',1,1,2,40,''xl65'','''',1
1,2,'''',1,1,2,41,''xl65'','''',1
1,2,'''',1,1,2,42,''xl65'','''',1
1,2,'''',1,1,2,43,''xl65'','''',1
1,2,'''',1,1,2,44,''xl65'','''',1
1,2,'''',1,1,2,45,''xl65'','''',1
1,2,'''',1,1,2,46,''xl65'','''',1
1,2,'''',1,1,2,47,''xl65'','''',1
1,2,'''',1,1,2,48,''xl65'','''',1
1,2,'''',1,1,2,49,''xl65'','''',1
1,2,'''',1,1,2,50,''xl65'','''',1
1,2,'''',1,1,2,51,''xl65'','''',1
1,2,'''',1,1,2,52,''xl22'','''',1
1,2,'''',1,1,2,53,''xl22'','''',1
1,2,''>>>Footer'',1,51,3,1,''xl31'','''',1
1,2,'''',1,1,3,52,''xl22'','''',1
1,2,'''',1,1,3,53,''xl22'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl25'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,3,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,4,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,5,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)"&("CC"="#/";"";"+1")'',1,1,1,6,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,7,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,8,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,9,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,10,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,4,1,11,''xl70'','''',1
2,1,''>>"=("&(34)&"R[0]C[-4]"&(34)&";)+1"'',1,1,1,15,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,16,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,17,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,18,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,19,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,20,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,21,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,22,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,23,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,24,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,25,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,26,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,27,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,28,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,29,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,30,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,31,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,32,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,33,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,34,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,35,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,36,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,37,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,38,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,39,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,40,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,41,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,42,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,43,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,44,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,45,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,46,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,47,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,48,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,49,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,50,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,51,''xl25'','''',1
2,1,'''',1,1,1,52,''xl22'','''',1
2,1,'''',1,1,1,53,''xl22'','''',1
3,1,''>>>{po5_n}'',1,1,1,1,''xl27'','''',1
3,1,''>>>{cpo5}'',1,1,1,2,''xl34'','''',1
3,1,'''',1,1,1,3,''xl43'','''',1
3,1,'''',1,1,1,4,''xl43'','''',1
3,1,'''',1,1,1,5,''xl43'','''',1
3,1,'''',1,1,1,6,''xl43'','''',1
3,1,'''',1,1,1,7,''xl43'','''',1
3,1,'''',1,1,1,8,''xl43'','''',1
3,1,'''',1,1,1,9,''xl43'','''',1
3,1,'''',1,1,1,10,''xl43'','''',1
3,1,'''',1,1,1,11,''xl43'','''',1
3,1,'''',1,1,1,12,''xl43'','''',1
3,1,'''',1,1,1,13,''xl43'','''',1
3,1,'''',1,1,1,14,''xl43'','''',1
3,1,''>>(<s_1>)'',1,1,1,15,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_2>)'',1,1,1,16,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_3>)'',1,1,1,19,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_4>)'',1,1,1,21,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_5>)'',1,1,1,23,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_6>)'',1,1,1,25,''xl72'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '3,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_1>)'',1,1,1,27,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_2>)'',1,1,1,28,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_3>)'',1,1,1,31,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_4>)'',1,1,1,33,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_5>)'',1,1,1,35,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_6>)'',1,1,1,37,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_7>)'',1,1,1,39,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_8>)'',1,1,1,41,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl72'',''"#,##0.00"'',1
3,1,''>>(<s_9>)'',1,1,1,43,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_7>)'',1,1,1,45,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_8>)'',1,1,1,47,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl72'',''"#,##0.00"'',1
3,1,''>>(<k_9>)'',1,1,1,49,''xl72'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl72'',''"#,##0.00"'',1
3,1,'''',1,1,1,51,''xl43'','''',1
3,1,'''',1,1,1,52,''xl22'','''',1
3,1,'''',1,1,1,53,''xl22'','''',1
4,1,''>>>{po4_n}'',1,1,1,1,''xl27'','''',1
4,1,''>>>{cpo4}'',1,1,1,2,''xl34'','''',1
4,1,'''',1,1,1,3,''xl43'','''',1
4,1,'''',1,1,1,4,''xl43'','''',1
4,1,'''',1,1,1,5,''xl43'','''',1
4,1,'''',1,1,1,6,''xl43'','''',1
4,1,'''',1,1,1,7,''xl43'','''',1
4,1,'''',1,1,1,8,''xl43'','''',1
4,1,'''',1,1,1,9,''xl43'','''',1
4,1,'''',1,1,1,10,''xl43'','''',1
4,1,'''',1,1,1,11,''xl43'','''',1
4,1,'''',1,1,1,12,''xl43'','''',1
4,1,'''',1,1,1,13,''xl43'','''',1
4,1,'''',1,1,1,14,''xl43'','''',1
4,1,''>>(<s_1>)'',1,1,1,15,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_2>)'',1,1,1,16,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_3>)'',1,1,1,19,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_4>)'',1,1,1,21,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_5>)'',1,1,1,23,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_6>)'',1,1,1,25,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_1>)'',1,1,1,27,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_2>)'',1,1,1,28,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_3>)'',1,1,1,31,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_4>)'',1,1,1,33,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_5>)'',1,1,1,35,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_6>)'',1,1,1,37,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_7>)'',1,1,1,39,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_8>)'',1,1,1,41,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl72'',''"#,##0.00"'',1
4,1,''>>(<s_9>)'',1,1,1,43,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_7>)'',1,1,1,45,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_8>)'',1,1,1,47,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl72'',''"#,##0.00"'',1
4,1,''>>(<k_9>)'',1,1,1,49,''xl72'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl72'',''"#,##0.00"'',1
4,1,'''',1,1,1,51,''xl43'','''',1
4,1,'''',1,1,1,52,''xl22'','''',1
4,1,'''',1,1,1,53,''xl22'','''',1
5,1,''>>>{po3_n}'',1,1,1,1,''xl27'','''',1
5,1,''>>>{cpo3}'',1,1,1,2,''xl34'','''',1
5,1,'''',1,1,1,3,''xl43'','''',1
5,1,'''',1,1,1,4,''xl43'','''',1
5,1,'''',1,1,1,5,''xl43'','''',1
5,1,'''',1,1,1,6,''xl43'','''',1
5,1,'''',1,1,1,7,''xl43'','''',1
5,1,'''',1,1,1,8,''xl43'','''',1
5,1,'''',1,1,1,9,''xl43'','''',1
5,1,'''',1,1,1,10,''xl43'','''',1
5,1,'''',1,1,1,11,''xl43'','''',1
5,1,'''',1,1,1,12,''xl43'','''',1
5,1,'''',1,1,1,13,''xl43'','''',1
5,1,'''',1,1,1,14,''xl43'','''',1
5,1,''>>(<s_1>)'',1,1,1,15,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_2>)'',1,1,1,16,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_3>)'',1,1,1,19,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_4>)'',1,1,1,21,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_5>)'',1,1,1,23,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_6>)'',1,1,1,25,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_1>)'',1,1,1,27,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_2>)'',1,1,1,28,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_3>)'',1,1,1,31,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_4>)'',1,1,1,33,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_5>)'',1,1,1,35,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_6>)'',1,1,1,37,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_7>)'',1,1,1,39,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_8>)'',1,1,1,41,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl72'',''"#,##0.00"'',1
5,1,''>>(<s_9>)'',1,1,1,43,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_7>)'',1,1,1,45,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_8>)'',1,1,1,47,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl72'',''"#,##0.00"'',1
5,1,''>>(<k_9>)'',1,1,1,49,''xl72'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl72'',''"#,##0.00"'',1
5,1,'''',1,1,1,51,''xl43'','''',1
5,1,'''',1,1,1,52,''xl22'','''',1
5,1,'''',1,1,1,53,''xl22'','''',1
6,1,''>>>{po2_n}'',1,1,1,1,''xl27'','''',1
6,1,''>>>{cpo2}'',1,1,1,2,''xl34'','''',1
6,1,'''',1,1,1,3,''xl43'','''',1
6,1,'''',1,1,1,4,''xl43'','''',1
6,1,'''',1,1,1,5,''xl43'','''',1
6,1,'''',1,1,1,6,''xl43'','''',1
6,1,'''',1,1,1,7,''xl43'','''',1
6,1,'''',1,1,1,8,''xl43'','''',1
6,1,'''',1,1,1,9,''xl43'','''',1
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '6,1,'''',1,1,1,10,''xl43'','''',1
6,1,'''',1,1,1,11,''xl43'','''',1
6,1,'''',1,1,1,12,''xl43'','''',1
6,1,'''',1,1,1,13,''xl43'','''',1
6,1,'''',1,1,1,14,''xl43'','''',1
6,1,''>>(<s_1>)'',1,1,1,15,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_2>)'',1,1,1,16,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_3>)'',1,1,1,19,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_4>)'',1,1,1,21,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_5>)'',1,1,1,23,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_6>)'',1,1,1,25,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_1>)'',1,1,1,27,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_2>)'',1,1,1,28,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_3>)'',1,1,1,31,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_4>)'',1,1,1,33,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_5>)'',1,1,1,35,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_6>)'',1,1,1,37,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_7>)'',1,1,1,39,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_8>)'',1,1,1,41,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl72'',''"#,##0.00"'',1
6,1,''>>(<s_9>)'',1,1,1,43,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_7>)'',1,1,1,45,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_8>)'',1,1,1,47,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl72'',''"#,##0.00"'',1
6,1,''>>(<k_9>)'',1,1,1,49,''xl72'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl72'',''"#,##0.00"'',1
6,1,'''',1,1,1,51,''xl43'','''',1
6,1,'''',1,1,1,52,''xl22'','''',1
6,1,'''',1,1,1,53,''xl22'','''',1
7,1,''>>>{po1_n}'',1,1,1,1,''xl27'','''',1
7,1,''>>>{cpo1}'',1,1,1,2,''xl34'','''',1
7,1,'''',1,1,1,3,''xl43'','''',1
7,1,'''',1,1,1,4,''xl43'','''',1
7,1,'''',1,1,1,5,''xl43'','''',1
7,1,'''',1,1,1,6,''xl43'','''',1
7,1,'''',1,1,1,7,''xl43'','''',1
7,1,'''',1,1,1,8,''xl43'','''',1
7,1,'''',1,1,1,9,''xl43'','''',1
7,1,'''',1,1,1,10,''xl43'','''',1
7,1,'''',1,1,1,11,''xl43'','''',1
7,1,'''',1,1,1,12,''xl43'','''',1
7,1,'''',1,1,1,13,''xl43'','''',1
7,1,'''',1,1,1,14,''xl43'','''',1
7,1,''>>(<s_1>)'',1,1,1,15,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_2>)'',1,1,1,16,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_3>)'',1,1,1,19,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_4>)'',1,1,1,21,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_5>)'',1,1,1,23,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_6>)'',1,1,1,25,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_1>)'',1,1,1,27,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_2>)'',1,1,1,28,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_3>)'',1,1,1,31,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_4>)'',1,1,1,33,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_5>)'',1,1,1,35,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_6>)'',1,1,1,37,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_7>)'',1,1,1,39,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_8>)'',1,1,1,41,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl72'',''"#,##0.00"'',1
7,1,''>>(<s_9>)'',1,1,1,43,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_7>)'',1,1,1,45,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_8>)'',1,1,1,47,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl72'',''"#,##0.00"'',1
7,1,''>>(<k_9>)'',1,1,1,49,''xl72'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl72'',''"#,##0.00"'',1
7,1,'''',1,1,1,51,''xl43'','''',1
7,1,'''',1,1,1,52,''xl22'','''',1
7,1,'''',1,1,1,53,''xl22'','''',1
8,1,''>>>nvl({po_n};" ")&"\"'',1,1,1,1,''xl28'','''',1
8,1,''>>>nvl({cpo};" ")&"\"'',1,1,1,2,''xl36'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<nam_1>)'',1,1,1,3,''xl45'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<res_1>)'',1,1,1,4,''xl45'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<dat_1>)'',1,1,1,5,''xl45'','''',1
8,1,''>>>2(<lev1>;AA;<st>;1;<cod_1>)'',1,1,1,6,''xl45'','''',1
8,1,''>>>2(<lev2>;AA;<st>;1;<nam_2>)'',1,1,1,7,''xl45'','''',1
8,1,''>>>2(<lev2>;AA;<st>;1;<res_2>)'',1,1,1,8,''xl45'','''',1
8,1,''>>>2(<lev2>;AA;<st>;1;<dat_2>)'',1,1,1,9,''xl58'','''',1
8,1,''>>nvl({cpog};" ")&"\"'',1,1,1,10,''xl60'','''',1
8,1,''>>2(<lev>;1;<st>;1;<cdiv>)'',1,1,1,11,''xl63'','''',1
8,1,''>>2(<lev>;1;<st>;1;<ctgt>)'',1,1,1,12,''xl63'','''',1
8,1,''>>2(<lev>;1;<st>;1;<cexp>)'',1,1,1,13,''xl63'','''',1
8,1,''>>2(<lev>;1;<st>;1;<citm>)'',1,1,1,14,''xl63'','''',1
8,1,''>>(<st>;1;<s_1>)'',1,1,1,15,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_2>)'',1,1,1,16,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_1>)'',1,1,1,17,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_2>)'',1,1,1,18,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_3>)'',1,1,1,19,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_3>)'',1,1,1,20,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_4>)'',1,1,1,21,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_4>)'',1,1,1,22,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_5>)'',1,1,1,23,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_5>)'',1,1,1,24,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_6>)'',1,1,1,25,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_6>)'',1,1,1,26,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_1>)'',1,1,1,27,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_2>)'',1,1,1,28,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_1>)'',1,1,1,29,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_2>)'',1,1,1,30,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_3>)'',1,1,1,31,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_3>)'',1,1,1,32,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_4>)'',1,1,1,33,''xl73'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 7, '8,1,''>>2(<su>;AA;<st>;1;<k_4>)'',1,1,1,34,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_5>)'',1,1,1,35,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_5>)'',1,1,1,36,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_6>)'',1,1,1,37,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_6>)'',1,1,1,38,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_7>)'',1,1,1,39,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_7>)'',1,1,1,40,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_8>)'',1,1,1,41,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_8>)'',1,1,1,42,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<s_9>)'',1,1,1,43,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<s_9>)'',1,1,1,44,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_7>)'',1,1,1,45,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_7>)'',1,1,1,46,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_8>)'',1,1,1,47,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_8>)'',1,1,1,48,''xl73'',''"#,##0.00"'',1
8,1,''>>(<st>;1;<k_9>)'',1,1,1,49,''xl73'',''"#,##0.00"'',1
8,1,''>>2(<su>;AA;<st>;1;<k_9>)'',1,1,1,50,''xl73'',''"#,##0.00"'',1
8,1,''>>>2(<lev>;1;<st>;1;<metod>)'',1,1,1,51,''xl36'','''',1
8,1,'''',1,1,1,52,''xl22'','''',1
8,1,'''',1,1,1,53,''xl22'','''',1
9,1,''\'',1,1,1,1,''xl28'','''',1
9,1,''\'',1,1,1,2,''xl36'','''',1
9,1,''>>>(<lev1>;AA;<nam_1>)'',1,1,1,3,''xl45'','''',1
9,1,''>>>(<lev1>;AA;<res_1>)'',1,1,1,4,''xl45'','''',1
9,1,''>>>(<lev1>;AA;<dat_1>)'',1,1,1,5,''xl45'','''',1
9,1,''>>>(<lev1>;AA;<cod_1>)'',1,1,1,6,''xl45'','''',1
9,1,''>>>(<lev2>;AA;<nam_2>)'',1,1,1,7,''xl45'','''',1
9,1,''>>>(<lev2>;AA;<res_2>)'',1,1,1,8,''xl45'','''',1
9,1,''>>>(<lev2>;AA;<dat_2>)'',1,1,1,9,''xl58'','''',1
9,1,''\'',1,1,1,10,''xl60'','''',1
9,1,''>>(<lev>;1;<cdiv>)'',1,1,1,11,''xl63'','''',1
9,1,''>>(<lev>;1;<ctgt>)'',1,1,1,12,''xl63'','''',1
9,1,''>>(<lev>;1;<cexp>)'',1,1,1,13,''xl63'','''',1
9,1,''>>(<lev>;1;<citm>)'',1,1,1,14,''xl63'','''',1
9,1,''>>(<s_1>)'',1,1,1,15,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_2>)'',1,1,1,16,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_1>)'',1,1,1,17,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_2>)'',1,1,1,18,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_3>)'',1,1,1,19,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_3>)'',1,1,1,20,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_4>)'',1,1,1,21,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_4>)'',1,1,1,22,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_5>)'',1,1,1,23,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_5>)'',1,1,1,24,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_6>)'',1,1,1,25,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_6>)'',1,1,1,26,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_1>)'',1,1,1,27,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_2>)'',1,1,1,28,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_1>)'',1,1,1,29,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_2>)'',1,1,1,30,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_3>)'',1,1,1,31,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_3>)'',1,1,1,32,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_4>)'',1,1,1,33,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_4>)'',1,1,1,34,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_5>)'',1,1,1,35,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_5>)'',1,1,1,36,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_6>)'',1,1,1,37,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_6>)'',1,1,1,38,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_7>)'',1,1,1,39,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_7>)'',1,1,1,40,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_8>)'',1,1,1,41,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_8>)'',1,1,1,42,''xl73'',''"#,##0.00"'',1
9,1,''>>(<s_9>)'',1,1,1,43,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_9>)'',1,1,1,44,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_7>)'',1,1,1,45,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_7>)'',1,1,1,46,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_8>)'',1,1,1,47,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_8>)'',1,1,1,48,''xl73'',''"#,##0.00"'',1
9,1,''>>(<k_9>)'',1,1,1,49,''xl73'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_9>)'',1,1,1,50,''xl73'',''"#,##0.00"'',1
9,1,''>>>(<lev>;1;<metod>)'',1,1,1,51,''xl36'','''',1
9,1,''>>st'',1,1,1,52,''xl95'','''',1
9,1,'''',1,1,1,53,''xl22'','''',1
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 8, '1,1,'''',1,1,1,1,''xl22'','''',2
1,1,'''',1,1,1,2,''xl22'','''',2
1,1,'''',1,1,1,3,''xl22'','''',2
1,1,'''',1,1,1,4,''xl22'','''',2
1,1,'''',1,1,1,5,''xl22'','''',2
1,1,'''',1,1,1,6,''xl22'','''',2
1,1,'''',1,1,1,7,''xl22'','''',2
1,1,'''',1,1,1,8,''xl22'','''',2
1,1,'''',1,1,1,9,''xl22'','''',2
1,1,'''',1,1,1,10,''xl22'','''',2
1,1,'''',1,1,1,11,''xl22'','''',2
1,1,'''',1,1,1,12,''xl22'','''',2
1,1,'''',1,1,1,13,''xl22'','''',2
1,1,'''',1,1,1,14,''xl22'','''',2
1,1,'''',1,1,1,15,''xl22'','''',2
1,1,'''',1,1,1,16,''xl22'','''',2
1,1,'''',1,1,1,17,''xl22'','''',2
1,1,'''',1,1,1,18,''xl22'','''',2
1,1,'''',1,1,1,19,''xl22'','''',2
1,1,'''',1,1,1,20,''xl22'','''',2
1,1,'''',1,1,1,21,''xl22'','''',2
1,1,'''',1,1,1,22,''xl22'','''',2
1,1,'''',1,1,1,23,''xl22'','''',2
1,1,'''',1,1,1,24,''xl22'','''',2
1,1,'''',1,1,1,25,''xl22'','''',2
1,1,'''',1,1,1,26,''xl22'','''',2
1,1,'''',1,1,1,27,''xl22'','''',2
1,1,'''',1,1,1,28,''xl22'','''',2
1,1,'''',1,1,1,29,''xl87'','''',2
1,1,'''',1,1,1,30,''xl87'','''',2
1,1,'''',1,1,1,31,''xl87'','''',2
1,1,'''',1,1,1,32,''xl87'','''',2
1,1,'''',1,1,1,33,''xl87'','''',2
1,1,'''',1,1,1,34,''xl87'','''',2
1,1,'''',1,1,1,35,''xl87'','''',2
1,1,'''',1,1,1,36,''xl22'','''',2
1,1,'''',1,1,1,37,''xl90'','''',2
1,1,'''',1,1,1,38,''xl90'','''',2
1,1,'''',1,1,1,39,''xl90'','''',2
1,1,'''',1,1,1,40,''xl90'','''',2
1,1,'''',1,1,1,41,''xl23'','''',2
1,1,'''',1,1,1,42,''xl90'','''',2
1,1,'''',1,1,1,43,''xl90'','''',2
1,1,'''',1,1,1,44,''xl90'','''',2
1,1,'''',1,1,1,45,''xl90'','''',2
1,1,'''',1,1,1,46,''xl90'','''',2
1,1,'''',1,1,1,47,''xl90'','''',2
1,1,'''',1,1,1,48,''xl90'','''',2
1,1,'''',1,1,1,49,''xl90'','''',2
1,1,'''',1,1,1,50,''xl90'','''',2
1,1,'''',1,1,1,51,''xl90'','''',2
1,1,'''',1,1,1,52,''xl90'','''',2
1,1,'''',1,1,1,53,''xl90'','''',2
1,1,'''',1,1,1,54,''xl90'','''',2
1,1,''>>"#/"'',1,1,1,55,''xl93'','''',2
1,1,'''',1,1,1,56,''xl22'','''',2
1,1,''           ,'',1,27,2,1,''xl85'','''',2
1,1,'''',1,1,2,28,''xl22'','''',2
1,1,'''',1,1,2,29,''xl87'','''',2
1,1,'''',1,1,2,30,''xl87'','''',2
1,1,'''',1,1,2,31,''xl87'','''',2
1,1,'''',1,1,2,32,''xl87'','''',2
1,1,'''',1,1,2,33,''xl87'','''',2
1,1,'''',1,1,2,34,''xl87'','''',2
1,1,'''',1,1,2,35,''xl87'','''',2
1,1,'''',1,1,2,36,''xl22'','''',2
1,1,'''',1,1,2,37,''xl90'','''',2
1,1,'''',1,1,2,38,''xl90'','''',2
1,1,'''',1,1,2,39,''xl90'','''',2
1,1,'''',1,1,2,40,''xl90'','''',2
1,1,'''',1,1,2,41,''xl23'','''',2
1,1,'''',1,1,2,42,''xl90'','''',2
1,1,'''',1,1,2,43,''xl90'','''',2
1,1,'''',1,1,2,44,''xl90'','''',2
1,1,'''',1,1,2,45,''xl90'','''',2
1,1,'''',1,1,2,46,''xl90'','''',2
1,1,'''',1,1,2,47,''xl90'','''',2
1,1,'''',1,1,2,48,''xl90'','''',2
1,1,'''',1,1,2,49,''xl90'','''',2
1,1,'''',1,1,2,50,''xl90'','''',2
1,1,'''',1,1,2,51,''xl90'','''',2
1,1,'''',1,1,2,52,''xl90'','''',2
1,1,'''',1,1,2,53,''xl90'','''',2
1,1,'''',1,1,2,54,''xl90'','''',2
1,1,'''',1,1,2,55,''xl22'','''',2
1,1,'''',1,1,2,56,''xl22'','''',2
1,1,''          ,     '',1,27,3,1,''xl85'','''',2
1,1,'''',1,1,3,28,''xl87'','''',2
1,1,'''',1,1,3,29,''xl80'','''',2
1,1,'''',1,1,3,30,''xl80'','''',2
1,1,'''',1,1,3,31,''xl80'','''',2
1,1,'''',1,1,3,32,''xl80'','''',2
1,1,'''',1,1,3,33,''xl80'','''',2
1,1,'''',1,1,3,34,''xl80'','''',2
1,1,'''',1,1,3,35,''xl80'','''',2
1,1,'''',1,1,3,36,''xl22'','''',2
1,1,'''',1,1,3,37,''xl90'','''',2
1,1,'''',1,1,3,38,''xl90'','''',2
1,1,'''',1,1,3,39,''xl90'','''',2
1,1,'''',1,1,3,40,''xl90'','''',2
1,1,'''',1,1,3,41,''xl23'','''',2
1,1,'''',1,1,3,42,''xl90'','''',2
1,1,'''',1,1,3,43,''xl90'','''',2
1,1,'''',1,1,3,44,''xl90'','''',2
1,1,'''',1,1,3,45,''xl90'','''',2
1,1,'''',1,1,3,46,''xl90'','''',2
1,1,'''',1,1,3,47,''xl90'','''',2
1,1,'''',1,1,3,48,''xl90'','''',2
1,1,'''',1,1,3,49,''xl90'','''',2
1,1,'''',1,1,3,50,''xl90'','''',2
1,1,'''',1,1,3,51,''xl90'','''',2
1,1,'''',1,1,3,52,''xl90'','''',2
1,1,'''',1,1,3,53,''xl90'','''',2
1,1,'''',1,1,3,54,''xl90'','''',2
1,1,'''',1,1,3,55,''xl22'','''',2
1,1,'''',1,1,3,56,''xl22'','''',2
1,1,''>>" "&(dDate_2+1;0)&"."'',1,27,4,1,''xl47'','''',2
1,1,'''',1,1,4,28,''xl47'','''',2
1,1,'''',1,1,4,29,''xl47'','''',2
1,1,'''',1,1,4,30,''xl47'','''',2
1,1,'''',1,1,4,31,''xl47'','''',2
1,1,'''',1,1,4,32,''xl47'','''',2
1,1,'''',1,1,4,33,''xl47'','''',2
1,1,'''',1,1,4,34,''xl47'','''',2
1,1,'''',1,1,4,35,''xl47'','''',2
1,1,'''',1,1,4,36,''xl22'','''',2
1,1,'''',1,1,4,37,''xl90'','''',2
1,1,'''',1,1,4,38,''xl90'','''',2
1,1,'''',1,1,4,39,''xl90'','''',2
1,1,'''',1,1,4,40,''xl90'','''',2
1,1,'''',1,1,4,41,''xl23'','''',2
1,1,'''',1,1,4,42,''xl90'','''',2
1,1,'''',1,1,4,43,''xl90'','''',2
1,1,'''',1,1,4,44,''xl90'','''',2
1,1,'''',1,1,4,45,''xl90'','''',2
1,1,'''',1,1,4,46,''xl90'','''',2
1,1,'''',1,1,4,47,''xl90'','''',2
1,1,'''',1,1,4,48,''xl90'','''',2
1,1,'''',1,1,4,49,''xl90'','''',2
1,1,'''',1,1,4,50,''xl90'','''',2
1,1,'''',1,1,4,51,''xl90'','''',2
1,1,'''',1,1,4,52,''xl90'','''',2
1,1,'''',1,1,4,53,''xl90'','''',2
1,1,'''',1,1,4,54,''xl90'','''',2
1,1,'''',1,1,4,55,''xl22'','''',2
1,1,'''',1,1,4,56,''xl22'','''',2
1,1,'''',1,1,5,1,''xl22'','''',2
1,1,'''',1,1,5,2,''xl22'','''',2
1,1,'''',1,1,5,3,''xl22'','''',2
1,1,'''',1,1,5,4,''xl22'','''',2
1,1,'''',1,1,5,5,''xl22'','''',2
1,1,'''',1,1,5,6,''xl22'','''',2
1,1,'''',1,1,5,7,''xl22'','''',2
1,1,'''',1,1,5,8,''xl41'','''',2
1,1,'''',1,1,5,9,''xl41'','''',2
1,1,'''',1,1,5,10,''xl107'','''',2
1,1,'''',1,1,5,11,''xl107'','''',2
1,1,'''',1,1,5,12,''xl107'','''',2
1,1,'''',1,1,5,13,''xl41'','''',2
1,1,'''',1,1,5,14,''xl32'','''',2
1,1,'''',1,1,5,15,''xl32'','''',2
1,1,'''',1,1,5,16,''xl32'','''',2
1,1,'''',1,1,5,17,''xl41'','''',2
1,1,'''',1,1,5,18,''xl41'','''',2
1,1,'''',1,1,5,19,''xl41'','''',2
1,1,'''',1,1,5,20,''xl41'','''',2
1,1,'''',1,1,5,21,''xl41'','''',2
1,1,'''',1,1,5,22,''xl41'','''',2
1,1,'''',1,1,5,23,''xl80'','''',2
1,1,'''',1,1,5,24,''xl80'','''',2
1,1,'''',1,1,5,25,''xl80'','''',2
1,1,'''',1,1,5,26,''xl80'','''',2
1,1,'''',1,1,5,27,''xl41'','''',2
1,1,'''',1,1,5,28,''xl41'','''',2
1,1,'''',1,1,5,29,''xl41'','''',2
1,1,'''',1,1,5,30,''xl41'','''',2
1,1,'''',1,1,5,31,''xl41'','''',2
1,1,'''',1,1,5,32,''xl41'','''',2
1,1,'''',1,1,5,33,''xl41'','''',2
1,1,'''',1,1,5,34,''xl41'','''',2
1,1,'''',1,1,5,35,''xl41'','''',2
1,1,'''',1,1,5,36,''xl22'','''',2
1,1,'''',1,1,5,37,''xl90'','''',2
1,1,'''',1,1,5,38,''xl90'','''',2
1,1,'''',1,1,5,39,''xl90'','''',2
1,1,'''',1,1,5,40,''xl90'','''',2
1,1,'''',1,1,5,41,''xl23'','''',2
1,1,'''',1,1,5,42,''xl90'','''',2
1,1,'''',1,1,5,43,''xl90'','''',2
1,1,'''',1,1,5,44,''xl90'','''',2
1,1,'''',1,1,5,45,''xl90'','''',2
1,1,'''',1,1,5,46,''xl90'','''',2
1,1,'''',1,1,5,47,''xl90'','''',2
1,1,'''',1,1,5,48,''xl90'','''',2
1,1,'''',1,1,5,49,''xl90'','''',2
1,1,'''',1,1,5,50,''xl90'','''',2
1,1,'''',1,1,5,51,''xl90'','''',2
1,1,'''',1,1,5,52,''xl90'','''',2
1,1,'''',1,1,5,53,''xl90'','''',2
1,1,'''',1,1,5,54,''xl90'','''',2
1,1,'''',1,1,5,55,''xl22'','''',2
1,1,'''',1,1,5,56,''xl22'','''',2
1,1,''        '',1,1,6,1,''xl23'','''',2
1,1,''$$select name from c_data1 where list=2#name#name#NN'',1,28,6,2,''xl88'','''',2
1,1,'''',1,1,6,30,''xl41'','''',2
1,1,'''',1,1,6,31,''xl41'','''',2
1,1,'''',1,1,6,32,''xl41'','''',2
1,1,'''',1,1,6,33,''xl41'','''',2
1,1,'''',1,1,6,34,''xl41'','''',2
1,1,'''',1,1,6,35,''xl41'','''',2
1,1,'''',1,1,6,36,''xl22'','''',2
1,1,'''',1,1,6,37,''xl90'','''',2
1,1,'''',1,1,6,38,''xl90'','''',2
1,1,'''',1,1,6,39,''xl90'','''',2
1,1,'''',1,1,6,40,''xl90'','''',2
1,1,'''',1,1,6,41,''xl23'','''',2
1,1,'''',1,1,6,42,''xl90'','''',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 9, '1,1,'''',1,1,6,43,''xl90'','''',2
1,1,'''',1,1,6,44,''xl90'','''',2
1,1,'''',1,1,6,45,''xl90'','''',2
1,1,'''',1,1,6,46,''xl90'','''',2
1,1,'''',1,1,6,47,''xl90'','''',2
1,1,'''',1,1,6,48,''xl90'','''',2
1,1,'''',1,1,6,49,''xl90'','''',2
1,1,'''',1,1,6,50,''xl90'','''',2
1,1,'''',1,1,6,51,''xl90'','''',2
1,1,'''',1,1,6,52,''xl90'','''',2
1,1,'''',1,1,6,53,''xl90'','''',2
1,1,'''',1,1,6,54,''xl90'','''',2
1,1,'''',1,1,6,55,''xl22'','''',2
1,1,'''',1,1,6,56,''xl22'','''',2
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,29,7,1,''xl89'','''',2
1,1,'''',1,1,7,30,''xl41'','''',2
1,1,'''',1,1,7,31,''xl41'','''',2
1,1,'''',1,1,7,32,''xl41'','''',2
1,1,'''',1,1,7,33,''xl41'','''',2
1,1,'''',1,1,7,34,''xl41'','''',2
1,1,'''',1,1,7,35,''xl41'','''',2
1,1,'''',1,1,7,36,''xl41'','''',2
1,1,'''',1,1,7,37,''xl41'','''',2
1,1,'''',1,1,7,38,''xl41'','''',2
1,1,'''',1,1,7,39,''xl41'','''',2
1,1,'''',1,1,7,40,''xl41'','''',2
1,1,'''',1,1,7,41,''xl23'','''',2
1,1,'''',1,1,7,42,''xl41'','''',2
1,1,'''',1,1,7,43,''xl41'','''',2
1,1,'''',1,1,7,44,''xl41'','''',2
1,1,'''',1,1,7,45,''xl41'','''',2
1,1,'''',1,1,7,46,''xl41'','''',2
1,1,'''',1,1,7,47,''xl41'','''',2
1,1,'''',1,1,7,48,''xl41'','''',2
1,1,'''',1,1,7,49,''xl41'','''',2
1,1,'''',1,1,7,50,''xl41'','''',2
1,1,'''',1,1,7,51,''xl41'','''',2
1,1,'''',1,1,7,52,''xl41'','''',2
1,1,'''',1,1,7,53,''xl41'','''',2
1,1,'''',1,1,7,54,''xl41'','''',2
1,1,'''',1,1,7,55,''xl22'','''',2
1,1,'''',1,1,7,56,''xl22'','''',2
1,1,'''',1,1,8,1,''xl23'','''',2
1,1,'''',1,1,8,2,''xl32'','''',2
1,1,'''',1,1,8,3,''xl41'','''',2
1,1,'''',1,1,8,4,''xl41'','''',2
1,1,'''',1,1,8,5,''xl41'','''',2
1,1,'''',1,1,8,6,''xl41'','''',2
1,1,'''',1,1,8,7,''xl41'','''',2
1,1,'''',1,1,8,8,''xl41'','''',2
1,1,'''',1,1,8,9,''xl41'','''',2
1,1,'''',1,1,8,10,''xl107'','''',2
1,1,'''',1,1,8,11,''xl107'','''',2
1,1,'''',1,1,8,12,''xl107'','''',2
1,1,'''',1,1,8,13,''xl41'','''',2
1,1,'''',1,1,8,14,''xl32'','''',2
1,1,'''',1,1,8,15,''xl32'','''',2
1,1,'''',1,1,8,16,''xl32'','''',2
1,1,'''',1,1,8,17,''xl41'','''',2
1,1,'''',1,1,8,18,''xl41'','''',2
1,1,'''',1,1,8,19,''xl41'','''',2
1,1,'''',1,1,8,20,''xl41'','''',2
1,1,'''',1,1,8,21,''xl41'','''',2
1,1,'''',1,1,8,22,''xl41'','''',2
1,1,'''',1,1,8,23,''xl41'','''',2
1,1,'''',1,1,8,24,''xl41'','''',2
1,1,'''',1,1,8,25,''xl41'','''',2
1,1,'''',1,1,8,26,''xl41'','''',2
1,1,'''',1,1,8,27,''xl41'','''',2
1,1,'''',1,1,8,28,''xl41'','''',2
1,1,'''',1,1,8,29,''xl41'','''',2
1,1,'''',1,1,8,30,''xl41'','''',2
1,1,'''',1,1,8,31,''xl41'','''',2
1,1,'''',1,1,8,32,''xl41'','''',2
1,1,'''',1,1,8,33,''xl41'','''',2
1,1,'''',1,1,8,34,''xl41'','''',2
1,1,'''',1,1,8,35,''xl41'','''',2
1,1,'''',1,1,8,36,''xl41'','''',2
1,1,'''',1,1,8,37,''xl41'','''',2
1,1,'''',1,1,8,38,''xl41'','''',2
1,1,'''',1,1,8,39,''xl41'','''',2
1,1,'''',1,1,8,40,''xl41'','''',2
1,1,'''',1,1,8,41,''xl41'','''',2
1,1,'''',1,1,8,42,''xl41'','''',2
1,1,'''',1,1,8,43,''xl41'','''',2
1,1,'''',1,1,8,44,''xl41'','''',2
1,1,'''',1,1,8,45,''xl41'','''',2
1,1,'''',1,1,8,46,''xl41'','''',2
1,1,'''',1,1,8,47,''xl41'','''',2
1,1,'''',1,1,8,48,''xl41'','''',2
1,1,'''',1,1,8,49,''xl41'','''',2
1,1,'''',1,1,8,50,''xl41'','''',2
1,1,'''',1,1,8,51,''xl41'','''',2
1,1,'''',1,1,8,52,''xl41'','''',2
1,1,'''',1,1,8,53,''xl41'','''',2
1,1,'''',1,1,8,54,''xl41'','''',2
1,1,'''',1,1,8,55,''xl22'','''',2
1,1,'''',1,1,8,56,''xl22'','''',2
1,1,'' , chr(10) '',10,1,9,1,''xl96'','''',2
1,1,'' '',10,1,9,2,''xl98'','''',2
1,1,''      ,    '',2,10,9,3,''xl75'','''',2
1,1,''  ,  '',10,1,9,13,''xl117'','''',2
1,1,''    '',4,4,9,14,''xl121'','''',2
1,1,''       '',3,12,9,18,''xl75'','''',2
1,1,'' ..                 '',3,12,9,30,''xl75'','''',2
1,1,''    '',3,6,9,42,''xl75'','''',2
1,1,'' ..                 '',3,6,9,48,''xl75'','''',2
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,9,54,''xl124'','''',2
1,1,'''',1,1,9,55,''xl94'','''',2
1,1,'''',1,1,9,56,''xl94'','''',2
1,1,'''',1,1,10,55,''xl94'','''',2
1,1,'''',1,1,10,56,''xl94'','''',2
1,1,'' '',1,4,11,3,''xl51'','''',2
1,1,''>>>cText_35'',1,3,11,7,''xl51'','''',2
1,1,''  '',1,3,11,10,''xl51'','''',2
1,1,'''',1,1,11,55,''xl94'','''',2
1,1,'''',1,1,11,56,''xl94'','''',2
1,1,''&&select orders,name from c_data3 order by orders#name#orders#AA'',1,4,12,3,''xl51'','''',2
1,1,''&&select orders,name from c_data4 order by orders#name#orders#AA'',1,3,12,7,''xl51'','''',2
1,1,''&&select orders,name from c_data5 order by orders#name#orders#AA'',1,3,12,10,''xl51'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,18,''xl75'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,22,''xl75'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,24,''xl75'','''',2
1,1,'' '',1,4,12,26,''xl75'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,30,''xl75'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,34,''xl75'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,36,''xl75'','''',2
1,1,'' '',1,4,12,38,''xl75'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,12,42,''xl75'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,12,44,''xl75'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,12,46,''xl75'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,12,48,''xl75'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,12,50,''xl75'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,12,52,''xl75'','''',2
1,1,'''',1,1,12,55,''xl94'','''',2
1,1,'''',1,1,12,56,''xl94'','''',2
1,1,'',   '',6,1,13,3,''xl100'','''',2
1,1,''&&select vip from c_data3 where orders=AA#vip#vip#CC'',6,1,13,4,''xl101'','''',2
1,1,''   ,  '',6,1,13,5,''xl102'','''',2
1,1,''&&select code from c_data3 where orders=AA#code#code#CC'',6,1,13,6,''xl103'','''',2
1,1,'',   '',6,1,13,7,''xl104'','''',2
1,1,''&&select vip from c_data4 where orders=AA#vip#vip#CC'',6,1,13,8,''xl105'','''',2
1,1,''   ,  '',6,1,13,9,''xl106'','''',2
1,1,''>>>(nCheck_16=1;",   ";"#/")'',6,1,13,10,''xl108'','''',2
1,1,''>>>(nCheck_16=1;"  (),  ()";"#/")'',6,1,13,11,''xl113'','''',2
1,1,''>>>(nCheck_16=1;"   ,  ";"#/")'',6,1,13,12,''xl114'','''',2
1,1,''>>>(nCheck_34=1;"/";"#/")'',6,1,13,14,''xl118'','''',2
1,1,''>>>(nCheck_19=1;" ";"#/")'',6,1,13,15,''xl119'','''',2
1,1,''>>>(nCheck_20=1;" ";"#/")'',6,1,13,16,''xl120'','''',2
1,1,''>>>(nCheck_21=1;"";"#/")'',6,1,13,17,''xl122'','''',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 10, '1,1,'''',1,2,13,18,''xl75'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,13,20,''xl75'','''',2
1,1,'''',6,1,13,22,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,23,''xl84'','''',2
1,1,'''',6,1,13,24,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,25,''xl84'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,13,26,''xl86'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,13,28,''xl86'','''',2
1,1,'''',1,2,13,30,''xl75'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',1,2,13,32,''xl75'','''',2
1,1,'''',6,1,13,34,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,35,''xl84'','''',2
1,1,'''',6,1,13,36,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,37,''xl84'','''',2
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,13,38,''xl86'','''',2
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,13,40,''xl86'','''',2
1,1,'''',6,1,13,42,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,43,''xl84'','''',2
1,1,'''',6,1,13,44,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,45,''xl84'','''',2
1,1,'''',6,1,13,46,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,47,''xl84'','''',2
1,1,'''',6,1,13,48,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,49,''xl84'','''',2
1,1,'''',6,1,13,50,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,51,''xl84'','''',2
1,1,'''',6,1,13,52,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',6,1,13,53,''xl84'','''',2
1,1,'''',1,1,13,55,''xl94'','''',2
1,1,'''',1,1,13,56,''xl94'','''',2
1,1,''  '',5,1,14,18,''xl84'','''',2
1,1,'''',5,1,14,19,''xl84'','''',2
1,1,''  '',5,1,14,20,''xl84'','''',2
1,1,'''',5,1,14,21,''xl84'','''',2
1,1,'''',5,1,14,26,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,27,''xl84'','''',2
1,1,'''',5,1,14,28,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,29,''xl84'','''',2
1,1,''  '',5,1,14,30,''xl84'','''',2
1,1,'''',5,1,14,31,''xl84'','''',2
1,1,''  '',5,1,14,32,''xl84'','''',2
1,1,'''',5,1,14,33,''xl84'','''',2
1,1,'''',5,1,14,38,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,39,''xl84'','''',2
1,1,'''',5,1,14,40,''xl84'','''',2
1,1,''&&select orders,name from c_data6 where list=2 order by orders#name#orders#AA'',5,1,14,41,''xl84'','''',2
1,1,'''',1,1,14,55,''xl94'','''',2
1,1,'''',1,1,14,56,''xl94'','''',2
1,1,'''',1,1,15,55,''xl94'','''',2
1,1,'''',1,1,15,56,''xl94'','''',2
1,1,'''',1,1,16,55,''xl94'','''',2
1,1,'''',1,1,16,56,''xl94'','''',2
1,1,'''',1,1,17,55,''xl94'','''',2
1,1,'''',1,1,17,56,''xl94'','''',2
1,1,'''',1,1,18,55,''xl94'','''',2
1,1,'''',1,1,18,56,''xl94'','''',2
1,2,''    ,    '',1,1,1,1,''xl27'','''',2
1,2,''11800'',1,1,1,2,''xl43'','''',2
1,2,'''',1,1,1,3,''xl43'','''',2
1,2,'''',1,1,1,4,''xl43'','''',2
1,2,'''',1,1,1,5,''xl43'','''',2
1,2,'''',1,1,1,6,''xl43'','''',2
1,2,'''',1,1,1,7,''xl43'','''',2
1,2,'''',1,1,1,8,''xl43'','''',2
1,2,'''',1,1,1,9,''xl43'','''',2
1,2,'''',1,1,1,10,''xl109'','''',2
1,2,'''',1,1,1,11,''xl109'','''',2
1,2,'''',1,1,1,12,''xl109'','''',2
1,2,'''',1,1,1,13,''xl43'','''',2
1,2,'''',1,1,1,14,''xl43'','''',2
1,2,'''',1,1,1,15,''xl43'','''',2
1,2,'''',1,1,1,16,''xl43'','''',2
1,2,'''',1,1,1,17,''xl43'','''',2
1,2,''>>2(<npog>;1;<list>;2;<s_1>)'',1,1,1,18,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_2>)'',1,1,1,19,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_1>)'',1,1,1,20,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_2>)'',1,1,1,21,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_3>)'',1,1,1,22,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_3>)'',1,1,1,23,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_4>)'',1,1,1,24,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_4>)'',1,1,1,25,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_5>)'',1,1,1,26,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_5>)'',1,1,1,27,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_6>)'',1,1,1,28,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_6>)'',1,1,1,29,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_1>)'',1,1,1,30,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_2>)'',1,1,1,31,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_1>)'',1,1,1,32,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_2>)'',1,1,1,33,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_3>)'',1,1,1,34,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_3>)'',1,1,1,35,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_4>)'',1,1,1,36,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_4>)'',1,1,1,37,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_5>)'',1,1,1,38,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_5>)'',1,1,1,39,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_6>)'',1,1,1,40,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_6>)'',1,1,1,41,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_7>)'',1,1,1,42,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_7>)'',1,1,1,43,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_8>)'',1,1,1,44,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_8>)'',1,1,1,45,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<s_9>)'',1,1,1,46,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<s_9>)'',1,1,1,47,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_7>)'',1,1,1,48,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_7>)'',1,1,1,49,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_8>)'',1,1,1,50,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_8>)'',1,1,1,51,''xl72'',''"#,##0.00"'',2
1,2,''>>2(<npog>;1;<list>;2;<k_9>)'',1,1,1,52,''xl72'',''"#,##0.00"'',2
1,2,''>>3(<npog>;1;<su>;AA;<list>;2;<k_9>)'',1,1,1,53,''xl72'',''"#,##0.00"'',2
1,2,'''',1,1,1,54,''xl109'','''',2
1,2,'''',1,1,1,55,''xl22'','''',2
1,2,'''',1,1,1,56,''xl22'','''',2
1,2,''     '',1,1,2,1,''xl97'','''',2
1,2,''11900'',1,1,2,2,''xl99'','''',2
1,2,'''',1,1,2,3,''xl99'','''',2
1,2,'''',1,1,2,4,''xl99'','''',2
1,2,'''',1,1,2,5,''xl99'','''',2
1,2,'''',1,1,2,6,''xl99'','''',2
1,2,'''',1,1,2,7,''xl99'','''',2
1,2,'''',1,1,2,8,''xl99'','''',2
1,2,'''',1,1,2,9,''xl99'','''',2
1,2,'''',1,1,2,10,''xl111'','''',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 11, '1,2,'''',1,1,2,11,''xl111'','''',2
1,2,'''',1,1,2,12,''xl111'','''',2
1,2,'''',1,1,2,13,''xl99'','''',2
1,2,'''',1,1,2,14,''xl99'','''',2
1,2,'''',1,1,2,15,''xl99'','''',2
1,2,'''',1,1,2,16,''xl99'','''',2
1,2,'''',1,1,2,17,''xl99'','''',2
1,2,''>>(<list>;2;<s_1>)'',1,1,2,18,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_2>)'',1,1,2,19,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_1>)'',1,1,2,20,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_2>)'',1,1,2,21,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_3>)'',1,1,2,22,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_3>)'',1,1,2,23,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_4>)'',1,1,2,24,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_4>)'',1,1,2,25,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_5>)'',1,1,2,26,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_5>)'',1,1,2,27,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_6>)'',1,1,2,28,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_6>)'',1,1,2,29,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_1>)'',1,1,2,30,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_2>)'',1,1,2,31,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_1>)'',1,1,2,32,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_2>)'',1,1,2,33,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_3>)'',1,1,2,34,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_3>)'',1,1,2,35,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_4>)'',1,1,2,36,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_4>)'',1,1,2,37,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_5>)'',1,1,2,38,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_5>)'',1,1,2,39,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_6>)'',1,1,2,40,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_6>)'',1,1,2,41,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_7>)'',1,1,2,42,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_7>)'',1,1,2,43,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_8>)'',1,1,2,44,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_8>)'',1,1,2,45,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<s_9>)'',1,1,2,46,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<s_9>)'',1,1,2,47,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_7>)'',1,1,2,48,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_7>)'',1,1,2,49,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_8>)'',1,1,2,50,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_8>)'',1,1,2,51,''xl123'',''"#,##0.00"'',2
1,2,''>>(<list>;2;<k_9>)'',1,1,2,52,''xl123'',''"#,##0.00"'',2
1,2,''>>2(<su>;AA;<list>;2;<k_9>)'',1,1,2,53,''xl123'',''"#,##0.00"'',2
1,2,'''',1,1,2,54,''xl111'','''',2
1,2,'''',1,1,2,55,''xl22'','''',2
1,2,'''',1,1,2,56,''xl22'','''',2
1,2,'''',1,1,3,1,''xl30'','''',2
1,2,'''',1,1,3,2,''xl39'','''',2
1,2,'''',1,1,3,3,''xl47'','''',2
1,2,'''',1,1,3,4,''xl47'','''',2
1,2,'''',1,1,3,5,''xl47'','''',2
1,2,'''',1,1,3,6,''xl47'','''',2
1,2,'''',1,1,3,7,''xl47'','''',2
1,2,'''',1,1,3,8,''xl47'','''',2
1,2,'''',1,1,3,9,''xl47'','''',2
1,2,'''',1,1,3,10,''xl47'','''',2
1,2,'''',1,1,3,11,''xl47'','''',2
1,2,'''',1,1,3,12,''xl47'','''',2
1,2,'''',1,1,3,13,''xl47'','''',2
1,2,'''',1,1,3,14,''xl39'','''',2
1,2,'''',1,1,3,15,''xl39'','''',2
1,2,'''',1,1,3,16,''xl39'','''',2
1,2,'''',1,1,3,17,''xl65'','''',2
1,2,'''',1,1,3,18,''xl65'','''',2
1,2,'''',1,1,3,19,''xl65'','''',2
1,2,'''',1,1,3,20,''xl65'','''',2
1,2,'''',1,1,3,21,''xl65'','''',2
1,2,'''',1,1,3,22,''xl65'','''',2
1,2,'''',1,1,3,23,''xl65'','''',2
1,2,'''',1,1,3,24,''xl65'','''',2
1,2,'''',1,1,3,25,''xl65'','''',2
1,2,'''',1,1,3,26,''xl65'','''',2
1,2,'''',1,1,3,27,''xl65'','''',2
1,2,'''',1,1,3,28,''xl65'','''',2
1,2,'''',1,1,3,29,''xl65'','''',2
1,2,'''',1,1,3,30,''xl65'','''',2
1,2,'''',1,1,3,31,''xl65'','''',2
1,2,'''',1,1,3,32,''xl65'','''',2
1,2,'''',1,1,3,33,''xl65'','''',2
1,2,'''',1,1,3,34,''xl65'','''',2
1,2,'''',1,1,3,35,''xl65'','''',2
1,2,'''',1,1,3,36,''xl65'','''',2
1,2,'''',1,1,3,37,''xl65'','''',2
1,2,'''',1,1,3,38,''xl65'','''',2
1,2,'''',1,1,3,39,''xl65'','''',2
1,2,'''',1,1,3,40,''xl65'','''',2
1,2,'''',1,1,3,41,''xl65'','''',2
1,2,'''',1,1,3,42,''xl65'','''',2
1,2,'''',1,1,3,43,''xl65'','''',2
1,2,'''',1,1,3,44,''xl65'','''',2
1,2,'''',1,1,3,45,''xl65'','''',2
1,2,'''',1,1,3,46,''xl65'','''',2
1,2,'''',1,1,3,47,''xl65'','''',2
1,2,'''',1,1,3,48,''xl65'','''',2
1,2,'''',1,1,3,49,''xl65'','''',2
1,2,'''',1,1,3,50,''xl65'','''',2
1,2,'''',1,1,3,51,''xl65'','''',2
1,2,'''',1,1,3,52,''xl65'','''',2
1,2,'''',1,1,3,53,''xl65'','''',2
1,2,'''',1,1,3,54,''xl65'','''',2
1,2,'''',1,1,3,55,''xl22'','''',2
1,2,'''',1,1,3,56,''xl22'','''',2
1,2,''>>>Footer'',1,54,4,1,''xl31'','''',2
1,2,'''',1,1,4,55,''xl22'','''',2
1,2,'''',1,1,4,56,''xl22'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl25'','''',2
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,3,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,4,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,5,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)"&("CC"="#/";"";"+1")'',1,1,1,6,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,7,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,8,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,9,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+"&(nCheck_16;"0")'',1,1,1,10,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+"&(nCheck_16;"0")'',1,1,1,11,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+"&(nCheck_16;"0")'',1,1,1,12,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-"&(nCheck_16=1;"1";"4")&"]"&(34)&";)+1"'',1,1,1,13,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,4,1,14,''xl70'','''',2
2,1,''>>"=("&(34)&"R[0]C[-4]"&(34)&";)+1"'',1,1,1,18,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,19,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,20,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,21,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,22,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,23,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,24,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,25,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,26,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,27,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,28,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,29,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,30,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,31,''xl25'','''',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 12, '2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,32,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,33,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,34,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,35,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,36,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,37,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,38,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,39,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,40,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,41,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,42,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,43,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,44,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,45,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,46,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,47,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,48,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,49,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,50,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,51,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,52,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,53,''xl25'','''',2
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,54,''xl25'','''',2
2,1,'''',1,1,1,55,''xl22'','''',2
2,1,'''',1,1,1,56,''xl22'','''',2
3,1,''>>>{po5_n}'',1,1,1,1,''xl27'','''',2
3,1,''>>>{cpo5}'',1,1,1,2,''xl34'','''',2
3,1,'''',1,1,1,3,''xl43'','''',2
3,1,'''',1,1,1,4,''xl43'','''',2
3,1,'''',1,1,1,5,''xl43'','''',2
3,1,'''',1,1,1,6,''xl43'','''',2
3,1,'''',1,1,1,7,''xl43'','''',2
3,1,'''',1,1,1,8,''xl43'','''',2
3,1,'''',1,1,1,9,''xl43'','''',2
3,1,'''',1,1,1,10,''xl109'','''',2
3,1,'''',1,1,1,11,''xl109'','''',2
3,1,'''',1,1,1,12,''xl109'','''',2
3,1,'''',1,1,1,13,''xl43'','''',2
3,1,'''',1,1,1,14,''xl43'','''',2
3,1,'''',1,1,1,15,''xl43'','''',2
3,1,'''',1,1,1,16,''xl43'','''',2
3,1,'''',1,1,1,17,''xl43'','''',2
3,1,''>>(<s_1>)'',1,1,1,18,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_2>)'',1,1,1,19,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,20,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,21,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_3>)'',1,1,1,22,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,23,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_4>)'',1,1,1,24,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,25,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_5>)'',1,1,1,26,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,27,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_6>)'',1,1,1,28,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,29,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_1>)'',1,1,1,30,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_2>)'',1,1,1,31,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,32,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,33,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_3>)'',1,1,1,34,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,35,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_4>)'',1,1,1,36,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,37,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_5>)'',1,1,1,38,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,39,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_6>)'',1,1,1,40,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,41,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_7>)'',1,1,1,42,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,43,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_8>)'',1,1,1,44,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,45,''xl72'',''"#,##0.00"'',2
3,1,''>>(<s_9>)'',1,1,1,46,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,47,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_7>)'',1,1,1,48,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,49,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_8>)'',1,1,1,50,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,51,''xl72'',''"#,##0.00"'',2
3,1,''>>(<k_9>)'',1,1,1,52,''xl72'',''"#,##0.00"'',2
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,53,''xl72'',''"#,##0.00"'',2
3,1,'''',1,1,1,54,''xl43'','''',2
3,1,'''',1,1,1,55,''xl22'','''',2
3,1,'''',1,1,1,56,''xl22'','''',2
4,1,''>>>{po4_n}'',1,1,1,1,''xl27'','''',2
4,1,''>>>{cpo4}'',1,1,1,2,''xl34'','''',2
4,1,'''',1,1,1,3,''xl43'','''',2
4,1,'''',1,1,1,4,''xl43'','''',2
4,1,'''',1,1,1,5,''xl43'','''',2
4,1,'''',1,1,1,6,''xl43'','''',2
4,1,'''',1,1,1,7,''xl43'','''',2
4,1,'''',1,1,1,8,''xl43'','''',2
4,1,'''',1,1,1,9,''xl43'','''',2
4,1,'''',1,1,1,10,''xl109'','''',2
4,1,'''',1,1,1,11,''xl109'','''',2
4,1,'''',1,1,1,12,''xl109'','''',2
4,1,'''',1,1,1,13,''xl43'','''',2
4,1,'''',1,1,1,14,''xl43'','''',2
4,1,'''',1,1,1,15,''xl43'','''',2
4,1,'''',1,1,1,16,''xl43'','''',2
4,1,'''',1,1,1,17,''xl43'','''',2
4,1,''>>(<s_1>)'',1,1,1,18,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_2>)'',1,1,1,19,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,20,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,21,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_3>)'',1,1,1,22,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,23,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_4>)'',1,1,1,24,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,25,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_5>)'',1,1,1,26,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,27,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_6>)'',1,1,1,28,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,29,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_1>)'',1,1,1,30,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_2>)'',1,1,1,31,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,32,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,33,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_3>)'',1,1,1,34,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,35,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_4>)'',1,1,1,36,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,37,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_5>)'',1,1,1,38,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,39,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_6>)'',1,1,1,40,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,41,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_7>)'',1,1,1,42,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,43,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_8>)'',1,1,1,44,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,45,''xl72'',''"#,##0.00"'',2
4,1,''>>(<s_9>)'',1,1,1,46,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,47,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_7>)'',1,1,1,48,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,49,''xl72'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 13, '4,1,''>>(<k_8>)'',1,1,1,50,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,51,''xl72'',''"#,##0.00"'',2
4,1,''>>(<k_9>)'',1,1,1,52,''xl72'',''"#,##0.00"'',2
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,53,''xl72'',''"#,##0.00"'',2
4,1,'''',1,1,1,54,''xl43'','''',2
4,1,'''',1,1,1,55,''xl22'','''',2
4,1,'''',1,1,1,56,''xl22'','''',2
5,1,''>>>{po3_n}'',1,1,1,1,''xl27'','''',2
5,1,''>>>{cpo3}'',1,1,1,2,''xl34'','''',2
5,1,'''',1,1,1,3,''xl43'','''',2
5,1,'''',1,1,1,4,''xl43'','''',2
5,1,'''',1,1,1,5,''xl43'','''',2
5,1,'''',1,1,1,6,''xl43'','''',2
5,1,'''',1,1,1,7,''xl43'','''',2
5,1,'''',1,1,1,8,''xl43'','''',2
5,1,'''',1,1,1,9,''xl43'','''',2
5,1,'''',1,1,1,10,''xl109'','''',2
5,1,'''',1,1,1,11,''xl109'','''',2
5,1,'''',1,1,1,12,''xl109'','''',2
5,1,'''',1,1,1,13,''xl43'','''',2
5,1,'''',1,1,1,14,''xl43'','''',2
5,1,'''',1,1,1,15,''xl43'','''',2
5,1,'''',1,1,1,16,''xl43'','''',2
5,1,'''',1,1,1,17,''xl43'','''',2
5,1,''>>(<s_1>)'',1,1,1,18,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_2>)'',1,1,1,19,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,20,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,21,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_3>)'',1,1,1,22,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,23,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_4>)'',1,1,1,24,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,25,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_5>)'',1,1,1,26,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,27,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_6>)'',1,1,1,28,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,29,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_1>)'',1,1,1,30,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_2>)'',1,1,1,31,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,32,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,33,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_3>)'',1,1,1,34,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,35,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_4>)'',1,1,1,36,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,37,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_5>)'',1,1,1,38,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,39,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_6>)'',1,1,1,40,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,41,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_7>)'',1,1,1,42,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,43,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_8>)'',1,1,1,44,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,45,''xl72'',''"#,##0.00"'',2
5,1,''>>(<s_9>)'',1,1,1,46,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,47,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_7>)'',1,1,1,48,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,49,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_8>)'',1,1,1,50,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,51,''xl72'',''"#,##0.00"'',2
5,1,''>>(<k_9>)'',1,1,1,52,''xl72'',''"#,##0.00"'',2
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,53,''xl72'',''"#,##0.00"'',2
5,1,'''',1,1,1,54,''xl43'','''',2
5,1,'''',1,1,1,55,''xl22'','''',2
5,1,'''',1,1,1,56,''xl22'','''',2
6,1,''>>>{po2_n}'',1,1,1,1,''xl27'','''',2
6,1,''>>>{cpo2}'',1,1,1,2,''xl34'','''',2
6,1,'''',1,1,1,3,''xl43'','''',2
6,1,'''',1,1,1,4,''xl43'','''',2
6,1,'''',1,1,1,5,''xl43'','''',2
6,1,'''',1,1,1,6,''xl43'','''',2
6,1,'''',1,1,1,7,''xl43'','''',2
6,1,'''',1,1,1,8,''xl43'','''',2
6,1,'''',1,1,1,9,''xl43'','''',2
6,1,'''',1,1,1,10,''xl109'','''',2
6,1,'''',1,1,1,11,''xl109'','''',2
6,1,'''',1,1,1,12,''xl109'','''',2
6,1,'''',1,1,1,13,''xl43'','''',2
6,1,'''',1,1,1,14,''xl43'','''',2
6,1,'''',1,1,1,15,''xl43'','''',2
6,1,'''',1,1,1,16,''xl43'','''',2
6,1,'''',1,1,1,17,''xl43'','''',2
6,1,''>>(<s_1>)'',1,1,1,18,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_2>)'',1,1,1,19,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,20,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,21,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_3>)'',1,1,1,22,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,23,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_4>)'',1,1,1,24,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,25,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_5>)'',1,1,1,26,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,27,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_6>)'',1,1,1,28,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,29,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_1>)'',1,1,1,30,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_2>)'',1,1,1,31,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,32,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,33,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_3>)'',1,1,1,34,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,35,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_4>)'',1,1,1,36,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,37,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_5>)'',1,1,1,38,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,39,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_6>)'',1,1,1,40,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,41,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_7>)'',1,1,1,42,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,43,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_8>)'',1,1,1,44,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,45,''xl72'',''"#,##0.00"'',2
6,1,''>>(<s_9>)'',1,1,1,46,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,47,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_7>)'',1,1,1,48,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,49,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_8>)'',1,1,1,50,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,51,''xl72'',''"#,##0.00"'',2
6,1,''>>(<k_9>)'',1,1,1,52,''xl72'',''"#,##0.00"'',2
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,53,''xl72'',''"#,##0.00"'',2
6,1,'''',1,1,1,54,''xl43'','''',2
6,1,'''',1,1,1,55,''xl22'','''',2
6,1,'''',1,1,1,56,''xl22'','''',2
7,1,''>>>{po1_n}'',1,1,1,1,''xl27'','''',2
7,1,''>>>{cpo1}'',1,1,1,2,''xl34'','''',2
7,1,'''',1,1,1,3,''xl43'','''',2
7,1,'''',1,1,1,4,''xl43'','''',2
7,1,'''',1,1,1,5,''xl43'','''',2
7,1,'''',1,1,1,6,''xl43'','''',2
7,1,'''',1,1,1,7,''xl43'','''',2
7,1,'''',1,1,1,8,''xl43'','''',2
7,1,'''',1,1,1,9,''xl43'','''',2
7,1,'''',1,1,1,10,''xl109'','''',2
7,1,'''',1,1,1,11,''xl109'','''',2
7,1,'''',1,1,1,12,''xl109'','''',2
7,1,'''',1,1,1,13,''xl43'','''',2
7,1,'''',1,1,1,14,''xl43'','''',2
7,1,'''',1,1,1,15,''xl43'','''',2
7,1,'''',1,1,1,16,''xl43'','''',2
7,1,'''',1,1,1,17,''xl43'','''',2
7,1,''>>(<s_1>)'',1,1,1,18,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_2>)'',1,1,1,19,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,20,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,21,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_3>)'',1,1,1,22,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,23,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_4>)'',1,1,1,24,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,25,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_5>)'',1,1,1,26,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,27,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_6>)'',1,1,1,28,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,29,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_1>)'',1,1,1,30,''xl72'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 14, '7,1,''>>(<k_2>)'',1,1,1,31,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,32,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,33,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_3>)'',1,1,1,34,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,35,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_4>)'',1,1,1,36,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,37,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_5>)'',1,1,1,38,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,39,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_6>)'',1,1,1,40,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,41,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_7>)'',1,1,1,42,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,43,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_8>)'',1,1,1,44,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,45,''xl72'',''"#,##0.00"'',2
7,1,''>>(<s_9>)'',1,1,1,46,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,47,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_7>)'',1,1,1,48,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,49,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_8>)'',1,1,1,50,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,51,''xl72'',''"#,##0.00"'',2
7,1,''>>(<k_9>)'',1,1,1,52,''xl72'',''"#,##0.00"'',2
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,53,''xl72'',''"#,##0.00"'',2
7,1,'''',1,1,1,54,''xl43'','''',2
7,1,'''',1,1,1,55,''xl22'','''',2
7,1,'''',1,1,1,56,''xl22'','''',2
8,1,''>>>nvl({po_n};" ")&"\"'',1,1,1,1,''xl28'','''',2
8,1,''>>>nvl({cpo};" ")&"\"'',1,1,1,2,''xl36'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<nam_1>)'',1,1,1,3,''xl45'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<res_1>)'',1,1,1,4,''xl45'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<dat_1>)'',1,1,1,5,''xl45'','''',2
8,1,''>>>2(<lev1>;AA;<st>;1;<cod_1>)'',1,1,1,6,''xl45'','''',2
8,1,''>>>2(<lev2>;AA;<st>;1;<nam_2>)'',1,1,1,7,''xl45'','''',2
8,1,''>>>2(<lev2>;AA;<st>;1;<res_2>)'',1,1,1,8,''xl45'','''',2
8,1,''>>>2(<lev2>;AA;<st>;1;<dat_2>)'',1,1,1,9,''xl58'','''',2
8,1,''>>>2(<lev3>;AA;<st>;1;<nam_3>)'',1,1,1,10,''xl110'','''',2
8,1,''>>>2(<lev3>;AA;<st>;1;<res_3>)'',1,1,1,11,''xl110'','''',2
8,1,''>>>2(<lev3>;AA;<st>;1;<dat_3>)'',1,1,1,12,''xl115'','''',2
8,1,''>>nvl({cpog};" ")&"\"'',1,1,1,13,''xl60'','''',2
8,1,''>>2(<lev>;1;<st>;1;<cdiv>)'',1,1,1,14,''xl63'','''',2
8,1,''>>2(<lev>;1;<st>;1;<ctgt>)'',1,1,1,15,''xl63'','''',2
8,1,''>>2(<lev>;1;<st>;1;<cexp>)'',1,1,1,16,''xl63'','''',2
8,1,''>>2(<lev>;1;<st>;1;<citm>)'',1,1,1,17,''xl63'','''',2
8,1,''>>(<st>;1;<s_1>)'',1,1,1,18,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_2>)'',1,1,1,19,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_1>)'',1,1,1,20,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_2>)'',1,1,1,21,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_3>)'',1,1,1,22,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_3>)'',1,1,1,23,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_4>)'',1,1,1,24,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_4>)'',1,1,1,25,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_5>)'',1,1,1,26,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_5>)'',1,1,1,27,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_6>)'',1,1,1,28,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_6>)'',1,1,1,29,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_1>)'',1,1,1,30,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_2>)'',1,1,1,31,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_1>)'',1,1,1,32,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_2>)'',1,1,1,33,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_3>)'',1,1,1,34,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_3>)'',1,1,1,35,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_4>)'',1,1,1,36,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_4>)'',1,1,1,37,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_5>)'',1,1,1,38,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_5>)'',1,1,1,39,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_6>)'',1,1,1,40,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_6>)'',1,1,1,41,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_7>)'',1,1,1,42,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_7>)'',1,1,1,43,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_8>)'',1,1,1,44,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_8>)'',1,1,1,45,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<s_9>)'',1,1,1,46,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<s_9>)'',1,1,1,47,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_7>)'',1,1,1,48,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_7>)'',1,1,1,49,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_8>)'',1,1,1,50,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_8>)'',1,1,1,51,''xl73'',''"#,##0.00"'',2
8,1,''>>(<st>;1;<k_9>)'',1,1,1,52,''xl73'',''"#,##0.00"'',2
8,1,''>>2(<su>;AA;<st>;1;<k_9>)'',1,1,1,53,''xl73'',''"#,##0.00"'',2
8,1,''>>>2(<lev>;1;<st>;1;<metod>)'',1,1,1,54,''xl36'','''',2
8,1,'''',1,1,1,55,''xl22'','''',2
8,1,'''',1,1,1,56,''xl22'','''',2
9,1,''\'',1,1,1,1,''xl28'','''',2
9,1,''\'',1,1,1,2,''xl36'','''',2
9,1,''>>>(<lev1>;AA;<nam_1>)'',1,1,1,3,''xl45'','''',2
9,1,''>>>(<lev1>;AA;<res_1>)'',1,1,1,4,''xl45'','''',2
9,1,''>>>(<lev1>;AA;<dat_1>)'',1,1,1,5,''xl45'','''',2
9,1,''>>>(<lev1>;AA;<cod_1>)'',1,1,1,6,''xl45'','''',2
9,1,''>>>(<lev2>;AA;<nam_2>)'',1,1,1,7,''xl45'','''',2
9,1,''>>>(<lev2>;AA;<res_2>)'',1,1,1,8,''xl45'','''',2
9,1,''>>>(<lev2>;AA;<dat_2>)'',1,1,1,9,''xl58'','''',2
9,1,''>>>(<lev3>;AA;<nam_3>)'',1,1,1,10,''xl45'','''',2
9,1,''>>>(<lev3>;AA;<res_3>)'',1,1,1,11,''xl45'','''',2
9,1,''>>>(<lev3>;AA;<dat_3>)'',1,1,1,12,''xl58'','''',2
9,1,''\'',1,1,1,13,''xl60'','''',2
9,1,''>>(<lev>;1;<cdiv>)'',1,1,1,14,''xl63'','''',2
9,1,''>>(<lev>;1;<ctgt>)'',1,1,1,15,''xl63'','''',2
9,1,''>>(<lev>;1;<cexp>)'',1,1,1,16,''xl63'','''',2
9,1,''>>(<lev>;1;<citm>)'',1,1,1,17,''xl63'','''',2
9,1,''>>(<s_1>)'',1,1,1,18,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_2>)'',1,1,1,19,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_1>)'',1,1,1,20,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_2>)'',1,1,1,21,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_3>)'',1,1,1,22,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_3>)'',1,1,1,23,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_4>)'',1,1,1,24,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_4>)'',1,1,1,25,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_5>)'',1,1,1,26,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_5>)'',1,1,1,27,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_6>)'',1,1,1,28,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_6>)'',1,1,1,29,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_1>)'',1,1,1,30,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_2>)'',1,1,1,31,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_1>)'',1,1,1,32,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_2>)'',1,1,1,33,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_3>)'',1,1,1,34,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_3>)'',1,1,1,35,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_4>)'',1,1,1,36,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_4>)'',1,1,1,37,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_5>)'',1,1,1,38,''xl73'',''"#,##0.00"'',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 15, '9,1,''>>(<su>;AA;<k_5>)'',1,1,1,39,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_6>)'',1,1,1,40,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_6>)'',1,1,1,41,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_7>)'',1,1,1,42,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_7>)'',1,1,1,43,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_8>)'',1,1,1,44,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_8>)'',1,1,1,45,''xl73'',''"#,##0.00"'',2
9,1,''>>(<s_9>)'',1,1,1,46,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<s_9>)'',1,1,1,47,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_7>)'',1,1,1,48,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_7>)'',1,1,1,49,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_8>)'',1,1,1,50,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_8>)'',1,1,1,51,''xl73'',''"#,##0.00"'',2
9,1,''>>(<k_9>)'',1,1,1,52,''xl73'',''"#,##0.00"'',2
9,1,''>>(<su>;AA;<k_9>)'',1,1,1,53,''xl73'',''"#,##0.00"'',2
9,1,''>>>(<lev>;1;<metod>)'',1,1,1,54,''xl36'','''',2
9,1,''>>st'',1,1,1,55,''xl95'','''',2
9,1,'''',1,1,1,56,''xl22'','''',2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=1;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=1;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=1'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=1;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,'''',1,1,0,0,0,'''',''''
2,'''',0,0,0,1,0,'''',''''
3,''po5c'',0,0,0,0,0,''>>(nvl({list};0)=2;{poc}<>{po5c})'',''''
4,''po4c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po4c};{poc}<>{po4c})'',''''
5,''po3c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po3c};{po4c}<>{po3c};{poc}<>{po3c})'',''''
6,''po2c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po2c};{po4c}<>{po2c};{po3c}<>{po2c};{poc}<>{po2c})'',''''
7,''po1c'',0,0,0,0,0,''>>(nvl({list};0)=2;{po5c}<>{po1c};{po4c}<>{po1c};{po3c}<>{po1c};{po2c}<>{po1c};{poc}<>{po1c})'',''''
8,''poc'',0,0,0,0,0,''>>nvl({list};0)=2'',''''
9,''st'',0,0,0,0,0,''>>(nvl({list};0)=2;nvl({st};0)>1)'',''''
0,'''',0,0,0,0,0,'''',''''
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_GROUPS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '35.33,195
4.56,28.8
33.67,186
8.22,48.6
7.89,46.8
6.11,37.2
33.67,186
8.22,48.6
8.11,48
4.89,30.6
4.33,27.6
10.11,58.8
3.89,25.2
5.89,36
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '35.11,193.8
4.56,28.8
33.67,186
8.22,48.6
7.89,46.8
6.11,37.2
33.67,186
8.22,48.6
8.11,48
32.89,181.8
8.33,49.2
8.11,48
4.89,30.6
4.33,27.6
10.11,58.8
3.89,25.2
5.89,36
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
11.89,68.4
8.33,49.2
8.33,49.2
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_COLUMNS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '<html xmlns:v="urn:schemas-microsoft-com:vml" xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
<meta name=ProgId content=Excel.Sheet>
<meta http-equiv=Content-Type content="text/html; charset=windows-1251">
<link rel=Stylesheet href=stylesheet.css>
<style>
<!--table
	{mso-displayed-decimal-separator:"\,";
	mso-displayed-thousand-separator:" ";}
@page
	{margin:.3541667in .1965278in .3541667in .2756945in;
	mso-header-margin:0in;
	mso-footer-margin:0in;
	mso-header-data:"&C&8&P";
	mso-page-orientation:landscape;

	mso-page-footerFirst:differentFirst;

	mso-first-footer-data:"";
	mso-first-header-data:"";}
-->
</style>
<!--[if gte mso 9]><xml>
	<x:WorksheetOptions>
     <x:FitToPage/>
     <x:Print>
     <x:FitWidth>1</x:FitWidth>
     <x:FitHeight>0</x:FitHeight>
     <x:SheetScale>85</x:SheetScale>
     <x:PaperSizeIndex>9</x:PaperSizeIndex>
      <x:ValidPrinterInfo/>
	</x:Print>
     <x:DoNotDisplayGridlines/>
    </x:WorksheetOptions>
</xml><![endif]-->
</head>
<body>
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_HEADER')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,51
9,1,22.5
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.5
1,1,11.25
1,1,27
1,1,14.25
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,1,13.2
1,2,22.5
1,2,22.5
1,2,13.2
1,2,13.2
0,1,13.2
2,1,10.5
3,1,22.5
4,1,22.5
5,1,22.5
6,1,22.5
7,1,22.5
8,1,51
9,1,22.5
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_ROWS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 0, 'tr
	{mso-height-source:auto;}
col
	{mso-width-source:auto;}
br
	{mso-data-placement:same-cell;}
.style0
	{font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;
	mso-style-name:;
	mso-style-id:0;}
td
	{mso-style-parent:style0;
	padding-top:1px;padding-right:1px;padding-left:1px;mso-ignore:padding;
	font-family:"Arial Cyr";
	font-size:10pt;
	font-style:normal;
	font-weight:400;
	mso-number-format:"";
	mso-text-control:;
	text-align:general;
	text-decoration:none;
	vertical-align:bottom;
	white-space:nowrap;
	mso-rotate:0;
	mso-background-source:auto;
	color:windowtext;
	mso-generic-font-family:auto;
	mso-font-charset:204;
	border:none;
	mso-pattern:auto none;
	mso-protection:locked visible;}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 21, '.xl21
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 22, '.xl22
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 23, '.xl23
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 24, '.xl24
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 25, '.xl25
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 26, '.xl26
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 27, '.xl27
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 28, '.xl28
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 29, '.xl29
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 30, '.xl30
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 31, '.xl31
	{mso-style-parent:style0;
	text-align:left;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 32, '.xl32
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 33, '.xl33
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 34, '.xl34
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 35, '.xl35
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 36, '.xl36
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 37, '.xl37
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 38, '.xl38
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 39, '.xl39
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 40, '.xl40
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 41, '.xl41
	{mso-style-parent:style0;
	font-size:8pt;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 42, '.xl42
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 43, '.xl43
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 44, '.xl44
	{mso-style-parent:style0;
	mso-number-format:"@";
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 45, '.xl45
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 46, '.xl46
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 47, '.xl47
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 48, '.xl48
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 49, '.xl49
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 50, '.xl50
	{mso-style-parent:style0;
	mso-text-control:shrinktofit;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 51, '.xl51
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 52, '.xl52
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 53, '.xl53
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 54, '.xl54
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 55, '.xl55
	{mso-style-parent:style0;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 56, '.xl56
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 57, '.xl57
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 58, '.xl58
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 59, '.xl59
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 60, '.xl60
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 61, '.xl61
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 62, '.xl62
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 63, '.xl63
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 64, '.xl64
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:;
	border-right:;
	border-top:.5pt solid #000;
	background: #C0C0C0;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 65, '.xl65
	{mso-style-parent:style0;
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 66, '.xl66
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 67, '.xl67
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 68, '.xl68
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 69, '.xl69
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 70, '.xl70
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 71, '.xl71
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 72, '.xl72
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 73, '.xl73
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 74, '.xl74
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 75, '.xl75
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 76, '.xl76
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 77, '.xl77
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 78, '.xl78
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 79, '.xl79
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 80, '.xl80
	{mso-style-parent:style0;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 81, '.xl81
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 82, '.xl82
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 83, '.xl83
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 84, '.xl84
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 85, '.xl85
	{mso-style-parent:style0;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 86, '.xl86
	{mso-style-parent:style0;
	font-family:"Times New Roman Cyr";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 87, '.xl87
	{mso-style-parent:style0;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 88, '.xl88
	{mso-style-parent:style0;
	font-size:8pt;
	text-decoration:underline;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 89, '.xl89
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 90, '.xl90
	{mso-style-parent:style0;
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 91, '.xl91
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 92, '.xl92
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 93, '.xl93
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 94, '.xl94
	{mso-style-parent:style0;
	mso-number-format:"@";
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 95, '.xl95
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	mso-text-control:shrinktofit;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:.5pt solid #000;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 96, '.xl96
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 97, '.xl97
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:left;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 98, '.xl98
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 99, '.xl99
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"@";
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 100, '.xl100
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 101, '.xl101
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 102, '.xl102
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 103, '.xl103
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 104, '.xl104
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 105, '.xl105
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 106, '.xl106
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 107, '.xl107
	{mso-style-parent:style0;
	font-size:8pt;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:;
	border-left:;
	border-right:;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 108, '.xl108
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 109, '.xl109
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 110, '.xl110
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 111, '.xl111
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 112, '.xl112
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 113, '.xl113
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 114, '.xl114
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 115, '.xl115
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 116, '.xl116
	{mso-style-parent:style0;
	font-size:8pt;
	text-align:center;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:.5pt solid #000;
	border-left:;
	border-right:;
	border-top:;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 117, '.xl117
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 118, '.xl118
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 119, '.xl119
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 120, '.xl120
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 121, '.xl121
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 122, '.xl122
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 123, '.xl123
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	font-weight:700;
	mso-number-format:"#,##0.00";
	mso-text-control:shrinktofit;
	text-align:right;
	vertical-align:top;
	mso-protection:locked visible;
	border-bottom:1.0pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:;
	background: #FFFFFF;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 124, '.xl124
	{mso-style-parent:style0;
	font-family:"Times New Roman";
	font-size:8pt;
	mso-number-format:"@";
	text-align:center;
	vertical-align:middle;
	mso-protection:locked visible;
	white-space:normal;
	border-bottom:.5pt solid #000;
	border-left:.5pt solid #000;
	border-right:.5pt solid #000;
	border-top:.5pt solid #000;
	}
', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_HTM_STYLES')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '||list=1|list,poc,st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_PROP')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '||list=2|list,poc,st|0||&C&8&P|||||||1', 'SYS_XL_sqr_rro_34n_kbk', 'XL_REPORT_PROP')

GO
		

	CREATE TABLE #T_OBJECT (LINK int, CODE varchar(100), NAME varchar(254), ORDERS int, LINK_SELF int, LINK_CLASS int, CODE_SELF varchar(100), CODE_CLASS varchar(100))



GO
		

	CREATE TABLE #T_GROUPS (GROUP_NAME varchar(250), NAME varchar(254), CODE_OBJ varchar(50), IMAGE_ID int, SQ_CODE varchar(100), GATE_CODE varchar(50), GDIR_CODE varchar(50), STAT int)



GO
		

	EXECUTE M_UPDATE_SQUERY '#T_OBJ','#T_PROP','#T_OBJECT','#T_GROUPS'

	DROP TABLE #T_OBJ
	DROP TABLE #T_PROP
	DROP TABLE #T_OBJECT
	DROP TABLE #T_GROUPS
	exec dtt '#t_xlrep_'

--end squery

GO




-- XL_REPORT-SYS_XL_sqr_rro_34n_kbk_dep.sql

--squery
--KS-1063\katyakov 29.01.2025

--%OBJECT%SYS_XL_sqr_rro_34n_kbk_dep%%
-- : sqr_rro_34n_kbk_dep.xlt

if object_id('tempdb..#T_OBJ') is not null drop table #T_OBJ
if object_id('tempdb..#T_PROP') is not null drop table #T_PROP
if object_id('tempdb..#T_OBJECT') is not null drop table #T_OBJECT
if object_id('tempdb..#T_GROUPS') is not null drop table #T_GROUPS

GO


	CREATE TABLE #T_OBJ (LINK int, NAME varchar(254), OBJECT int, CODE varchar(100), USERS int, ORDERS int, LINK_SELF int, LINK_STATE int, CODE_OBJ varchar(100), CODE_SELF varchar(100), CODE_STATE varchar(100))


	INSERT INTO #T_OBJ (NAME, CODE, USERS, ORDERS, CODE_OBJ, CODE_SELF, CODE_STATE) VALUES ('sqr_rro_34n_kbk_dep.xlt', 'SYS_XL_sqr_rro_34n_kbk_dep', null, null, 'XL_REPORT', null, null)

GO
		

	CREATE TABLE #T_PROP (LINK_UP int, PROPERTY int, USERS int, ORDERS int, VALUE nvarchar(max), CODE_UP varchar(100), CODE_PROP varchar(100))


	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, 'katyakov', 'SYS_XL_sqr_rro_34n_kbk_dep', 'SQUERY_AUTHOR')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, null, '2025-01-29 15:38:19.117', 'SYS_XL_sqr_rro_34n_kbk_dep', 'SQUERY_DATETIME')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 1, '1,1,'''',1,1,1,1,''xl22'','''',1
1,1,'''',1,1,1,2,''xl22'','''',1
1,1,'''',1,1,1,3,''xl22'','''',1
1,1,'''',1,1,1,4,''xl22'','''',1
1,1,'''',1,1,1,5,''xl22'','''',1
1,1,'''',1,1,1,6,''xl22'','''',1
1,1,'''',1,1,1,7,''xl22'','''',1
1,1,'''',1,1,1,8,''xl22'','''',1
1,1,'''',1,1,1,9,''xl22'','''',1
1,1,'''',1,1,1,10,''xl22'','''',1
1,1,'''',1,1,1,11,''xl22'','''',1
1,1,'''',1,1,1,12,''xl22'','''',1
1,1,'''',1,1,1,13,''xl22'','''',1
1,1,'''',1,1,1,14,''xl22'','''',1
1,1,'''',1,1,1,15,''xl22'','''',1
1,1,'''',1,1,1,16,''xl22'','''',1
1,1,'''',1,1,1,17,''xl22'','''',1
1,1,'''',1,1,1,18,''xl22'','''',1
1,1,'''',1,1,1,19,''xl22'','''',1
1,1,'''',1,1,1,20,''xl22'','''',1
1,1,'''',1,1,1,21,''xl22'','''',1
1,1,'''',1,1,1,22,''xl22'','''',1
1,1,'''',1,1,1,23,''xl22'','''',1
1,1,'''',1,1,1,24,''xl22'','''',1
1,1,'''',1,1,1,25,''xl22'','''',1
1,1,'''',1,1,1,26,''xl22'','''',1
1,1,'''',1,1,1,27,''xl22'','''',1
1,1,'''',1,1,1,28,''xl91'','''',1
1,1,'''',1,1,1,29,''xl91'','''',1
1,1,'''',1,1,1,30,''xl91'','''',1
1,1,'''',1,1,1,31,''xl91'','''',1
1,1,'''',1,1,1,32,''xl91'','''',1
1,1,'''',1,1,1,33,''xl91'','''',1
1,1,'''',1,1,1,34,''xl91'','''',1
1,1,'''',1,1,1,35,''xl22'','''',1
1,1,'''',1,1,1,36,''xl94'','''',1
1,1,'''',1,1,1,37,''xl94'','''',1
1,1,'''',1,1,1,38,''xl94'','''',1
1,1,'''',1,1,1,39,''xl94'','''',1
1,1,'''',1,1,1,40,''xl23'','''',1
1,1,'''',1,1,1,41,''xl94'','''',1
1,1,'''',1,1,1,42,''xl94'','''',1
1,1,'''',1,1,1,43,''xl94'','''',1
1,1,'''',1,1,1,44,''xl94'','''',1
1,1,'''',1,1,1,45,''xl94'','''',1
1,1,'''',1,1,1,46,''xl94'','''',1
1,1,'''',1,1,1,47,''xl94'','''',1
1,1,'''',1,1,1,48,''xl94'','''',1
1,1,'''',1,1,1,49,''xl94'','''',1
1,1,'''',1,1,1,50,''xl94'','''',1
1,1,'''',1,1,1,51,''xl94'','''',1
1,1,'''',1,1,1,52,''xl94'','''',1
1,1,'''',1,1,1,53,''xl94'','''',1
1,1,''>>"#/"'',1,1,1,54,''xl97'','''',1
1,1,'''',1,1,1,55,''xl22'','''',1
1,1,'''',1,1,2,1,''xl22'','''',1
1,1,'''',1,1,2,2,''xl22'','''',1
1,1,'''',1,1,2,3,''xl22'','''',1
1,1,'''',1,1,2,4,''xl22'','''',1
1,1,'''',1,1,2,5,''xl22'','''',1
1,1,'''',1,1,2,6,''xl22'','''',1
1,1,'''',1,1,2,7,''xl22'','''',1
1,1,'''',1,1,2,8,''xl22'','''',1
1,1,'''',1,1,2,9,''xl22'','''',1
1,1,'''',1,1,2,10,''xl22'','''',1
1,1,'''',1,1,2,11,''xl22'','''',1
1,1,'''',1,1,2,12,''xl22'','''',1
1,1,'''',1,1,2,13,''xl22'','''',1
1,1,'''',1,1,2,14,''xl22'','''',1
1,1,'''',1,1,2,15,''xl22'','''',1
1,1,'''',1,1,2,16,''xl22'','''',1
1,1,'''',1,1,2,17,''xl22'','''',1
1,1,'''',1,1,2,18,''xl22'','''',1
1,1,'''',1,1,2,19,''xl22'','''',1
1,1,'''',1,1,2,20,''xl22'','''',1
1,1,'''',1,1,2,21,''xl22'','''',1
1,1,'''',1,1,2,22,''xl22'','''',1
1,1,'''',1,1,2,23,''xl22'','''',1
1,1,'''',1,1,2,24,''xl22'','''',1
1,1,'''',1,1,2,25,''xl22'','''',1
1,1,'''',1,1,2,26,''xl22'','''',1
1,1,'''',1,1,2,27,''xl22'','''',1
1,1,'''',1,1,2,28,''xl91'','''',1
1,1,'''',1,1,2,29,''xl91'','''',1
1,1,'''',1,1,2,30,''xl91'','''',1
1,1,'''',1,1,2,31,''xl91'','''',1
1,1,'''',1,1,2,32,''xl91'','''',1
1,1,'''',1,1,2,33,''xl91'','''',1
1,1,'''',1,1,2,34,''xl91'','''',1
1,1,'''',1,1,2,35,''xl22'','''',1
1,1,'''',1,1,2,36,''xl94'','''',1
1,1,'''',1,1,2,37,''xl94'','''',1
1,1,'''',1,1,2,38,''xl94'','''',1
1,1,'''',1,1,2,39,''xl94'','''',1
1,1,'''',1,1,2,40,''xl23'','''',1
1,1,'''',1,1,2,41,''xl94'','''',1
1,1,'''',1,1,2,42,''xl94'','''',1
1,1,'''',1,1,2,43,''xl94'','''',1
1,1,'''',1,1,2,44,''xl94'','''',1
1,1,'''',1,1,2,45,''xl94'','''',1
1,1,'''',1,1,2,46,''xl94'','''',1
1,1,'''',1,1,2,47,''xl94'','''',1
1,1,'''',1,1,2,48,''xl94'','''',1
1,1,'''',1,1,2,49,''xl94'','''',1
1,1,'''',1,1,2,50,''xl94'','''',1
1,1,'''',1,1,2,51,''xl94'','''',1
1,1,'''',1,1,2,52,''xl94'','''',1
1,1,'''',1,1,2,53,''xl94'','''',1
1,1,'''',1,1,2,54,''xl22'','''',1
1,1,'''',1,1,2,55,''xl22'','''',1
1,1,''     '',1,26,3,1,''xl89'','''',1
1,1,'''',1,1,3,27,''xl91'','''',1
1,1,'''',1,1,3,28,''xl84'','''',1
1,1,'''',1,1,3,29,''xl84'','''',1
1,1,'''',1,1,3,30,''xl84'','''',1
1,1,'''',1,1,3,31,''xl84'','''',1
1,1,'''',1,1,3,32,''xl84'','''',1
1,1,'''',1,1,3,33,''xl84'','''',1
1,1,'''',1,1,3,34,''xl84'','''',1
1,1,'''',1,1,3,35,''xl22'','''',1
1,1,'''',1,1,3,36,''xl94'','''',1
1,1,'''',1,1,3,37,''xl94'','''',1
1,1,'''',1,1,3,38,''xl94'','''',1
1,1,'''',1,1,3,39,''xl94'','''',1
1,1,'''',1,1,3,40,''xl23'','''',1
1,1,'''',1,1,3,41,''xl94'','''',1
1,1,'''',1,1,3,42,''xl94'','''',1
1,1,'''',1,1,3,43,''xl94'','''',1
1,1,'''',1,1,3,44,''xl94'','''',1
1,1,'''',1,1,3,45,''xl94'','''',1
1,1,'''',1,1,3,46,''xl94'','''',1
1,1,'''',1,1,3,47,''xl94'','''',1
1,1,'''',1,1,3,48,''xl94'','''',1
1,1,'''',1,1,3,49,''xl94'','''',1
1,1,'''',1,1,3,50,''xl94'','''',1
1,1,'''',1,1,3,51,''xl94'','''',1
1,1,'''',1,1,3,52,''xl94'','''',1
1,1,'''',1,1,3,53,''xl94'','''',1
1,1,'''',1,1,3,54,''xl22'','''',1
1,1,'''',1,1,3,55,''xl22'','''',1
1,1,''>>" "&(dDate_2+1;0)&"."'',1,26,4,1,''xl47'','''',1
1,1,'''',1,1,4,27,''xl47'','''',1
1,1,'''',1,1,4,28,''xl47'','''',1
1,1,'''',1,1,4,29,''xl47'','''',1
1,1,'''',1,1,4,30,''xl47'','''',1
1,1,'''',1,1,4,31,''xl47'','''',1
1,1,'''',1,1,4,32,''xl47'','''',1
1,1,'''',1,1,4,33,''xl47'','''',1
1,1,'''',1,1,4,34,''xl47'','''',1
1,1,'''',1,1,4,35,''xl22'','''',1
1,1,'''',1,1,4,36,''xl94'','''',1
1,1,'''',1,1,4,37,''xl94'','''',1
1,1,'''',1,1,4,38,''xl94'','''',1
1,1,'''',1,1,4,39,''xl94'','''',1
1,1,'''',1,1,4,40,''xl23'','''',1
1,1,'''',1,1,4,41,''xl94'','''',1
1,1,'''',1,1,4,42,''xl94'','''',1
1,1,'''',1,1,4,43,''xl94'','''',1
1,1,'''',1,1,4,44,''xl94'','''',1
1,1,'''',1,1,4,45,''xl94'','''',1
1,1,'''',1,1,4,46,''xl94'','''',1
1,1,'''',1,1,4,47,''xl94'','''',1
1,1,'''',1,1,4,48,''xl94'','''',1
1,1,'''',1,1,4,49,''xl94'','''',1
1,1,'''',1,1,4,50,''xl94'','''',1
1,1,'''',1,1,4,51,''xl94'','''',1
1,1,'''',1,1,4,52,''xl94'','''',1
1,1,'''',1,1,4,53,''xl94'','''',1
1,1,'''',1,1,4,54,''xl22'','''',1
1,1,'''',1,1,4,55,''xl22'','''',1
1,1,'''',1,1,5,1,''xl22'','''',1
1,1,'''',1,1,5,2,''xl22'','''',1
1,1,'''',1,1,5,3,''xl22'','''',1
1,1,'''',1,1,5,4,''xl22'','''',1
1,1,'''',1,1,5,5,''xl22'','''',1
1,1,'''',1,1,5,6,''xl22'','''',1
1,1,'''',1,1,5,7,''xl22'','''',1
1,1,'''',1,1,5,8,''xl41'','''',1
1,1,'''',1,1,5,9,''xl41'','''',1
1,1,'''',1,1,5,10,''xl41'','''',1
1,1,'''',1,1,5,11,''xl32'','''',1
1,1,'''',1,1,5,12,''xl32'','''',1
1,1,'''',1,1,5,13,''xl32'','''',1
1,1,'''',1,1,5,14,''xl32'','''',1
1,1,'''',1,1,5,15,''xl32'','''',1
1,1,'''',1,1,5,16,''xl41'','''',1
1,1,'''',1,1,5,17,''xl41'','''',1
1,1,'''',1,1,5,18,''xl41'','''',1
1,1,'''',1,1,5,19,''xl41'','''',1
1,1,'''',1,1,5,20,''xl41'','''',1
1,1,'''',1,1,5,21,''xl41'','''',1
1,1,'''',1,1,5,22,''xl84'','''',1
1,1,'''',1,1,5,23,''xl84'','''',1
1,1,'''',1,1,5,24,''xl84'','''',1
1,1,'''',1,1,5,25,''xl84'','''',1
1,1,'''',1,1,5,26,''xl41'','''',1
1,1,'''',1,1,5,27,''xl41'','''',1
1,1,'''',1,1,5,28,''xl41'','''',1
1,1,'''',1,1,5,29,''xl41'','''',1
1,1,'''',1,1,5,30,''xl41'','''',1
1,1,'''',1,1,5,31,''xl41'','''',1
1,1,'''',1,1,5,32,''xl41'','''',1
1,1,'''',1,1,5,33,''xl41'','''',1
1,1,'''',1,1,5,34,''xl41'','''',1
1,1,'''',1,1,5,35,''xl22'','''',1
1,1,'''',1,1,5,36,''xl94'','''',1
1,1,'''',1,1,5,37,''xl94'','''',1
1,1,'''',1,1,5,38,''xl94'','''',1
1,1,'''',1,1,5,39,''xl94'','''',1
1,1,'''',1,1,5,40,''xl23'','''',1
1,1,'''',1,1,5,41,''xl94'','''',1
1,1,'''',1,1,5,42,''xl94'','''',1
1,1,'''',1,1,5,43,''xl94'','''',1
1,1,'''',1,1,5,44,''xl94'','''',1
1,1,'''',1,1,5,45,''xl94'','''',1
1,1,'''',1,1,5,46,''xl94'','''',1
1,1,'''',1,1,5,47,''xl94'','''',1
1,1,'''',1,1,5,48,''xl94'','''',1
1,1,'''',1,1,5,49,''xl94'','''',1
1,1,'''',1,1,5,50,''xl94'','''',1
1,1,'''',1,1,5,51,''xl94'','''',1
1,1,'''',1,1,5,52,''xl94'','''',1
1,1,'''',1,1,5,53,''xl94'','''',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 2, '1,1,'''',1,1,5,54,''xl22'','''',1
1,1,'''',1,1,5,55,''xl22'','''',1
1,1,''        '',1,1,6,1,''xl23'','''',1
1,1,''$$select name from c_data1 where list=1#name#name#NN'',1,27,6,2,''xl92'','''',1
1,1,'''',1,1,6,29,''xl41'','''',1
1,1,'''',1,1,6,30,''xl41'','''',1
1,1,'''',1,1,6,31,''xl41'','''',1
1,1,'''',1,1,6,32,''xl41'','''',1
1,1,'''',1,1,6,33,''xl41'','''',1
1,1,'''',1,1,6,34,''xl41'','''',1
1,1,'''',1,1,6,35,''xl22'','''',1
1,1,'''',1,1,6,36,''xl94'','''',1
1,1,'''',1,1,6,37,''xl94'','''',1
1,1,'''',1,1,6,38,''xl94'','''',1
1,1,'''',1,1,6,39,''xl94'','''',1
1,1,'''',1,1,6,40,''xl23'','''',1
1,1,'''',1,1,6,41,''xl94'','''',1
1,1,'''',1,1,6,42,''xl94'','''',1
1,1,'''',1,1,6,43,''xl94'','''',1
1,1,'''',1,1,6,44,''xl94'','''',1
1,1,'''',1,1,6,45,''xl94'','''',1
1,1,'''',1,1,6,46,''xl94'','''',1
1,1,'''',1,1,6,47,''xl94'','''',1
1,1,'''',1,1,6,48,''xl94'','''',1
1,1,'''',1,1,6,49,''xl94'','''',1
1,1,'''',1,1,6,50,''xl94'','''',1
1,1,'''',1,1,6,51,''xl94'','''',1
1,1,'''',1,1,6,52,''xl94'','''',1
1,1,'''',1,1,6,53,''xl94'','''',1
1,1,'''',1,1,6,54,''xl22'','''',1
1,1,'''',1,1,6,55,''xl22'','''',1
1,1,''  '',1,1,7,1,''xl23'','''',1
1,1,''$$select name from c_data2#name#name#NN'',1,27,7,2,''xl92'','''',1
1,1,'''',1,1,7,29,''xl41'','''',1
1,1,'''',1,1,7,30,''xl41'','''',1
1,1,'''',1,1,7,31,''xl41'','''',1
1,1,'''',1,1,7,32,''xl41'','''',1
1,1,'''',1,1,7,33,''xl41'','''',1
1,1,'''',1,1,7,34,''xl41'','''',1
1,1,'''',1,1,7,35,''xl41'','''',1
1,1,'''',1,1,7,36,''xl41'','''',1
1,1,'''',1,1,7,37,''xl41'','''',1
1,1,'''',1,1,7,38,''xl41'','''',1
1,1,'''',1,1,7,39,''xl41'','''',1
1,1,'''',1,1,7,40,''xl23'','''',1
1,1,'''',1,1,7,41,''xl41'','''',1
1,1,'''',1,1,7,42,''xl41'','''',1
1,1,'''',1,1,7,43,''xl41'','''',1
1,1,'''',1,1,7,44,''xl41'','''',1
1,1,'''',1,1,7,45,''xl41'','''',1
1,1,'''',1,1,7,46,''xl41'','''',1
1,1,'''',1,1,7,47,''xl41'','''',1
1,1,'''',1,1,7,48,''xl41'','''',1
1,1,'''',1,1,7,49,''xl41'','''',1
1,1,'''',1,1,7,50,''xl41'','''',1
1,1,'''',1,1,7,51,''xl41'','''',1
1,1,'''',1,1,7,52,''xl41'','''',1
1,1,'''',1,1,7,53,''xl41'','''',1
1,1,'''',1,1,7,54,''xl22'','''',1
1,1,'''',1,1,7,55,''xl22'','''',1
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,28,8,1,''xl93'','''',1
1,1,'''',1,1,8,29,''xl41'','''',1
1,1,'''',1,1,8,30,''xl41'','''',1
1,1,'''',1,1,8,31,''xl41'','''',1
1,1,'''',1,1,8,32,''xl41'','''',1
1,1,'''',1,1,8,33,''xl41'','''',1
1,1,'''',1,1,8,34,''xl41'','''',1
1,1,'''',1,1,8,35,''xl41'','''',1
1,1,'''',1,1,8,36,''xl41'','''',1
1,1,'''',1,1,8,37,''xl41'','''',1
1,1,'''',1,1,8,38,''xl41'','''',1
1,1,'''',1,1,8,39,''xl41'','''',1
1,1,'''',1,1,8,40,''xl41'','''',1
1,1,'''',1,1,8,41,''xl41'','''',1
1,1,'''',1,1,8,42,''xl41'','''',1
1,1,'''',1,1,8,43,''xl41'','''',1
1,1,'''',1,1,8,44,''xl41'','''',1
1,1,'''',1,1,8,45,''xl41'','''',1
1,1,'''',1,1,8,46,''xl41'','''',1
1,1,'''',1,1,8,47,''xl41'','''',1
1,1,'''',1,1,8,48,''xl41'','''',1
1,1,'''',1,1,8,49,''xl41'','''',1
1,1,'''',1,1,8,50,''xl41'','''',1
1,1,'''',1,1,8,51,''xl41'','''',1
1,1,'''',1,1,8,52,''xl41'','''',1
1,1,'''',1,1,8,53,''xl41'','''',1
1,1,'''',1,1,8,54,''xl22'','''',1
1,1,'''',1,1,8,55,''xl22'','''',1
1,1,'''',1,1,9,1,''xl23'','''',1
1,1,'''',1,1,9,2,''xl32'','''',1
1,1,'''',1,1,9,3,''xl41'','''',1
1,1,'''',1,1,9,4,''xl41'','''',1
1,1,'''',1,1,9,5,''xl41'','''',1
1,1,'''',1,1,9,6,''xl41'','''',1
1,1,'''',1,1,9,7,''xl41'','''',1
1,1,'''',1,1,9,8,''xl41'','''',1
1,1,'''',1,1,9,9,''xl41'','''',1
1,1,'''',1,1,9,10,''xl41'','''',1
1,1,'''',1,1,9,11,''xl32'','''',1
1,1,'''',1,1,9,12,''xl32'','''',1
1,1,'''',1,1,9,13,''xl32'','''',1
1,1,'''',1,1,9,14,''xl32'','''',1
1,1,'''',1,1,9,15,''xl32'','''',1
1,1,'''',1,1,9,16,''xl41'','''',1
1,1,'''',1,1,9,17,''xl41'','''',1
1,1,'''',1,1,9,18,''xl41'','''',1
1,1,'''',1,1,9,19,''xl41'','''',1
1,1,'''',1,1,9,20,''xl41'','''',1
1,1,'''',1,1,9,21,''xl41'','''',1
1,1,'''',1,1,9,22,''xl41'','''',1
1,1,'''',1,1,9,23,''xl41'','''',1
1,1,'''',1,1,9,24,''xl41'','''',1
1,1,'''',1,1,9,25,''xl41'','''',1
1,1,'''',1,1,9,26,''xl41'','''',1
1,1,'''',1,1,9,27,''xl41'','''',1
1,1,'''',1,1,9,28,''xl41'','''',1
1,1,'''',1,1,9,29,''xl41'','''',1
1,1,'''',1,1,9,30,''xl41'','''',1
1,1,'''',1,1,9,31,''xl41'','''',1
1,1,'''',1,1,9,32,''xl41'','''',1
1,1,'''',1,1,9,33,''xl41'','''',1
1,1,'''',1,1,9,34,''xl41'','''',1
1,1,'''',1,1,9,35,''xl41'','''',1
1,1,'''',1,1,9,36,''xl41'','''',1
1,1,'''',1,1,9,37,''xl41'','''',1
1,1,'''',1,1,9,38,''xl41'','''',1
1,1,'''',1,1,9,39,''xl41'','''',1
1,1,'''',1,1,9,40,''xl41'','''',1
1,1,'''',1,1,9,41,''xl41'','''',1
1,1,'''',1,1,9,42,''xl41'','''',1
1,1,'''',1,1,9,43,''xl41'','''',1
1,1,'''',1,1,9,44,''xl41'','''',1
1,1,'''',1,1,9,45,''xl41'','''',1
1,1,'''',1,1,9,46,''xl41'','''',1
1,1,'''',1,1,9,47,''xl41'','''',1
1,1,'''',1,1,9,48,''xl41'','''',1
1,1,'''',1,1,9,49,''xl41'','''',1
1,1,'''',1,1,9,50,''xl41'','''',1
1,1,'''',1,1,9,51,''xl41'','''',1
1,1,'''',1,1,9,52,''xl41'','''',1
1,1,'''',1,1,9,53,''xl41'','''',1
1,1,'''',1,1,9,54,''xl22'','''',1
1,1,'''',1,1,9,55,''xl22'','''',1
1,1,''>>>" , chr(10)  "&cText_35'',10,1,10,1,''xl24'','''',1
1,1,'' '',10,1,10,2,''xl33'','''',1
1,1,''>>>"    ,   "&cText_35'',2,7,10,3,''xl57'','''',1
1,1,''  ,  '',10,1,10,10,''xl60'','''',1
1,1,''    '',4,6,10,11,''xl71'','''',1
1,1,''>>>"      "&cText_35'',3,12,10,17,''xl79'','''',1
1,1,''>>>" ..       "&cText_35&"           () "'',3,12,10,29,''xl79'','''',1
1,1,''>>>"    () "&cText_35'',3,6,10,41,''xl79'','''',1
1,1,''>>>" ..     () "&cText_35&"           () "'',3,6,10,47,''xl79'','''',1
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,10,53,''xl95'','''',1
1,1,'''',1,1,10,54,''xl98'','''',1
1,1,'''',1,1,10,55,''xl98'','''',1
1,1,'''',1,1,11,54,''xl98'','''',1
1,1,'''',1,1,11,55,''xl98'','''',1
1,1,'' '',1,4,12,3,''xl52'','''',1
1,1,''>>>cText_35'',1,3,12,7,''xl52'','''',1
1,1,'''',1,1,12,54,''xl98'','''',1
1,1,'''',1,1,12,55,''xl98'','''',1
1,1,''&&select orders,name from c_data3 order by orders#name#orders#AA'',1,4,13,3,''xl52'','''',1
1,1,''&&select orders,name from c_data4 order by orders#name#orders#AA'',1,3,13,7,''xl52'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,17,''xl79'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,21,''xl79'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,23,''xl79'','''',1
1,1,'' '',1,4,13,25,''xl79'','''',1
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,13,29,''xl79'','''',1
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,13,33,''xl79'','''',1
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,13,35,''xl79'','''',1
1,1,'' '',1,4,13,37,''xl79'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,41,''xl79'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,43,''xl79'','''',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 3, '1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,45,''xl79'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/")'',1,2,13,47,''xl79'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10;"0")&" .";"#/")'',1,2,13,49,''xl79'','''',1
1,1,''>>>(nCheck_22=1;" "&(nInt_10+1;"0")&" .";"#/")'',1,2,13,51,''xl79'','''',1
1,1,'''',1,1,13,54,''xl98'','''',1
1,1,'''',1,1,13,55,''xl98'','''',1
1,1,'',   '',6,1,14,3,''xl42'','''',1
1,1,''&&select vip from c_data3 where orders=AA#vip#vip#CC'',6,1,14,4,''xl48'','''',1
1,1,''   ,  '',6,1,14,5,''xl49'','''',1
1,1,''&&select code from c_data3 where orders=AA#code#code#CC'',6,1,14,6,''xl53'','''',1
1,1,'',   '',6,1,14,7,''xl54'','''',1
1,1,''&&select vip from c_data4 where orders=AA#vip#vip#CC'',6,1,14,8,''xl55'','''',1
1,1,''   ,  '',6,1,14,9,''xl58'','''',1
1,1,''>>>(nCheck_34=1;"/";"#/")'',6,1,14,11,''xl62'','''',1
1,1,''>>>(nCheck_19=1;" ";"#/")'',6,1,14,12,''xl67'','''',1
1,1,''>>>(nCheck_20=1;" ";"#/")'',6,1,14,13,''xl68'','''',1
1,1,''>>>(nCheck_21=1;"";"#/")'',6,1,14,14,''xl69'','''',1
1,1,''>>>(nCheck_25=1;" ";"#/")'',6,1,14,15,''xl70'','''',1
1,1,''>>>(nCheck_26=1;" ";"#/")'',6,1,14,16,''xl72'','''',1
1,1,'''',1,2,14,17,''xl79'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,19,''xl79'','''',1
1,1,'''',6,1,14,21,''xl83'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,22,''xl85'','''',1
1,1,'''',6,1,14,23,''xl86'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,24,''xl87'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,25,''xl90'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,27,''xl90'','''',1
1,1,'''',1,2,14,29,''xl79'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',1,2,14,31,''xl79'','''',1
1,1,'''',6,1,14,33,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,34,''xl88'','''',1
1,1,'''',6,1,14,35,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,36,''xl88'','''',1
1,1,''>>>(nInt_10+2;"0")&" ."'',1,2,14,37,''xl90'','''',1
1,1,''>>>(nInt_10+3;"0")&" ."'',1,2,14,39,''xl90'','''',1
1,1,'''',6,1,14,41,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,42,''xl88'','''',1
1,1,'''',6,1,14,43,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,44,''xl88'','''',1
1,1,'''',6,1,14,45,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,46,''xl88'','''',1
1,1,'''',6,1,14,47,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,48,''xl88'','''',1
1,1,'''',6,1,14,49,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,50,''xl88'','''',1
1,1,'''',6,1,14,51,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',6,1,14,52,''xl88'','''',1
1,1,'''',1,1,14,54,''xl98'','''',1
1,1,'''',1,1,14,55,''xl98'','''',1
1,1,''  '',5,1,15,17,''xl75'','''',1
1,1,'''',5,1,15,18,''xl80'','''',1
1,1,''  '',5,1,15,19,''xl81'','''',1
1,1,'''',5,1,15,20,''xl82'','''',1
1,1,'''',5,1,15,25,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,26,''xl88'','''',1
1,1,'''',5,1,15,27,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,28,''xl88'','''',1
1,1,''  '',5,1,15,29,''xl88'','''',1
1,1,'''',5,1,15,30,''xl88'','''',1
1,1,''  '',5,1,15,31,''xl88'','''',1
1,1,'''',5,1,15,32,''xl88'','''',1
1,1,'''',5,1,15,37,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,38,''xl88'','''',1
1,1,'''',5,1,15,39,''xl88'','''',1
1,1,''&&select orders,name from c_data6 where list=1 order by orders#name#orders#AA'',5,1,15,40,''xl88'','''',1
1,1,'''',1,1,15,54,''xl98'','''',1
1,1,'''',1,1,15,55,''xl98'','''',1
1,1,'''',1,1,16,54,''xl98'','''',1
1,1,'''',1,1,16,55,''xl98'','''',1
1,1,'''',1,1,17,54,''xl98'','''',1
1,1,'''',1,1,17,55,''xl98'','''',1
1,1,'''',1,1,18,54,''xl98'','''',1
1,1,'''',1,1,18,55,''xl98'','''',1
1,1,'''',1,1,19,54,''xl98'','''',1
1,1,'''',1,1,19,55,''xl98'','''',1
1,2,''>>>"   "&cText_35'',1,1,1,1,''xl29'','''',1
1,2,''8000'',1,1,1,2,''xl38'','''',1
1,2,'''',1,1,1,3,''xl46'','''',1
1,2,'''',1,1,1,4,''xl46'','''',1
1,2,'''',1,1,1,5,''xl46'','''',1
1,2,'''',1,1,1,6,''xl46'','''',1
1,2,'''',1,1,1,7,''xl46'','''',1
1,2,'''',1,1,1,8,''xl46'','''',1
1,2,'''',1,1,1,9,''xl46'','''',1
1,2,'''',1,1,1,10,''xl46'','''',1
1,2,'''',1,1,1,11,''xl46'','''',1
1,2,'''',1,1,1,12,''xl46'','''',1
1,2,'''',1,1,1,13,''xl46'','''',1
1,2,'''',1,1,1,14,''xl46'','''',1
1,2,'''',1,1,1,15,''xl46'','''',1
1,2,'''',1,1,1,16,''xl46'','''',1
1,2,''>>(<list>;1;<s_1>)'',1,1,1,17,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_2>)'',1,1,1,18,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_1>)'',1,1,1,19,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_2>)'',1,1,1,20,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_3>)'',1,1,1,21,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_3>)'',1,1,1,22,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_4>)'',1,1,1,23,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_4>)'',1,1,1,24,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_5>)'',1,1,1,25,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_5>)'',1,1,1,26,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_6>)'',1,1,1,27,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_6>)'',1,1,1,28,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_1>)'',1,1,1,29,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_2>)'',1,1,1,30,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_1>)'',1,1,1,31,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_2>)'',1,1,1,32,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_3>)'',1,1,1,33,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_3>)'',1,1,1,34,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_4>)'',1,1,1,35,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_4>)'',1,1,1,36,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_5>)'',1,1,1,37,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_5>)'',1,1,1,38,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_6>)'',1,1,1,39,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_6>)'',1,1,1,40,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_7>)'',1,1,1,41,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_7>)'',1,1,1,42,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<s_8>)'',1,1,1,43,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_8>)'',1,1,1,44,''xl78'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 4, '1,2,''>>(<list>;1;<s_9>)'',1,1,1,45,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<s_9>)'',1,1,1,46,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_7>)'',1,1,1,47,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_7>)'',1,1,1,48,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_8>)'',1,1,1,49,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_8>)'',1,1,1,50,''xl78'',''"#,##0.00"'',1
1,2,''>>(<list>;1;<k_9>)'',1,1,1,51,''xl78'',''"#,##0.00"'',1
1,2,''>>2(<su>;AA;<list>;1;<k_9>)'',1,1,1,52,''xl78'',''"#,##0.00"'',1
1,2,'''',1,1,1,53,''xl96'','''',1
1,2,'''',1,1,1,54,''xl22'','''',1
1,2,'''',1,1,1,55,''xl22'','''',1
1,2,'''',1,1,2,1,''xl30'','''',1
1,2,'''',1,1,2,2,''xl39'','''',1
1,2,'''',1,1,2,3,''xl47'','''',1
1,2,'''',1,1,2,4,''xl47'','''',1
1,2,'''',1,1,2,5,''xl47'','''',1
1,2,'''',1,1,2,6,''xl47'','''',1
1,2,'''',1,1,2,7,''xl47'','''',1
1,2,'''',1,1,2,8,''xl47'','''',1
1,2,'''',1,1,2,9,''xl47'','''',1
1,2,'''',1,1,2,10,''xl47'','''',1
1,2,'''',1,1,2,11,''xl39'','''',1
1,2,'''',1,1,2,12,''xl39'','''',1
1,2,'''',1,1,2,13,''xl39'','''',1
1,2,'''',1,1,2,14,''xl39'','''',1
1,2,'''',1,1,2,15,''xl39'','''',1
1,2,'''',1,1,2,16,''xl66'','''',1
1,2,'''',1,1,2,17,''xl66'','''',1
1,2,'''',1,1,2,18,''xl66'','''',1
1,2,'''',1,1,2,19,''xl66'','''',1
1,2,'''',1,1,2,20,''xl66'','''',1
1,2,'''',1,1,2,21,''xl66'','''',1
1,2,'''',1,1,2,22,''xl66'','''',1
1,2,'''',1,1,2,23,''xl66'','''',1
1,2,'''',1,1,2,24,''xl66'','''',1
1,2,'''',1,1,2,25,''xl66'','''',1
1,2,'''',1,1,2,26,''xl66'','''',1
1,2,'''',1,1,2,27,''xl66'','''',1
1,2,'''',1,1,2,28,''xl66'','''',1
1,2,'''',1,1,2,29,''xl66'','''',1
1,2,'''',1,1,2,30,''xl66'','''',1
1,2,'''',1,1,2,31,''xl66'','''',1
1,2,'''',1,1,2,32,''xl66'','''',1
1,2,'''',1,1,2,33,''xl66'','''',1
1,2,'''',1,1,2,34,''xl66'','''',1
1,2,'''',1,1,2,35,''xl66'','''',1
1,2,'''',1,1,2,36,''xl66'','''',1
1,2,'''',1,1,2,37,''xl66'','''',1
1,2,'''',1,1,2,38,''xl66'','''',1
1,2,'''',1,1,2,39,''xl66'','''',1
1,2,'''',1,1,2,40,''xl66'','''',1
1,2,'''',1,1,2,41,''xl66'','''',1
1,2,'''',1,1,2,42,''xl66'','''',1
1,2,'''',1,1,2,43,''xl66'','''',1
1,2,'''',1,1,2,44,''xl66'','''',1
1,2,'''',1,1,2,45,''xl66'','''',1
1,2,'''',1,1,2,46,''xl66'','''',1
1,2,'''',1,1,2,47,''xl66'','''',1
1,2,'''',1,1,2,48,''xl66'','''',1
1,2,'''',1,1,2,49,''xl66'','''',1
1,2,'''',1,1,2,50,''xl66'','''',1
1,2,'''',1,1,2,51,''xl66'','''',1
1,2,'''',1,1,2,52,''xl66'','''',1
1,2,'''',1,1,2,53,''xl66'','''',1
1,2,'''',1,1,2,54,''xl22'','''',1
1,2,'''',1,1,2,55,''xl22'','''',1
1,2,''>>>Footer'',1,53,3,1,''xl31'','''',1
1,2,'''',1,1,3,54,''xl22'','''',1
1,2,'''',1,1,3,55,''xl22'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,1,''xl25'','''',1
2,1,''>>(("R[0]C[0]";))'',1,1,1,2,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,3,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,4,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,5,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)"&("CC"="#/";"";"+1")'',1,1,1,6,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,7,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,8,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,9,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,10,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,6,1,11,''xl73'','''',1
2,1,''>>"=("&(34)&"R[0]C[-6]"&(34)&";)+1"'',1,1,1,17,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,18,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,19,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,20,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,21,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,22,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,23,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,24,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,25,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,26,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,27,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,28,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,29,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,30,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,31,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,32,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,33,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,34,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,35,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,36,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,37,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,38,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,39,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,40,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,41,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,42,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,43,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,44,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,45,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,46,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,47,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,48,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,49,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,50,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,51,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,52,''xl25'','''',1
2,1,''>>"=("&(34)&"R[0]C[-1]"&(34)&";)+1"'',1,1,1,53,''xl25'','''',1
2,1,'''',1,1,1,54,''xl99'','''',1
2,1,'''',1,1,1,55,''xl99'','''',1
3,1,''>>>{cdep}&"-"&{dep_n}'',1,16,1,1,''xl74'','''',1
3,1,''>>(<s_1>)'',1,1,1,17,''xl76'',''"#,##0.00"'',1
3,1,''>>(<s_2>)'',1,1,1,18,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl76'',''"#,##0.00"'',1
3,1,''>>(<s_3>)'',1,1,1,21,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl76'',''"#,##0.00"'',1
3,1,''>>(<s_4>)'',1,1,1,23,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl76'',''"#,##0.00"'',1
3,1,''>>(<s_5>)'',1,1,1,25,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl76'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 5, '3,1,''>>(<s_6>)'',1,1,1,27,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_1>)'',1,1,1,29,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_2>)'',1,1,1,30,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_3>)'',1,1,1,33,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_4>)'',1,1,1,35,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_5>)'',1,1,1,37,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_6>)'',1,1,1,39,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl76'',''"#,##0.00"'',1
3,1,''>>(<s_7>)'',1,1,1,41,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl76'',''"#,##0.00"'',1
3,1,''>>(<s_8>)'',1,1,1,43,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl76'',''"#,##0.00"'',1
3,1,''>>(<s_9>)'',1,1,1,45,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_7>)'',1,1,1,47,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_8>)'',1,1,1,49,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl76'',''"#,##0.00"'',1
3,1,''>>(<k_9>)'',1,1,1,51,''xl76'',''"#,##0.00"'',1
3,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl76'',''"#,##0.00"'',1
3,1,'''',1,1,1,53,''xl43'','''',1
3,1,'''',1,1,1,54,''xl22'','''',1
3,1,'''',1,1,1,55,''xl22'','''',1
4,1,''>>>{po5_n}'',1,1,1,1,''xl27'','''',1
4,1,''>>>{cpo5}'',1,1,1,2,''xl34'','''',1
4,1,'''',1,1,1,3,''xl43'','''',1
4,1,'''',1,1,1,4,''xl43'','''',1
4,1,'''',1,1,1,5,''xl43'','''',1
4,1,'''',1,1,1,6,''xl43'','''',1
4,1,'''',1,1,1,7,''xl43'','''',1
4,1,'''',1,1,1,8,''xl43'','''',1
4,1,'''',1,1,1,9,''xl43'','''',1
4,1,'''',1,1,1,10,''xl43'','''',1
4,1,'''',1,1,1,11,''xl43'','''',1
4,1,'''',1,1,1,12,''xl43'','''',1
4,1,'''',1,1,1,13,''xl43'','''',1
4,1,'''',1,1,1,14,''xl43'','''',1
4,1,'''',1,1,1,15,''xl43'','''',1
4,1,'''',1,1,1,16,''xl43'','''',1
4,1,''>>(<s_1>)'',1,1,1,17,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_2>)'',1,1,1,18,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_3>)'',1,1,1,21,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_4>)'',1,1,1,23,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_5>)'',1,1,1,25,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_6>)'',1,1,1,27,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_1>)'',1,1,1,29,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_2>)'',1,1,1,30,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_3>)'',1,1,1,33,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_4>)'',1,1,1,35,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_5>)'',1,1,1,37,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_6>)'',1,1,1,39,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_7>)'',1,1,1,41,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_8>)'',1,1,1,43,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl76'',''"#,##0.00"'',1
4,1,''>>(<s_9>)'',1,1,1,45,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_7>)'',1,1,1,47,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_8>)'',1,1,1,49,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl76'',''"#,##0.00"'',1
4,1,''>>(<k_9>)'',1,1,1,51,''xl76'',''"#,##0.00"'',1
4,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl76'',''"#,##0.00"'',1
4,1,'''',1,1,1,53,''xl43'','''',1
4,1,'''',1,1,1,54,''xl22'','''',1
4,1,'''',1,1,1,55,''xl22'','''',1
5,1,''>>>{po4_n}'',1,1,1,1,''xl27'','''',1
5,1,''>>>{cpo4}'',1,1,1,2,''xl34'','''',1
5,1,'''',1,1,1,3,''xl43'','''',1
5,1,'''',1,1,1,4,''xl43'','''',1
5,1,'''',1,1,1,5,''xl43'','''',1
5,1,'''',1,1,1,6,''xl43'','''',1
5,1,'''',1,1,1,7,''xl43'','''',1
5,1,'''',1,1,1,8,''xl43'','''',1
5,1,'''',1,1,1,9,''xl43'','''',1
5,1,'''',1,1,1,10,''xl43'','''',1
5,1,'''',1,1,1,11,''xl43'','''',1
5,1,'''',1,1,1,12,''xl43'','''',1
5,1,'''',1,1,1,13,''xl43'','''',1
5,1,'''',1,1,1,14,''xl43'','''',1
5,1,'''',1,1,1,15,''xl43'','''',1
5,1,'''',1,1,1,16,''xl43'','''',1
5,1,''>>(<s_1>)'',1,1,1,17,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_2>)'',1,1,1,18,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_3>)'',1,1,1,21,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_4>)'',1,1,1,23,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_5>)'',1,1,1,25,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_6>)'',1,1,1,27,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_1>)'',1,1,1,29,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_2>)'',1,1,1,30,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_3>)'',1,1,1,33,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_4>)'',1,1,1,35,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_5>)'',1,1,1,37,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_6>)'',1,1,1,39,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_7>)'',1,1,1,41,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_8>)'',1,1,1,43,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl76'',''"#,##0.00"'',1
5,1,''>>(<s_9>)'',1,1,1,45,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_7>)'',1,1,1,47,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_8>)'',1,1,1,49,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl76'',''"#,##0.00"'',1
5,1,''>>(<k_9>)'',1,1,1,51,''xl76'',''"#,##0.00"'',1
5,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl76'',''"#,##0.00"'',1
5,1,'''',1,1,1,53,''xl43'','''',1
5,1,'''',1,1,1,54,''xl22'','''',1
5,1,'''',1,1,1,55,''xl22'','''',1
6,1,''>>>{po3_n}'',1,1,1,1,''xl27'','''',1
6,1,''>>>{cpo3}'',1,1,1,2,''xl34'','''',1
6,1,'''',1,1,1,3,''xl43'','''',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 6, '6,1,'''',1,1,1,4,''xl43'','''',1
6,1,'''',1,1,1,5,''xl43'','''',1
6,1,'''',1,1,1,6,''xl43'','''',1
6,1,'''',1,1,1,7,''xl43'','''',1
6,1,'''',1,1,1,8,''xl43'','''',1
6,1,'''',1,1,1,9,''xl43'','''',1
6,1,'''',1,1,1,10,''xl43'','''',1
6,1,'''',1,1,1,11,''xl43'','''',1
6,1,'''',1,1,1,12,''xl43'','''',1
6,1,'''',1,1,1,13,''xl43'','''',1
6,1,'''',1,1,1,14,''xl43'','''',1
6,1,'''',1,1,1,15,''xl43'','''',1
6,1,'''',1,1,1,16,''xl43'','''',1
6,1,''>>(<s_1>)'',1,1,1,17,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_2>)'',1,1,1,18,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_3>)'',1,1,1,21,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_4>)'',1,1,1,23,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_5>)'',1,1,1,25,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_6>)'',1,1,1,27,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_1>)'',1,1,1,29,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_2>)'',1,1,1,30,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_3>)'',1,1,1,33,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_4>)'',1,1,1,35,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_5>)'',1,1,1,37,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_6>)'',1,1,1,39,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_7>)'',1,1,1,41,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_8>)'',1,1,1,43,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl76'',''"#,##0.00"'',1
6,1,''>>(<s_9>)'',1,1,1,45,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_7>)'',1,1,1,47,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_8>)'',1,1,1,49,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl76'',''"#,##0.00"'',1
6,1,''>>(<k_9>)'',1,1,1,51,''xl76'',''"#,##0.00"'',1
6,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl76'',''"#,##0.00"'',1
6,1,'''',1,1,1,53,''xl43'','''',1
6,1,'''',1,1,1,54,''xl22'','''',1
6,1,'''',1,1,1,55,''xl22'','''',1
7,1,''>>>{po2_n}'',1,1,1,1,''xl27'','''',1
7,1,''>>>{cpo2}'',1,1,1,2,''xl34'','''',1
7,1,'''',1,1,1,3,''xl43'','''',1
7,1,'''',1,1,1,4,''xl43'','''',1
7,1,'''',1,1,1,5,''xl43'','''',1
7,1,'''',1,1,1,6,''xl43'','''',1
7,1,'''',1,1,1,7,''xl43'','''',1
7,1,'''',1,1,1,8,''xl43'','''',1
7,1,'''',1,1,1,9,''xl43'','''',1
7,1,'''',1,1,1,10,''xl43'','''',1
7,1,'''',1,1,1,11,''xl43'','''',1
7,1,'''',1,1,1,12,''xl43'','''',1
7,1,'''',1,1,1,13,''xl43'','''',1
7,1,'''',1,1,1,14,''xl43'','''',1
7,1,'''',1,1,1,15,''xl43'','''',1
7,1,'''',1,1,1,16,''xl43'','''',1
7,1,''>>(<s_1>)'',1,1,1,17,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_2>)'',1,1,1,18,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_3>)'',1,1,1,21,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_4>)'',1,1,1,23,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_5>)'',1,1,1,25,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_6>)'',1,1,1,27,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_1>)'',1,1,1,29,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_2>)'',1,1,1,30,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_3>)'',1,1,1,33,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_4>)'',1,1,1,35,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_5>)'',1,1,1,37,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_6>)'',1,1,1,39,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_7>)'',1,1,1,41,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_8>)'',1,1,1,43,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl76'',''"#,##0.00"'',1
7,1,''>>(<s_9>)'',1,1,1,45,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_7>)'',1,1,1,47,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_8>)'',1,1,1,49,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl76'',''"#,##0.00"'',1
7,1,''>>(<k_9>)'',1,1,1,51,''xl76'',''"#,##0.00"'',1
7,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl76'',''"#,##0.00"'',1
7,1,'''',1,1,1,53,''xl43'','''',1
7,1,'''',1,1,1,54,''xl22'','''',1
7,1,'''',1,1,1,55,''xl22'','''',1
8,1,''>>>{po1_n}'',1,1,1,1,''xl27'','''',1
8,1,''>>>{cpo1}'',1,1,1,2,''xl34'','''',1
8,1,'''',1,1,1,3,''xl43'','''',1
8,1,'''',1,1,1,4,''xl43'','''',1
8,1,'''',1,1,1,5,''xl43'','''',1
8,1,'''',1,1,1,6,''xl43'','''',1
8,1,'''',1,1,1,7,''xl43'','''',1
8,1,'''',1,1,1,8,''xl43'','''',1
8,1,'''',1,1,1,9,''xl43'','''',1
8,1,'''',1,1,1,10,''xl43'','''',1
8,1,'''',1,1,1,11,''xl43'','''',1
8,1,'''',1,1,1,12,''xl43'','''',1
8,1,'''',1,1,1,13,''xl43'','''',1
8,1,'''',1,1,1,14,''xl43'','''',1
8,1,'''',1,1,1,15,''xl43'','''',1
8,1,'''',1,1,1,16,''xl43'','''',1
8,1,''>>(<s_1>)'',1,1,1,17,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_2>)'',1,1,1,18,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_3>)'',1,1,1,21,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_4>)'',1,1,1,23,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_5>)'',1,1,1,25,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_6>)'',1,1,1,27,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_1>)'',1,1,1,29,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_2>)'',1,1,1,30,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_3>)'',1,1,1,33,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_4>)'',1,1,1,35,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_5>)'',1,1,1,37,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl76'',''"#,##0.00"'',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 7, '8,1,''>>(<k_6>)'',1,1,1,39,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_7>)'',1,1,1,41,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_8>)'',1,1,1,43,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl76'',''"#,##0.00"'',1
8,1,''>>(<s_9>)'',1,1,1,45,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_7>)'',1,1,1,47,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_8>)'',1,1,1,49,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl76'',''"#,##0.00"'',1
8,1,''>>(<k_9>)'',1,1,1,51,''xl76'',''"#,##0.00"'',1
8,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl76'',''"#,##0.00"'',1
8,1,'''',1,1,1,53,''xl43'','''',1
8,1,'''',1,1,1,54,''xl22'','''',1
8,1,'''',1,1,1,55,''xl22'','''',1
9,1,''>>>nvl({po_n};" ")&"\"'',1,1,1,1,''xl28'','''',1
9,1,''>>>nvl({cpo};" ")&"\"'',1,1,1,2,''xl36'','''',1
9,1,''>>>2(<lev1>;AA;<st>;1;<nam_1>)'',1,1,1,3,''xl45'','''',1
9,1,''>>>2(<lev1>;AA;<st>;1;<res_1>)'',1,1,1,4,''xl45'','''',1
9,1,''>>>2(<lev1>;AA;<st>;1;<dat_1>)'',1,1,1,5,''xl45'','''',1
9,1,''>>>2(<lev1>;AA;<st>;1;<cod_1>)'',1,1,1,6,''xl45'','''',1
9,1,''>>>2(<lev2>;AA;<st>;1;<nam_2>)'',1,1,1,7,''xl45'','''',1
9,1,''>>>2(<lev2>;AA;<st>;1;<res_2>)'',1,1,1,8,''xl45'','''',1
9,1,''>>>2(<lev2>;AA;<st>;1;<dat_2>)'',1,1,1,9,''xl59'','''',1
9,1,''>>nvl({cpog};" ")&"\"'',1,1,1,10,''xl61'','''',1
9,1,''>>2(<lev>;1;<st>;1;<cdiv>)'',1,1,1,11,''xl64'','''',1
9,1,''>>2(<lev>;1;<st>;1;<ctgt>)'',1,1,1,12,''xl64'','''',1
9,1,''>>2(<lev>;1;<st>;1;<cexp>)'',1,1,1,13,''xl64'','''',1
9,1,''>>2(<lev>;1;<st>;1;<citm>)'',1,1,1,14,''xl64'','''',1
9,1,''>>2(<lev>;1;<st>;1;<cdop>)'',1,1,1,15,''xl64'','''',1
9,1,''>>2(<lev>;1;<st>;1;<clcl>)'',1,1,1,16,''xl64'','''',1
9,1,''>>(<s_1>)'',1,1,1,17,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_2>)'',1,1,1,18,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_3>)'',1,1,1,21,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_4>)'',1,1,1,23,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_5>)'',1,1,1,25,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_6>)'',1,1,1,27,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_1>)'',1,1,1,29,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_2>)'',1,1,1,30,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_3>)'',1,1,1,33,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_4>)'',1,1,1,35,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_5>)'',1,1,1,37,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_6>)'',1,1,1,39,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_7>)'',1,1,1,41,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_8>)'',1,1,1,43,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl76'',''"#,##0.00"'',1
9,1,''>>(<s_9>)'',1,1,1,45,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_7>)'',1,1,1,47,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_8>)'',1,1,1,49,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl76'',''"#,##0.00"'',1
9,1,''>>(<k_9>)'',1,1,1,51,''xl76'',''"#,##0.00"'',1
9,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl76'',''"#,##0.00"'',1
9,1,'''',1,1,1,53,''xl36'','''',1
9,1,'''',1,1,1,54,''xl22'','''',1
9,1,'''',1,1,1,55,''xl22'','''',1
10,1,''\'',1,1,1,1,''xl28'','''',1
10,1,''\'',1,1,1,2,''xl36'','''',1
10,1,''>>>(<lev1>;AA;<nam_1>)'',1,1,1,3,''xl45'','''',1
10,1,''>>>(<lev1>;AA;<res_1>)'',1,1,1,4,''xl45'','''',1
10,1,''>>>(<lev1>;AA;<dat_1>)'',1,1,1,5,''xl45'','''',1
10,1,''>>>(<lev1>;AA;<cod_1>)'',1,1,1,6,''xl45'','''',1
10,1,''>>>(<lev2>;AA;<nam_2>)'',1,1,1,7,''xl45'','''',1
10,1,''>>>(<lev2>;AA;<res_2>)'',1,1,1,8,''xl45'','''',1
10,1,''>>>(<lev2>;AA;<dat_2>)'',1,1,1,9,''xl59'','''',1
10,1,''\'',1,1,1,10,''xl61'','''',1
10,1,''>>(<lev>;1;<cdiv>)'',1,1,1,11,''xl64'','''',1
10,1,''>>(<lev>;1;<ctgt>)'',1,1,1,12,''xl64'','''',1
10,1,''>>(<lev>;1;<cexp>)'',1,1,1,13,''xl64'','''',1
10,1,''>>(<lev>;1;<citm>)'',1,1,1,14,''xl64'','''',1
10,1,''>>(<lev>;1;<cdop>)'',1,1,1,15,''xl64'','''',1
10,1,''>>(<lev>;1;<clcl>)'',1,1,1,16,''xl64'','''',1
10,1,''>>(<s_1>)'',1,1,1,17,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_2>)'',1,1,1,18,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_1>)'',1,1,1,19,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_2>)'',1,1,1,20,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_3>)'',1,1,1,21,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_3>)'',1,1,1,22,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_4>)'',1,1,1,23,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_4>)'',1,1,1,24,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_5>)'',1,1,1,25,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_5>)'',1,1,1,26,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_6>)'',1,1,1,27,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_6>)'',1,1,1,28,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_1>)'',1,1,1,29,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_2>)'',1,1,1,30,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_1>)'',1,1,1,31,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_2>)'',1,1,1,32,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_3>)'',1,1,1,33,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_3>)'',1,1,1,34,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_4>)'',1,1,1,35,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_4>)'',1,1,1,36,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_5>)'',1,1,1,37,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_5>)'',1,1,1,38,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_6>)'',1,1,1,39,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_6>)'',1,1,1,40,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_7>)'',1,1,1,41,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_7>)'',1,1,1,42,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_8>)'',1,1,1,43,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_8>)'',1,1,1,44,''xl77'',''"#,##0.00"'',1
10,1,''>>(<s_9>)'',1,1,1,45,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<s_9>)'',1,1,1,46,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_7>)'',1,1,1,47,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_7>)'',1,1,1,48,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_8>)'',1,1,1,49,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_8>)'',1,1,1,50,''xl77'',''"#,##0.00"'',1
10,1,''>>(<k_9>)'',1,1,1,51,''xl77'',''"#,##0.00"'',1
10,1,''>>(<su>;AA;<k_9>)'',1,1,1,52,''xl77'',''"#,##0.00"'',1
10,1,''>>>(<lev>;1;<metod>)'',1,1,1,53,''xl36'','''',1
10,1,''>>st'',1,1,1,54,''xl100'','''',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 8, '10,1,'''',1,1,1,55,''xl22'','''',1
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 9, '1,1,'''',1,1,1,1,''xl22'','''',2
1,1,'''',1,1,1,2,''xl22'','''',2
1,1,'''',1,1,1,3,''xl22'','''',2
1,1,'''',1,1,1,4,''xl22'','''',2
1,1,'''',1,1,1,5,''xl22'','''',2
1,1,'''',1,1,1,6,''xl22'','''',2
1,1,'''',1,1,1,7,''xl22'','''',2
1,1,'''',1,1,1,8,''xl22'','''',2
1,1,'''',1,1,1,9,''xl22'','''',2
1,1,'''',1,1,1,10,''xl22'','''',2
1,1,'''',1,1,1,11,''xl22'','''',2
1,1,'''',1,1,1,12,''xl22'','''',2
1,1,'''',1,1,1,13,''xl22'','''',2
1,1,'''',1,1,1,14,''xl22'','''',2
1,1,'''',1,1,1,15,''xl22'','''',2
1,1,'''',1,1,1,16,''xl22'','''',2
1,1,'''',1,1,1,17,''xl22'','''',2
1,1,'''',1,1,1,18,''xl22'','''',2
1,1,'''',1,1,1,19,''xl22'','''',2
1,1,'''',1,1,1,20,''xl22'','''',2
1,1,'''',1,1,1,21,''xl22'','''',2
1,1,'''',1,1,1,22,''xl22'','''',2
1,1,'''',1,1,1,23,''xl22'','''',2
1,1,'''',1,1,1,24,''xl22'','''',2
1,1,'''',1,1,1,25,''xl22'','''',2
1,1,'''',1,1,1,26,''xl22'','''',2
1,1,'''',1,1,1,27,''xl22'','''',2
1,1,'''',1,1,1,28,''xl22'','''',2
1,1,'''',1,1,1,29,''xl22'','''',2
1,1,'''',1,1,1,30,''xl22'','''',2
1,1,'''',1,1,1,31,''xl91'','''',2
1,1,'''',1,1,1,32,''xl91'','''',2
1,1,'''',1,1,1,33,''xl91'','''',2
1,1,'''',1,1,1,34,''xl91'','''',2
1,1,'''',1,1,1,35,''xl91'','''',2
1,1,'''',1,1,1,36,''xl91'','''',2
1,1,'''',1,1,1,37,''xl91'','''',2
1,1,'''',1,1,1,38,''xl22'','''',2
1,1,'''',1,1,1,39,''xl94'','''',2
1,1,'''',1,1,1,40,''xl94'','''',2
1,1,'''',1,1,1,41,''xl94'','''',2
1,1,'''',1,1,1,42,''xl94'','''',2
1,1,'''',1,1,1,43,''xl23'','''',2
1,1,'''',1,1,1,44,''xl94'','''',2
1,1,'''',1,1,1,45,''xl94'','''',2
1,1,'''',1,1,1,46,''xl94'','''',2
1,1,'''',1,1,1,47,''xl94'','''',2
1,1,'''',1,1,1,48,''xl94'','''',2
1,1,'''',1,1,1,49,''xl94'','''',2
1,1,'''',1,1,1,50,''xl94'','''',2
1,1,'''',1,1,1,51,''xl94'','''',2
1,1,'''',1,1,1,52,''xl94'','''',2
1,1,'''',1,1,1,53,''xl94'','''',2
1,1,'''',1,1,1,54,''xl94'','''',2
1,1,'''',1,1,1,55,''xl94'','''',2
1,1,'''',1,1,1,56,''xl94'','''',2
1,1,''>>"#/"'',1,1,1,57,''xl97'','''',2
1,1,'''',1,1,1,58,''xl22'','''',2
1,1,''           ,'',1,29,2,1,''xl89'','''',2
1,1,'''',1,1,2,30,''xl22'','''',2
1,1,'''',1,1,2,31,''xl91'','''',2
1,1,'''',1,1,2,32,''xl91'','''',2
1,1,'''',1,1,2,33,''xl91'','''',2
1,1,'''',1,1,2,34,''xl91'','''',2
1,1,'''',1,1,2,35,''xl91'','''',2
1,1,'''',1,1,2,36,''xl91'','''',2
1,1,'''',1,1,2,37,''xl91'','''',2
1,1,'''',1,1,2,38,''xl22'','''',2
1,1,'''',1,1,2,39,''xl94'','''',2
1,1,'''',1,1,2,40,''xl94'','''',2
1,1,'''',1,1,2,41,''xl94'','''',2
1,1,'''',1,1,2,42,''xl94'','''',2
1,1,'''',1,1,2,43,''xl23'','''',2
1,1,'''',1,1,2,44,''xl94'','''',2
1,1,'''',1,1,2,45,''xl94'','''',2
1,1,'''',1,1,2,46,''xl94'','''',2
1,1,'''',1,1,2,47,''xl94'','''',2
1,1,'''',1,1,2,48,''xl94'','''',2
1,1,'''',1,1,2,49,''xl94'','''',2
1,1,'''',1,1,2,50,''xl94'','''',2
1,1,'''',1,1,2,51,''xl94'','''',2
1,1,'''',1,1,2,52,''xl94'','''',2
1,1,'''',1,1,2,53,''xl94'','''',2
1,1,'''',1,1,2,54,''xl94'','''',2
1,1,'''',1,1,2,55,''xl94'','''',2
1,1,'''',1,1,2,56,''xl94'','''',2
1,1,'''',1,1,2,57,''xl22'','''',2
1,1,'''',1,1,2,58,''xl22'','''',2
1,1,''          ,     '',1,29,3,1,''xl89'','''',2
1,1,'''',1,1,3,30,''xl91'','''',2
1,1,'''',1,1,3,31,''xl84'','''',2
1,1,'''',1,1,3,32,''xl84'','''',2
1,1,'''',1,1,3,33,''xl84'','''',2
1,1,'''',1,1,3,34,''xl84'','''',2
1,1,'''',1,1,3,35,''xl84'','''',2
1,1,'''',1,1,3,36,''xl84'','''',2
1,1,'''',1,1,3,37,''xl84'','''',2
1,1,'''',1,1,3,38,''xl22'','''',2
1,1,'''',1,1,3,39,''xl94'','''',2
1,1,'''',1,1,3,40,''xl94'','''',2
1,1,'''',1,1,3,41,''xl94'','''',2
1,1,'''',1,1,3,42,''xl94'','''',2
1,1,'''',1,1,3,43,''xl23'','''',2
1,1,'''',1,1,3,44,''xl94'','''',2
1,1,'''',1,1,3,45,''xl94'','''',2
1,1,'''',1,1,3,46,''xl94'','''',2
1,1,'''',1,1,3,47,''xl94'','''',2
1,1,'''',1,1,3,48,''xl94'','''',2
1,1,'''',1,1,3,49,''xl94'','''',2
1,1,'''',1,1,3,50,''xl94'','''',2
1,1,'''',1,1,3,51,''xl94'','''',2
1,1,'''',1,1,3,52,''xl94'','''',2
1,1,'''',1,1,3,53,''xl94'','''',2
1,1,'''',1,1,3,54,''xl94'','''',2
1,1,'''',1,1,3,55,''xl94'','''',2
1,1,'''',1,1,3,56,''xl94'','''',2
1,1,'''',1,1,3,57,''xl22'','''',2
1,1,'''',1,1,3,58,''xl22'','''',2
1,1,''>>" "&(dDate_2+1;0)&"."'',1,29,4,1,''xl47'','''',2
1,1,'''',1,1,4,30,''xl47'','''',2
1,1,'''',1,1,4,31,''xl47'','''',2
1,1,'''',1,1,4,32,''xl47'','''',2
1,1,'''',1,1,4,33,''xl47'','''',2
1,1,'''',1,1,4,34,''xl47'','''',2
1,1,'''',1,1,4,35,''xl47'','''',2
1,1,'''',1,1,4,36,''xl47'','''',2
1,1,'''',1,1,4,37,''xl47'','''',2
1,1,'''',1,1,4,38,''xl22'','''',2
1,1,'''',1,1,4,39,''xl94'','''',2
1,1,'''',1,1,4,40,''xl94'','''',2
1,1,'''',1,1,4,41,''xl94'','''',2
1,1,'''',1,1,4,42,''xl94'','''',2
1,1,'''',1,1,4,43,''xl23'','''',2
1,1,'''',1,1,4,44,''xl94'','''',2
1,1,'''',1,1,4,45,''xl94'','''',2
1,1,'''',1,1,4,46,''xl94'','''',2
1,1,'''',1,1,4,47,''xl94'','''',2
1,1,'''',1,1,4,48,''xl94'','''',2
1,1,'''',1,1,4,49,''xl94'','''',2
1,1,'''',1,1,4,50,''xl94'','''',2
1,1,'''',1,1,4,51,''xl94'','''',2
1,1,'''',1,1,4,52,''xl94'','''',2
1,1,'''',1,1,4,53,''xl94'','''',2
1,1,'''',1,1,4,54,''xl94'','''',2
1,1,'''',1,1,4,55,''xl94'','''',2
1,1,'''',1,1,4,56,''xl94'','''',2
1,1,'''',1,1,4,57,''xl22'','''',2
1,1,'''',1,1,4,58,''xl22'','''',2
1,1,'''',1,1,5,1,''xl22'','''',2
1,1,'''',1,1,5,2,''xl22'','''',2
1,1,'''',1,1,5,3,''xl22'','''',2
1,1,'''',1,1,5,4,''xl22'','''',2
1,1,'''',1,1,5,5,''xl22'','''',2
1,1,'''',1,1,5,6,''xl22'','''',2
1,1,'''',1,1,5,7,''xl22'','''',2
1,1,'''',1,1,5,8,''xl41'','''',2
1,1,'''',1,1,5,9,''xl41'','''',2
1,1,'''',1,1,5,10,''xl47'','''',2
1,1,'''',1,1,5,11,''xl47'','''',2
1,1,'''',1,1,5,12,''xl47'','''',2
1,1,'''',1,1,5,13,''xl41'','''',2
1,1,'''',1,1,5,14,''xl32'','''',2
1,1,'''',1,1,5,15,''xl32'','''',2
1,1,'''',1,1,5,16,''xl32'','''',2
1,1,'''',1,1,5,17,''xl32'','''',2
1,1,'''',1,1,5,18,''xl32'','''',2
1,1,'''',1,1,5,19,''xl41'','''',2
1,1,'''',1,1,5,20,''xl41'','''',2
1,1,'''',1,1,5,21,''xl41'','''',2
1,1,'''',1,1,5,22,''xl41'','''',2
1,1,'''',1,1,5,23,''xl41'','''',2
1,1,'''',1,1,5,24,''xl41'','''',2
1,1,'''',1,1,5,25,''xl84'','''',2
1,1,'''',1,1,5,26,''xl84'','''',2
1,1,'''',1,1,5,27,''xl84'','''',2
1,1,'''',1,1,5,28,''xl84'','''',2
1,1,'''',1,1,5,29,''xl41'','''',2
1,1,'''',1,1,5,30,''xl41'','''',2
1,1,'''',1,1,5,31,''xl41'','''',2
1,1,'''',1,1,5,32,''xl41'','''',2
1,1,'''',1,1,5,33,''xl41'','''',2
1,1,'''',1,1,5,34,''xl41'','''',2
1,1,'''',1,1,5,35,''xl41'','''',2
1,1,'''',1,1,5,36,''xl41'','''',2
1,1,'''',1,1,5,37,''xl41'','''',2
1,1,'''',1,1,5,38,''xl22'','''',2
1,1,'''',1,1,5,39,''xl94'','''',2
1,1,'''',1,1,5,40,''xl94'','''',2
1,1,'''',1,1,5,41,''xl94'','''',2
1,1,'''',1,1,5,42,''xl94'','''',2
1,1,'''',1,1,5,43,''xl23'','''',2
1,1,'''',1,1,5,44,''xl94'','''',2
1,1,'''',1,1,5,45,''xl94'','''',2
1,1,'''',1,1,5,46,''xl94'','''',2
1,1,'''',1,1,5,47,''xl94'','''',2
1,1,'''',1,1,5,48,''xl94'','''',2
1,1,'''',1,1,5,49,''xl94'','''',2
1,1,'''',1,1,5,50,''xl94'','''',2
1,1,'''',1,1,5,51,''xl94'','''',2
1,1,'''',1,1,5,52,''xl94'','''',2
1,1,'''',1,1,5,53,''xl94'','''',2
1,1,'''',1,1,5,54,''xl94'','''',2
1,1,'''',1,1,5,55,''xl94'','''',2
1,1,'''',1,1,5,56,''xl94'','''',2
1,1,'''',1,1,5,57,''xl22'','''',2
1,1,'''',1,1,5,58,''xl22'','''',2
1,1,''        '',1,1,6,1,''xl23'','''',2
1,1,''$$select name from c_data1 where list=2#name#name#NN'',1,30,6,2,''xl92'','''',2
1,1,'''',1,1,6,32,''xl41'','''',2
1,1,'''',1,1,6,33,''xl41'','''',2
1,1,'''',1,1,6,34,''xl41'','''',2
1,1,'''',1,1,6,35,''xl41'','''',2
1,1,'''',1,1,6,36,''xl41'','''',2
1,1,'''',1,1,6,37,''xl41'','''',2
1,1,'''',1,1,6,38,''xl22'','''',2
1,1,'''',1,1,6,39,''xl94'','''',2
1,1,'''',1,1,6,40,''xl94'','''',2
', 'SYS_XL_sqr_rro_34n_kbk_dep', 'XL_REPORT_CELLS')
	INSERT INTO #T_PROP (USERS, ORDERS, VALUE, CODE_UP, CODE_PROP) VALUES (null, 10, '1,1,'''',1,1,6,41,''xl94'','''',2
1,1,'''',1,1,6,42,''xl94'','''',2
1,1,'''',1,1,6,43,''xl23'','''',2
1,1,'''',1,1,6,44,''xl94'','''',2
1,1,'''',1,1,6,45,''xl94'','''',2
1,1,'''',1,1,6,46,''xl94'','''',2
1,1,'''',1,1,6,47,''xl94'','''',2
1,1,'''',1,1,6,48,''xl94'','''',2
1,1,'''',1,1,6,49,''xl94'','''',2
1,1,'''',1,1,6,50,''xl94'','''',2
1,1,'''',1,1,6,51,''xl94'','''',2
1,1,'''',1,1,6,52,''xl94'','''',2
1,1,'''',1,1,6,53,''xl94'','''',2
1,1,'''',1,1,6,54,''xl94'','''',2
1,1,'''',1,1,6,55,''xl94'','''',2
1,1,'''',1,1,6,56,''xl94'','''',2
1,1,'''',1,1,6,57,''xl22'','''',2
1,1,'''',1,1,6,58,''xl22'','''',2
1,1,''>>" : "&((nDivide=2; nDivide=3); " ";((nDivide=4; nDivide=5); " ";((nDivide=6; nDivide=7);"  ";"")))&""&(nDigit=1;" (    ''+'' )";"")'',1,31,7,1,''xl93'','''',2
1,1,'''',1,1,7,32,''xl41'','''',2
1,1,'''',1,1,7,33,''xl41'','''',2
1,1,'''',1,1,7,34,''xl41'','''',2
1,1,'''',1,1,7,35,''xl41'','''',2
1,1,'''',1,1,7,36,''xl41'','''',2
1,1,'''',1,1,7,37,''xl41'','''',2
1,1,'''',1,1,7,38,''xl41'','''',2
1,1,'''',1,1,7,39,''xl41'','''',2
1,1,'''',1,1,7,40,''xl41'','''',2
1,1,'''',1,1,7,41,''xl41'','''',2
1,1,'''',1,1,7,42,''xl41'','''',2
1,1,'''',1,1,7,43,''xl23'','''',2
1,1,'''',1,1,7,44,''xl41'','''',2
1,1,'''',1,1,7,45,''xl41'','''',2
1,1,'''',1,1,7,46,''xl41'','''',2
1,1,'''',1,1,7,47,''xl41'','''',2
1,1,'''',1,1,7,48,''xl41'','''',2
1,1,'''',1,1,7,49,''xl41'','''',2
1,1,'''',1,1,7,50,''xl41'','''',2
1,1,'''',1,1,7,51,''xl41'','''',2
1,1,'''',1,1,7,52,''xl41'','''',2
1,1,'''',1,1,7,53,''xl41'','''',2
1,1,'''',1,1,7,54,''xl41'','''',2
1,1,'''',1,1,7,55,''xl41'','''',2
1,1,'''',1,1,7,56,''xl41'','''',2
1,1,'''',1,1,7,57,''xl22'','''',2
1,1,'''',1,1,7,58,''xl22'','''',2
1,1,'''',1,1,8,1,''xl23'','''',2
1,1,'''',1,1,8,2,''xl32'','''',2
1,1,'''',1,1,8,3,''xl41'','''',2
1,1,'''',1,1,8,4,''xl41'','''',2
1,1,'''',1,1,8,5,''xl41'','''',2
1,1,'''',1,1,8,6,''xl41'','''',2
1,1,'''',1,1,8,7,''xl41'','''',2
1,1,'''',1,1,8,8,''xl41'','''',2
1,1,'''',1,1,8,9,''xl41'','''',2
1,1,'''',1,1,8,10,''xl112'','''',2
1,1,'''',1,1,8,11,''xl112'','''',2
1,1,'''',1,1,8,12,''xl112'','''',2
1,1,'''',1,1,8,13,''xl41'','''',2
1,1,'''',1,1,8,14,''xl32'','''',2
1,1,'''',1,1,8,15,''xl32'','''',2
1,1,'''',1,1,8,16,''xl32'','''',2
1,1,'''',1,1,8,17,''xl32'','''',2
1,1,'''',1,1,8,18,''xl32'','''',2
1,1,'''',1,1,8,19,''xl41'','''',2
1,1,'''',1,1,8,20,''xl41'','''',2
1,1,'''',1,1,8,21,''xl41'','''',2
1,1,'''',1,1,8,22,''xl41'','''',2
1,1,'''',1,1,8,23,''xl41'','''',2
1,1,'''',1,1,8,24,''xl41'','''',2
1,1,'''',1,1,8,25,''xl41'','''',2
1,1,'''',1,1,8,26,''xl41'','''',2
1,1,'''',1,1,8,27,''xl41'','''',2
1,1,'''',1,1,8,28,''xl41'','''',2
1,1,'''',1,1,8,29,''xl41'','''',2
1,1,'''',1,1,8,30,''xl41'','''',2
1,1,'''',1,1,8,31,''xl41'','''',2
1,1,'''',1,1,8,32,''xl41'','''',2
1,1,'''',1,1,8,33,''xl41'','''',2
1,1,'''',1,1,8,34,''xl41'','''',2
1,1,'''',1,1,8,35,''xl41'','''',2
1,1,'''',1,1,8,36,''xl41'','''',2
1,1,'''',1,1,8,37,''xl41'','''',2
1,1,'''',1,1,8,38,''xl41'','''',2
1,1,'''',1,1,8,39,''xl41'','''',2
1,1,'''',1,1,8,40,''xl41'','''',2
1,1,'''',1,1,8,41,''xl41'','''',2
1,1,'''',1,1,8,42,''xl41'','''',2
1,1,'''',1,1,8,43,''xl41'','''',2
1,1,'''',1,1,8,44,''xl41'','''',2
1,1,'''',1,1,8,45,''xl41'','''',2
1,1,'''',1,1,8,46,''xl41'','''',2
1,1,'''',1,1,8,47,''xl41'','''',2
1,1,'''',1,1,8,48,''xl41'','''',2
1,1,'''',1,1,8,49,''xl41'','''',2
1,1,'''',1,1,8,50,''xl41'','''',2
1,1,'''',1,1,8,51,''xl41'','''',2
1,1,'''',1,1,8,52,''xl41'','''',2
1,1,'''',1,1,8,53,''xl41'','''',2
1,1,'''',1,1,8,54,''xl41'','''',2
1,1,'''',1,1,8,55,''xl41'','''',2
1,1,'''',1,1,8,56,''xl41'','''',2
1,1,'''',1,1,8,57,''xl22'','''',2
1,1,'''',1,1,8,58,''xl22'','''',2
1,1,'' , chr(10) '',10,1,9,1,''xl101'','''',2
1,1,'' '',10,1,9,2,''xl103'','''',2
1,1,''      ,    '',2,10,9,3,''xl120'','''',2
1,1,''  ,  '',10,1,9,13,''xl125'','''',2
1,1,''    '',4,6,9,14,''xl131'','''',2
1,1,''       '',3,12,9,20,''xl79'','''',2
1,1,'' ..                 '',3,12,9,32,''xl79'','''',2
1,1,''    '',3,6,9,44,''xl79'','''',2
1,1,'' ..                 '',3,6,9,50,''xl79'','''',2
1,1,''>>>(nCheck_22=1;"  ";"#/")'',10,1,9,56,''xl134'','''',2
1,1,'''',1,1,9,57,''xl98'','''',2
1,1,'''',1,1,9,58,''xl98'','''',2
1,1,'''',1,1,10,57,''xl98'','''',2
1,1,'''',1,1,10,58,''xl98'','''',2
1,1,'' '',1,4,11,3,''xl52'','''',2
1,1,''>>>cText_35'',1,3,11,7,''xl52'','''',2
1,1,''  '',1,3,11,10,''xl121'','''',2
1,1,'''',1,1,11,57,''xl98'','''',2
1,1,'''',1,1,11,58,''xl98'','''',2
1,1,''&&select orders,name from c_data3 order by orders#name#orders#AA'',1,4,12,3,''xl52'','''',2
1,1,''&&select orders,name from c_data4 order by orders#name#orders#AA'',1,3,12,7,''xl52'','''',2
1,1,''&&select orders,name from c_data5 order by orders#name#orders#AA'',1,3,12,10,''xl121'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,20,''xl79'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,24,''xl79'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,26,''xl79'','''',2
1,1,'' '',1,4,12,28,''xl79'','''',2
1,1,''>>>"  "&(nInt_10-1;"0")&" ."'',1,4,12,32,''xl79'','''',2
1,1,''>>>"chr(10)"&(nInt_10;"0")&" ."'',1,2,12,36,''xl79'','''',2
1,1,''>>>"chr(10)"&(nInt_10+1;"0")&" ."'',1,2,12,38,''xl79'','''',2
1,1,'' '',1,4,12,40,''xl79'','''',2
1,1,''>>>(nCheck_22=1;" "&(nInt_10-1;"0")&" .";"#/